// chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/reading_list/reading_list.mojom-forward.h"  // IWYU pragma: export
#include "ui/base/mojom/window_open_disposition.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace reading_list::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "reading_list.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "reading_list.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetReadLaterEntriesMinVersion = 0,
    kOpenURLMinVersion = 0,
    kUpdateReadStatusMinVersion = 0,
    kMarkCurrentTabAsReadMinVersion = 0,
    kAddCurrentTabMinVersion = 0,
    kRemoveEntryMinVersion = 0,
    kShowContextMenuForURLMinVersion = 0,
    kUpdateCurrentPageActionButtonStateMinVersion = 0,
    kShowUIMinVersion = 0,
    kCloseUIMinVersion = 0,
    kGetWindowDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetReadLaterEntries_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateReadStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MarkCurrentTabAsRead_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddCurrentTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveEntry_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenuForURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateCurrentPageActionButtonState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetWindowData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetReadLaterEntriesCallback = base::OnceCallback<void(ReadLaterEntriesByStatusPtr)>;
  using GetReadLaterEntriesMojoCallback = base::OnceCallback<void(ReadLaterEntriesByStatusPtr)>;

  virtual void GetReadLaterEntries(GetReadLaterEntriesCallback callback) = 0;

  virtual void OpenURL(const ::GURL& url, bool mark_as_read, ::ui::mojom::ClickModifiersPtr click_modifiers) = 0;

  virtual void UpdateReadStatus(const ::GURL& url, bool read) = 0;

  virtual void MarkCurrentTabAsRead() = 0;

  virtual void AddCurrentTab() = 0;

  virtual void RemoveEntry(const ::GURL& url) = 0;

  virtual void ShowContextMenuForURL(const ::GURL& url, int32_t x, int32_t y) = 0;

  virtual void UpdateCurrentPageActionButtonState() = 0;

  virtual void ShowUI() = 0;

  virtual void CloseUI() = 0;

  using GetWindowDataCallback = base::OnceCallback<void(std::vector<WindowPtr>)>;
  using GetWindowDataMojoCallback = base::OnceCallback<void(std::vector<WindowPtr>)>;

  virtual void GetWindowData(GetWindowDataCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "reading_list.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kItemsChangedMinVersion = 0,
    kCurrentPageActionButtonStateChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ItemsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CurrentPageActionButtonStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void ItemsChanged(ReadLaterEntriesByStatusPtr entries) = 0;

  virtual void CurrentPageActionButtonStateChanged(CurrentPageActionButtonState state) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetReadLaterEntries(GetReadLaterEntriesCallback callback) final;
  
  void OpenURL(const ::GURL& url, bool mark_as_read, ::ui::mojom::ClickModifiersPtr click_modifiers) final;
  
  void UpdateReadStatus(const ::GURL& url, bool read) final;
  
  void MarkCurrentTabAsRead() final;
  
  void AddCurrentTab() final;
  
  void RemoveEntry(const ::GURL& url) final;
  
  void ShowContextMenuForURL(const ::GURL& url, int32_t x, int32_t y) final;
  
  void UpdateCurrentPageActionButtonState() final;
  
  void ShowUI() final;
  
  void CloseUI() final;
  
  void GetWindowData(GetWindowDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ItemsChanged(ReadLaterEntriesByStatusPtr entries) final;
  
  void CurrentPageActionButtonStateChanged(CurrentPageActionButtonState state) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class  Window {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Window, T>::value>;
  using DataView = WindowDataView;
  using Data_ = internal::Window_Data;

  template <typename... Args>
  static WindowPtr New(Args&&... args) {
    return WindowPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WindowPtr From(const U& u) {
    return mojo::TypeConverter<WindowPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Window>::Convert(*this);
  }


  Window();

  Window(
      bool active,
      uint32_t height);


  ~Window();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WindowPtr>
  WindowPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Window::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Window::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Window::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Window::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Window_UnserializedMessageContext<
            UserType, Window::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Window::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Window::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Window_UnserializedMessageContext<
            UserType, Window::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Window::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool active;
  
  uint32_t height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Window::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  ReadLaterEntriesByStatus {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadLaterEntriesByStatus, T>::value>;
  using DataView = ReadLaterEntriesByStatusDataView;
  using Data_ = internal::ReadLaterEntriesByStatus_Data;

  template <typename... Args>
  static ReadLaterEntriesByStatusPtr New(Args&&... args) {
    return ReadLaterEntriesByStatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadLaterEntriesByStatusPtr From(const U& u) {
    return mojo::TypeConverter<ReadLaterEntriesByStatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadLaterEntriesByStatus>::Convert(*this);
  }


  ReadLaterEntriesByStatus();

  ReadLaterEntriesByStatus(
      std::vector<ReadLaterEntryPtr> unread_entries,
      std::vector<ReadLaterEntryPtr> read_entries);

ReadLaterEntriesByStatus(const ReadLaterEntriesByStatus&) = delete;
ReadLaterEntriesByStatus& operator=(const ReadLaterEntriesByStatus&) = delete;

  ~ReadLaterEntriesByStatus();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadLaterEntriesByStatusPtr>
  ReadLaterEntriesByStatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadLaterEntriesByStatus::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadLaterEntriesByStatus::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadLaterEntriesByStatus::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadLaterEntriesByStatus_UnserializedMessageContext<
            UserType, ReadLaterEntriesByStatus::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadLaterEntriesByStatus::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadLaterEntriesByStatus::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadLaterEntriesByStatus_UnserializedMessageContext<
            UserType, ReadLaterEntriesByStatus::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadLaterEntriesByStatus::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<ReadLaterEntryPtr> unread_entries;
  
  std::vector<ReadLaterEntryPtr> read_entries;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ReadLaterEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ReadLaterEntry, T>::value>;
  using DataView = ReadLaterEntryDataView;
  using Data_ = internal::ReadLaterEntry_Data;

  template <typename... Args>
  static ReadLaterEntryPtr New(Args&&... args) {
    return ReadLaterEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ReadLaterEntryPtr From(const U& u) {
    return mojo::TypeConverter<ReadLaterEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ReadLaterEntry>::Convert(*this);
  }


  ReadLaterEntry();

  ReadLaterEntry(
      const std::string& title,
      const ::GURL& url,
      const std::string& display_url,
      int64_t update_time,
      bool read,
      const std::string& display_time_since_update);


  ~ReadLaterEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ReadLaterEntryPtr>
  ReadLaterEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadLaterEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ReadLaterEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ReadLaterEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ReadLaterEntry_UnserializedMessageContext<
            UserType, ReadLaterEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ReadLaterEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ReadLaterEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ReadLaterEntry_UnserializedMessageContext<
            UserType, ReadLaterEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ReadLaterEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::GURL url;
  
  std::string display_url;
  
  int64_t update_time;
  
  bool read;
  
  std::string display_time_since_update;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ReadLaterEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
ReadLaterEntriesByStatusPtr ReadLaterEntriesByStatus::Clone() const {
  return New(
      mojo::Clone(unread_entries),
      mojo::Clone(read_entries)
  );
}

template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>*>
bool ReadLaterEntriesByStatus::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->unread_entries, other_struct.unread_entries))
    return false;
  if (!mojo::Equals(this->read_entries, other_struct.read_entries))
    return false;
  return true;
}

template <typename T, ReadLaterEntriesByStatus::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.unread_entries < rhs.unread_entries)
    return true;
  if (rhs.unread_entries < lhs.unread_entries)
    return false;
  if (lhs.read_entries < rhs.read_entries)
    return true;
  if (rhs.read_entries < lhs.read_entries)
    return false;
  return false;
}
template <typename StructPtrType>
ReadLaterEntryPtr ReadLaterEntry::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(display_url),
      mojo::Clone(update_time),
      mojo::Clone(read),
      mojo::Clone(display_time_since_update)
  );
}

template <typename T, ReadLaterEntry::EnableIfSame<T>*>
bool ReadLaterEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->display_url, other_struct.display_url))
    return false;
  if (!mojo::Equals(this->update_time, other_struct.update_time))
    return false;
  if (!mojo::Equals(this->read, other_struct.read))
    return false;
  if (!mojo::Equals(this->display_time_since_update, other_struct.display_time_since_update))
    return false;
  return true;
}

template <typename T, ReadLaterEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.display_url < rhs.display_url)
    return true;
  if (rhs.display_url < lhs.display_url)
    return false;
  if (lhs.update_time < rhs.update_time)
    return true;
  if (rhs.update_time < lhs.update_time)
    return false;
  if (lhs.read < rhs.read)
    return true;
  if (rhs.read < lhs.read)
    return false;
  if (lhs.display_time_since_update < rhs.display_time_since_update)
    return true;
  if (rhs.display_time_since_update < lhs.display_time_since_update)
    return false;
  return false;
}
template <typename StructPtrType>
WindowPtr Window::Clone() const {
  return New(
      mojo::Clone(active),
      mojo::Clone(height)
  );
}

template <typename T, Window::EnableIfSame<T>*>
bool Window::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, Window::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}


}  // reading_list::mojom

namespace mojo {


template <>
struct  StructTraits<::reading_list::mojom::ReadLaterEntriesByStatus::DataView,
                                         ::reading_list::mojom::ReadLaterEntriesByStatusPtr> {
  static bool IsNull(const ::reading_list::mojom::ReadLaterEntriesByStatusPtr& input) { return !input; }
  static void SetToNull(::reading_list::mojom::ReadLaterEntriesByStatusPtr* output) { output->reset(); }

  static const decltype(::reading_list::mojom::ReadLaterEntriesByStatus::unread_entries)& unread_entries(
      const ::reading_list::mojom::ReadLaterEntriesByStatusPtr& input) {
    return input->unread_entries;
  }

  static const decltype(::reading_list::mojom::ReadLaterEntriesByStatus::read_entries)& read_entries(
      const ::reading_list::mojom::ReadLaterEntriesByStatusPtr& input) {
    return input->read_entries;
  }

  static bool Read(::reading_list::mojom::ReadLaterEntriesByStatus::DataView input, ::reading_list::mojom::ReadLaterEntriesByStatusPtr* output);
};


template <>
struct  StructTraits<::reading_list::mojom::ReadLaterEntry::DataView,
                                         ::reading_list::mojom::ReadLaterEntryPtr> {
  static bool IsNull(const ::reading_list::mojom::ReadLaterEntryPtr& input) { return !input; }
  static void SetToNull(::reading_list::mojom::ReadLaterEntryPtr* output) { output->reset(); }

  static const decltype(::reading_list::mojom::ReadLaterEntry::title)& title(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->title;
  }

  static const decltype(::reading_list::mojom::ReadLaterEntry::url)& url(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->url;
  }

  static const decltype(::reading_list::mojom::ReadLaterEntry::display_url)& display_url(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->display_url;
  }

  static decltype(::reading_list::mojom::ReadLaterEntry::update_time) update_time(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->update_time;
  }

  static decltype(::reading_list::mojom::ReadLaterEntry::read) read(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->read;
  }

  static const decltype(::reading_list::mojom::ReadLaterEntry::display_time_since_update)& display_time_since_update(
      const ::reading_list::mojom::ReadLaterEntryPtr& input) {
    return input->display_time_since_update;
  }

  static bool Read(::reading_list::mojom::ReadLaterEntry::DataView input, ::reading_list::mojom::ReadLaterEntryPtr* output);
};


template <>
struct  StructTraits<::reading_list::mojom::Window::DataView,
                                         ::reading_list::mojom::WindowPtr> {
  static bool IsNull(const ::reading_list::mojom::WindowPtr& input) { return !input; }
  static void SetToNull(::reading_list::mojom::WindowPtr* output) { output->reset(); }

  static decltype(::reading_list::mojom::Window::active) active(
      const ::reading_list::mojom::WindowPtr& input) {
    return input->active;
  }

  static decltype(::reading_list::mojom::Window::height) height(
      const ::reading_list::mojom::WindowPtr& input) {
    return input->height;
  }

  static bool Read(::reading_list::mojom::Window::DataView input, ::reading_list::mojom::WindowPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_READING_LIST_READING_LIST_MOJOM_H_