// chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-params-data.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-import-headers.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/wallpaper_search/wallpaper_search.mojom-test-utils.h"


namespace side_panel::customize_chrome::mojom {
KeyLabel::KeyLabel()
    : key(),
      label() {}

KeyLabel::KeyLabel(
    const std::string& key_in,
    const std::string& label_in)
    : key(std::move(key_in)),
      label(std::move(label_in)) {}

KeyLabel::~KeyLabel() = default;
size_t KeyLabel::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->label);
  return seed;
}

void KeyLabel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool KeyLabel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Group::Group()
    : category(),
      descriptor_as() {}

Group::Group(
    const std::string& category_in,
    std::vector<KeyLabelPtr> descriptor_as_in)
    : category(std::move(category_in)),
      descriptor_as(std::move(descriptor_as_in)) {}

Group::~Group() = default;

void Group::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category"), this->category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor_as"), this->descriptor_as,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<KeyLabelPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Group::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DescriptorB::DescriptorB()
    : key(),
      label(),
      image_path() {}

DescriptorB::DescriptorB(
    const std::string& key_in,
    const std::string& label_in,
    const std::string& image_path_in)
    : key(std::move(key_in)),
      label(std::move(label_in)),
      image_path(std::move(image_path_in)) {}

DescriptorB::~DescriptorB() = default;
size_t DescriptorB::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->key);
  seed = mojo::internal::Hash(seed, this->label);
  seed = mojo::internal::Hash(seed, this->image_path);
  return seed;
}

void DescriptorB::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key"), this->key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "label"), this->label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image_path"), this->image_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DescriptorB::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Descriptors::Descriptors()
    : groups(),
      descriptor_b(),
      descriptor_c() {}

Descriptors::Descriptors(
    std::vector<GroupPtr> groups_in,
    std::vector<DescriptorBPtr> descriptor_b_in,
    std::vector<KeyLabelPtr> descriptor_c_in)
    : groups(std::move(groups_in)),
      descriptor_b(std::move(descriptor_b_in)),
      descriptor_c(std::move(descriptor_c_in)) {}

Descriptors::~Descriptors() = default;

void Descriptors::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "groups"), this->groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<GroupPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor_b"), this->descriptor_b,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<DescriptorBPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptor_c"), this->descriptor_c,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<KeyLabelPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Descriptors::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Inspiration::Inspiration()
    : id(),
      description(),
      background_url(),
      thumbnail_url() {}

Inspiration::Inspiration(
    const ::base::Token& id_in,
    const std::string& description_in,
    const ::GURL& background_url_in,
    const ::GURL& thumbnail_url_in)
    : id(std::move(id_in)),
      description(std::move(description_in)),
      background_url(std::move(background_url_in)),
      thumbnail_url(std::move(thumbnail_url_in)) {}

Inspiration::~Inspiration() = default;

void Inspiration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_url"), this->background_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "thumbnail_url"), this->thumbnail_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Inspiration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspirationDescriptors::InspirationDescriptors()
    : subject(),
      style(),
      mood(),
      color() {}

InspirationDescriptors::InspirationDescriptors(
    KeyLabelPtr subject_in,
    KeyLabelPtr style_in,
    KeyLabelPtr mood_in,
    DescriptorDValuePtr color_in)
    : subject(std::move(subject_in)),
      style(std::move(style_in)),
      mood(std::move(mood_in)),
      color(std::move(color_in)) {}

InspirationDescriptors::~InspirationDescriptors() = default;

void InspirationDescriptors::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject"), this->subject,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyLabelPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyLabelPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mood"), this->mood,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type KeyLabelPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DescriptorDValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InspirationDescriptors::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InspirationGroup::InspirationGroup()
    : descriptors(),
      inspirations() {}

InspirationGroup::InspirationGroup(
    InspirationDescriptorsPtr descriptors_in,
    std::vector<InspirationPtr> inspirations_in)
    : descriptors(std::move(descriptors_in)),
      inspirations(std::move(inspirations_in)) {}

InspirationGroup::~InspirationGroup() = default;

void InspirationGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptors"), this->descriptors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type InspirationDescriptorsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inspirations"), this->inspirations,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<InspirationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InspirationGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WallpaperSearchResult::WallpaperSearchResult()
    : id(),
      image(),
      descriptors() {}

WallpaperSearchResult::WallpaperSearchResult(
    const ::base::Token& id_in,
    const std::string& image_in,
    ResultDescriptorsPtr descriptors_in)
    : id(std::move(id_in)),
      image(std::move(image_in)),
      descriptors(std::move(descriptors_in)) {}

WallpaperSearchResult::~WallpaperSearchResult() = default;

void WallpaperSearchResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::Token&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image"), this->image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "descriptors"), this->descriptors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResultDescriptorsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WallpaperSearchResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResultDescriptors::ResultDescriptors()
    : subject(),
      style(),
      mood(),
      color() {}

ResultDescriptors::ResultDescriptors(
    const std::optional<std::string>& subject_in,
    const std::optional<std::string>& style_in,
    const std::optional<std::string>& mood_in,
    DescriptorDValuePtr color_in)
    : subject(std::move(subject_in)),
      style(std::move(style_in)),
      mood(std::move(mood_in)),
      color(std::move(color_in)) {}

ResultDescriptors::~ResultDescriptors() = default;

void ResultDescriptors::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subject"), this->subject,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mood"), this->mood,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DescriptorDValuePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResultDescriptors::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DescriptorDValuePtr
DescriptorDValue::NewColor(
    ::SkColor value) {
  return DescriptorDValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kColor)>,
      std::move(value));
}

DescriptorDValuePtr
DescriptorDValue::NewHue(
    float value) {
  return DescriptorDValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kHue)>,
      std::move(value));
}

DescriptorDValuePtr
DescriptorDValue::NewName(
    DescriptorDName value) {
  return DescriptorDValuePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kName)>,
      std::move(value));
}

DescriptorDValue::DescriptorDValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
    ::SkColor value)
    : tag_(Tag::kColor),
      data_(std::in_place_index<static_cast<size_t>(Tag::kColor)>,
            std::move(value)) {}

DescriptorDValue::DescriptorDValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kHue)>,
    float value)
    : tag_(Tag::kHue),
      data_(std::in_place_index<static_cast<size_t>(Tag::kHue)>,
            std::move(value)) {}

DescriptorDValue::DescriptorDValue(
    std::in_place_index_t<static_cast<size_t>(Tag::kName)>,
    DescriptorDName value)
    : tag_(Tag::kName),
      data_(std::in_place_index<static_cast<size_t>(Tag::kName)>,
            std::move(value)) {}
DescriptorDValue::~DescriptorDValue() {
  DestroyActive();
}

void DescriptorDValue::set_color(::SkColor color) {
  if (tag_ == Tag::kColor) {
    data_.color = std::move(color);
  } else {
    DestroyActive();
    tag_ = Tag::kColor;
    new (&data_.color) ::SkColor(
        std::move(color));
  }
}

void DescriptorDValue::set_hue(float hue) {
  if (tag_ != Tag::kHue) {
    DestroyActive();
    tag_ = Tag::kHue;
  }
  data_.hue = hue;
}

void DescriptorDValue::set_name(DescriptorDName name) {
  if (tag_ != Tag::kName) {
    DestroyActive();
    tag_ = Tag::kName;
  }
  data_.name = name;
}


DescriptorDValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kColor)>,
    ::SkColor value)
    : color(std::move(value)) {}

DescriptorDValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kHue)>,
    float value)
    : hue(std::move(value)) {}

DescriptorDValue::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kName)>,
    DescriptorDName value)
    : name(std::move(value)) {}

void DescriptorDValue::DestroyActive() {
  switch (tag_) {

    case Tag::kColor:
      std::destroy_at(&data_.color);
      break;
    case Tag::kHue:
      std::destroy_at(&data_.hue);
      break;
    case Tag::kName:
      std::destroy_at(&data_.name);
      break;
  }
}

bool DescriptorDValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WallpaperSearchHandlerFactory::IPCStableHashFunction WallpaperSearchHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WallpaperSearchHandlerFactory>(message.name())) {
    case messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler: {
      return &WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WallpaperSearchHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WallpaperSearchHandlerFactory>(message.name())) {
      case messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler";
    }
  } else {
    switch (static_cast<messages::WallpaperSearchHandlerFactory>(message.name())) {
      case messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd604976a;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WallpaperSearchHandlerFactoryProxy::WallpaperSearchHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WallpaperSearchHandlerFactoryProxy::CreateWallpaperSearchHandler(
    ::mojo::PendingRemote<WallpaperSearchClient> in_client, ::mojo::PendingReceiver<WallpaperSearchHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandlerFactory::CreateWallpaperSearchHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<WallpaperSearchClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<WallpaperSearchHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::side_panel::customize_chrome::mojom::WallpaperSearchClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in WallpaperSearchHandlerFactory.CreateWallpaperSearchHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::side_panel::customize_chrome::mojom::WallpaperSearchHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in WallpaperSearchHandlerFactory.CreateWallpaperSearchHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandlerFactory::Name_);
  message.set_method_name("CreateWallpaperSearchHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WallpaperSearchHandlerFactoryStubDispatch::Accept(
    WallpaperSearchHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WallpaperSearchHandlerFactory>(message->header()->name)) {
    case messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<WallpaperSearchClient> p_client{};
      ::mojo::PendingReceiver<WallpaperSearchHandler> p_handler{};
      WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWallpaperSearchHandler(        
        std::move(p_client), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool WallpaperSearchHandlerFactoryStubDispatch::AcceptWithResponder(
    WallpaperSearchHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WallpaperSearchHandlerFactory>(message->header()->name)) {
    case messages::WallpaperSearchHandlerFactory::kCreateWallpaperSearchHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWallpaperSearchHandlerFactoryValidationInfo[] = {
    { &internal::WallpaperSearchHandlerFactory_CreateWallpaperSearchHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool WallpaperSearchHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::WallpaperSearchHandlerFactory::Name_,
    kWallpaperSearchHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

WallpaperSearchHandler::IPCStableHashFunction WallpaperSearchHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WallpaperSearchHandler>(message.name())) {
    case messages::WallpaperSearchHandler::kGetDescriptors: {
      return &WallpaperSearchHandler::GetDescriptors_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kGetInspirations: {
      return &WallpaperSearchHandler::GetInspirations_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kGetWallpaperSearchResults: {
      return &WallpaperSearchHandler::GetWallpaperSearchResults_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kSetResultRenderTime: {
      return &WallpaperSearchHandler::SetResultRenderTime_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage: {
      return &WallpaperSearchHandler::SetBackgroundToHistoryImage_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage: {
      return &WallpaperSearchHandler::SetBackgroundToInspirationImage_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult: {
      return &WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kUpdateHistory: {
      return &WallpaperSearchHandler::UpdateHistory_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kSetUserFeedback: {
      return &WallpaperSearchHandler::SetUserFeedback_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kOpenHelpArticle: {
      return &WallpaperSearchHandler::OpenHelpArticle_Sym::IPCStableHash;
    }
    case messages::WallpaperSearchHandler::kLaunchHatsSurvey: {
      return &WallpaperSearchHandler::LaunchHatsSurvey_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WallpaperSearchHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WallpaperSearchHandler>(message.name())) {
      case messages::WallpaperSearchHandler::kGetDescriptors:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetDescriptors";
      case messages::WallpaperSearchHandler::kGetInspirations:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetInspirations";
      case messages::WallpaperSearchHandler::kGetWallpaperSearchResults:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetWallpaperSearchResults";
      case messages::WallpaperSearchHandler::kSetResultRenderTime:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetResultRenderTime";
      case messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToHistoryImage";
      case messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToInspirationImage";
      case messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult";
      case messages::WallpaperSearchHandler::kUpdateHistory:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::UpdateHistory";
      case messages::WallpaperSearchHandler::kSetUserFeedback:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetUserFeedback";
      case messages::WallpaperSearchHandler::kOpenHelpArticle:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::OpenHelpArticle";
      case messages::WallpaperSearchHandler::kLaunchHatsSurvey:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchHandler::LaunchHatsSurvey";
    }
  } else {
    switch (static_cast<messages::WallpaperSearchHandler>(message.name())) {
      case messages::WallpaperSearchHandler::kGetDescriptors:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetDescriptors";
      case messages::WallpaperSearchHandler::kGetInspirations:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetInspirations";
      case messages::WallpaperSearchHandler::kGetWallpaperSearchResults:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetWallpaperSearchResults";
      case messages::WallpaperSearchHandler::kSetResultRenderTime:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetResultRenderTime";
      case messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToHistoryImage";
      case messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToInspirationImage";
      case messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult";
      case messages::WallpaperSearchHandler::kUpdateHistory:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::UpdateHistory";
      case messages::WallpaperSearchHandler::kSetUserFeedback:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetUserFeedback";
      case messages::WallpaperSearchHandler::kOpenHelpArticle:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::OpenHelpArticle";
      case messages::WallpaperSearchHandler::kLaunchHatsSurvey:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::LaunchHatsSurvey";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WallpaperSearchHandler::GetDescriptors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x564c1aa8;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetDescriptors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::GetInspirations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3730d6b;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetInspirations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::GetWallpaperSearchResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10c5ac97;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetWallpaperSearchResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::SetResultRenderTime_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa35c3520;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetResultRenderTime
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::SetBackgroundToHistoryImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4c456294;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToHistoryImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::SetBackgroundToInspirationImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf45f2889;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToInspirationImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2edd758c;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::UpdateHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf7bb7137;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::UpdateHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::SetUserFeedback_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd700a6c2;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetUserFeedback
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::OpenHelpArticle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x888a9406;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::OpenHelpArticle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WallpaperSearchHandler::LaunchHatsSurvey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x730db4d5;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchHandler::LaunchHatsSurvey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WallpaperSearchHandler_GetDescriptors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WallpaperSearchHandler_GetDescriptors_ForwardToCallback(
      WallpaperSearchHandler::GetDescriptorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WallpaperSearchHandler_GetDescriptors_ForwardToCallback(const WallpaperSearchHandler_GetDescriptors_ForwardToCallback&) = delete;
  WallpaperSearchHandler_GetDescriptors_ForwardToCallback& operator=(const WallpaperSearchHandler_GetDescriptors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WallpaperSearchHandler::GetDescriptorsCallback callback_;
};

class WallpaperSearchHandler_GetInspirations_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WallpaperSearchHandler_GetInspirations_ForwardToCallback(
      WallpaperSearchHandler::GetInspirationsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WallpaperSearchHandler_GetInspirations_ForwardToCallback(const WallpaperSearchHandler_GetInspirations_ForwardToCallback&) = delete;
  WallpaperSearchHandler_GetInspirations_ForwardToCallback& operator=(const WallpaperSearchHandler_GetInspirations_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WallpaperSearchHandler::GetInspirationsCallback callback_;
};

class WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback(
      WallpaperSearchHandler::GetWallpaperSearchResultsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback(const WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback&) = delete;
  WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback& operator=(const WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WallpaperSearchHandler::GetWallpaperSearchResultsCallback callback_;
};

WallpaperSearchHandlerProxy::WallpaperSearchHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WallpaperSearchHandlerProxy::GetDescriptors(
    GetDescriptorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetDescriptors");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetDescriptors_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetDescriptors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WallpaperSearchHandler_GetDescriptors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WallpaperSearchHandlerProxy::GetInspirations(
    GetInspirationsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetInspirations");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetInspirations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetInspirations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetInspirations");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WallpaperSearchHandler_GetInspirations_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WallpaperSearchHandlerProxy::GetWallpaperSearchResults(
    ResultDescriptorsPtr in_result_descriptors, GetWallpaperSearchResultsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetWallpaperSearchResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_descriptors"), in_result_descriptors,
                        "<value of type ResultDescriptorsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetWallpaperSearchResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_descriptors)::BaseType> result_descriptors_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ResultDescriptorsDataView>(
    in_result_descriptors,
    result_descriptors_fragment);

  params->result_descriptors.Set(
      result_descriptors_fragment.is_null() ? nullptr : result_descriptors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_descriptors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_descriptors in WallpaperSearchHandler.GetWallpaperSearchResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetWallpaperSearchResults");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WallpaperSearchHandlerProxy::SetResultRenderTime(
    const std::vector<::base::Token>& in_result_ids, double in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetResultRenderTime", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_ids"), in_result_ids,
                        "<value of type const std::vector<::base::Token>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kSetResultRenderTime), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_SetResultRenderTime_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_ids)::BaseType>
      result_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::TokenDataView>>(
    in_result_ids,
    result_ids_fragment,
    &result_ids_validate_params);

  params->result_ids.Set(
      result_ids_fragment.is_null() ? nullptr : result_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_ids in WallpaperSearchHandler.SetResultRenderTime request");

  params->time = in_time;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("SetResultRenderTime");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::SetBackgroundToHistoryImage(
    const ::base::Token& in_result_id, ResultDescriptorsPtr in_descriptors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToHistoryImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_id"), in_result_id,
                        "<value of type const ::base::Token&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptors"), in_descriptors,
                        "<value of type ResultDescriptorsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_id)::BaseType> result_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_result_id,
    result_id_fragment);

  params->result_id.Set(
      result_id_fragment.is_null() ? nullptr : result_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_id in WallpaperSearchHandler.SetBackgroundToHistoryImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->descriptors)::BaseType> descriptors_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ResultDescriptorsDataView>(
    in_descriptors,
    descriptors_fragment);

  params->descriptors.Set(
      descriptors_fragment.is_null() ? nullptr : descriptors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptors in WallpaperSearchHandler.SetBackgroundToHistoryImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("SetBackgroundToHistoryImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::SetBackgroundToInspirationImage(
    const ::base::Token& in_id, const ::GURL& in_background_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToInspirationImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type const ::base::Token&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("background_url"), in_background_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->id)::BaseType> id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_id,
    id_fragment);

  params->id.Set(
      id_fragment.is_null() ? nullptr : id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null id in WallpaperSearchHandler.SetBackgroundToInspirationImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->background_url)::BaseType> background_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_background_url,
    background_url_fragment);

  params->background_url.Set(
      background_url_fragment.is_null() ? nullptr : background_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->background_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null background_url in WallpaperSearchHandler.SetBackgroundToInspirationImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("SetBackgroundToInspirationImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::SetBackgroundToWallpaperSearchResult(
    const ::base::Token& in_result_id, double in_time, ResultDescriptorsPtr in_descriptors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetBackgroundToWallpaperSearchResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_id"), in_result_id,
                        "<value of type const ::base::Token&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type double>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptors"), in_descriptors,
                        "<value of type ResultDescriptorsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_id)::BaseType> result_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TokenDataView>(
    in_result_id,
    result_id_fragment);

  params->result_id.Set(
      result_id_fragment.is_null() ? nullptr : result_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_id in WallpaperSearchHandler.SetBackgroundToWallpaperSearchResult request");

  params->time = in_time;
  mojo::internal::MessageFragment<
      typename decltype(params->descriptors)::BaseType> descriptors_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ResultDescriptorsDataView>(
    in_descriptors,
    descriptors_fragment);

  params->descriptors.Set(
      descriptors_fragment.is_null() ? nullptr : descriptors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->descriptors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null descriptors in WallpaperSearchHandler.SetBackgroundToWallpaperSearchResult request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("SetBackgroundToWallpaperSearchResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::UpdateHistory(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::UpdateHistory");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kUpdateHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_UpdateHistory_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("UpdateHistory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::SetUserFeedback(
    UserFeedback in_selected_option) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::SetUserFeedback", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("selected_option"), in_selected_option,
                        "<value of type UserFeedback>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kSetUserFeedback), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_SetUserFeedback_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::UserFeedback>(
    in_selected_option,
    &params->selected_option);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("SetUserFeedback");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::OpenHelpArticle(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::OpenHelpArticle");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kOpenHelpArticle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_OpenHelpArticle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("OpenHelpArticle");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WallpaperSearchHandlerProxy::LaunchHatsSurvey(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchHandler::LaunchHatsSurvey");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kLaunchHatsSurvey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_LaunchHatsSurvey_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("LaunchHatsSurvey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WallpaperSearchHandler_GetDescriptors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WallpaperSearchHandler::GetDescriptorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WallpaperSearchHandler_GetDescriptors_ProxyToResponder> proxy(
        new WallpaperSearchHandler_GetDescriptors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WallpaperSearchHandler_GetDescriptors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WallpaperSearchHandler_GetDescriptors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WallpaperSearchHandler_GetDescriptors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WallpaperSearchHandler::GetDescriptorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DescriptorsPtr in_descriptors);
};

bool WallpaperSearchHandler_GetDescriptors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WallpaperSearchHandler_GetDescriptors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WallpaperSearchHandler_GetDescriptors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WallpaperSearchHandler.0
  bool success = true;
  DescriptorsPtr p_descriptors{};
  WallpaperSearchHandler_GetDescriptors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDescriptors(&p_descriptors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WallpaperSearchHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_descriptors));
  }
  return true;
}

void WallpaperSearchHandler_GetDescriptors_ProxyToResponder::Run(
    DescriptorsPtr in_descriptors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetDescriptors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("descriptors"), in_descriptors,
                        "<value of type DescriptorsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetDescriptors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetDescriptors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->descriptors)::BaseType> descriptors_fragment(
          params.message());
  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::DescriptorsDataView>(
    in_descriptors,
    descriptors_fragment);

  params->descriptors.Set(
      descriptors_fragment.is_null() ? nullptr : descriptors_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetDescriptors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WallpaperSearchHandler_GetInspirations_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WallpaperSearchHandler::GetInspirationsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WallpaperSearchHandler_GetInspirations_ProxyToResponder> proxy(
        new WallpaperSearchHandler_GetInspirations_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WallpaperSearchHandler_GetInspirations_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WallpaperSearchHandler_GetInspirations_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WallpaperSearchHandler_GetInspirations_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WallpaperSearchHandler::GetInspirationsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<std::vector<InspirationGroupPtr>> in_inspirationGroups);
};

bool WallpaperSearchHandler_GetInspirations_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WallpaperSearchHandler_GetInspirations_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WallpaperSearchHandler_GetInspirations_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WallpaperSearchHandler.1
  bool success = true;
  std::optional<std::vector<InspirationGroupPtr>> p_inspirationGroups{};
  WallpaperSearchHandler_GetInspirations_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInspirationGroups(&p_inspirationGroups))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WallpaperSearchHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_inspirationGroups));
  }
  return true;
}

void WallpaperSearchHandler_GetInspirations_ProxyToResponder::Run(
    std::optional<std::vector<InspirationGroupPtr>> in_inspirationGroups) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetInspirations", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inspirationGroups"), in_inspirationGroups,
                        "<value of type std::optional<std::vector<InspirationGroupPtr>>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetInspirations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetInspirations_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->inspirationGroups)::BaseType>
      inspirationGroups_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& inspirationGroups_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::InspirationGroupDataView>>(
    in_inspirationGroups,
    inspirationGroups_fragment,
    &inspirationGroups_validate_params);

  params->inspirationGroups.Set(
      inspirationGroups_fragment.is_null() ? nullptr : inspirationGroups_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetInspirations");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WallpaperSearchHandler::GetWallpaperSearchResultsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder> proxy(
        new WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WallpaperSearchHandler::GetWallpaperSearchResultsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      WallpaperSearchStatus in_status, std::vector<WallpaperSearchResultPtr> in_results);
};

bool WallpaperSearchHandler_GetWallpaperSearchResults_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WallpaperSearchHandler.2
  bool success = true;
  WallpaperSearchStatus p_status{};
  std::vector<WallpaperSearchResultPtr> p_results{};
  WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WallpaperSearchHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_results));
  }
  return true;
}

void WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder::Run(
    WallpaperSearchStatus in_status, std::vector<WallpaperSearchResultPtr> in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::WallpaperSearchHandler::GetWallpaperSearchResults", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type WallpaperSearchStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type std::vector<WallpaperSearchResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchHandler::kGetWallpaperSearchResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::WallpaperSearchStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType>
      results_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::WallpaperSearchResultDataView>>(
    in_results,
    results_fragment,
    &results_validate_params);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchHandler::Name_);
  message.set_method_name("GetWallpaperSearchResults");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WallpaperSearchHandlerStubDispatch::Accept(
    WallpaperSearchHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WallpaperSearchHandler>(message->header()->name)) {
    case messages::WallpaperSearchHandler::kGetDescriptors: {
      break;
    }
    case messages::WallpaperSearchHandler::kGetInspirations: {
      break;
    }
    case messages::WallpaperSearchHandler::kGetWallpaperSearchResults: {
      break;
    }
    case messages::WallpaperSearchHandler::kSetResultRenderTime: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_SetResultRenderTime_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_SetResultRenderTime_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.3
      bool success = true;
      std::vector<::base::Token> p_result_ids{};
      double p_time{};
      WallpaperSearchHandler_SetResultRenderTime_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultIds(&p_result_ids))
        success = false;
      if (success)
        p_time = input_data_view.time();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetResultRenderTime(        
        std::move(p_result_ids), 
        std::move(p_time));
      return true;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.4
      bool success = true;
      ::base::Token p_result_id{};
      ResultDescriptorsPtr p_descriptors{};
      WallpaperSearchHandler_SetBackgroundToHistoryImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultId(&p_result_id))
        success = false;
      if (success && !input_data_view.ReadDescriptors(&p_descriptors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundToHistoryImage(        
        std::move(p_result_id), 
        std::move(p_descriptors));
      return true;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.5
      bool success = true;
      ::base::Token p_id{};
      ::GURL p_background_url{};
      WallpaperSearchHandler_SetBackgroundToInspirationImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadId(&p_id))
        success = false;
      if (success && !input_data_view.ReadBackgroundUrl(&p_background_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundToInspirationImage(        
        std::move(p_id), 
        std::move(p_background_url));
      return true;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.6
      bool success = true;
      ::base::Token p_result_id{};
      double p_time{};
      ResultDescriptorsPtr p_descriptors{};
      WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultId(&p_result_id))
        success = false;
      if (success)
        p_time = input_data_view.time();
      if (success && !input_data_view.ReadDescriptors(&p_descriptors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundToWallpaperSearchResult(        
        std::move(p_result_id), 
        std::move(p_time), 
        std::move(p_descriptors));
      return true;
    }
    case messages::WallpaperSearchHandler::kUpdateHistory: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_UpdateHistory_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_UpdateHistory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.7
      bool success = true;
      WallpaperSearchHandler_UpdateHistory_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateHistory(        );
      return true;
    }
    case messages::WallpaperSearchHandler::kSetUserFeedback: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_SetUserFeedback_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_SetUserFeedback_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.8
      bool success = true;
      UserFeedback p_selected_option{};
      WallpaperSearchHandler_SetUserFeedback_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSelectedOption(&p_selected_option))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserFeedback(        
        std::move(p_selected_option));
      return true;
    }
    case messages::WallpaperSearchHandler::kOpenHelpArticle: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_OpenHelpArticle_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_OpenHelpArticle_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.9
      bool success = true;
      WallpaperSearchHandler_OpenHelpArticle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenHelpArticle(        );
      return true;
    }
    case messages::WallpaperSearchHandler::kLaunchHatsSurvey: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchHandler_LaunchHatsSurvey_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchHandler_LaunchHatsSurvey_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.10
      bool success = true;
      WallpaperSearchHandler_LaunchHatsSurvey_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LaunchHatsSurvey(        );
      return true;
    }
  }
  return false;
}

// static
bool WallpaperSearchHandlerStubDispatch::AcceptWithResponder(
    WallpaperSearchHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WallpaperSearchHandler>(message->header()->name)) {
    case messages::WallpaperSearchHandler::kGetDescriptors: {
      internal::WallpaperSearchHandler_GetDescriptors_Params_Data* params =
          reinterpret_cast<
              internal::WallpaperSearchHandler_GetDescriptors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.0
      bool success = true;
      WallpaperSearchHandler_GetDescriptors_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          WallpaperSearchHandler_GetDescriptors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDescriptors(std::move(callback));
      return true;
    }
    case messages::WallpaperSearchHandler::kGetInspirations: {
      internal::WallpaperSearchHandler_GetInspirations_Params_Data* params =
          reinterpret_cast<
              internal::WallpaperSearchHandler_GetInspirations_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.1
      bool success = true;
      WallpaperSearchHandler_GetInspirations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          WallpaperSearchHandler_GetInspirations_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInspirations(std::move(callback));
      return true;
    }
    case messages::WallpaperSearchHandler::kGetWallpaperSearchResults: {
      internal::WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data* params =
          reinterpret_cast<
              internal::WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WallpaperSearchHandler.2
      bool success = true;
      ResultDescriptorsPtr p_result_descriptors{};
      WallpaperSearchHandler_GetWallpaperSearchResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultDescriptors(&p_result_descriptors))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          WallpaperSearchHandler_GetWallpaperSearchResults_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWallpaperSearchResults(        
        std::move(p_result_descriptors), std::move(callback));
      return true;
    }
    case messages::WallpaperSearchHandler::kSetResultRenderTime: {
      break;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToHistoryImage: {
      break;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToInspirationImage: {
      break;
    }
    case messages::WallpaperSearchHandler::kSetBackgroundToWallpaperSearchResult: {
      break;
    }
    case messages::WallpaperSearchHandler::kUpdateHistory: {
      break;
    }
    case messages::WallpaperSearchHandler::kSetUserFeedback: {
      break;
    }
    case messages::WallpaperSearchHandler::kOpenHelpArticle: {
      break;
    }
    case messages::WallpaperSearchHandler::kLaunchHatsSurvey: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWallpaperSearchHandlerValidationInfo[] = {
    { &internal::WallpaperSearchHandler_GetDescriptors_Params_Data::Validate,
     &internal::WallpaperSearchHandler_GetDescriptors_ResponseParams_Data::Validate},
    { &internal::WallpaperSearchHandler_GetInspirations_Params_Data::Validate,
     &internal::WallpaperSearchHandler_GetInspirations_ResponseParams_Data::Validate},
    { &internal::WallpaperSearchHandler_GetWallpaperSearchResults_Params_Data::Validate,
     &internal::WallpaperSearchHandler_GetWallpaperSearchResults_ResponseParams_Data::Validate},
    { &internal::WallpaperSearchHandler_SetResultRenderTime_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_SetBackgroundToHistoryImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_SetBackgroundToInspirationImage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_SetBackgroundToWallpaperSearchResult_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_UpdateHistory_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_SetUserFeedback_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_OpenHelpArticle_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WallpaperSearchHandler_LaunchHatsSurvey_Params_Data::Validate,
     nullptr /* no response */},
};

bool WallpaperSearchHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::WallpaperSearchHandler::Name_,
    kWallpaperSearchHandlerValidationInfo);
}

bool WallpaperSearchHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::WallpaperSearchHandler::Name_,
    kWallpaperSearchHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

WallpaperSearchClient::IPCStableHashFunction WallpaperSearchClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WallpaperSearchClient>(message.name())) {
    case messages::WallpaperSearchClient::kSetHistory: {
      return &WallpaperSearchClient::SetHistory_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WallpaperSearchClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WallpaperSearchClient>(message.name())) {
      case messages::WallpaperSearchClient::kSetHistory:
            return "Receive side_panel::customize_chrome::mojom::WallpaperSearchClient::SetHistory";
    }
  } else {
    switch (static_cast<messages::WallpaperSearchClient>(message.name())) {
      case messages::WallpaperSearchClient::kSetHistory:
            return "Receive reply side_panel::customize_chrome::mojom::WallpaperSearchClient::SetHistory";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WallpaperSearchClient::SetHistory_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22234e38;  // IPCStableHash for side_panel::customize_chrome::mojom::WallpaperSearchClient::SetHistory
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WallpaperSearchClientProxy::WallpaperSearchClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WallpaperSearchClientProxy::SetHistory(
    std::vector<WallpaperSearchResultPtr> in_history) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::WallpaperSearchClient::SetHistory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("history"), in_history,
                        "<value of type std::vector<WallpaperSearchResultPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WallpaperSearchClient::kSetHistory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::WallpaperSearchClient_SetHistory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->history)::BaseType>
      history_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& history_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::WallpaperSearchResultDataView>>(
    in_history,
    history_fragment,
    &history_validate_params);

  params->history.Set(
      history_fragment.is_null() ? nullptr : history_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->history.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null history in WallpaperSearchClient.SetHistory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WallpaperSearchClient::Name_);
  message.set_method_name("SetHistory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WallpaperSearchClientStubDispatch::Accept(
    WallpaperSearchClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WallpaperSearchClient>(message->header()->name)) {
    case messages::WallpaperSearchClient::kSetHistory: {
      DCHECK(message->is_serialized());
      internal::WallpaperSearchClient_SetHistory_Params_Data* params =
          reinterpret_cast<internal::WallpaperSearchClient_SetHistory_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WallpaperSearchClient.0
      bool success = true;
      std::vector<WallpaperSearchResultPtr> p_history{};
      WallpaperSearchClient_SetHistory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHistory(&p_history))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WallpaperSearchClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHistory(        
        std::move(p_history));
      return true;
    }
  }
  return false;
}

// static
bool WallpaperSearchClientStubDispatch::AcceptWithResponder(
    WallpaperSearchClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WallpaperSearchClient>(message->header()->name)) {
    case messages::WallpaperSearchClient::kSetHistory: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWallpaperSearchClientValidationInfo[] = {
    { &internal::WallpaperSearchClient_SetHistory_Params_Data::Validate,
     nullptr /* no response */},
};

bool WallpaperSearchClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::WallpaperSearchClient::Name_,
    kWallpaperSearchClientValidationInfo);
}



}  // side_panel::customize_chrome::mojom


namespace mojo {


// static
bool StructTraits<::side_panel::customize_chrome::mojom::KeyLabel::DataView, ::side_panel::customize_chrome::mojom::KeyLabelPtr>::Read(
    ::side_panel::customize_chrome::mojom::KeyLabel::DataView input,
    ::side_panel::customize_chrome::mojom::KeyLabelPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::KeyLabelPtr result(::side_panel::customize_chrome::mojom::KeyLabel::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::Group::DataView, ::side_panel::customize_chrome::mojom::GroupPtr>::Read(
    ::side_panel::customize_chrome::mojom::Group::DataView input,
    ::side_panel::customize_chrome::mojom::GroupPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::GroupPtr result(::side_panel::customize_chrome::mojom::Group::New());
  
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadDescriptorAs(&result->descriptor_as))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::DescriptorB::DataView, ::side_panel::customize_chrome::mojom::DescriptorBPtr>::Read(
    ::side_panel::customize_chrome::mojom::DescriptorB::DataView input,
    ::side_panel::customize_chrome::mojom::DescriptorBPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::DescriptorBPtr result(::side_panel::customize_chrome::mojom::DescriptorB::New());
  
      if (success && !input.ReadKey(&result->key))
        success = false;
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadImagePath(&result->image_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::Descriptors::DataView, ::side_panel::customize_chrome::mojom::DescriptorsPtr>::Read(
    ::side_panel::customize_chrome::mojom::Descriptors::DataView input,
    ::side_panel::customize_chrome::mojom::DescriptorsPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::DescriptorsPtr result(::side_panel::customize_chrome::mojom::Descriptors::New());
  
      if (success && !input.ReadGroups(&result->groups))
        success = false;
      if (success && !input.ReadDescriptorB(&result->descriptor_b))
        success = false;
      if (success && !input.ReadDescriptorC(&result->descriptor_c))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::Inspiration::DataView, ::side_panel::customize_chrome::mojom::InspirationPtr>::Read(
    ::side_panel::customize_chrome::mojom::Inspiration::DataView input,
    ::side_panel::customize_chrome::mojom::InspirationPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::InspirationPtr result(::side_panel::customize_chrome::mojom::Inspiration::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadBackgroundUrl(&result->background_url))
        success = false;
      if (success && !input.ReadThumbnailUrl(&result->thumbnail_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::InspirationDescriptors::DataView, ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr>::Read(
    ::side_panel::customize_chrome::mojom::InspirationDescriptors::DataView input,
    ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::InspirationDescriptorsPtr result(::side_panel::customize_chrome::mojom::InspirationDescriptors::New());
  
      if (success && !input.ReadSubject(&result->subject))
        success = false;
      if (success && !input.ReadStyle(&result->style))
        success = false;
      if (success && !input.ReadMood(&result->mood))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::InspirationGroup::DataView, ::side_panel::customize_chrome::mojom::InspirationGroupPtr>::Read(
    ::side_panel::customize_chrome::mojom::InspirationGroup::DataView input,
    ::side_panel::customize_chrome::mojom::InspirationGroupPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::InspirationGroupPtr result(::side_panel::customize_chrome::mojom::InspirationGroup::New());
  
      if (success && !input.ReadDescriptors(&result->descriptors))
        success = false;
      if (success && !input.ReadInspirations(&result->inspirations))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::WallpaperSearchResult::DataView, ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr>::Read(
    ::side_panel::customize_chrome::mojom::WallpaperSearchResult::DataView input,
    ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::WallpaperSearchResultPtr result(::side_panel::customize_chrome::mojom::WallpaperSearchResult::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadImage(&result->image))
        success = false;
      if (success && !input.ReadDescriptors(&result->descriptors))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::ResultDescriptors::DataView, ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr>::Read(
    ::side_panel::customize_chrome::mojom::ResultDescriptors::DataView input,
    ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::ResultDescriptorsPtr result(::side_panel::customize_chrome::mojom::ResultDescriptors::New());
  
      if (success && !input.ReadSubject(&result->subject))
        success = false;
      if (success && !input.ReadStyle(&result->style))
        success = false;
      if (success && !input.ReadMood(&result->mood))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::side_panel::customize_chrome::mojom::DescriptorDValue::DataView, ::side_panel::customize_chrome::mojom::DescriptorDValuePtr>::Read(
    ::side_panel::customize_chrome::mojom::DescriptorDValue::DataView input,
    ::side_panel::customize_chrome::mojom::DescriptorDValuePtr* output) {
  using UnionType = ::side_panel::customize_chrome::mojom::DescriptorDValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kColor: {
      ::SkColor result_color{};
      if (!input.ReadColor(&result_color))
        return false;

      *output = UnionType::NewColor(
          std::move(result_color));
      break;
    }
    case Tag::kHue: {
      *output = UnionType::NewHue(input.hue());
      break;
    }
    case Tag::kName: {
      ::side_panel::customize_chrome::mojom::DescriptorDName result_name;
      if (!input.ReadName(&result_name))
        return false;

      *output = UnionType::NewName(result_name);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace side_panel::customize_chrome::mojom {


void WallpaperSearchHandlerFactoryInterceptorForTesting::CreateWallpaperSearchHandler(::mojo::PendingRemote<WallpaperSearchClient> client, ::mojo::PendingReceiver<WallpaperSearchHandler> handler) {
  GetForwardingInterface()->CreateWallpaperSearchHandler(
    std::move(client)
    , 
    std::move(handler)
    );
}
WallpaperSearchHandlerFactoryAsyncWaiter::WallpaperSearchHandlerFactoryAsyncWaiter(
    WallpaperSearchHandlerFactory* proxy) : proxy_(proxy) {}

WallpaperSearchHandlerFactoryAsyncWaiter::~WallpaperSearchHandlerFactoryAsyncWaiter() = default;





void WallpaperSearchHandlerInterceptorForTesting::GetDescriptors(GetDescriptorsCallback callback) {
  GetForwardingInterface()->GetDescriptors(std::move(callback));
}
void WallpaperSearchHandlerInterceptorForTesting::GetInspirations(GetInspirationsCallback callback) {
  GetForwardingInterface()->GetInspirations(std::move(callback));
}
void WallpaperSearchHandlerInterceptorForTesting::GetWallpaperSearchResults(ResultDescriptorsPtr result_descriptors, GetWallpaperSearchResultsCallback callback) {
  GetForwardingInterface()->GetWallpaperSearchResults(
    std::move(result_descriptors)
    , std::move(callback));
}
void WallpaperSearchHandlerInterceptorForTesting::SetResultRenderTime(const std::vector<::base::Token>& result_ids, double time) {
  GetForwardingInterface()->SetResultRenderTime(
    std::move(result_ids)
    , 
    std::move(time)
    );
}
void WallpaperSearchHandlerInterceptorForTesting::SetBackgroundToHistoryImage(const ::base::Token& result_id, ResultDescriptorsPtr descriptors) {
  GetForwardingInterface()->SetBackgroundToHistoryImage(
    std::move(result_id)
    , 
    std::move(descriptors)
    );
}
void WallpaperSearchHandlerInterceptorForTesting::SetBackgroundToInspirationImage(const ::base::Token& id, const ::GURL& background_url) {
  GetForwardingInterface()->SetBackgroundToInspirationImage(
    std::move(id)
    , 
    std::move(background_url)
    );
}
void WallpaperSearchHandlerInterceptorForTesting::SetBackgroundToWallpaperSearchResult(const ::base::Token& result_id, double time, ResultDescriptorsPtr descriptors) {
  GetForwardingInterface()->SetBackgroundToWallpaperSearchResult(
    std::move(result_id)
    , 
    std::move(time)
    , 
    std::move(descriptors)
    );
}
void WallpaperSearchHandlerInterceptorForTesting::UpdateHistory() {
  GetForwardingInterface()->UpdateHistory();
}
void WallpaperSearchHandlerInterceptorForTesting::SetUserFeedback(UserFeedback selected_option) {
  GetForwardingInterface()->SetUserFeedback(
    std::move(selected_option)
    );
}
void WallpaperSearchHandlerInterceptorForTesting::OpenHelpArticle() {
  GetForwardingInterface()->OpenHelpArticle();
}
void WallpaperSearchHandlerInterceptorForTesting::LaunchHatsSurvey() {
  GetForwardingInterface()->LaunchHatsSurvey();
}
WallpaperSearchHandlerAsyncWaiter::WallpaperSearchHandlerAsyncWaiter(
    WallpaperSearchHandler* proxy) : proxy_(proxy) {}

WallpaperSearchHandlerAsyncWaiter::~WallpaperSearchHandlerAsyncWaiter() = default;


void WallpaperSearchHandlerAsyncWaiter::GetDescriptors(
    DescriptorsPtr* out_descriptors) {
  base::RunLoop loop;
  proxy_->GetDescriptors(
      base::BindOnce(
          [](base::RunLoop* loop,
             DescriptorsPtr* out_descriptors
,
             DescriptorsPtr descriptors) {*out_descriptors = std::move(descriptors);
            loop->Quit();
          },
          &loop,
          out_descriptors));
  loop.Run();
}

DescriptorsPtr WallpaperSearchHandlerAsyncWaiter::GetDescriptors(
    ) {
  DescriptorsPtr async_wait_result;
  GetDescriptors(&async_wait_result);
  return async_wait_result;
}

void WallpaperSearchHandlerAsyncWaiter::GetInspirations(
    std::optional<std::vector<InspirationGroupPtr>>* out_inspirationGroups) {
  base::RunLoop loop;
  proxy_->GetInspirations(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<InspirationGroupPtr>>* out_inspirationGroups
,
             std::optional<std::vector<InspirationGroupPtr>> inspirationGroups) {*out_inspirationGroups = std::move(inspirationGroups);
            loop->Quit();
          },
          &loop,
          out_inspirationGroups));
  loop.Run();
}

std::optional<std::vector<InspirationGroupPtr>> WallpaperSearchHandlerAsyncWaiter::GetInspirations(
    ) {
  std::optional<std::vector<InspirationGroupPtr>> async_wait_result;
  GetInspirations(&async_wait_result);
  return async_wait_result;
}

void WallpaperSearchHandlerAsyncWaiter::GetWallpaperSearchResults(
    ResultDescriptorsPtr result_descriptors, WallpaperSearchStatus* out_status, std::vector<WallpaperSearchResultPtr>* out_results) {
  base::RunLoop loop;
  proxy_->GetWallpaperSearchResults(
      std::move(result_descriptors),
      base::BindOnce(
          [](base::RunLoop* loop,
             WallpaperSearchStatus* out_status
,
             std::vector<WallpaperSearchResultPtr>* out_results
,
             WallpaperSearchStatus status,
             std::vector<WallpaperSearchResultPtr> results) {*out_status = std::move(status);*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_status,
          out_results));
  loop.Run();
}






void WallpaperSearchClientInterceptorForTesting::SetHistory(std::vector<WallpaperSearchResultPtr> history) {
  GetForwardingInterface()->SetHistory(
    std::move(history)
    );
}
WallpaperSearchClientAsyncWaiter::WallpaperSearchClientAsyncWaiter(
    WallpaperSearchClient* proxy) : proxy_(proxy) {}

WallpaperSearchClientAsyncWaiter::~WallpaperSearchClientAsyncWaiter() = default;







}  // side_panel::customize_chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif