// chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-params-data.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-import-headers.h"
#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_toolbar/customize_toolbar.mojom-test-utils.h"


namespace side_panel::customize_chrome::mojom {
Action::Action()
    : id(),
      display_name(),
      pinned(),
      has_enterprise_controlled_pinned_state(),
      category(),
      icon_url() {}

Action::Action(
    ActionId id_in,
    const std::string& display_name_in,
    bool pinned_in,
    bool has_enterprise_controlled_pinned_state_in,
    CategoryId category_in,
    const ::GURL& icon_url_in)
    : id(std::move(id_in)),
      display_name(std::move(display_name_in)),
      pinned(std::move(pinned_in)),
      has_enterprise_controlled_pinned_state(std::move(has_enterprise_controlled_pinned_state_in)),
      category(std::move(category_in)),
      icon_url(std::move(icon_url_in)) {}

Action::~Action() = default;

void Action::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ActionId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinned"), this->pinned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_enterprise_controlled_pinned_state"), this->has_enterprise_controlled_pinned_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category"), this->category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CategoryId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_url"), this->icon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Action::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Category::Category()
    : id(),
      display_name() {}

Category::Category(
    CategoryId id_in,
    const std::string& display_name_in)
    : id(std::move(id_in)),
      display_name(std::move(display_name_in)) {}

Category::~Category() = default;
size_t Category::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->display_name);
  return seed;
}

void Category::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CategoryId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Category::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CustomizeToolbarHandlerFactory::IPCStableHashFunction CustomizeToolbarHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeToolbarHandlerFactory>(message.name())) {
    case messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler: {
      return &CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeToolbarHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeToolbarHandlerFactory>(message.name())) {
      case messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler";
    }
  } else {
    switch (static_cast<messages::CustomizeToolbarHandlerFactory>(message.name())) {
      case messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab7f0a51;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeToolbarHandlerFactoryProxy::CustomizeToolbarHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeToolbarHandlerFactoryProxy::CreateCustomizeToolbarHandler(
    ::mojo::PendingRemote<CustomizeToolbarClient> in_client, ::mojo::PendingReceiver<CustomizeToolbarHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandlerFactory::CreateCustomizeToolbarHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<CustomizeToolbarClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CustomizeToolbarHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::side_panel::customize_chrome::mojom::CustomizeToolbarClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in CustomizeToolbarHandlerFactory.CreateCustomizeToolbarHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::side_panel::customize_chrome::mojom::CustomizeToolbarHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CustomizeToolbarHandlerFactory.CreateCustomizeToolbarHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandlerFactory::Name_);
  message.set_method_name("CreateCustomizeToolbarHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeToolbarHandlerFactoryStubDispatch::Accept(
    CustomizeToolbarHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeToolbarHandlerFactory>(message->header()->name)) {
    case messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler: {
      DCHECK(message->is_serialized());
      internal::CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data* params =
          reinterpret_cast<internal::CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeToolbarHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<CustomizeToolbarClient> p_client{};
      ::mojo::PendingReceiver<CustomizeToolbarHandler> p_handler{};
      CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCustomizeToolbarHandler(        
        std::move(p_client), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeToolbarHandlerFactoryStubDispatch::AcceptWithResponder(
    CustomizeToolbarHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeToolbarHandlerFactory>(message->header()->name)) {
    case messages::CustomizeToolbarHandlerFactory::kCreateCustomizeToolbarHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeToolbarHandlerFactoryValidationInfo[] = {
    { &internal::CustomizeToolbarHandlerFactory_CreateCustomizeToolbarHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeToolbarHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::CustomizeToolbarHandlerFactory::Name_,
    kCustomizeToolbarHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CustomizeToolbarHandler::IPCStableHashFunction CustomizeToolbarHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeToolbarHandler>(message.name())) {
    case messages::CustomizeToolbarHandler::kListActions: {
      return &CustomizeToolbarHandler::ListActions_Sym::IPCStableHash;
    }
    case messages::CustomizeToolbarHandler::kListCategories: {
      return &CustomizeToolbarHandler::ListCategories_Sym::IPCStableHash;
    }
    case messages::CustomizeToolbarHandler::kPinAction: {
      return &CustomizeToolbarHandler::PinAction_Sym::IPCStableHash;
    }
    case messages::CustomizeToolbarHandler::kGetIsCustomized: {
      return &CustomizeToolbarHandler::GetIsCustomized_Sym::IPCStableHash;
    }
    case messages::CustomizeToolbarHandler::kResetToDefault: {
      return &CustomizeToolbarHandler::ResetToDefault_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeToolbarHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeToolbarHandler>(message.name())) {
      case messages::CustomizeToolbarHandler::kListActions:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListActions";
      case messages::CustomizeToolbarHandler::kListCategories:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListCategories";
      case messages::CustomizeToolbarHandler::kPinAction:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandler::PinAction";
      case messages::CustomizeToolbarHandler::kGetIsCustomized:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandler::GetIsCustomized";
      case messages::CustomizeToolbarHandler::kResetToDefault:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ResetToDefault";
    }
  } else {
    switch (static_cast<messages::CustomizeToolbarHandler>(message.name())) {
      case messages::CustomizeToolbarHandler::kListActions:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListActions";
      case messages::CustomizeToolbarHandler::kListCategories:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListCategories";
      case messages::CustomizeToolbarHandler::kPinAction:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::PinAction";
      case messages::CustomizeToolbarHandler::kGetIsCustomized:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::GetIsCustomized";
      case messages::CustomizeToolbarHandler::kResetToDefault:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ResetToDefault";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeToolbarHandler::ListActions_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36f7bcf1;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListActions
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeToolbarHandler::ListCategories_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f19a75b;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListCategories
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeToolbarHandler::PinAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9f1ce049;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandler::PinAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeToolbarHandler::GetIsCustomized_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec4d4a2e;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandler::GetIsCustomized
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeToolbarHandler::ResetToDefault_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x91cdd5f5;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ResetToDefault
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CustomizeToolbarHandler_ListActions_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeToolbarHandler_ListActions_ForwardToCallback(
      CustomizeToolbarHandler::ListActionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeToolbarHandler_ListActions_ForwardToCallback(const CustomizeToolbarHandler_ListActions_ForwardToCallback&) = delete;
  CustomizeToolbarHandler_ListActions_ForwardToCallback& operator=(const CustomizeToolbarHandler_ListActions_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeToolbarHandler::ListActionsCallback callback_;
};

class CustomizeToolbarHandler_ListCategories_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeToolbarHandler_ListCategories_ForwardToCallback(
      CustomizeToolbarHandler::ListCategoriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeToolbarHandler_ListCategories_ForwardToCallback(const CustomizeToolbarHandler_ListCategories_ForwardToCallback&) = delete;
  CustomizeToolbarHandler_ListCategories_ForwardToCallback& operator=(const CustomizeToolbarHandler_ListCategories_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeToolbarHandler::ListCategoriesCallback callback_;
};

class CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback(
      CustomizeToolbarHandler::GetIsCustomizedCallback callback
      ) : callback_(std::move(callback)) {
  }

  CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback(const CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback&) = delete;
  CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback& operator=(const CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CustomizeToolbarHandler::GetIsCustomizedCallback callback_;
};

CustomizeToolbarHandlerProxy::CustomizeToolbarHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeToolbarHandlerProxy::ListActions(
    ListActionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListActions");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kListActions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_ListActions_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("ListActions");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeToolbarHandler_ListActions_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeToolbarHandlerProxy::ListCategories(
    ListCategoriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListCategories");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kListCategories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_ListCategories_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("ListCategories");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeToolbarHandler_ListCategories_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeToolbarHandlerProxy::PinAction(
    ActionId in_action_id, bool in_pinned) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandler::PinAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_id"), in_action_id,
                        "<value of type ActionId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinned"), in_pinned,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kPinAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_PinAction_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ActionId>(
    in_action_id,
    &params->action_id);

  params->pinned = in_pinned;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("PinAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeToolbarHandlerProxy::GetIsCustomized(
    GetIsCustomizedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandler::GetIsCustomized");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kGetIsCustomized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_GetIsCustomized_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("GetIsCustomized");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CustomizeToolbarHandlerProxy::ResetToDefault(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ResetToDefault");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kResetToDefault), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_ResetToDefault_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("ResetToDefault");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CustomizeToolbarHandler_ListActions_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeToolbarHandler::ListActionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeToolbarHandler_ListActions_ProxyToResponder> proxy(
        new CustomizeToolbarHandler_ListActions_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeToolbarHandler_ListActions_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeToolbarHandler_ListActions_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeToolbarHandler_ListActions_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeToolbarHandler::ListActionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ActionPtr> in_actions);
};

bool CustomizeToolbarHandler_ListActions_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeToolbarHandler_ListActions_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeToolbarHandler_ListActions_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeToolbarHandler.0
  bool success = true;
  std::vector<ActionPtr> p_actions{};
  CustomizeToolbarHandler_ListActions_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadActions(&p_actions))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeToolbarHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_actions));
  }
  return true;
}

void CustomizeToolbarHandler_ListActions_ProxyToResponder::Run(
    std::vector<ActionPtr> in_actions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListActions", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("actions"), in_actions,
                        "<value of type std::vector<ActionPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kListActions), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_ListActions_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->actions)::BaseType>
      actions_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& actions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::ActionDataView>>(
    in_actions,
    actions_fragment,
    &actions_validate_params);

  params->actions.Set(
      actions_fragment.is_null() ? nullptr : actions_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->actions.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null actions in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("ListActions");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CustomizeToolbarHandler_ListCategories_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeToolbarHandler::ListCategoriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeToolbarHandler_ListCategories_ProxyToResponder> proxy(
        new CustomizeToolbarHandler_ListCategories_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeToolbarHandler_ListCategories_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeToolbarHandler_ListCategories_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeToolbarHandler_ListCategories_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeToolbarHandler::ListCategoriesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<CategoryPtr> in_categories);
};

bool CustomizeToolbarHandler_ListCategories_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeToolbarHandler_ListCategories_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeToolbarHandler_ListCategories_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeToolbarHandler.1
  bool success = true;
  std::vector<CategoryPtr> p_categories{};
  CustomizeToolbarHandler_ListCategories_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCategories(&p_categories))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeToolbarHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_categories));
  }
  return true;
}

void CustomizeToolbarHandler_ListCategories_ProxyToResponder::Run(
    std::vector<CategoryPtr> in_categories) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::ListCategories", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("categories"), in_categories,
                        "<value of type std::vector<CategoryPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kListCategories), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_ListCategories_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->categories)::BaseType>
      categories_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& categories_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::side_panel::customize_chrome::mojom::CategoryDataView>>(
    in_categories,
    categories_fragment,
    &categories_validate_params);

  params->categories.Set(
      categories_fragment.is_null() ? nullptr : categories_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->categories.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null categories in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("ListCategories");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CustomizeToolbarHandler::GetIsCustomizedCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder> proxy(
        new CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CustomizeToolbarHandler::GetIsCustomizedCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_customized);
};

bool CustomizeToolbarHandler_GetIsCustomized_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CustomizeToolbarHandler.3
  bool success = true;
  bool p_customized{};
  CustomizeToolbarHandler_GetIsCustomized_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_customized = input_data_view.customized();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomizeToolbarHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_customized));
  }
  return true;
}

void CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder::Run(
    bool in_customized) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply side_panel::customize_chrome::mojom::CustomizeToolbarHandler::GetIsCustomized", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("customized"), in_customized,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarHandler::kGetIsCustomized), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->customized = in_customized;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarHandler::Name_);
  message.set_method_name("GetIsCustomized");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CustomizeToolbarHandlerStubDispatch::Accept(
    CustomizeToolbarHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeToolbarHandler>(message->header()->name)) {
    case messages::CustomizeToolbarHandler::kListActions: {
      break;
    }
    case messages::CustomizeToolbarHandler::kListCategories: {
      break;
    }
    case messages::CustomizeToolbarHandler::kPinAction: {
      DCHECK(message->is_serialized());
      internal::CustomizeToolbarHandler_PinAction_Params_Data* params =
          reinterpret_cast<internal::CustomizeToolbarHandler_PinAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeToolbarHandler.2
      bool success = true;
      ActionId p_action_id{};
      bool p_pinned{};
      CustomizeToolbarHandler_PinAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionId(&p_action_id))
        success = false;
      if (success)
        p_pinned = input_data_view.pinned();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PinAction(        
        std::move(p_action_id), 
        std::move(p_pinned));
      return true;
    }
    case messages::CustomizeToolbarHandler::kGetIsCustomized: {
      break;
    }
    case messages::CustomizeToolbarHandler::kResetToDefault: {
      DCHECK(message->is_serialized());
      internal::CustomizeToolbarHandler_ResetToDefault_Params_Data* params =
          reinterpret_cast<internal::CustomizeToolbarHandler_ResetToDefault_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeToolbarHandler.4
      bool success = true;
      CustomizeToolbarHandler_ResetToDefault_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetToDefault(        );
      return true;
    }
  }
  return false;
}

// static
bool CustomizeToolbarHandlerStubDispatch::AcceptWithResponder(
    CustomizeToolbarHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeToolbarHandler>(message->header()->name)) {
    case messages::CustomizeToolbarHandler::kListActions: {
      internal::CustomizeToolbarHandler_ListActions_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeToolbarHandler_ListActions_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeToolbarHandler.0
      bool success = true;
      CustomizeToolbarHandler_ListActions_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          CustomizeToolbarHandler_ListActions_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListActions(std::move(callback));
      return true;
    }
    case messages::CustomizeToolbarHandler::kListCategories: {
      internal::CustomizeToolbarHandler_ListCategories_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeToolbarHandler_ListCategories_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeToolbarHandler.1
      bool success = true;
      CustomizeToolbarHandler_ListCategories_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          CustomizeToolbarHandler_ListCategories_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ListCategories(std::move(callback));
      return true;
    }
    case messages::CustomizeToolbarHandler::kPinAction: {
      break;
    }
    case messages::CustomizeToolbarHandler::kGetIsCustomized: {
      internal::CustomizeToolbarHandler_GetIsCustomized_Params_Data* params =
          reinterpret_cast<
              internal::CustomizeToolbarHandler_GetIsCustomized_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CustomizeToolbarHandler.3
      bool success = true;
      CustomizeToolbarHandler_GetIsCustomized_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          CustomizeToolbarHandler_GetIsCustomized_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsCustomized(std::move(callback));
      return true;
    }
    case messages::CustomizeToolbarHandler::kResetToDefault: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeToolbarHandlerValidationInfo[] = {
    { &internal::CustomizeToolbarHandler_ListActions_Params_Data::Validate,
     &internal::CustomizeToolbarHandler_ListActions_ResponseParams_Data::Validate},
    { &internal::CustomizeToolbarHandler_ListCategories_Params_Data::Validate,
     &internal::CustomizeToolbarHandler_ListCategories_ResponseParams_Data::Validate},
    { &internal::CustomizeToolbarHandler_PinAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeToolbarHandler_GetIsCustomized_Params_Data::Validate,
     &internal::CustomizeToolbarHandler_GetIsCustomized_ResponseParams_Data::Validate},
    { &internal::CustomizeToolbarHandler_ResetToDefault_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeToolbarHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::CustomizeToolbarHandler::Name_,
    kCustomizeToolbarHandlerValidationInfo);
}

bool CustomizeToolbarHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::CustomizeToolbarHandler::Name_,
    kCustomizeToolbarHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

CustomizeToolbarClient::IPCStableHashFunction CustomizeToolbarClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeToolbarClient>(message.name())) {
    case messages::CustomizeToolbarClient::kSetActionPinned: {
      return &CustomizeToolbarClient::SetActionPinned_Sym::IPCStableHash;
    }
    case messages::CustomizeToolbarClient::kNotifyActionsUpdated: {
      return &CustomizeToolbarClient::NotifyActionsUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeToolbarClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeToolbarClient>(message.name())) {
      case messages::CustomizeToolbarClient::kSetActionPinned:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarClient::SetActionPinned";
      case messages::CustomizeToolbarClient::kNotifyActionsUpdated:
            return "Receive side_panel::customize_chrome::mojom::CustomizeToolbarClient::NotifyActionsUpdated";
    }
  } else {
    switch (static_cast<messages::CustomizeToolbarClient>(message.name())) {
      case messages::CustomizeToolbarClient::kSetActionPinned:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarClient::SetActionPinned";
      case messages::CustomizeToolbarClient::kNotifyActionsUpdated:
            return "Receive reply side_panel::customize_chrome::mojom::CustomizeToolbarClient::NotifyActionsUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeToolbarClient::SetActionPinned_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80a1c754;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarClient::SetActionPinned
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeToolbarClient::NotifyActionsUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd8e5f7d9;  // IPCStableHash for side_panel::customize_chrome::mojom::CustomizeToolbarClient::NotifyActionsUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeToolbarClientProxy::CustomizeToolbarClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeToolbarClientProxy::SetActionPinned(
    ActionId in_action_id, bool in_pinned) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarClient::SetActionPinned", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_id"), in_action_id,
                        "<value of type ActionId>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinned"), in_pinned,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarClient::kSetActionPinned), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarClient_SetActionPinned_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::side_panel::customize_chrome::mojom::ActionId>(
    in_action_id,
    &params->action_id);

  params->pinned = in_pinned;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarClient::Name_);
  message.set_method_name("SetActionPinned");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeToolbarClientProxy::NotifyActionsUpdated(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send side_panel::customize_chrome::mojom::CustomizeToolbarClient::NotifyActionsUpdated");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeToolbarClient::kNotifyActionsUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::side_panel::customize_chrome::mojom::internal::CustomizeToolbarClient_NotifyActionsUpdated_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeToolbarClient::Name_);
  message.set_method_name("NotifyActionsUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeToolbarClientStubDispatch::Accept(
    CustomizeToolbarClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeToolbarClient>(message->header()->name)) {
    case messages::CustomizeToolbarClient::kSetActionPinned: {
      DCHECK(message->is_serialized());
      internal::CustomizeToolbarClient_SetActionPinned_Params_Data* params =
          reinterpret_cast<internal::CustomizeToolbarClient_SetActionPinned_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeToolbarClient.0
      bool success = true;
      ActionId p_action_id{};
      bool p_pinned{};
      CustomizeToolbarClient_SetActionPinned_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionId(&p_action_id))
        success = false;
      if (success)
        p_pinned = input_data_view.pinned();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActionPinned(        
        std::move(p_action_id), 
        std::move(p_pinned));
      return true;
    }
    case messages::CustomizeToolbarClient::kNotifyActionsUpdated: {
      DCHECK(message->is_serialized());
      internal::CustomizeToolbarClient_NotifyActionsUpdated_Params_Data* params =
          reinterpret_cast<internal::CustomizeToolbarClient_NotifyActionsUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeToolbarClient.1
      bool success = true;
      CustomizeToolbarClient_NotifyActionsUpdated_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeToolbarClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyActionsUpdated(        );
      return true;
    }
  }
  return false;
}

// static
bool CustomizeToolbarClientStubDispatch::AcceptWithResponder(
    CustomizeToolbarClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeToolbarClient>(message->header()->name)) {
    case messages::CustomizeToolbarClient::kSetActionPinned: {
      break;
    }
    case messages::CustomizeToolbarClient::kNotifyActionsUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeToolbarClientValidationInfo[] = {
    { &internal::CustomizeToolbarClient_SetActionPinned_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeToolbarClient_NotifyActionsUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeToolbarClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::side_panel::customize_chrome::mojom::CustomizeToolbarClient::Name_,
    kCustomizeToolbarClientValidationInfo);
}



}  // side_panel::customize_chrome::mojom


namespace mojo {


// static
bool StructTraits<::side_panel::customize_chrome::mojom::Action::DataView, ::side_panel::customize_chrome::mojom::ActionPtr>::Read(
    ::side_panel::customize_chrome::mojom::Action::DataView input,
    ::side_panel::customize_chrome::mojom::ActionPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::ActionPtr result(::side_panel::customize_chrome::mojom::Action::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success)
        result->pinned = input.pinned();
      if (success)
        result->has_enterprise_controlled_pinned_state = input.has_enterprise_controlled_pinned_state();
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadIconUrl(&result->icon_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::side_panel::customize_chrome::mojom::Category::DataView, ::side_panel::customize_chrome::mojom::CategoryPtr>::Read(
    ::side_panel::customize_chrome::mojom::Category::DataView input,
    ::side_panel::customize_chrome::mojom::CategoryPtr* output) {
  bool success = true;
  ::side_panel::customize_chrome::mojom::CategoryPtr result(::side_panel::customize_chrome::mojom::Category::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace side_panel::customize_chrome::mojom {


void CustomizeToolbarHandlerFactoryInterceptorForTesting::CreateCustomizeToolbarHandler(::mojo::PendingRemote<CustomizeToolbarClient> client, ::mojo::PendingReceiver<CustomizeToolbarHandler> handler) {
  GetForwardingInterface()->CreateCustomizeToolbarHandler(
    std::move(client)
    , 
    std::move(handler)
    );
}
CustomizeToolbarHandlerFactoryAsyncWaiter::CustomizeToolbarHandlerFactoryAsyncWaiter(
    CustomizeToolbarHandlerFactory* proxy) : proxy_(proxy) {}

CustomizeToolbarHandlerFactoryAsyncWaiter::~CustomizeToolbarHandlerFactoryAsyncWaiter() = default;





void CustomizeToolbarHandlerInterceptorForTesting::ListActions(ListActionsCallback callback) {
  GetForwardingInterface()->ListActions(std::move(callback));
}
void CustomizeToolbarHandlerInterceptorForTesting::ListCategories(ListCategoriesCallback callback) {
  GetForwardingInterface()->ListCategories(std::move(callback));
}
void CustomizeToolbarHandlerInterceptorForTesting::PinAction(ActionId action_id, bool pinned) {
  GetForwardingInterface()->PinAction(
    std::move(action_id)
    , 
    std::move(pinned)
    );
}
void CustomizeToolbarHandlerInterceptorForTesting::GetIsCustomized(GetIsCustomizedCallback callback) {
  GetForwardingInterface()->GetIsCustomized(std::move(callback));
}
void CustomizeToolbarHandlerInterceptorForTesting::ResetToDefault() {
  GetForwardingInterface()->ResetToDefault();
}
CustomizeToolbarHandlerAsyncWaiter::CustomizeToolbarHandlerAsyncWaiter(
    CustomizeToolbarHandler* proxy) : proxy_(proxy) {}

CustomizeToolbarHandlerAsyncWaiter::~CustomizeToolbarHandlerAsyncWaiter() = default;


void CustomizeToolbarHandlerAsyncWaiter::ListActions(
    std::vector<ActionPtr>* out_actions) {
  base::RunLoop loop;
  proxy_->ListActions(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ActionPtr>* out_actions
,
             std::vector<ActionPtr> actions) {*out_actions = std::move(actions);
            loop->Quit();
          },
          &loop,
          out_actions));
  loop.Run();
}

std::vector<ActionPtr> CustomizeToolbarHandlerAsyncWaiter::ListActions(
    ) {
  std::vector<ActionPtr> async_wait_result;
  ListActions(&async_wait_result);
  return async_wait_result;
}

void CustomizeToolbarHandlerAsyncWaiter::ListCategories(
    std::vector<CategoryPtr>* out_categories) {
  base::RunLoop loop;
  proxy_->ListCategories(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<CategoryPtr>* out_categories
,
             std::vector<CategoryPtr> categories) {*out_categories = std::move(categories);
            loop->Quit();
          },
          &loop,
          out_categories));
  loop.Run();
}

std::vector<CategoryPtr> CustomizeToolbarHandlerAsyncWaiter::ListCategories(
    ) {
  std::vector<CategoryPtr> async_wait_result;
  ListCategories(&async_wait_result);
  return async_wait_result;
}

void CustomizeToolbarHandlerAsyncWaiter::GetIsCustomized(
    bool* out_customized) {
  base::RunLoop loop;
  proxy_->GetIsCustomized(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_customized
,
             bool customized) {*out_customized = std::move(customized);
            loop->Quit();
          },
          &loop,
          out_customized));
  loop.Run();
}

bool CustomizeToolbarHandlerAsyncWaiter::GetIsCustomized(
    ) {
  bool async_wait_result;
  GetIsCustomized(&async_wait_result);
  return async_wait_result;
}




void CustomizeToolbarClientInterceptorForTesting::SetActionPinned(ActionId action_id, bool pinned) {
  GetForwardingInterface()->SetActionPinned(
    std::move(action_id)
    , 
    std::move(pinned)
    );
}
void CustomizeToolbarClientInterceptorForTesting::NotifyActionsUpdated() {
  GetForwardingInterface()->NotifyActionsUpdated();
}
CustomizeToolbarClientAsyncWaiter::CustomizeToolbarClientAsyncWaiter(
    CustomizeToolbarClient* proxy) : proxy_(proxy) {}

CustomizeToolbarClientAsyncWaiter::~CustomizeToolbarClientAsyncWaiter() = default;







}  // side_panel::customize_chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif