// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-forward.h"  // IWYU pragma: export
#include "ui/base/mojom/window_open_disposition.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace side_panel::mojom {

class BookmarksPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class BookmarksPageHandlerFactoryStub;

class BookmarksPageHandlerFactoryRequestValidator;


class BookmarksPageHandlerFactory
    : public BookmarksPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.BookmarksPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarksPageHandlerFactoryInterfaceBase;
  using Proxy_ = BookmarksPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarksPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = BookmarksPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateBookmarksPageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateBookmarksPageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarksPageHandlerFactory() = default;

  virtual void CreateBookmarksPageHandler(::mojo::PendingRemote<BookmarksPage> page, ::mojo::PendingReceiver<BookmarksPageHandler> handler) = 0;
};

class BookmarksPageHandlerProxy;

template <typename ImplRefTraits>
class BookmarksPageHandlerStub;

class BookmarksPageHandlerRequestValidator;
class BookmarksPageHandlerResponseValidator;


class BookmarksPageHandler
    : public BookmarksPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.BookmarksPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarksPageHandlerInterfaceBase;
  using Proxy_ = BookmarksPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarksPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = BookmarksPageHandlerRequestValidator;
  using ResponseValidator_ = BookmarksPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBookmarkCurrentTabInFolderMinVersion = 0,
    kCreateFolderMinVersion = 0,
    kDropBookmarksMinVersion = 0,
    kExecuteEditCommandMinVersion = 0,
    kExecuteMoveCommandMinVersion = 0,
    kExecuteOpenInNewTabCommandMinVersion = 0,
    kExecuteOpenInNewWindowCommandMinVersion = 0,
    kExecuteOpenInIncognitoWindowCommandMinVersion = 0,
    kExecuteOpenInNewTabGroupCommandMinVersion = 0,
    kExecuteOpenInSplitViewCommandMinVersion = 0,
    kExecuteAddToBookmarksBarCommandMinVersion = 0,
    kExecuteRemoveFromBookmarksBarCommandMinVersion = 0,
    kExecuteDeleteCommandMinVersion = 0,
    kOpenBookmarkMinVersion = 0,
    kUndoMinVersion = 0,
    kRenameBookmarkMinVersion = 0,
    kMoveBookmarkMinVersion = 0,
    kRemoveBookmarksMinVersion = 0,
    kSetSortOrderMinVersion = 0,
    kSetViewTypeMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kShowUIMinVersion = 0,
    kGetAllBookmarksMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BookmarkCurrentTabInFolder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateFolder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DropBookmarks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteEditCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteMoveCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteOpenInNewTabCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteOpenInNewWindowCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteOpenInIncognitoWindowCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteOpenInNewTabGroupCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteOpenInSplitViewCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteAddToBookmarksBarCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteRemoveFromBookmarksBarCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteDeleteCommand_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Undo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RenameBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MoveBookmark_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveBookmarks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSortOrder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetViewType_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetAllBookmarks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarksPageHandler() = default;

  virtual void BookmarkCurrentTabInFolder(const std::string& folder_id) = 0;

  using CreateFolderCallback = base::OnceCallback<void(const std::string&)>;
  using CreateFolderMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void CreateFolder(const std::string& folder_id, const std::string& title, CreateFolderCallback callback) = 0;

  using DropBookmarksCallback = base::OnceCallback<void()>;
  using DropBookmarksMojoCallback = base::OnceCallback<void()>;

  virtual void DropBookmarks(const std::string& folder_id, DropBookmarksCallback callback) = 0;

  virtual void ExecuteEditCommand(const std::vector<int64_t>& node_ids, ActionSource source) = 0;

  virtual void ExecuteMoveCommand(const std::vector<int64_t>& node_ids, ActionSource source) = 0;

  virtual void ExecuteOpenInNewTabCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) = 0;

  virtual void ExecuteOpenInNewWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) = 0;

  virtual void ExecuteOpenInIncognitoWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) = 0;

  virtual void ExecuteOpenInNewTabGroupCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) = 0;

  virtual void ExecuteOpenInSplitViewCommand(const std::vector<int64_t>& node_ids, ActionSource source) = 0;

  virtual void ExecuteAddToBookmarksBarCommand(int64_t node_id, ActionSource source) = 0;

  virtual void ExecuteRemoveFromBookmarksBarCommand(int64_t node_id, ActionSource source) = 0;

  virtual void ExecuteDeleteCommand(const std::vector<int64_t>& node_ids, ActionSource source) = 0;

  virtual void OpenBookmark(int64_t node_id, int32_t parent_folder_depth, ::ui::mojom::ClickModifiersPtr click_modifiers, ActionSource source) = 0;

  virtual void Undo() = 0;

  virtual void RenameBookmark(int64_t node_id, const std::string& new_title) = 0;

  virtual void MoveBookmark(int64_t node_id, const std::string& folder_id) = 0;

  using RemoveBookmarksCallback = base::OnceCallback<void()>;
  using RemoveBookmarksMojoCallback = base::OnceCallback<void()>;

  virtual void RemoveBookmarks(const std::vector<int64_t>& node_ids, RemoveBookmarksCallback callback) = 0;

  virtual void SetSortOrder(SortOrder sort_order) = 0;

  virtual void SetViewType(ViewType view_type) = 0;

  virtual void ShowContextMenu(const std::string& id, const ::gfx::Point& point, ActionSource source) = 0;

  virtual void ShowUI() = 0;

  using GetAllBookmarksCallback = base::OnceCallback<void(std::vector<BookmarksTreeNodePtr>)>;
  using GetAllBookmarksMojoCallback = base::OnceCallback<void(std::vector<BookmarksTreeNodePtr>)>;

  virtual void GetAllBookmarks(GetAllBookmarksCallback callback) = 0;
};

class BookmarksPageProxy;

template <typename ImplRefTraits>
class BookmarksPageStub;

class BookmarksPageRequestValidator;


class BookmarksPage
    : public BookmarksPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "side_panel.mojom.BookmarksPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = BookmarksPageInterfaceBase;
  using Proxy_ = BookmarksPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = BookmarksPageStub<ImplRefTraits>;

  using RequestValidator_ = BookmarksPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnBookmarkNodeAddedMinVersion = 0,
    kOnBookmarkNodesRemovedMinVersion = 0,
    kOnBookmarkParentFolderChildrenReorderedMinVersion = 0,
    kOnBookmarkNodeMovedMinVersion = 0,
    kOnBookmarkNodeChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnBookmarkNodeAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarkNodesRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarkParentFolderChildrenReordered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarkNodeMoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnBookmarkNodeChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~BookmarksPage() = default;

  virtual void OnBookmarkNodeAdded(BookmarksTreeNodePtr node) = 0;

  virtual void OnBookmarkNodesRemoved(const std::vector<std::string>& node_ids) = 0;

  virtual void OnBookmarkParentFolderChildrenReordered(const std::string& folder_id, const std::vector<std::string>& children_ordered_ids) = 0;

  virtual void OnBookmarkNodeMoved(const std::string& old_parent_index, uint32_t old_node_index, const std::string& new_parent_index, uint32_t new_node_index) = 0;

  virtual void OnBookmarkNodeChanged(const std::string& id, const std::string& new_title, const std::string& new_url) = 0;
};



class  BookmarksPageHandlerFactoryProxy
    : public BookmarksPageHandlerFactory {
 public:
  using InterfaceType = BookmarksPageHandlerFactory;

  explicit BookmarksPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateBookmarksPageHandler(::mojo::PendingRemote<BookmarksPage> page, ::mojo::PendingReceiver<BookmarksPageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BookmarksPageHandlerProxy
    : public BookmarksPageHandler {
 public:
  using InterfaceType = BookmarksPageHandler;

  explicit BookmarksPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BookmarkCurrentTabInFolder(const std::string& folder_id) final;
  
  void CreateFolder(const std::string& folder_id, const std::string& title, CreateFolderCallback callback) final;
  
  void DropBookmarks(const std::string& folder_id, DropBookmarksCallback callback) final;
  
  void ExecuteEditCommand(const std::vector<int64_t>& node_ids, ActionSource source) final;
  
  void ExecuteMoveCommand(const std::vector<int64_t>& node_ids, ActionSource source) final;
  
  void ExecuteOpenInNewTabCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) final;
  
  void ExecuteOpenInNewWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) final;
  
  void ExecuteOpenInIncognitoWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) final;
  
  void ExecuteOpenInNewTabGroupCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) final;
  
  void ExecuteOpenInSplitViewCommand(const std::vector<int64_t>& node_ids, ActionSource source) final;
  
  void ExecuteAddToBookmarksBarCommand(int64_t node_id, ActionSource source) final;
  
  void ExecuteRemoveFromBookmarksBarCommand(int64_t node_id, ActionSource source) final;
  
  void ExecuteDeleteCommand(const std::vector<int64_t>& node_ids, ActionSource source) final;
  
  void OpenBookmark(int64_t node_id, int32_t parent_folder_depth, ::ui::mojom::ClickModifiersPtr click_modifiers, ActionSource source) final;
  
  void Undo() final;
  
  void RenameBookmark(int64_t node_id, const std::string& new_title) final;
  
  void MoveBookmark(int64_t node_id, const std::string& folder_id) final;
  
  void RemoveBookmarks(const std::vector<int64_t>& node_ids, RemoveBookmarksCallback callback) final;
  
  void SetSortOrder(SortOrder sort_order) final;
  
  void SetViewType(ViewType view_type) final;
  
  void ShowContextMenu(const std::string& id, const ::gfx::Point& point, ActionSource source) final;
  
  void ShowUI() final;
  
  void GetAllBookmarks(GetAllBookmarksCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  BookmarksPageProxy
    : public BookmarksPage {
 public:
  using InterfaceType = BookmarksPage;

  explicit BookmarksPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBookmarkNodeAdded(BookmarksTreeNodePtr node) final;
  
  void OnBookmarkNodesRemoved(const std::vector<std::string>& node_ids) final;
  
  void OnBookmarkParentFolderChildrenReordered(const std::string& folder_id, const std::vector<std::string>& children_ordered_ids) final;
  
  void OnBookmarkNodeMoved(const std::string& old_parent_index, uint32_t old_node_index, const std::string& new_parent_index, uint32_t new_node_index) final;
  
  void OnBookmarkNodeChanged(const std::string& id, const std::string& new_title, const std::string& new_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  BookmarksPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(BookmarksPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarksPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarksPageHandlerFactory>>
class BookmarksPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarksPageHandlerFactoryStub() = default;
  ~BookmarksPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarksPageHandlerStubDispatch {
 public:
  static bool Accept(BookmarksPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarksPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarksPageHandler>>
class BookmarksPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarksPageHandlerStub() = default;
  ~BookmarksPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarksPageStubDispatch {
 public:
  static bool Accept(BookmarksPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      BookmarksPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<BookmarksPage>>
class BookmarksPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  BookmarksPageStub() = default;
  ~BookmarksPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return BookmarksPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  BookmarksPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarksPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarksPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  BookmarksPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  BookmarksTreeNode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BookmarksTreeNode, T>::value>;
  using DataView = BookmarksTreeNodeDataView;
  using Data_ = internal::BookmarksTreeNode_Data;

  template <typename... Args>
  static BookmarksTreeNodePtr New(Args&&... args) {
    return BookmarksTreeNodePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BookmarksTreeNodePtr From(const U& u) {
    return mojo::TypeConverter<BookmarksTreeNodePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BookmarksTreeNode>::Convert(*this);
  }


  BookmarksTreeNode();

  BookmarksTreeNode(
      const std::string& id,
      const std::string& parent_id,
      uint32_t index,
      const std::string& title,
      const std::optional<std::string>& url,
      std::optional<std::vector<BookmarksTreeNodePtr>> children,
      std::optional<double> date_added,
      std::optional<double> date_last_used,
      bool unmodifiable);

BookmarksTreeNode(const BookmarksTreeNode&) = delete;
BookmarksTreeNode& operator=(const BookmarksTreeNode&) = delete;

  ~BookmarksTreeNode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BookmarksTreeNodePtr>
  BookmarksTreeNodePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarksTreeNode::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BookmarksTreeNode::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BookmarksTreeNode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BookmarksTreeNode_UnserializedMessageContext<
            UserType, BookmarksTreeNode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BookmarksTreeNode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BookmarksTreeNode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BookmarksTreeNode_UnserializedMessageContext<
            UserType, BookmarksTreeNode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BookmarksTreeNode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string parent_id;
  
  uint32_t index;
  
  std::string title;
  
  std::optional<std::string> url;
  
  std::optional<std::vector<BookmarksTreeNodePtr>> children;
  
  std::optional<double> date_added;
  
  std::optional<double> date_last_used;
  
  bool unmodifiable;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BookmarksTreeNode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
BookmarksTreeNodePtr BookmarksTreeNode::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(parent_id),
      mojo::Clone(index),
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(children),
      mojo::Clone(date_added),
      mojo::Clone(date_last_used),
      mojo::Clone(unmodifiable)
  );
}

template <typename T, BookmarksTreeNode::EnableIfSame<T>*>
bool BookmarksTreeNode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->children, other_struct.children))
    return false;
  if (!mojo::Equals(this->date_added, other_struct.date_added))
    return false;
  if (!mojo::Equals(this->date_last_used, other_struct.date_last_used))
    return false;
  if (!mojo::Equals(this->unmodifiable, other_struct.unmodifiable))
    return false;
  return true;
}

template <typename T, BookmarksTreeNode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.children < rhs.children)
    return true;
  if (rhs.children < lhs.children)
    return false;
  if (lhs.date_added < rhs.date_added)
    return true;
  if (rhs.date_added < lhs.date_added)
    return false;
  if (lhs.date_last_used < rhs.date_last_used)
    return true;
  if (rhs.date_last_used < lhs.date_last_used)
    return false;
  if (lhs.unmodifiable < rhs.unmodifiable)
    return true;
  if (rhs.unmodifiable < lhs.unmodifiable)
    return false;
  return false;
}


}  // side_panel::mojom

namespace mojo {


template <>
struct  StructTraits<::side_panel::mojom::BookmarksTreeNode::DataView,
                                         ::side_panel::mojom::BookmarksTreeNodePtr> {
  static bool IsNull(const ::side_panel::mojom::BookmarksTreeNodePtr& input) { return !input; }
  static void SetToNull(::side_panel::mojom::BookmarksTreeNodePtr* output) { output->reset(); }

  static const decltype(::side_panel::mojom::BookmarksTreeNode::id)& id(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->id;
  }

  static const decltype(::side_panel::mojom::BookmarksTreeNode::parent_id)& parent_id(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->parent_id;
  }

  static decltype(::side_panel::mojom::BookmarksTreeNode::index) index(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->index;
  }

  static const decltype(::side_panel::mojom::BookmarksTreeNode::title)& title(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->title;
  }

  static const decltype(::side_panel::mojom::BookmarksTreeNode::url)& url(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->url;
  }

  static const decltype(::side_panel::mojom::BookmarksTreeNode::children)& children(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->children;
  }

  static decltype(::side_panel::mojom::BookmarksTreeNode::date_added) date_added(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->date_added;
  }

  static decltype(::side_panel::mojom::BookmarksTreeNode::date_last_used) date_last_used(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->date_last_used;
  }

  static decltype(::side_panel::mojom::BookmarksTreeNode::unmodifiable) unmodifiable(
      const ::side_panel::mojom::BookmarksTreeNodePtr& input) {
    return input->unmodifiable;
  }

  static bool Read(::side_panel::mojom::BookmarksTreeNode::DataView input, ::side_panel::mojom::BookmarksTreeNodePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_H_