// chrome/browser/ui/webui/segmentation_internals/segmentation_internals.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_PARAMS_DATA_H_
#define CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace segmentation_internals::mojom {
namespace internal {
class  PageHandlerFactory_CreatePageHandler_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data page;
  mojo::internal::Handle_Data handler;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandlerFactory_CreatePageHandler_Params_Data>;

  PageHandlerFactory_CreatePageHandler_Params_Data();
  ~PageHandlerFactory_CreatePageHandler_Params_Data() = delete;
};
static_assert(sizeof(PageHandlerFactory_CreatePageHandler_Params_Data) == 24,
              "Bad sizeof(PageHandlerFactory_CreatePageHandler_Params_Data)");
class  PageHandler_GetServiceStatus_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_GetServiceStatus_Params_Data>;

  PageHandler_GetServiceStatus_Params_Data();
  ~PageHandler_GetServiceStatus_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_GetServiceStatus_Params_Data) == 8,
              "Bad sizeof(PageHandler_GetServiceStatus_Params_Data)");
class  PageHandler_ExecuteModel_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t segment_id;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_ExecuteModel_Params_Data>;

  PageHandler_ExecuteModel_Params_Data();
  ~PageHandler_ExecuteModel_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_ExecuteModel_Params_Data) == 16,
              "Bad sizeof(PageHandler_ExecuteModel_Params_Data)");
class  PageHandler_OverwriteResult_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t segment_id;
  float result;

 private:
  friend class mojo::internal::MessageFragment<PageHandler_OverwriteResult_Params_Data>;

  PageHandler_OverwriteResult_Params_Data();
  ~PageHandler_OverwriteResult_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_OverwriteResult_Params_Data) == 16,
              "Bad sizeof(PageHandler_OverwriteResult_Params_Data)");
class  PageHandler_SetSelected_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> segmentation_key;
  int32_t optimization_target;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<PageHandler_SetSelected_Params_Data>;

  PageHandler_SetSelected_Params_Data();
  ~PageHandler_SetSelected_Params_Data() = delete;
};
static_assert(sizeof(PageHandler_SetSelected_Params_Data) == 24,
              "Bad sizeof(PageHandler_SetSelected_Params_Data)");
class  Page_OnServiceStatusChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_initialized : 1;
  uint8_t pad0_[3];
  int32_t status_flag;

 private:
  friend class mojo::internal::MessageFragment<Page_OnServiceStatusChanged_Params_Data>;

  Page_OnServiceStatusChanged_Params_Data();
  ~Page_OnServiceStatusChanged_Params_Data() = delete;
};
static_assert(sizeof(Page_OnServiceStatusChanged_Params_Data) == 16,
              "Bad sizeof(Page_OnServiceStatusChanged_Params_Data)");
class  Page_OnClientInfoAvailable_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ClientInfo_Data>>> client_info;

 private:
  friend class mojo::internal::MessageFragment<Page_OnClientInfoAvailable_Params_Data>;

  Page_OnClientInfoAvailable_Params_Data();
  ~Page_OnClientInfoAvailable_Params_Data() = delete;
};
static_assert(sizeof(Page_OnClientInfoAvailable_Params_Data) == 16,
              "Bad sizeof(Page_OnClientInfoAvailable_Params_Data)");

}  // namespace internal


class PageHandlerFactory_CreatePageHandler_ParamsDataView {
 public:
  PageHandlerFactory_CreatePageHandler_ParamsDataView() = default;

  PageHandlerFactory_CreatePageHandler_ParamsDataView(
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePage() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::segmentation_internals::mojom::PageInterfaceBase>>(
            &data_->page, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeHandler() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::segmentation_internals::mojom::PageHandlerInterfaceBase>>(
            &data_->handler, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::PageHandlerFactory_CreatePageHandler_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageHandler_GetServiceStatus_ParamsDataView {
 public:
  PageHandler_GetServiceStatus_ParamsDataView() = default;

  PageHandler_GetServiceStatus_ParamsDataView(
      internal::PageHandler_GetServiceStatus_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::PageHandler_GetServiceStatus_Params_Data* data_ = nullptr;
};


class PageHandler_ExecuteModel_ParamsDataView {
 public:
  PageHandler_ExecuteModel_ParamsDataView() = default;

  PageHandler_ExecuteModel_ParamsDataView(
      internal::PageHandler_ExecuteModel_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t segment_id() const {
    return data_->segment_id;
  }
 private:
  internal::PageHandler_ExecuteModel_Params_Data* data_ = nullptr;
};


class PageHandler_OverwriteResult_ParamsDataView {
 public:
  PageHandler_OverwriteResult_ParamsDataView() = default;

  PageHandler_OverwriteResult_ParamsDataView(
      internal::PageHandler_OverwriteResult_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t segment_id() const {
    return data_->segment_id;
  }
  float result() const {
    return data_->result;
  }
 private:
  internal::PageHandler_OverwriteResult_Params_Data* data_ = nullptr;
};


class PageHandler_SetSelected_ParamsDataView {
 public:
  PageHandler_SetSelected_ParamsDataView() = default;

  PageHandler_SetSelected_ParamsDataView(
      internal::PageHandler_SetSelected_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSegmentationKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSegmentationKey(UserType* output) {
    
    auto* pointer = data_->segmentation_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t optimization_target() const {
    return data_->optimization_target;
  }
 private:
  internal::PageHandler_SetSelected_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Page_OnServiceStatusChanged_ParamsDataView {
 public:
  Page_OnServiceStatusChanged_ParamsDataView() = default;

  Page_OnServiceStatusChanged_ParamsDataView(
      internal::Page_OnServiceStatusChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_initialized() const {
    return data_->is_initialized;
  }
  int32_t status_flag() const {
    return data_->status_flag;
  }
 private:
  internal::Page_OnServiceStatusChanged_Params_Data* data_ = nullptr;
};


class Page_OnClientInfoAvailable_ParamsDataView {
 public:
  Page_OnClientInfoAvailable_ParamsDataView() = default;

  Page_OnClientInfoAvailable_ParamsDataView(
      internal::Page_OnClientInfoAvailable_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetClientInfoDataView(
      mojo::ArrayDataView<ClientInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientInfo(UserType* output) {
    
    auto* pointer = data_->client_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::segmentation_internals::mojom::ClientInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Page_OnClientInfoAvailable_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};









inline void PageHandler_SetSelected_ParamsDataView::GetSegmentationKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->segmentation_key.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void Page_OnClientInfoAvailable_ParamsDataView::GetClientInfoDataView(
    mojo::ArrayDataView<ClientInfoDataView>* output) {
  auto pointer = data_->client_info.Get();
  *output = mojo::ArrayDataView<ClientInfoDataView>(pointer, message_);
}



}  // segmentation_internals::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CHROME_BROWSER_UI_WEBUI_SEGMENTATION_INTERNALS_SEGMENTATION_INTERNALS_MOJOM_PARAMS_DATA_H_