// chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-params-data.h"
namespace related_website_sets {
namespace mojom {

NOINLINE static const char* SiteTypeToStringHelper(SiteType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SiteType::kPrimary:
      return "kPrimary";
    case SiteType::kAssociated:
      return "kAssociated";
    case SiteType::kService:
      return "kService";
    default:
      return nullptr;
  }
}

std::string SiteTypeToString(SiteType value) {
  const char *str = SiteTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SiteType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SiteType value) {
  return os << SiteTypeToString(value);
}

namespace internal {
// static
bool GetRelatedWebsiteSetsResponse_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const GetRelatedWebsiteSetsResponse_Data* object = static_cast<const GetRelatedWebsiteSetsResponse_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case GetRelatedWebsiteSetsResponse_Tag::kRelatedWebsiteSets: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_related_website_sets, 1, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& related_website_sets_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_related_website_sets, validation_context,
                                             &related_website_sets_validate_params)) {
        return false;
      }
      return true;
    }
    case GetRelatedWebsiteSetsResponse_Tag::kErrorMessage: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_error_message, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_error_message, validation_context,
                                             &error_message_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in GetRelatedWebsiteSetsResponse");
      return false;
    }
  }
}


// static
bool Member_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Member_Data* object =
      static_cast<const Member_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& site_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->site, validation_context,
                                         &site_validate_params)) {
    return false;
  }


  if (!::related_website_sets::mojom::internal::SiteType_Data
        ::Validate(object->type, validation_context))
    return false;

  return true;
}

Member_Data::Member_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RelatedWebsiteSet_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RelatedWebsiteSet_Data* object =
      static_cast<const RelatedWebsiteSet_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->primary_site, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& primary_site_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->primary_site, validation_context,
                                         &primary_site_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->member_sites, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& member_sites_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->member_sites, validation_context,
                                         &member_sites_validate_params)) {
    return false;
  }

  return true;
}

RelatedWebsiteSet_Data::RelatedWebsiteSet_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data* object =
      static_cast<const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data*>(data);

  return true;
}

RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data* object =
      static_cast<const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->related_website_sets_info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->related_website_sets_info, validation_context))
    return false;

  return true;
}

RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace related_website_sets

namespace perfetto {

// static
void TraceFormatTraits<::related_website_sets::mojom::SiteType>::WriteIntoTrace(
   perfetto::TracedValue context, ::related_website_sets::mojom::SiteType value) {
  return std::move(context).WriteString(::related_website_sets::mojom::SiteTypeToString(value));
}

} // namespace perfetto