// chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-params-data.h"
#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-import-headers.h"
#include "chrome/browser/ui/webui/privacy_sandbox/private_state_tokens/private_state_tokens.mojom-test-utils.h"


namespace private_state_tokens::mojom {
IssuerTokenCount::IssuerTokenCount()
    : issuer(),
      count() {}

IssuerTokenCount::IssuerTokenCount(
    const std::string& issuer_in,
    int32_t count_in)
    : issuer(std::move(issuer_in)),
      count(std::move(count_in)) {}

IssuerTokenCount::~IssuerTokenCount() = default;
size_t IssuerTokenCount::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->issuer);
  seed = mojo::internal::Hash(seed, this->count);
  return seed;
}

void IssuerTokenCount::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IssuerTokenCount::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PrivateStateTokensPageHandler::IPCStableHashFunction PrivateStateTokensPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PrivateStateTokensPageHandler>(message.name())) {
    case messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts: {
      return &PrivateStateTokensPageHandler::GetIssuerTokenCounts_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PrivateStateTokensPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PrivateStateTokensPageHandler>(message.name())) {
      case messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts:
            return "Receive private_state_tokens::mojom::PrivateStateTokensPageHandler::GetIssuerTokenCounts";
    }
  } else {
    switch (static_cast<messages::PrivateStateTokensPageHandler>(message.name())) {
      case messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts:
            return "Receive reply private_state_tokens::mojom::PrivateStateTokensPageHandler::GetIssuerTokenCounts";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PrivateStateTokensPageHandler::GetIssuerTokenCounts_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd0a7bcd8;  // IPCStableHash for private_state_tokens::mojom::PrivateStateTokensPageHandler::GetIssuerTokenCounts
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback(
      PrivateStateTokensPageHandler::GetIssuerTokenCountsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback(const PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback&) = delete;
  PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback& operator=(const PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PrivateStateTokensPageHandler::GetIssuerTokenCountsCallback callback_;
};

PrivateStateTokensPageHandlerProxy::PrivateStateTokensPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PrivateStateTokensPageHandlerProxy::GetIssuerTokenCounts(
    GetIssuerTokenCountsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send private_state_tokens::mojom::PrivateStateTokensPageHandler::GetIssuerTokenCounts");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_state_tokens::mojom::internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrivateStateTokensPageHandler::Name_);
  message.set_method_name("GetIssuerTokenCounts");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PrivateStateTokensPageHandler::GetIssuerTokenCountsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder> proxy(
        new PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PrivateStateTokensPageHandler::GetIssuerTokenCountsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<IssuerTokenCountPtr> in_private_state_tokens_count);
};

bool PrivateStateTokensPageHandler_GetIssuerTokenCounts_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PrivateStateTokensPageHandler.0
  bool success = true;
  std::vector<IssuerTokenCountPtr> p_private_state_tokens_count{};
  PrivateStateTokensPageHandler_GetIssuerTokenCounts_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPrivateStateTokensCount(&p_private_state_tokens_count))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PrivateStateTokensPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_private_state_tokens_count));
  }
  return true;
}

void PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder::Run(
    std::vector<IssuerTokenCountPtr> in_private_state_tokens_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply private_state_tokens::mojom::PrivateStateTokensPageHandler::GetIssuerTokenCounts", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("private_state_tokens_count"), in_private_state_tokens_count,
                        "<value of type std::vector<IssuerTokenCountPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::private_state_tokens::mojom::internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->private_state_tokens_count)::BaseType>
      private_state_tokens_count_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& private_state_tokens_count_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::private_state_tokens::mojom::IssuerTokenCountDataView>>(
    in_private_state_tokens_count,
    private_state_tokens_count_fragment,
    &private_state_tokens_count_validate_params);

  params->private_state_tokens_count.Set(
      private_state_tokens_count_fragment.is_null() ? nullptr : private_state_tokens_count_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->private_state_tokens_count.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null private_state_tokens_count in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PrivateStateTokensPageHandler::Name_);
  message.set_method_name("GetIssuerTokenCounts");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PrivateStateTokensPageHandlerStubDispatch::Accept(
    PrivateStateTokensPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PrivateStateTokensPageHandler>(message->header()->name)) {
    case messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts: {
      break;
    }
  }
  return false;
}

// static
bool PrivateStateTokensPageHandlerStubDispatch::AcceptWithResponder(
    PrivateStateTokensPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PrivateStateTokensPageHandler>(message->header()->name)) {
    case messages::PrivateStateTokensPageHandler::kGetIssuerTokenCounts: {
      internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_Params_Data* params =
          reinterpret_cast<
              internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PrivateStateTokensPageHandler.0
      bool success = true;
      PrivateStateTokensPageHandler_GetIssuerTokenCounts_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PrivateStateTokensPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PrivateStateTokensPageHandler_GetIssuerTokenCounts_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIssuerTokenCounts(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPrivateStateTokensPageHandlerValidationInfo[] = {
    { &internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_Params_Data::Validate,
     &internal::PrivateStateTokensPageHandler_GetIssuerTokenCounts_ResponseParams_Data::Validate},
};

bool PrivateStateTokensPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::private_state_tokens::mojom::PrivateStateTokensPageHandler::Name_,
    kPrivateStateTokensPageHandlerValidationInfo);
}

bool PrivateStateTokensPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::private_state_tokens::mojom::PrivateStateTokensPageHandler::Name_,
    kPrivateStateTokensPageHandlerValidationInfo);
}


}  // private_state_tokens::mojom


namespace mojo {


// static
bool StructTraits<::private_state_tokens::mojom::IssuerTokenCount::DataView, ::private_state_tokens::mojom::IssuerTokenCountPtr>::Read(
    ::private_state_tokens::mojom::IssuerTokenCount::DataView input,
    ::private_state_tokens::mojom::IssuerTokenCountPtr* output) {
  bool success = true;
  ::private_state_tokens::mojom::IssuerTokenCountPtr result(::private_state_tokens::mojom::IssuerTokenCount::New());
  
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success)
        result->count = input.count();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace private_state_tokens::mojom {


void PrivateStateTokensPageHandlerInterceptorForTesting::GetIssuerTokenCounts(GetIssuerTokenCountsCallback callback) {
  GetForwardingInterface()->GetIssuerTokenCounts(std::move(callback));
}
PrivateStateTokensPageHandlerAsyncWaiter::PrivateStateTokensPageHandlerAsyncWaiter(
    PrivateStateTokensPageHandler* proxy) : proxy_(proxy) {}

PrivateStateTokensPageHandlerAsyncWaiter::~PrivateStateTokensPageHandlerAsyncWaiter() = default;


void PrivateStateTokensPageHandlerAsyncWaiter::GetIssuerTokenCounts(
    std::vector<IssuerTokenCountPtr>* out_private_state_tokens_count) {
  base::RunLoop loop;
  proxy_->GetIssuerTokenCounts(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<IssuerTokenCountPtr>* out_private_state_tokens_count
,
             std::vector<IssuerTokenCountPtr> private_state_tokens_count) {*out_private_state_tokens_count = std::move(private_state_tokens_count);
            loop->Quit();
          },
          &loop,
          out_private_state_tokens_count));
  loop.Run();
}

std::vector<IssuerTokenCountPtr> PrivateStateTokensPageHandlerAsyncWaiter::GetIssuerTokenCounts(
    ) {
  std::vector<IssuerTokenCountPtr> async_wait_result;
  GetIssuerTokenCounts(&async_wait_result);
  return async_wait_result;
}






}  // private_state_tokens::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif