// chrome/browser/ui/webui/privacy_sandbox/privacy_sandbox_internals.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ContentSettingPatternSourceSpec as contentSettings_mojom_ContentSettingPatternSourceSpec,
  ContentSettingPatternSource as contentSettings_mojom_ContentSettingPatternSource,
  ContentSettingsPatternSpec as contentSettings_mojom_ContentSettingsPatternSpec,
  ContentSettingsPattern as contentSettings_mojom_ContentSettingsPattern
} from './content_settings.mojom-webui.js';
import {
  ContentSettingsTypeSpec as contentSettings_mojom_ContentSettingsTypeSpec,
  ContentSettingsType as contentSettings_mojom_ContentSettingsType
} from './content_settings_types.mojom-webui.js';
import {
  ValueSpec as mojoBase_mojom_ValueSpec,
  Value as mojoBase_mojom_Value
} from '//resources/mojo/mojo/public/mojom/base/values.mojom-webui.js';







export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'privacy_sandbox_internals.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  readPrefsWithPrefixes(prefPrefixes: string[]): Promise<{
        prefs: PrivacySandboxInternalsPref[], }>;
  readContentSettings(type: contentSettings_mojom_ContentSettingsType): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[], }>;
  getTpcdMetadataGrants(): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[], }>;
  contentSettingsPatternToString(pattern: contentSettings_mojom_ContentSettingsPattern): Promise<{
        s: string, }>;
  stringToContentSettingsPattern(s: string): Promise<{
        pattern: contentSettings_mojom_ContentSettingsPattern, }>;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  readPrefsWithPrefixes(
      prefPrefixes: string[]): Promise<{
        prefs: PrivacySandboxInternalsPref[], }> {
    return this.proxy.sendMessage(
        0,
        PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$,
        PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$,
        [
          prefPrefixes
        ],
        false);
  }

  readContentSettings(
      type: contentSettings_mojom_ContentSettingsType): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[], }> {
    return this.proxy.sendMessage(
        1,
        PageHandler_ReadContentSettings_ParamsSpec.$,
        PageHandler_ReadContentSettings_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }

  getTpcdMetadataGrants(): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[], }> {
    return this.proxy.sendMessage(
        2,
        PageHandler_GetTpcdMetadataGrants_ParamsSpec.$,
        PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  contentSettingsPatternToString(
      pattern: contentSettings_mojom_ContentSettingsPattern): Promise<{
        s: string, }> {
    return this.proxy.sendMessage(
        3,
        PageHandler_ContentSettingsPatternToString_ParamsSpec.$,
        PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$,
        [
          pattern
        ],
        false);
  }

  stringToContentSettingsPattern(
      s: string): Promise<{
        pattern: contentSettings_mojom_ContentSettingsPattern, }> {
    return this.proxy.sendMessage(
        4,
        PageHandler_StringToContentSettingsPattern_ParamsSpec.$,
        PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$,
        [
          s
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$,
        PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$,
        impl.readPrefsWithPrefixes.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_ReadContentSettings_ParamsSpec.$,
        PageHandler_ReadContentSettings_ResponseParamsSpec.$,
        impl.readContentSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetTpcdMetadataGrants_ParamsSpec.$,
        PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$,
        impl.getTpcdMetadataGrants.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_ContentSettingsPatternToString_ParamsSpec.$,
        PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$,
        impl.contentSettingsPatternToString.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_StringToContentSettingsPattern_ParamsSpec.$,
        PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$,
        impl.stringToContentSettingsPattern.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "privacy_sandbox_internals.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  readPrefsWithPrefixes: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  readContentSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTpcdMetadataGrants: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  contentSettingsPatternToString: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stringToContentSettingsPattern: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.readPrefsWithPrefixes =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$,
        PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$,
        this.readPrefsWithPrefixes.createReceiverHandler(true /* expectsResponse */),
        false);
    this.readContentSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_ReadContentSettings_ParamsSpec.$,
        PageHandler_ReadContentSettings_ResponseParamsSpec.$,
        this.readContentSettings.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTpcdMetadataGrants =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_GetTpcdMetadataGrants_ParamsSpec.$,
        PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$,
        this.getTpcdMetadataGrants.createReceiverHandler(true /* expectsResponse */),
        false);
    this.contentSettingsPatternToString =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_ContentSettingsPatternToString_ParamsSpec.$,
        PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$,
        this.contentSettingsPatternToString.createReceiverHandler(true /* expectsResponse */),
        false);
    this.stringToContentSettingsPattern =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_StringToContentSettingsPattern_ParamsSpec.$,
        PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$,
        this.stringToContentSettingsPattern.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'privacy_sandbox_internals.mojom.Page',
        scope);
  }
}

export interface PageInterface {
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(_impl: PageInterface) {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "privacy_sandbox_internals.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PrivacySandboxInternalsPrefSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReadPrefsWithPrefixes_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReadContentSettings_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ReadContentSettings_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTpcdMetadataGrants_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ContentSettingsPatternToString_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ContentSettingsPatternToString_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StringToContentSettingsPattern_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StringToContentSettingsPattern_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PrivacySandboxInternalsPrefMojoType {
  name: string;
  value: mojoBase_mojom_Value;
}


export type PrivacySandboxInternalsPref = PrivacySandboxInternalsPrefMojoType;
mojo.internal.Struct<PrivacySandboxInternalsPrefMojoType>(
    PrivacySandboxInternalsPrefSpec.$,
    'PrivacySandboxInternalsPref',
    [
      mojo.internal.StructField<PrivacySandboxInternalsPrefMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PrivacySandboxInternalsPrefMojoType, mojoBase_mojom_Value>(
        'value', 8,
        0,
        mojoBase_mojom_ValueSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_ReadPrefsWithPrefixes_ParamsMojoType {
  prefPrefixes: string[];
}


export type PageHandler_ReadPrefsWithPrefixes_Params = PageHandler_ReadPrefsWithPrefixes_ParamsMojoType;
mojo.internal.Struct<PageHandler_ReadPrefsWithPrefixes_ParamsMojoType>(
    PageHandler_ReadPrefsWithPrefixes_ParamsSpec.$,
    'PageHandler_ReadPrefsWithPrefixes_Params',
    [
      mojo.internal.StructField<PageHandler_ReadPrefsWithPrefixes_ParamsMojoType, string[]>(
        'prefPrefixes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType {
  prefs: PrivacySandboxInternalsPref[];
}


export type PageHandler_ReadPrefsWithPrefixes_ResponseParams = PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType>(
    PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec.$,
    'PageHandler_ReadPrefsWithPrefixes_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType, PrivacySandboxInternalsPref[]>(
        'prefs', 0,
        0,
        mojo.internal.Array(PrivacySandboxInternalsPrefSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ReadContentSettings_ParamsMojoType {
  type: contentSettings_mojom_ContentSettingsType;
}


export type PageHandler_ReadContentSettings_Params = PageHandler_ReadContentSettings_ParamsMojoType;
mojo.internal.Struct<PageHandler_ReadContentSettings_ParamsMojoType>(
    PageHandler_ReadContentSettings_ParamsSpec.$,
    'PageHandler_ReadContentSettings_Params',
    [
      mojo.internal.StructField<PageHandler_ReadContentSettings_ParamsMojoType, contentSettings_mojom_ContentSettingsType>(
        'type', 0,
        0,
        contentSettings_mojom_ContentSettingsTypeSpec.$,
        -1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ReadContentSettings_ResponseParamsMojoType {
  contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
}


export type PageHandler_ReadContentSettings_ResponseParams = PageHandler_ReadContentSettings_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ReadContentSettings_ResponseParamsMojoType>(
    PageHandler_ReadContentSettings_ResponseParamsSpec.$,
    'PageHandler_ReadContentSettings_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ReadContentSettings_ResponseParamsMojoType, contentSettings_mojom_ContentSettingPatternSource[]>(
        'contentSettings', 0,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_GetTpcdMetadataGrants_ParamsMojoType {
}


export type PageHandler_GetTpcdMetadataGrants_Params = PageHandler_GetTpcdMetadataGrants_ParamsMojoType;
mojo.internal.Struct<PageHandler_GetTpcdMetadataGrants_ParamsMojoType>(
    PageHandler_GetTpcdMetadataGrants_ParamsSpec.$,
    'PageHandler_GetTpcdMetadataGrants_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType {
  contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
}


export type PageHandler_GetTpcdMetadataGrants_ResponseParams = PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType>(
    PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec.$,
    'PageHandler_GetTpcdMetadataGrants_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType, contentSettings_mojom_ContentSettingPatternSource[]>(
        'contentSettings', 0,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ContentSettingsPatternToString_ParamsMojoType {
  pattern: contentSettings_mojom_ContentSettingsPattern;
}


export type PageHandler_ContentSettingsPatternToString_Params = PageHandler_ContentSettingsPatternToString_ParamsMojoType;
mojo.internal.Struct<PageHandler_ContentSettingsPatternToString_ParamsMojoType>(
    PageHandler_ContentSettingsPatternToString_ParamsSpec.$,
    'PageHandler_ContentSettingsPatternToString_Params',
    [
      mojo.internal.StructField<PageHandler_ContentSettingsPatternToString_ParamsMojoType, contentSettings_mojom_ContentSettingsPattern>(
        'pattern', 0,
        0,
        contentSettings_mojom_ContentSettingsPatternSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType {
  s: string;
}


export type PageHandler_ContentSettingsPatternToString_ResponseParams = PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType>(
    PageHandler_ContentSettingsPatternToString_ResponseParamsSpec.$,
    'PageHandler_ContentSettingsPatternToString_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType, string>(
        's', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_StringToContentSettingsPattern_ParamsMojoType {
  s: string;
}


export type PageHandler_StringToContentSettingsPattern_Params = PageHandler_StringToContentSettingsPattern_ParamsMojoType;
mojo.internal.Struct<PageHandler_StringToContentSettingsPattern_ParamsMojoType>(
    PageHandler_StringToContentSettingsPattern_ParamsSpec.$,
    'PageHandler_StringToContentSettingsPattern_Params',
    [
      mojo.internal.StructField<PageHandler_StringToContentSettingsPattern_ParamsMojoType, string>(
        's', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType {
  pattern: contentSettings_mojom_ContentSettingsPattern;
}


export type PageHandler_StringToContentSettingsPattern_ResponseParams = PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType>(
    PageHandler_StringToContentSettingsPattern_ResponseParamsSpec.$,
    'PageHandler_StringToContentSettingsPattern_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType, contentSettings_mojom_ContentSettingsPattern>(
        'pattern', 0,
        0,
        contentSettings_mojom_ContentSettingsPatternSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



