// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-test-utils.h"


namespace mojom {
ACMatchClassification::ACMatchClassification()
    : offset(),
      style() {}

ACMatchClassification::ACMatchClassification(
    int32_t offset_in,
    int32_t style_in)
    : offset(std::move(offset_in)),
      style(std::move(style_in)) {}

ACMatchClassification::~ACMatchClassification() = default;

void ACMatchClassification::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "offset"), this->offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "style"), this->style,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ACMatchClassification::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Signals::Signals()
    : typed_count(),
      visit_count(),
      elapsed_time_last_visit_secs(),
      shortcut_visit_count(),
      shortest_shortcut_len(),
      elapsed_time_last_shortcut_visit_sec(),
      is_host_only(),
      num_bookmarks_of_url(),
      first_bookmark_title_match_position(),
      total_bookmark_title_match_length(),
      num_input_terms_matched_by_bookmark_title(),
      first_url_match_position(),
      total_url_match_length(),
      host_match_at_word_boundary(),
      total_host_match_length(),
      total_path_match_length(),
      total_query_or_ref_match_length(),
      total_title_match_length(),
      has_non_scheme_www_match(),
      num_input_terms_matched_by_title(),
      num_input_terms_matched_by_url(),
      length_of_url(),
      site_engagement(),
      allowed_to_be_default_match(),
      search_suggest_relevance(),
      is_search_suggest_entity(),
      is_verbatim(),
      is_navsuggest(),
      is_search_suggest_tail(),
      is_answer_suggest(),
      is_calculator_suggest() {}

Signals::Signals(
    std::optional<int32_t> typed_count_in,
    std::optional<int32_t> visit_count_in,
    std::optional<int64_t> elapsed_time_last_visit_secs_in,
    std::optional<int32_t> shortcut_visit_count_in,
    std::optional<int32_t> shortest_shortcut_len_in,
    std::optional<int64_t> elapsed_time_last_shortcut_visit_sec_in,
    std::optional<bool> is_host_only_in,
    std::optional<int32_t> num_bookmarks_of_url_in,
    std::optional<int32_t> first_bookmark_title_match_position_in,
    std::optional<int32_t> total_bookmark_title_match_length_in,
    std::optional<int32_t> num_input_terms_matched_by_bookmark_title_in,
    std::optional<int32_t> first_url_match_position_in,
    std::optional<int32_t> total_url_match_length_in,
    std::optional<bool> host_match_at_word_boundary_in,
    std::optional<int32_t> total_host_match_length_in,
    std::optional<int32_t> total_path_match_length_in,
    std::optional<int32_t> total_query_or_ref_match_length_in,
    std::optional<int32_t> total_title_match_length_in,
    std::optional<bool> has_non_scheme_www_match_in,
    std::optional<int32_t> num_input_terms_matched_by_title_in,
    std::optional<int32_t> num_input_terms_matched_by_url_in,
    std::optional<int32_t> length_of_url_in,
    std::optional<float> site_engagement_in,
    std::optional<bool> allowed_to_be_default_match_in,
    std::optional<int32_t> search_suggest_relevance_in,
    std::optional<bool> is_search_suggest_entity_in,
    std::optional<bool> is_verbatim_in,
    std::optional<bool> is_navsuggest_in,
    std::optional<bool> is_search_suggest_tail_in,
    std::optional<bool> is_answer_suggest_in,
    std::optional<bool> is_calculator_suggest_in)
    : typed_count(std::move(typed_count_in)),
      visit_count(std::move(visit_count_in)),
      elapsed_time_last_visit_secs(std::move(elapsed_time_last_visit_secs_in)),
      shortcut_visit_count(std::move(shortcut_visit_count_in)),
      shortest_shortcut_len(std::move(shortest_shortcut_len_in)),
      elapsed_time_last_shortcut_visit_sec(std::move(elapsed_time_last_shortcut_visit_sec_in)),
      is_host_only(std::move(is_host_only_in)),
      num_bookmarks_of_url(std::move(num_bookmarks_of_url_in)),
      first_bookmark_title_match_position(std::move(first_bookmark_title_match_position_in)),
      total_bookmark_title_match_length(std::move(total_bookmark_title_match_length_in)),
      num_input_terms_matched_by_bookmark_title(std::move(num_input_terms_matched_by_bookmark_title_in)),
      first_url_match_position(std::move(first_url_match_position_in)),
      total_url_match_length(std::move(total_url_match_length_in)),
      host_match_at_word_boundary(std::move(host_match_at_word_boundary_in)),
      total_host_match_length(std::move(total_host_match_length_in)),
      total_path_match_length(std::move(total_path_match_length_in)),
      total_query_or_ref_match_length(std::move(total_query_or_ref_match_length_in)),
      total_title_match_length(std::move(total_title_match_length_in)),
      has_non_scheme_www_match(std::move(has_non_scheme_www_match_in)),
      num_input_terms_matched_by_title(std::move(num_input_terms_matched_by_title_in)),
      num_input_terms_matched_by_url(std::move(num_input_terms_matched_by_url_in)),
      length_of_url(std::move(length_of_url_in)),
      site_engagement(std::move(site_engagement_in)),
      allowed_to_be_default_match(std::move(allowed_to_be_default_match_in)),
      search_suggest_relevance(std::move(search_suggest_relevance_in)),
      is_search_suggest_entity(std::move(is_search_suggest_entity_in)),
      is_verbatim(std::move(is_verbatim_in)),
      is_navsuggest(std::move(is_navsuggest_in)),
      is_search_suggest_tail(std::move(is_search_suggest_tail_in)),
      is_answer_suggest(std::move(is_answer_suggest_in)),
      is_calculator_suggest(std::move(is_calculator_suggest_in)) {}

Signals::~Signals() = default;

void Signals::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "typed_count"), this->typed_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visit_count"), this->visit_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elapsed_time_last_visit_secs"), this->elapsed_time_last_visit_secs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shortcut_visit_count"), this->shortcut_visit_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "shortest_shortcut_len"), this->shortest_shortcut_len,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "elapsed_time_last_shortcut_visit_sec"), this->elapsed_time_last_shortcut_visit_sec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int64_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_host_only"), this->is_host_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_bookmarks_of_url"), this->num_bookmarks_of_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_bookmark_title_match_position"), this->first_bookmark_title_match_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_bookmark_title_match_length"), this->total_bookmark_title_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_input_terms_matched_by_bookmark_title"), this->num_input_terms_matched_by_bookmark_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_url_match_position"), this->first_url_match_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_url_match_length"), this->total_url_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_match_at_word_boundary"), this->host_match_at_word_boundary,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_host_match_length"), this->total_host_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_path_match_length"), this->total_path_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_query_or_ref_match_length"), this->total_query_or_ref_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total_title_match_length"), this->total_title_match_length,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_non_scheme_www_match"), this->has_non_scheme_www_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_input_terms_matched_by_title"), this->num_input_terms_matched_by_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "num_input_terms_matched_by_url"), this->num_input_terms_matched_by_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "length_of_url"), this->length_of_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site_engagement"), this->site_engagement,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<float>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_to_be_default_match"), this->allowed_to_be_default_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "search_suggest_relevance"), this->search_suggest_relevance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_search_suggest_entity"), this->is_search_suggest_entity,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_verbatim"), this->is_verbatim,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_navsuggest"), this->is_navsuggest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_search_suggest_tail"), this->is_search_suggest_tail,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_answer_suggest"), this->is_answer_suggest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_calculator_suggest"), this->is_calculator_suggest,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<bool>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Signals::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteMatch::AutocompleteMatch()
    : provider_name(),
      provider_done(),
      relevance(),
      deletable(),
      fill_into_edit(),
      inline_autocompletion(),
      destination_url(),
      stripped_destination_url(),
      icon(),
      image(),
      contents(),
      contents_class(),
      description(),
      description_class(),
      swap_contents_and_description(),
      answer(),
      transition(),
      allowed_to_be_default_match(),
      type(),
      is_search_type(),
      aqs_type_subtypes(),
      has_tab_match(),
      associated_keyword(),
      keyword(),
      starred(),
      duplicates(),
      from_previous(),
      pedal_id(),
      scoring_signals(),
      additional_info() {}

AutocompleteMatch::AutocompleteMatch(
    const std::string& provider_name_in,
    bool provider_done_in,
    int32_t relevance_in,
    bool deletable_in,
    const std::string& fill_into_edit_in,
    const std::string& inline_autocompletion_in,
    const ::GURL& destination_url_in,
    const ::GURL& stripped_destination_url_in,
    const ::GURL& icon_in,
    const ::GURL& image_in,
    const std::string& contents_in,
    std::vector<::AutocompleteMatch::ACMatchClassification> contents_class_in,
    const std::string& description_in,
    std::vector<::AutocompleteMatch::ACMatchClassification> description_class_in,
    bool swap_contents_and_description_in,
    const std::string& answer_in,
    const std::string& transition_in,
    bool allowed_to_be_default_match_in,
    const std::string& type_in,
    bool is_search_type_in,
    const std::string& aqs_type_subtypes_in,
    bool has_tab_match_in,
    const std::string& associated_keyword_in,
    const std::string& keyword_in,
    bool starred_in,
    int32_t duplicates_in,
    bool from_previous_in,
    int32_t pedal_id_in,
    const ::AutocompleteMatch::ScoringSignals& scoring_signals_in,
    const base::flat_map<std::string, std::string>& additional_info_in)
    : provider_name(std::move(provider_name_in)),
      provider_done(std::move(provider_done_in)),
      relevance(std::move(relevance_in)),
      deletable(std::move(deletable_in)),
      fill_into_edit(std::move(fill_into_edit_in)),
      inline_autocompletion(std::move(inline_autocompletion_in)),
      destination_url(std::move(destination_url_in)),
      stripped_destination_url(std::move(stripped_destination_url_in)),
      icon(std::move(icon_in)),
      image(std::move(image_in)),
      contents(std::move(contents_in)),
      contents_class(std::move(contents_class_in)),
      description(std::move(description_in)),
      description_class(std::move(description_class_in)),
      swap_contents_and_description(std::move(swap_contents_and_description_in)),
      answer(std::move(answer_in)),
      transition(std::move(transition_in)),
      allowed_to_be_default_match(std::move(allowed_to_be_default_match_in)),
      type(std::move(type_in)),
      is_search_type(std::move(is_search_type_in)),
      aqs_type_subtypes(std::move(aqs_type_subtypes_in)),
      has_tab_match(std::move(has_tab_match_in)),
      associated_keyword(std::move(associated_keyword_in)),
      keyword(std::move(keyword_in)),
      starred(std::move(starred_in)),
      duplicates(std::move(duplicates_in)),
      from_previous(std::move(from_previous_in)),
      pedal_id(std::move(pedal_id_in)),
      scoring_signals(std::move(scoring_signals_in)),
      additional_info(std::move(additional_info_in)) {}

AutocompleteMatch::~AutocompleteMatch() = default;

void AutocompleteMatch::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_name"), this->provider_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_done"), this->provider_done,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relevance"), this->relevance,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "deletable"), this->deletable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "fill_into_edit"), this->fill_into_edit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "inline_autocompletion"), this->inline_autocompletion,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "destination_url"), this->destination_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stripped_destination_url"), this->stripped_destination_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "image"), this->image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents"), this->contents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "contents_class"), this->contents_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::AutocompleteMatch::ACMatchClassification>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description"), this->description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "description_class"), this->description_class,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::AutocompleteMatch::ACMatchClassification>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "swap_contents_and_description"), this->swap_contents_and_description,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "answer"), this->answer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transition"), this->transition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_to_be_default_match"), this->allowed_to_be_default_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_search_type"), this->is_search_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "aqs_type_subtypes"), this->aqs_type_subtypes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_tab_match"), this->has_tab_match,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "associated_keyword"), this->associated_keyword,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyword"), this->keyword,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starred"), this->starred,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplicates"), this->duplicates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "from_previous"), this->from_previous,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pedal_id"), this->pedal_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scoring_signals"), this->scoring_signals,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::AutocompleteMatch::ScoringSignals&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_info"), this->additional_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteMatch::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AutocompleteResultsForProvider::AutocompleteResultsForProvider()
    : provider_name(),
      results() {}

AutocompleteResultsForProvider::AutocompleteResultsForProvider(
    const std::string& provider_name_in,
    std::vector<::AutocompleteMatchWrapper> results_in)
    : provider_name(std::move(provider_name_in)),
      results(std::move(results_in)) {}

AutocompleteResultsForProvider::~AutocompleteResultsForProvider() = default;

void AutocompleteResultsForProvider::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_name"), this->provider_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results"), this->results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::AutocompleteMatchWrapper>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AutocompleteResultsForProvider::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OmniboxResponse::OmniboxResponse()
    : cursor_position(),
      time_since_omnibox_started_ms(),
      done(),
      type(),
      host(),
      is_typed_host(),
      input_text(),
      combined_results(),
      results_by_provider() {}

OmniboxResponse::OmniboxResponse(
    int32_t cursor_position_in,
    int32_t time_since_omnibox_started_ms_in,
    bool done_in,
    const std::string& type_in,
    const std::string& host_in,
    bool is_typed_host_in,
    const std::string& input_text_in,
    std::vector<::AutocompleteMatchWrapper> combined_results_in,
    std::vector<AutocompleteResultsForProviderPtr> results_by_provider_in)
    : cursor_position(std::move(cursor_position_in)),
      time_since_omnibox_started_ms(std::move(time_since_omnibox_started_ms_in)),
      done(std::move(done_in)),
      type(std::move(type_in)),
      host(std::move(host_in)),
      is_typed_host(std::move(is_typed_host_in)),
      input_text(std::move(input_text_in)),
      combined_results(std::move(combined_results_in)),
      results_by_provider(std::move(results_by_provider_in)) {}

OmniboxResponse::~OmniboxResponse() = default;

void OmniboxResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cursor_position"), this->cursor_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time_since_omnibox_started_ms"), this->time_since_omnibox_started_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "done"), this->done,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_typed_host"), this->is_typed_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_text"), this->input_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "combined_results"), this->combined_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::AutocompleteMatchWrapper>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results_by_provider"), this->results_by_provider,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AutocompleteResultsForProviderPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool OmniboxResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

OmniboxPageHandler::IPCStableHashFunction OmniboxPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OmniboxPageHandler>(message.name())) {
    case messages::OmniboxPageHandler::kSetClientPage: {
      return &OmniboxPageHandler::SetClientPage_Sym::IPCStableHash;
    }
    case messages::OmniboxPageHandler::kStartOmniboxQuery: {
      return &OmniboxPageHandler::StartOmniboxQuery_Sym::IPCStableHash;
    }
    case messages::OmniboxPageHandler::kGetMlModelVersion: {
      return &OmniboxPageHandler::GetMlModelVersion_Sym::IPCStableHash;
    }
    case messages::OmniboxPageHandler::kStartMl: {
      return &OmniboxPageHandler::StartMl_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OmniboxPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OmniboxPageHandler>(message.name())) {
      case messages::OmniboxPageHandler::kSetClientPage:
            return "Receive mojom::OmniboxPageHandler::SetClientPage";
      case messages::OmniboxPageHandler::kStartOmniboxQuery:
            return "Receive mojom::OmniboxPageHandler::StartOmniboxQuery";
      case messages::OmniboxPageHandler::kGetMlModelVersion:
            return "Receive mojom::OmniboxPageHandler::GetMlModelVersion";
      case messages::OmniboxPageHandler::kStartMl:
            return "Receive mojom::OmniboxPageHandler::StartMl";
    }
  } else {
    switch (static_cast<messages::OmniboxPageHandler>(message.name())) {
      case messages::OmniboxPageHandler::kSetClientPage:
            return "Receive reply mojom::OmniboxPageHandler::SetClientPage";
      case messages::OmniboxPageHandler::kStartOmniboxQuery:
            return "Receive reply mojom::OmniboxPageHandler::StartOmniboxQuery";
      case messages::OmniboxPageHandler::kGetMlModelVersion:
            return "Receive reply mojom::OmniboxPageHandler::GetMlModelVersion";
      case messages::OmniboxPageHandler::kStartMl:
            return "Receive reply mojom::OmniboxPageHandler::StartMl";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OmniboxPageHandler::SetClientPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49235ac3;  // IPCStableHash for mojom::OmniboxPageHandler::SetClientPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPageHandler::StartOmniboxQuery_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb48b6cd5;  // IPCStableHash for mojom::OmniboxPageHandler::StartOmniboxQuery
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPageHandler::GetMlModelVersion_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff3460f6;  // IPCStableHash for mojom::OmniboxPageHandler::GetMlModelVersion
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPageHandler::StartMl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb708748f;  // IPCStableHash for mojom::OmniboxPageHandler::StartMl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class OmniboxPageHandler_GetMlModelVersion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OmniboxPageHandler_GetMlModelVersion_ForwardToCallback(
      OmniboxPageHandler::GetMlModelVersionCallback callback
      ) : callback_(std::move(callback)) {
  }

  OmniboxPageHandler_GetMlModelVersion_ForwardToCallback(const OmniboxPageHandler_GetMlModelVersion_ForwardToCallback&) = delete;
  OmniboxPageHandler_GetMlModelVersion_ForwardToCallback& operator=(const OmniboxPageHandler_GetMlModelVersion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OmniboxPageHandler::GetMlModelVersionCallback callback_;
};

class OmniboxPageHandler_StartMl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  OmniboxPageHandler_StartMl_ForwardToCallback(
      OmniboxPageHandler::StartMlCallback callback
      ) : callback_(std::move(callback)) {
  }

  OmniboxPageHandler_StartMl_ForwardToCallback(const OmniboxPageHandler_StartMl_ForwardToCallback&) = delete;
  OmniboxPageHandler_StartMl_ForwardToCallback& operator=(const OmniboxPageHandler_StartMl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  OmniboxPageHandler::StartMlCallback callback_;
};

OmniboxPageHandlerProxy::OmniboxPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OmniboxPageHandlerProxy::SetClientPage(
    ::mojo::PendingRemote<OmniboxPage> in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPageHandler::SetClientPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<OmniboxPage>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kSetClientPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_SetClientPage_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::mojom::OmniboxPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in OmniboxPageHandler.SetClientPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("SetClientPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OmniboxPageHandlerProxy::StartOmniboxQuery(
    const std::string& in_input_string, bool in_reset_autocomplete_controller, int32_t in_cursor_position, bool in_zero_suggest, bool in_prevent_inline_autocomplete, bool in_prefer_keyword, const std::string& in_current_url, int32_t in_page_classification) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPageHandler::StartOmniboxQuery", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_string"), in_input_string,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_autocomplete_controller"), in_reset_autocomplete_controller,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cursor_position"), in_cursor_position,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("zero_suggest"), in_zero_suggest,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prevent_inline_autocomplete"), in_prevent_inline_autocomplete,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("prefer_keyword"), in_prefer_keyword,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("current_url"), in_current_url,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_classification"), in_page_classification,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kStartOmniboxQuery), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_StartOmniboxQuery_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->input_string)::BaseType> input_string_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input_string,
    input_string_fragment);

  params->input_string.Set(
      input_string_fragment.is_null() ? nullptr : input_string_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_string.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_string in OmniboxPageHandler.StartOmniboxQuery request");

  params->reset_autocomplete_controller = in_reset_autocomplete_controller;

  params->cursor_position = in_cursor_position;

  params->zero_suggest = in_zero_suggest;

  params->prevent_inline_autocomplete = in_prevent_inline_autocomplete;

  params->prefer_keyword = in_prefer_keyword;
  mojo::internal::MessageFragment<
      typename decltype(params->current_url)::BaseType> current_url_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_current_url,
    current_url_fragment);

  params->current_url.Set(
      current_url_fragment.is_null() ? nullptr : current_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->current_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null current_url in OmniboxPageHandler.StartOmniboxQuery request");

  params->page_classification = in_page_classification;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("StartOmniboxQuery");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OmniboxPageHandlerProxy::GetMlModelVersion(
    GetMlModelVersionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::OmniboxPageHandler::GetMlModelVersion");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kGetMlModelVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_GetMlModelVersion_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("GetMlModelVersion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OmniboxPageHandler_GetMlModelVersion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void OmniboxPageHandlerProxy::StartMl(
    const ::AutocompleteMatch::ScoringSignals& in_signals, StartMlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPageHandler::StartMl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("signals"), in_signals,
                        "<value of type const ::AutocompleteMatch::ScoringSignals&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kStartMl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_StartMl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->signals)::BaseType> signals_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojom::SignalsDataView>(
    in_signals,
    signals_fragment);

  params->signals.Set(
      signals_fragment.is_null() ? nullptr : signals_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->signals.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null signals in OmniboxPageHandler.StartMl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("StartMl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new OmniboxPageHandler_StartMl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class OmniboxPageHandler_GetMlModelVersion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OmniboxPageHandler::GetMlModelVersionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OmniboxPageHandler_GetMlModelVersion_ProxyToResponder> proxy(
        new OmniboxPageHandler_GetMlModelVersion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OmniboxPageHandler_GetMlModelVersion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OmniboxPageHandler_GetMlModelVersion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OmniboxPageHandler_GetMlModelVersion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OmniboxPageHandler::GetMlModelVersionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_version);
};

bool OmniboxPageHandler_GetMlModelVersion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OmniboxPageHandler.2
  bool success = true;
  int32_t p_version{};
  OmniboxPageHandler_GetMlModelVersion_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version = input_data_view.version();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OmniboxPageHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_version));
  }
  return true;
}

void OmniboxPageHandler_GetMlModelVersion_ProxyToResponder::Run(
    int32_t in_version) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::OmniboxPageHandler::GetMlModelVersion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kGetMlModelVersion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->version = in_version;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("GetMlModelVersion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class OmniboxPageHandler_StartMl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static OmniboxPageHandler::StartMlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<OmniboxPageHandler_StartMl_ProxyToResponder> proxy(
        new OmniboxPageHandler_StartMl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&OmniboxPageHandler_StartMl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~OmniboxPageHandler_StartMl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  OmniboxPageHandler_StartMl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "OmniboxPageHandler::StartMlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      float in_score);
};

bool OmniboxPageHandler_StartMl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::OmniboxPageHandler_StartMl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::OmniboxPageHandler_StartMl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for OmniboxPageHandler.3
  bool success = true;
  float p_score{};
  OmniboxPageHandler_StartMl_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_score = input_data_view.score();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        OmniboxPageHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_score));
  }
  return true;
}

void OmniboxPageHandler_StartMl_ProxyToResponder::Run(
    float in_score) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::OmniboxPageHandler::StartMl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("score"), in_score,
                        "<value of type float>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPageHandler::kStartMl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPageHandler_StartMl_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->score = in_score;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPageHandler::Name_);
  message.set_method_name("StartMl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool OmniboxPageHandlerStubDispatch::Accept(
    OmniboxPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OmniboxPageHandler>(message->header()->name)) {
    case messages::OmniboxPageHandler::kSetClientPage: {
      DCHECK(message->is_serialized());
      internal::OmniboxPageHandler_SetClientPage_Params_Data* params =
          reinterpret_cast<internal::OmniboxPageHandler_SetClientPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPageHandler.0
      bool success = true;
      ::mojo::PendingRemote<OmniboxPage> p_page{};
      OmniboxPageHandler_SetClientPage_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClientPage(        
        std::move(p_page));
      return true;
    }
    case messages::OmniboxPageHandler::kStartOmniboxQuery: {
      DCHECK(message->is_serialized());
      internal::OmniboxPageHandler_StartOmniboxQuery_Params_Data* params =
          reinterpret_cast<internal::OmniboxPageHandler_StartOmniboxQuery_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPageHandler.1
      bool success = true;
      std::string p_input_string{};
      bool p_reset_autocomplete_controller{};
      int32_t p_cursor_position{};
      bool p_zero_suggest{};
      bool p_prevent_inline_autocomplete{};
      bool p_prefer_keyword{};
      std::string p_current_url{};
      int32_t p_page_classification{};
      OmniboxPageHandler_StartOmniboxQuery_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputString(&p_input_string))
        success = false;
      if (success)
        p_reset_autocomplete_controller = input_data_view.reset_autocomplete_controller();
      if (success)
        p_cursor_position = input_data_view.cursor_position();
      if (success)
        p_zero_suggest = input_data_view.zero_suggest();
      if (success)
        p_prevent_inline_autocomplete = input_data_view.prevent_inline_autocomplete();
      if (success)
        p_prefer_keyword = input_data_view.prefer_keyword();
      if (success && !input_data_view.ReadCurrentUrl(&p_current_url))
        success = false;
      if (success)
        p_page_classification = input_data_view.page_classification();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartOmniboxQuery(        
        std::move(p_input_string), 
        std::move(p_reset_autocomplete_controller), 
        std::move(p_cursor_position), 
        std::move(p_zero_suggest), 
        std::move(p_prevent_inline_autocomplete), 
        std::move(p_prefer_keyword), 
        std::move(p_current_url), 
        std::move(p_page_classification));
      return true;
    }
    case messages::OmniboxPageHandler::kGetMlModelVersion: {
      break;
    }
    case messages::OmniboxPageHandler::kStartMl: {
      break;
    }
  }
  return false;
}

// static
bool OmniboxPageHandlerStubDispatch::AcceptWithResponder(
    OmniboxPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OmniboxPageHandler>(message->header()->name)) {
    case messages::OmniboxPageHandler::kSetClientPage: {
      break;
    }
    case messages::OmniboxPageHandler::kStartOmniboxQuery: {
      break;
    }
    case messages::OmniboxPageHandler::kGetMlModelVersion: {
      internal::OmniboxPageHandler_GetMlModelVersion_Params_Data* params =
          reinterpret_cast<
              internal::OmniboxPageHandler_GetMlModelVersion_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OmniboxPageHandler.2
      bool success = true;
      OmniboxPageHandler_GetMlModelVersion_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPageHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          OmniboxPageHandler_GetMlModelVersion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMlModelVersion(std::move(callback));
      return true;
    }
    case messages::OmniboxPageHandler::kStartMl: {
      internal::OmniboxPageHandler_StartMl_Params_Data* params =
          reinterpret_cast<
              internal::OmniboxPageHandler_StartMl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for OmniboxPageHandler.3
      bool success = true;
      ::AutocompleteMatch::ScoringSignals p_signals{};
      OmniboxPageHandler_StartMl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSignals(&p_signals))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPageHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          OmniboxPageHandler_StartMl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartMl(        
        std::move(p_signals), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOmniboxPageHandlerValidationInfo[] = {
    { &internal::OmniboxPageHandler_SetClientPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OmniboxPageHandler_StartOmniboxQuery_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OmniboxPageHandler_GetMlModelVersion_Params_Data::Validate,
     &internal::OmniboxPageHandler_GetMlModelVersion_ResponseParams_Data::Validate},
    { &internal::OmniboxPageHandler_StartMl_Params_Data::Validate,
     &internal::OmniboxPageHandler_StartMl_ResponseParams_Data::Validate},
};

bool OmniboxPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::OmniboxPageHandler::Name_,
    kOmniboxPageHandlerValidationInfo);
}

bool OmniboxPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mojom::OmniboxPageHandler::Name_,
    kOmniboxPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

OmniboxPage::IPCStableHashFunction OmniboxPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OmniboxPage>(message.name())) {
    case messages::OmniboxPage::kHandleNewAutocompleteQuery: {
      return &OmniboxPage::HandleNewAutocompleteQuery_Sym::IPCStableHash;
    }
    case messages::OmniboxPage::kHandleNewAutocompleteResponse: {
      return &OmniboxPage::HandleNewAutocompleteResponse_Sym::IPCStableHash;
    }
    case messages::OmniboxPage::kHandleNewMlResponse: {
      return &OmniboxPage::HandleNewMlResponse_Sym::IPCStableHash;
    }
    case messages::OmniboxPage::kHandleAnswerIconImageData: {
      return &OmniboxPage::HandleAnswerIconImageData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OmniboxPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OmniboxPage>(message.name())) {
      case messages::OmniboxPage::kHandleNewAutocompleteQuery:
            return "Receive mojom::OmniboxPage::HandleNewAutocompleteQuery";
      case messages::OmniboxPage::kHandleNewAutocompleteResponse:
            return "Receive mojom::OmniboxPage::HandleNewAutocompleteResponse";
      case messages::OmniboxPage::kHandleNewMlResponse:
            return "Receive mojom::OmniboxPage::HandleNewMlResponse";
      case messages::OmniboxPage::kHandleAnswerIconImageData:
            return "Receive mojom::OmniboxPage::HandleAnswerIconImageData";
    }
  } else {
    switch (static_cast<messages::OmniboxPage>(message.name())) {
      case messages::OmniboxPage::kHandleNewAutocompleteQuery:
            return "Receive reply mojom::OmniboxPage::HandleNewAutocompleteQuery";
      case messages::OmniboxPage::kHandleNewAutocompleteResponse:
            return "Receive reply mojom::OmniboxPage::HandleNewAutocompleteResponse";
      case messages::OmniboxPage::kHandleNewMlResponse:
            return "Receive reply mojom::OmniboxPage::HandleNewMlResponse";
      case messages::OmniboxPage::kHandleAnswerIconImageData:
            return "Receive reply mojom::OmniboxPage::HandleAnswerIconImageData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OmniboxPage::HandleNewAutocompleteQuery_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9693e06d;  // IPCStableHash for mojom::OmniboxPage::HandleNewAutocompleteQuery
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPage::HandleNewAutocompleteResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc7513bab;  // IPCStableHash for mojom::OmniboxPage::HandleNewAutocompleteResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPage::HandleNewMlResponse_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xede7502a;  // IPCStableHash for mojom::OmniboxPage::HandleNewMlResponse
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t OmniboxPage::HandleAnswerIconImageData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf3e1c4bf;  // IPCStableHash for mojom::OmniboxPage::HandleAnswerIconImageData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

OmniboxPageProxy::OmniboxPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OmniboxPageProxy::HandleNewAutocompleteQuery(
    AutocompleteControllerType in_autocomplete_controller_type, const std::string& in_input_text) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPage::HandleNewAutocompleteQuery", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autocomplete_controller_type"), in_autocomplete_controller_type,
                        "<value of type AutocompleteControllerType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_text"), in_input_text,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPage::kHandleNewAutocompleteQuery), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPage_HandleNewAutocompleteQuery_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojom::AutocompleteControllerType>(
    in_autocomplete_controller_type,
    &params->autocomplete_controller_type);
  mojo::internal::MessageFragment<
      typename decltype(params->input_text)::BaseType> input_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input_text,
    input_text_fragment);

  params->input_text.Set(
      input_text_fragment.is_null() ? nullptr : input_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_text in OmniboxPage.HandleNewAutocompleteQuery request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPage::Name_);
  message.set_method_name("HandleNewAutocompleteQuery");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OmniboxPageProxy::HandleNewAutocompleteResponse(
    AutocompleteControllerType in_autocomplete_controller_type, OmniboxResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPage::HandleNewAutocompleteResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autocomplete_controller_type"), in_autocomplete_controller_type,
                        "<value of type AutocompleteControllerType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type OmniboxResponsePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPage::kHandleNewAutocompleteResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPage_HandleNewAutocompleteResponse_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojom::AutocompleteControllerType>(
    in_autocomplete_controller_type,
    &params->autocomplete_controller_type);
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojom::OmniboxResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->response.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null response in OmniboxPage.HandleNewAutocompleteResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPage::Name_);
  message.set_method_name("HandleNewAutocompleteResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OmniboxPageProxy::HandleNewMlResponse(
    AutocompleteControllerType in_autocomplete_controller_type, const std::string& in_input_text, const std::vector<::AutocompleteMatchWrapper>& in_matches) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPage::HandleNewMlResponse", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autocomplete_controller_type"), in_autocomplete_controller_type,
                        "<value of type AutocompleteControllerType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_text"), in_input_text,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("matches"), in_matches,
                        "<value of type const std::vector<::AutocompleteMatchWrapper>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPage::kHandleNewMlResponse), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPage_HandleNewMlResponse_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojom::AutocompleteControllerType>(
    in_autocomplete_controller_type,
    &params->autocomplete_controller_type);
  mojo::internal::MessageFragment<
      typename decltype(params->input_text)::BaseType> input_text_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_input_text,
    input_text_fragment);

  params->input_text.Set(
      input_text_fragment.is_null() ? nullptr : input_text_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->input_text.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null input_text in OmniboxPage.HandleNewMlResponse request");
  mojo::internal::MessageFragment<
      typename decltype(params->matches)::BaseType>
      matches_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& matches_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::AutocompleteMatchDataView>>(
    in_matches,
    matches_fragment,
    &matches_validate_params);

  params->matches.Set(
      matches_fragment.is_null() ? nullptr : matches_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->matches.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null matches in OmniboxPage.HandleNewMlResponse request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPage::Name_);
  message.set_method_name("HandleNewMlResponse");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void OmniboxPageProxy::HandleAnswerIconImageData(
    AutocompleteControllerType in_autocomplete_controller_type, const ::GURL& in_image_url, const std::string& in_image_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::OmniboxPage::HandleAnswerIconImageData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("autocomplete_controller_type"), in_autocomplete_controller_type,
                        "<value of type AutocompleteControllerType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_url"), in_image_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_data"), in_image_data,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OmniboxPage::kHandleAnswerIconImageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::OmniboxPage_HandleAnswerIconImageData_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::mojom::AutocompleteControllerType>(
    in_autocomplete_controller_type,
    &params->autocomplete_controller_type);
  mojo::internal::MessageFragment<
      typename decltype(params->image_url)::BaseType> image_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_image_url,
    image_url_fragment);

  params->image_url.Set(
      image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_url in OmniboxPage.HandleAnswerIconImageData request");
  mojo::internal::MessageFragment<
      typename decltype(params->image_data)::BaseType> image_data_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_image_data,
    image_data_fragment);

  params->image_data.Set(
      image_data_fragment.is_null() ? nullptr : image_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image_data in OmniboxPage.HandleAnswerIconImageData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OmniboxPage::Name_);
  message.set_method_name("HandleAnswerIconImageData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OmniboxPageStubDispatch::Accept(
    OmniboxPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OmniboxPage>(message->header()->name)) {
    case messages::OmniboxPage::kHandleNewAutocompleteQuery: {
      DCHECK(message->is_serialized());
      internal::OmniboxPage_HandleNewAutocompleteQuery_Params_Data* params =
          reinterpret_cast<internal::OmniboxPage_HandleNewAutocompleteQuery_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPage.0
      bool success = true;
      AutocompleteControllerType p_autocomplete_controller_type{};
      std::string p_input_text{};
      OmniboxPage_HandleNewAutocompleteQuery_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutocompleteControllerType(&p_autocomplete_controller_type))
        success = false;
      if (success && !input_data_view.ReadInputText(&p_input_text))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleNewAutocompleteQuery(        
        std::move(p_autocomplete_controller_type), 
        std::move(p_input_text));
      return true;
    }
    case messages::OmniboxPage::kHandleNewAutocompleteResponse: {
      DCHECK(message->is_serialized());
      internal::OmniboxPage_HandleNewAutocompleteResponse_Params_Data* params =
          reinterpret_cast<internal::OmniboxPage_HandleNewAutocompleteResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPage.1
      bool success = true;
      AutocompleteControllerType p_autocomplete_controller_type{};
      OmniboxResponsePtr p_response{};
      OmniboxPage_HandleNewAutocompleteResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutocompleteControllerType(&p_autocomplete_controller_type))
        success = false;
      if (success && !input_data_view.ReadResponse(&p_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPage::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleNewAutocompleteResponse(        
        std::move(p_autocomplete_controller_type), 
        std::move(p_response));
      return true;
    }
    case messages::OmniboxPage::kHandleNewMlResponse: {
      DCHECK(message->is_serialized());
      internal::OmniboxPage_HandleNewMlResponse_Params_Data* params =
          reinterpret_cast<internal::OmniboxPage_HandleNewMlResponse_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPage.2
      bool success = true;
      AutocompleteControllerType p_autocomplete_controller_type{};
      std::string p_input_text{};
      std::vector<::AutocompleteMatchWrapper> p_matches{};
      OmniboxPage_HandleNewMlResponse_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutocompleteControllerType(&p_autocomplete_controller_type))
        success = false;
      if (success && !input_data_view.ReadInputText(&p_input_text))
        success = false;
      if (success && !input_data_view.ReadMatches(&p_matches))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPage::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleNewMlResponse(        
        std::move(p_autocomplete_controller_type), 
        std::move(p_input_text), 
        std::move(p_matches));
      return true;
    }
    case messages::OmniboxPage::kHandleAnswerIconImageData: {
      DCHECK(message->is_serialized());
      internal::OmniboxPage_HandleAnswerIconImageData_Params_Data* params =
          reinterpret_cast<internal::OmniboxPage_HandleAnswerIconImageData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OmniboxPage.3
      bool success = true;
      AutocompleteControllerType p_autocomplete_controller_type{};
      ::GURL p_image_url{};
      std::string p_image_data{};
      OmniboxPage_HandleAnswerIconImageData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAutocompleteControllerType(&p_autocomplete_controller_type))
        success = false;
      if (success && !input_data_view.ReadImageUrl(&p_image_url))
        success = false;
      if (success && !input_data_view.ReadImageData(&p_image_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OmniboxPage::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAnswerIconImageData(        
        std::move(p_autocomplete_controller_type), 
        std::move(p_image_url), 
        std::move(p_image_data));
      return true;
    }
  }
  return false;
}

// static
bool OmniboxPageStubDispatch::AcceptWithResponder(
    OmniboxPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OmniboxPage>(message->header()->name)) {
    case messages::OmniboxPage::kHandleNewAutocompleteQuery: {
      break;
    }
    case messages::OmniboxPage::kHandleNewAutocompleteResponse: {
      break;
    }
    case messages::OmniboxPage::kHandleNewMlResponse: {
      break;
    }
    case messages::OmniboxPage::kHandleAnswerIconImageData: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOmniboxPageValidationInfo[] = {
    { &internal::OmniboxPage_HandleNewAutocompleteQuery_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OmniboxPage_HandleNewAutocompleteResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OmniboxPage_HandleNewMlResponse_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::OmniboxPage_HandleAnswerIconImageData_Params_Data::Validate,
     nullptr /* no response */},
};

bool OmniboxPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::OmniboxPage::Name_,
    kOmniboxPageValidationInfo);
}



}  // mojom


namespace mojo {


// static
bool StructTraits<::mojom::ACMatchClassification::DataView, ::mojom::ACMatchClassificationPtr>::Read(
    ::mojom::ACMatchClassification::DataView input,
    ::mojom::ACMatchClassificationPtr* output) {
  bool success = true;
  ::mojom::ACMatchClassificationPtr result(::mojom::ACMatchClassification::New());
  
      if (success)
        result->offset = input.offset();
      if (success)
        result->style = input.style();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::Signals::DataView, ::mojom::SignalsPtr>::Read(
    ::mojom::Signals::DataView input,
    ::mojom::SignalsPtr* output) {
  bool success = true;
  ::mojom::SignalsPtr result(::mojom::Signals::New());
  
      if (success) {
        result->typed_count = input.typed_count();
      }
      if (success) {
        result->visit_count = input.visit_count();
      }
      if (success) {
        result->elapsed_time_last_visit_secs = input.elapsed_time_last_visit_secs();
      }
      if (success) {
        result->shortcut_visit_count = input.shortcut_visit_count();
      }
      if (success) {
        result->shortest_shortcut_len = input.shortest_shortcut_len();
      }
      if (success) {
        result->elapsed_time_last_shortcut_visit_sec = input.elapsed_time_last_shortcut_visit_sec();
      }
      if (success) {
        result->is_host_only = input.is_host_only();
      }
      if (success) {
        result->num_bookmarks_of_url = input.num_bookmarks_of_url();
      }
      if (success) {
        result->first_bookmark_title_match_position = input.first_bookmark_title_match_position();
      }
      if (success) {
        result->total_bookmark_title_match_length = input.total_bookmark_title_match_length();
      }
      if (success) {
        result->num_input_terms_matched_by_bookmark_title = input.num_input_terms_matched_by_bookmark_title();
      }
      if (success) {
        result->first_url_match_position = input.first_url_match_position();
      }
      if (success) {
        result->total_url_match_length = input.total_url_match_length();
      }
      if (success) {
        result->host_match_at_word_boundary = input.host_match_at_word_boundary();
      }
      if (success) {
        result->total_host_match_length = input.total_host_match_length();
      }
      if (success) {
        result->total_path_match_length = input.total_path_match_length();
      }
      if (success) {
        result->total_query_or_ref_match_length = input.total_query_or_ref_match_length();
      }
      if (success) {
        result->total_title_match_length = input.total_title_match_length();
      }
      if (success) {
        result->has_non_scheme_www_match = input.has_non_scheme_www_match();
      }
      if (success) {
        result->num_input_terms_matched_by_title = input.num_input_terms_matched_by_title();
      }
      if (success) {
        result->num_input_terms_matched_by_url = input.num_input_terms_matched_by_url();
      }
      if (success) {
        result->length_of_url = input.length_of_url();
      }
      if (success) {
        result->site_engagement = input.site_engagement();
      }
      if (success) {
        result->allowed_to_be_default_match = input.allowed_to_be_default_match();
      }
      if (success) {
        result->search_suggest_relevance = input.search_suggest_relevance();
      }
      if (success) {
        result->is_search_suggest_entity = input.is_search_suggest_entity();
      }
      if (success) {
        result->is_verbatim = input.is_verbatim();
      }
      if (success) {
        result->is_navsuggest = input.is_navsuggest();
      }
      if (success) {
        result->is_search_suggest_tail = input.is_search_suggest_tail();
      }
      if (success) {
        result->is_answer_suggest = input.is_answer_suggest();
      }
      if (success) {
        result->is_calculator_suggest = input.is_calculator_suggest();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::AutocompleteMatch::DataView, ::mojom::AutocompleteMatchPtr>::Read(
    ::mojom::AutocompleteMatch::DataView input,
    ::mojom::AutocompleteMatchPtr* output) {
  bool success = true;
  ::mojom::AutocompleteMatchPtr result(::mojom::AutocompleteMatch::New());
  
      if (success && !input.ReadProviderName(&result->provider_name))
        success = false;
      if (success)
        result->provider_done = input.provider_done();
      if (success)
        result->relevance = input.relevance();
      if (success)
        result->deletable = input.deletable();
      if (success && !input.ReadFillIntoEdit(&result->fill_into_edit))
        success = false;
      if (success && !input.ReadInlineAutocompletion(&result->inline_autocompletion))
        success = false;
      if (success && !input.ReadDestinationUrl(&result->destination_url))
        success = false;
      if (success && !input.ReadStrippedDestinationUrl(&result->stripped_destination_url))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success && !input.ReadImage(&result->image))
        success = false;
      if (success && !input.ReadContents(&result->contents))
        success = false;
      if (success && !input.ReadContentsClass(&result->contents_class))
        success = false;
      if (success && !input.ReadDescription(&result->description))
        success = false;
      if (success && !input.ReadDescriptionClass(&result->description_class))
        success = false;
      if (success)
        result->swap_contents_and_description = input.swap_contents_and_description();
      if (success && !input.ReadAnswer(&result->answer))
        success = false;
      if (success && !input.ReadTransition(&result->transition))
        success = false;
      if (success)
        result->allowed_to_be_default_match = input.allowed_to_be_default_match();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->is_search_type = input.is_search_type();
      if (success && !input.ReadAqsTypeSubtypes(&result->aqs_type_subtypes))
        success = false;
      if (success)
        result->has_tab_match = input.has_tab_match();
      if (success && !input.ReadAssociatedKeyword(&result->associated_keyword))
        success = false;
      if (success && !input.ReadKeyword(&result->keyword))
        success = false;
      if (success)
        result->starred = input.starred();
      if (success)
        result->duplicates = input.duplicates();
      if (success)
        result->from_previous = input.from_previous();
      if (success)
        result->pedal_id = input.pedal_id();
      if (success && !input.ReadScoringSignals(&result->scoring_signals))
        success = false;
      if (success && !input.ReadAdditionalInfo(&result->additional_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::AutocompleteResultsForProvider::DataView, ::mojom::AutocompleteResultsForProviderPtr>::Read(
    ::mojom::AutocompleteResultsForProvider::DataView input,
    ::mojom::AutocompleteResultsForProviderPtr* output) {
  bool success = true;
  ::mojom::AutocompleteResultsForProviderPtr result(::mojom::AutocompleteResultsForProvider::New());
  
      if (success && !input.ReadProviderName(&result->provider_name))
        success = false;
      if (success && !input.ReadResults(&result->results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::OmniboxResponse::DataView, ::mojom::OmniboxResponsePtr>::Read(
    ::mojom::OmniboxResponse::DataView input,
    ::mojom::OmniboxResponsePtr* output) {
  bool success = true;
  ::mojom::OmniboxResponsePtr result(::mojom::OmniboxResponse::New());
  
      if (success)
        result->cursor_position = input.cursor_position();
      if (success)
        result->time_since_omnibox_started_ms = input.time_since_omnibox_started_ms();
      if (success)
        result->done = input.done();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->is_typed_host = input.is_typed_host();
      if (success && !input.ReadInputText(&result->input_text))
        success = false;
      if (success && !input.ReadCombinedResults(&result->combined_results))
        success = false;
      if (success && !input.ReadResultsByProvider(&result->results_by_provider))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojom {


void OmniboxPageHandlerInterceptorForTesting::SetClientPage(::mojo::PendingRemote<OmniboxPage> page) {
  GetForwardingInterface()->SetClientPage(
    std::move(page)
    );
}
void OmniboxPageHandlerInterceptorForTesting::StartOmniboxQuery(const std::string& input_string, bool reset_autocomplete_controller, int32_t cursor_position, bool zero_suggest, bool prevent_inline_autocomplete, bool prefer_keyword, const std::string& current_url, int32_t page_classification) {
  GetForwardingInterface()->StartOmniboxQuery(
    std::move(input_string)
    , 
    std::move(reset_autocomplete_controller)
    , 
    std::move(cursor_position)
    , 
    std::move(zero_suggest)
    , 
    std::move(prevent_inline_autocomplete)
    , 
    std::move(prefer_keyword)
    , 
    std::move(current_url)
    , 
    std::move(page_classification)
    );
}
void OmniboxPageHandlerInterceptorForTesting::GetMlModelVersion(GetMlModelVersionCallback callback) {
  GetForwardingInterface()->GetMlModelVersion(std::move(callback));
}
void OmniboxPageHandlerInterceptorForTesting::StartMl(const ::AutocompleteMatch::ScoringSignals& signals, StartMlCallback callback) {
  GetForwardingInterface()->StartMl(
    std::move(signals)
    , std::move(callback));
}
OmniboxPageHandlerAsyncWaiter::OmniboxPageHandlerAsyncWaiter(
    OmniboxPageHandler* proxy) : proxy_(proxy) {}

OmniboxPageHandlerAsyncWaiter::~OmniboxPageHandlerAsyncWaiter() = default;


void OmniboxPageHandlerAsyncWaiter::GetMlModelVersion(
    int32_t* out_version) {
  base::RunLoop loop;
  proxy_->GetMlModelVersion(
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_version
,
             int32_t version) {*out_version = std::move(version);
            loop->Quit();
          },
          &loop,
          out_version));
  loop.Run();
}

int32_t OmniboxPageHandlerAsyncWaiter::GetMlModelVersion(
    ) {
  int32_t async_wait_result;
  GetMlModelVersion(&async_wait_result);
  return async_wait_result;
}

void OmniboxPageHandlerAsyncWaiter::StartMl(
    const ::AutocompleteMatch::ScoringSignals& signals, float* out_score) {
  base::RunLoop loop;
  proxy_->StartMl(
      std::move(signals),
      base::BindOnce(
          [](base::RunLoop* loop,
             float* out_score
,
             float score) {*out_score = std::move(score);
            loop->Quit();
          },
          &loop,
          out_score));
  loop.Run();
}

float OmniboxPageHandlerAsyncWaiter::StartMl(
    const ::AutocompleteMatch::ScoringSignals& signals) {
  float async_wait_result;
  StartMl(std::move(signals),&async_wait_result);
  return async_wait_result;
}




void OmniboxPageInterceptorForTesting::HandleNewAutocompleteQuery(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text) {
  GetForwardingInterface()->HandleNewAutocompleteQuery(
    std::move(autocomplete_controller_type)
    , 
    std::move(input_text)
    );
}
void OmniboxPageInterceptorForTesting::HandleNewAutocompleteResponse(AutocompleteControllerType autocomplete_controller_type, OmniboxResponsePtr response) {
  GetForwardingInterface()->HandleNewAutocompleteResponse(
    std::move(autocomplete_controller_type)
    , 
    std::move(response)
    );
}
void OmniboxPageInterceptorForTesting::HandleNewMlResponse(AutocompleteControllerType autocomplete_controller_type, const std::string& input_text, const std::vector<::AutocompleteMatchWrapper>& matches) {
  GetForwardingInterface()->HandleNewMlResponse(
    std::move(autocomplete_controller_type)
    , 
    std::move(input_text)
    , 
    std::move(matches)
    );
}
void OmniboxPageInterceptorForTesting::HandleAnswerIconImageData(AutocompleteControllerType autocomplete_controller_type, const ::GURL& image_url, const std::string& image_data) {
  GetForwardingInterface()->HandleAnswerIconImageData(
    std::move(autocomplete_controller_type)
    , 
    std::move(image_url)
    , 
    std::move(image_data)
    );
}
OmniboxPageAsyncWaiter::OmniboxPageAsyncWaiter(
    OmniboxPage* proxy) : proxy_(proxy) {}

OmniboxPageAsyncWaiter::~OmniboxPageAsyncWaiter() = default;







}  // mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif