// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-forward.h"  // IWYU pragma: export
#include "components/ntp_tiles/tile_type.mojom-forward.h"
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_shared_ui.mojom-forward.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace new_tab_page::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_page.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_page.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetMostVisitedSettingsMinVersion = 0,
    kGetMostVisitedSettingsMinVersion = 0,
    kGetDoodleMinVersion = 0,
    kUpdatePromoDataMinVersion = 0,
    kBlocklistPromoMinVersion = 0,
    kUndoBlocklistPromoMinVersion = 0,
    kOnDismissModuleMinVersion = 0,
    kOnRestoreModuleMinVersion = 0,
    kSetModulesVisibleMinVersion = 0,
    kSetModuleDisabledMinVersion = 0,
    kUpdateDisabledModulesMinVersion = 0,
    kOnModulesLoadedWithDataMinVersion = 0,
    kOnModuleUsedMinVersion = 0,
    kGetModulesIdNamesMinVersion = 0,
    kSetModulesOrderMinVersion = 0,
    kGetModulesOrderMinVersion = 0,
    kUpdateModulesLoadableMinVersion = 0,
    kUpdateActionChipsVisibilityMinVersion = 0,
    kUpdateFooterVisibilityMinVersion = 0,
    kMaybeShowFeaturePromoMinVersion = 0,
    kIncrementComposeButtonShownCountMinVersion = 0,
    kMaybeTriggerAutomaticCustomizeChromePromoMinVersion = 0,
    kOnOneGoogleBarRenderedMinVersion = 0,
    kOnPromoRenderedMinVersion = 0,
    kOnCustomizeDialogActionMinVersion = 0,
    kOnDoodleImageClickedMinVersion = 0,
    kOnDoodleImageRenderedMinVersion = 0,
    kOnDoodleSharedMinVersion = 0,
    kOnPromoLinkClickedMinVersion = 0,
    kOnAppRenderedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetMostVisitedSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMostVisitedSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDoodle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdatePromoData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BlocklistPromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndoBlocklistPromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDismissModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRestoreModule_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModulesVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModuleDisabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateDisabledModules_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnModulesLoadedWithData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnModuleUsed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetModulesIdNames_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModulesOrder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetModulesOrder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateModulesLoadable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateActionChipsVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFooterVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeShowFeaturePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IncrementComposeButtonShownCount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeTriggerAutomaticCustomizeChromePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOneGoogleBarRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPromoRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCustomizeDialogAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDoodleImageClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDoodleImageRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnDoodleShared_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPromoLinkClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnAppRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetMostVisitedSettings(::ntp_tiles::mojom::TileType shortcuts_type, bool shortcuts_visible) = 0;

  using GetMostVisitedSettingsCallback = base::OnceCallback<void(::ntp_tiles::mojom::TileType, bool)>;
  using GetMostVisitedSettingsMojoCallback = base::OnceCallback<void(::ntp_tiles::mojom::TileType, bool)>;

  virtual void GetMostVisitedSettings(GetMostVisitedSettingsCallback callback) = 0;

  using GetDoodleCallback = base::OnceCallback<void(DoodlePtr)>;
  using GetDoodleMojoCallback = base::OnceCallback<void(DoodlePtr)>;

  virtual void GetDoodle(GetDoodleCallback callback) = 0;

  virtual void UpdatePromoData() = 0;

  virtual void BlocklistPromo(const std::string& promo_id) = 0;

  virtual void UndoBlocklistPromo(const std::string& promo_id) = 0;

  virtual void OnDismissModule(const std::string& module_id) = 0;

  virtual void OnRestoreModule(const std::string& module_id) = 0;

  virtual void SetModulesVisible(bool visible) = 0;

  virtual void SetModuleDisabled(const std::string& module_id, bool disabled) = 0;

  virtual void UpdateDisabledModules() = 0;

  virtual void OnModulesLoadedWithData(const std::vector<std::string>& module_ids) = 0;

  virtual void OnModuleUsed(const std::string& module_id) = 0;

  using GetModulesIdNamesCallback = base::OnceCallback<void(std::vector<ModuleIdNamePtr>)>;
  using GetModulesIdNamesMojoCallback = base::OnceCallback<void(std::vector<ModuleIdNamePtr>)>;

  virtual void GetModulesIdNames(GetModulesIdNamesCallback callback) = 0;

  virtual void SetModulesOrder(const std::vector<std::string>& module_ids) = 0;

  using GetModulesOrderCallback = base::OnceCallback<void(const std::vector<std::string>&)>;
  using GetModulesOrderMojoCallback = base::OnceCallback<void(const std::vector<std::string>&)>;

  virtual void GetModulesOrder(GetModulesOrderCallback callback) = 0;

  virtual void UpdateModulesLoadable() = 0;

  virtual void UpdateActionChipsVisibility() = 0;

  virtual void UpdateFooterVisibility() = 0;

  virtual void MaybeShowFeaturePromo(IphFeature iph_feature) = 0;

  virtual void IncrementComposeButtonShownCount() = 0;

  virtual void MaybeTriggerAutomaticCustomizeChromePromo() = 0;

  virtual void OnOneGoogleBarRendered(double time) = 0;

  virtual void OnPromoRendered(double time, const std::optional<::GURL>& log_url) = 0;

  virtual void OnCustomizeDialogAction(CustomizeDialogAction action) = 0;

  virtual void OnDoodleImageClicked(DoodleImageType type, const std::optional<::GURL>& log_url) = 0;

  using OnDoodleImageRenderedCallback = base::OnceCallback<void(const std::optional<std::string>&, const std::optional<::GURL>&, const std::optional<std::string>&)>;
  using OnDoodleImageRenderedMojoCallback = base::OnceCallback<void(const std::optional<std::string>&, const std::optional<::GURL>&, const std::optional<std::string>&)>;

  virtual void OnDoodleImageRendered(DoodleImageType type, double time, const ::GURL& log_url, OnDoodleImageRenderedCallback callback) = 0;

  virtual void OnDoodleShared(DoodleShareChannel channel, const std::string& doodle_id, const std::optional<std::string>& share_id) = 0;

  virtual void OnPromoLinkClicked() = 0;

  virtual void OnAppRendered(double time) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_page.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetThemeMinVersion = 0,
    kSetDisabledModulesMinVersion = 0,
    kSetModulesLoadableMinVersion = 0,
    kSetActionChipsVisibilityMinVersion = 0,
    kSetPromoMinVersion = 0,
    kShowWebstoreToastMinVersion = 0,
    kSetWallpaperSearchButtonVisibilityMinVersion = 0,
    kFooterVisibilityUpdatedMinVersion = 0,
    kConnectToParentDocumentMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDisabledModules_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetModulesLoadable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetActionChipsVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowWebstoreToast_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWallpaperSearchButtonVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FooterVisibilityUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectToParentDocument_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SetTheme(ThemePtr theme) = 0;

  virtual void SetDisabledModules(bool all, const std::vector<std::string>& ids) = 0;

  virtual void SetModulesLoadable() = 0;

  virtual void SetActionChipsVisibility(bool visible) = 0;

  virtual void SetPromo(PromoPtr promo) = 0;

  virtual void ShowWebstoreToast() = 0;

  virtual void SetWallpaperSearchButtonVisibility(bool visible) = 0;

  virtual void FooterVisibilityUpdated(bool visible) = 0;

  virtual void ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_untrusted_document_remote) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMostVisitedSettings(::ntp_tiles::mojom::TileType shortcuts_type, bool shortcuts_visible) final;
  
  void GetMostVisitedSettings(GetMostVisitedSettingsCallback callback) final;
  
  void GetDoodle(GetDoodleCallback callback) final;
  
  void UpdatePromoData() final;
  
  void BlocklistPromo(const std::string& promo_id) final;
  
  void UndoBlocklistPromo(const std::string& promo_id) final;
  
  void OnDismissModule(const std::string& module_id) final;
  
  void OnRestoreModule(const std::string& module_id) final;
  
  void SetModulesVisible(bool visible) final;
  
  void SetModuleDisabled(const std::string& module_id, bool disabled) final;
  
  void UpdateDisabledModules() final;
  
  void OnModulesLoadedWithData(const std::vector<std::string>& module_ids) final;
  
  void OnModuleUsed(const std::string& module_id) final;
  
  void GetModulesIdNames(GetModulesIdNamesCallback callback) final;
  
  void SetModulesOrder(const std::vector<std::string>& module_ids) final;
  
  void GetModulesOrder(GetModulesOrderCallback callback) final;
  
  void UpdateModulesLoadable() final;
  
  void UpdateActionChipsVisibility() final;
  
  void UpdateFooterVisibility() final;
  
  void MaybeShowFeaturePromo(IphFeature iph_feature) final;
  
  void IncrementComposeButtonShownCount() final;
  
  void MaybeTriggerAutomaticCustomizeChromePromo() final;
  
  void OnOneGoogleBarRendered(double time) final;
  
  void OnPromoRendered(double time, const std::optional<::GURL>& log_url) final;
  
  void OnCustomizeDialogAction(CustomizeDialogAction action) final;
  
  void OnDoodleImageClicked(DoodleImageType type, const std::optional<::GURL>& log_url) final;
  
  void OnDoodleImageRendered(DoodleImageType type, double time, const ::GURL& log_url, OnDoodleImageRenderedCallback callback) final;
  
  void OnDoodleShared(DoodleShareChannel channel, const std::string& doodle_id, const std::optional<std::string>& share_id) final;
  
  void OnPromoLinkClicked() final;
  
  void OnAppRendered(double time) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetTheme(ThemePtr theme) final;
  
  void SetDisabledModules(bool all, const std::vector<std::string>& ids) final;
  
  void SetModulesLoadable() final;
  
  void SetActionChipsVisibility(bool visible) final;
  
  void SetPromo(PromoPtr promo) final;
  
  void ShowWebstoreToast() final;
  
  void SetWallpaperSearchButtonVisibility(bool visible) final;
  
  void FooterVisibilityUpdated(bool visible) final;
  
  void ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_untrusted_document_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};













class  PromoTextPart {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PromoTextPart, T>::value>;
  using DataView = PromoTextPartDataView;
  using Data_ = internal::PromoTextPart_Data;

  template <typename... Args>
  static PromoTextPartPtr New(Args&&... args) {
    return PromoTextPartPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromoTextPartPtr From(const U& u) {
    return mojo::TypeConverter<PromoTextPartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PromoTextPart>::Convert(*this);
  }


  PromoTextPart();

  explicit PromoTextPart(
      const std::string& text);


  ~PromoTextPart();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromoTextPartPtr>
  PromoTextPartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoTextPart::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoTextPart::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PromoTextPart::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PromoTextPart_UnserializedMessageContext<
            UserType, PromoTextPart::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PromoTextPart::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PromoTextPart::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PromoTextPart_UnserializedMessageContext<
            UserType, PromoTextPart::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PromoTextPart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PromoTextPart::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  ModuleIdName {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ModuleIdName, T>::value>;
  using DataView = ModuleIdNameDataView;
  using Data_ = internal::ModuleIdName_Data;

  template <typename... Args>
  static ModuleIdNamePtr New(Args&&... args) {
    return ModuleIdNamePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ModuleIdNamePtr From(const U& u) {
    return mojo::TypeConverter<ModuleIdNamePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ModuleIdName>::Convert(*this);
  }


  ModuleIdName();

  ModuleIdName(
      const std::string& id,
      const std::string& name);


  ~ModuleIdName();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ModuleIdNamePtr>
  ModuleIdNamePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModuleIdName::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ModuleIdName::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ModuleIdName::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ModuleIdName_UnserializedMessageContext<
            UserType, ModuleIdName::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ModuleIdName::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ModuleIdName::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ModuleIdName_UnserializedMessageContext<
            UserType, ModuleIdName::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ModuleIdName::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ModuleIdName::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PromoPart {
 public:
  using DataView = PromoPartDataView;
  using Data_ = internal::PromoPart_Data;
  using Tag = Data_::PromoPart_Tag;

  template <typename... Args>
  static PromoPartPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |image|.
  static PromoPartPtr NewImage(
      PromoImagePartPtr value);
  // Construct an instance holding |link|.
  static PromoPartPtr NewLink(
      PromoLinkPartPtr value);
  // Construct an instance holding |text|.
  static PromoPartPtr NewText(
      PromoTextPartPtr value);

  template <typename U>
  static PromoPartPtr From(const U& u) {
    return mojo::TypeConverter<PromoPartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PromoPart>::Convert(*this);
  }
  ~PromoPart();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  PromoPart(const PromoPart& other) = delete;
  PromoPart& operator=(const PromoPart& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = PromoPartPtr>
  PromoPartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, PromoPart>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, PromoPart>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_image() const { return tag_ == Tag::kImage; }
  const PromoImagePartPtr& get_image() const {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  PromoImagePartPtr& get_image() {
    CHECK(tag_ == Tag::kImage);
    return data_.image;
  }
  void set_image(PromoImagePartPtr image);

  bool is_link() const { return tag_ == Tag::kLink; }
  const PromoLinkPartPtr& get_link() const {
    CHECK(tag_ == Tag::kLink);
    return data_.link;
  }
  PromoLinkPartPtr& get_link() {
    CHECK(tag_ == Tag::kLink);
    return data_.link;
  }
  void set_link(PromoLinkPartPtr link);

  bool is_text() const { return tag_ == Tag::kText; }
  const PromoTextPartPtr& get_text() const {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  PromoTextPartPtr& get_text() {
    CHECK(tag_ == Tag::kText);
    return data_.text;
  }
  void set_text(PromoTextPartPtr text);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PromoPart::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<PromoPart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
        PromoImagePartPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kLink)>,
        PromoLinkPartPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
        PromoTextPartPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    PromoImagePartPtr image;
    PromoLinkPartPtr link;
    PromoTextPartPtr text;
  };

  PromoPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kImage)>,
      PromoImagePartPtr value);
  PromoPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kLink)>,
      PromoLinkPartPtr value);
  PromoPart(
      std::in_place_index_t<static_cast<size_t>(Tag::kText)>,
      PromoTextPartPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  BackgroundImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundImage, T>::value>;
  using DataView = BackgroundImageDataView;
  using Data_ = internal::BackgroundImage_Data;

  template <typename... Args>
  static BackgroundImagePtr New(Args&&... args) {
    return BackgroundImagePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundImagePtr From(const U& u) {
    return mojo::TypeConverter<BackgroundImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundImage>::Convert(*this);
  }


  BackgroundImage();

  BackgroundImage(
      const ::GURL& url,
      const std::optional<::GURL>& url_2x,
      const std::optional<::GURL>& attribution_url,
      const std::optional<std::string>& size,
      const std::optional<std::string>& repeat_x,
      const std::optional<std::string>& repeat_y,
      const std::optional<std::string>& position_x,
      const std::optional<std::string>& position_y,
      NtpBackgroundImageSource image_source);


  ~BackgroundImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundImagePtr>
  BackgroundImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundImage::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundImage_UnserializedMessageContext<
            UserType, BackgroundImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundImage::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundImage::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundImage_UnserializedMessageContext<
            UserType, BackgroundImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundImage::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  std::optional<::GURL> url_2x;
  
  std::optional<::GURL> attribution_url;
  
  std::optional<std::string> size;
  
  std::optional<std::string> repeat_x;
  
  std::optional<std::string> repeat_y;
  
  std::optional<std::string> position_x;
  
  std::optional<std::string> position_y;
  
  NtpBackgroundImageSource image_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Theme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Theme, T>::value>;
  using DataView = ThemeDataView;
  using Data_ = internal::Theme_Data;

  template <typename... Args>
  static ThemePtr New(Args&&... args) {
    return ThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThemePtr From(const U& u) {
    return mojo::TypeConverter<ThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Theme>::Convert(*this);
  }


  Theme();

  Theme(
      ::SkColor text_color,
      ::SkColor background_color,
      bool is_baseline,
      bool is_custom_background,
      bool daily_refresh_enabled,
      bool is_dark,
      std::optional<::SkColor> logo_color,
      const std::optional<std::string>& background_image_collection_id,
      BackgroundImagePtr background_image,
      const std::optional<std::string>& background_image_attribution_1,
      const std::optional<std::string>& background_image_attribution_2,
      const std::optional<::GURL>& background_image_attribution_url,
      ::most_visited::mojom::MostVisitedThemePtr most_visited);

Theme(const Theme&) = delete;
Theme& operator=(const Theme&) = delete;

  ~Theme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThemePtr>
  ThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Theme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Theme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor text_color;
  
  ::SkColor background_color;
  
  bool is_baseline;
  
  bool is_custom_background;
  
  bool daily_refresh_enabled;
  
  bool is_dark;
  
  std::optional<::SkColor> logo_color;
  
  std::optional<std::string> background_image_collection_id;
  
  BackgroundImagePtr background_image;
  
  std::optional<std::string> background_image_attribution_1;
  
  std::optional<std::string> background_image_attribution_2;
  
  std::optional<::GURL> background_image_attribution_url;
  
  ::most_visited::mojom::MostVisitedThemePtr most_visited;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ImageDoodle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ImageDoodle, T>::value>;
  using DataView = ImageDoodleDataView;
  using Data_ = internal::ImageDoodle_Data;

  template <typename... Args>
  static ImageDoodlePtr New(Args&&... args) {
    return ImageDoodlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ImageDoodlePtr From(const U& u) {
    return mojo::TypeConverter<ImageDoodlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ImageDoodle>::Convert(*this);
  }


  ImageDoodle();

  ImageDoodle(
      const ::GURL& image_url,
      const std::optional<::GURL>& animation_url,
      uint32_t width,
      uint32_t height,
      ::SkColor background_color,
      const ::GURL& image_impression_log_url,
      const std::optional<::GURL>& animation_impression_log_url);


  ~ImageDoodle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ImageDoodlePtr>
  ImageDoodlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageDoodle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ImageDoodle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ImageDoodle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ImageDoodle_UnserializedMessageContext<
            UserType, ImageDoodle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ImageDoodle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ImageDoodle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ImageDoodle_UnserializedMessageContext<
            UserType, ImageDoodle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ImageDoodle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL image_url;
  
  std::optional<::GURL> animation_url;
  
  uint32_t width;
  
  uint32_t height;
  
  ::SkColor background_color;
  
  ::GURL image_impression_log_url;
  
  std::optional<::GURL> animation_impression_log_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ImageDoodle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AllModeImageDoodle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AllModeImageDoodle, T>::value>;
  using DataView = AllModeImageDoodleDataView;
  using Data_ = internal::AllModeImageDoodle_Data;

  template <typename... Args>
  static AllModeImageDoodlePtr New(Args&&... args) {
    return AllModeImageDoodlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AllModeImageDoodlePtr From(const U& u) {
    return mojo::TypeConverter<AllModeImageDoodlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllModeImageDoodle>::Convert(*this);
  }


  AllModeImageDoodle();

  AllModeImageDoodle(
      ImageDoodlePtr light,
      ImageDoodlePtr dark,
      const std::optional<::GURL>& on_click_url,
      const ::GURL& share_url);

AllModeImageDoodle(const AllModeImageDoodle&) = delete;
AllModeImageDoodle& operator=(const AllModeImageDoodle&) = delete;

  ~AllModeImageDoodle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AllModeImageDoodlePtr>
  AllModeImageDoodlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllModeImageDoodle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AllModeImageDoodle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllModeImageDoodle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AllModeImageDoodle_UnserializedMessageContext<
            UserType, AllModeImageDoodle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AllModeImageDoodle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AllModeImageDoodle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AllModeImageDoodle_UnserializedMessageContext<
            UserType, AllModeImageDoodle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AllModeImageDoodle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ImageDoodlePtr light;
  
  ImageDoodlePtr dark;
  
  std::optional<::GURL> on_click_url;
  
  ::GURL share_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AllModeImageDoodle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InteractiveDoodle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InteractiveDoodle, T>::value>;
  using DataView = InteractiveDoodleDataView;
  using Data_ = internal::InteractiveDoodle_Data;

  template <typename... Args>
  static InteractiveDoodlePtr New(Args&&... args) {
    return InteractiveDoodlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InteractiveDoodlePtr From(const U& u) {
    return mojo::TypeConverter<InteractiveDoodlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InteractiveDoodle>::Convert(*this);
  }


  InteractiveDoodle();

  InteractiveDoodle(
      const ::GURL& url,
      uint32_t width,
      uint32_t height);


  ~InteractiveDoodle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InteractiveDoodlePtr>
  InteractiveDoodlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InteractiveDoodle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InteractiveDoodle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InteractiveDoodle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InteractiveDoodle_UnserializedMessageContext<
            UserType, InteractiveDoodle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InteractiveDoodle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InteractiveDoodle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InteractiveDoodle_UnserializedMessageContext<
            UserType, InteractiveDoodle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InteractiveDoodle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  uint32_t width;
  
  uint32_t height;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InteractiveDoodle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Doodle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Doodle, T>::value>;
  using DataView = DoodleDataView;
  using Data_ = internal::Doodle_Data;

  template <typename... Args>
  static DoodlePtr New(Args&&... args) {
    return DoodlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DoodlePtr From(const U& u) {
    return mojo::TypeConverter<DoodlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Doodle>::Convert(*this);
  }


  Doodle();

  Doodle(
      AllModeImageDoodlePtr image,
      InteractiveDoodlePtr interactive,
      const std::string& description);

Doodle(const Doodle&) = delete;
Doodle& operator=(const Doodle&) = delete;

  ~Doodle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DoodlePtr>
  DoodlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Doodle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Doodle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Doodle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Doodle::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Doodle::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Doodle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Doodle_UnserializedMessageContext<
            UserType, Doodle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Doodle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Doodle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Doodle_UnserializedMessageContext<
            UserType, Doodle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Doodle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AllModeImageDoodlePtr image;
  
  InteractiveDoodlePtr interactive;
  
  std::string description;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Doodle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Doodle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Doodle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Doodle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PromoImagePart {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PromoImagePart, T>::value>;
  using DataView = PromoImagePartDataView;
  using Data_ = internal::PromoImagePart_Data;

  template <typename... Args>
  static PromoImagePartPtr New(Args&&... args) {
    return PromoImagePartPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromoImagePartPtr From(const U& u) {
    return mojo::TypeConverter<PromoImagePartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PromoImagePart>::Convert(*this);
  }


  PromoImagePart();

  PromoImagePart(
      const ::GURL& image_url,
      const ::GURL& target);


  ~PromoImagePart();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromoImagePartPtr>
  PromoImagePartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoImagePart::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoImagePart::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PromoImagePart::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PromoImagePart_UnserializedMessageContext<
            UserType, PromoImagePart::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PromoImagePart::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PromoImagePart::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PromoImagePart_UnserializedMessageContext<
            UserType, PromoImagePart::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PromoImagePart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL image_url;
  
  ::GURL target;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PromoImagePart::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PromoLinkPart {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PromoLinkPart, T>::value>;
  using DataView = PromoLinkPartDataView;
  using Data_ = internal::PromoLinkPart_Data;

  template <typename... Args>
  static PromoLinkPartPtr New(Args&&... args) {
    return PromoLinkPartPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromoLinkPartPtr From(const U& u) {
    return mojo::TypeConverter<PromoLinkPartPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PromoLinkPart>::Convert(*this);
  }


  PromoLinkPart();

  PromoLinkPart(
      const std::string& text,
      const ::GURL& url);


  ~PromoLinkPart();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromoLinkPartPtr>
  PromoLinkPartPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoLinkPart::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromoLinkPart::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PromoLinkPart::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PromoLinkPart_UnserializedMessageContext<
            UserType, PromoLinkPart::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PromoLinkPart::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PromoLinkPart::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PromoLinkPart_UnserializedMessageContext<
            UserType, PromoLinkPart::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PromoLinkPart::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  ::GURL url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PromoLinkPart::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  Promo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Promo, T>::value>;
  using DataView = PromoDataView;
  using Data_ = internal::Promo_Data;

  template <typename... Args>
  static PromoPtr New(Args&&... args) {
    return PromoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromoPtr From(const U& u) {
    return mojo::TypeConverter<PromoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Promo>::Convert(*this);
  }


  Promo();

  Promo(
      const std::optional<std::string>& id,
      const std::optional<::GURL>& log_url,
      std::vector<PromoPartPtr> middle_slot_parts);

Promo(const Promo&) = delete;
Promo& operator=(const Promo&) = delete;

  ~Promo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromoPtr>
  PromoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Promo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Promo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Promo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Promo_UnserializedMessageContext<
            UserType, Promo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Promo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Promo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Promo_UnserializedMessageContext<
            UserType, Promo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Promo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> id;
  
  std::optional<::GURL> log_url;
  
  std::vector<PromoPartPtr> middle_slot_parts;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
PromoPartPtr PromoPart::Clone() const {
  switch (tag_) {
    case Tag::kImage:
      return NewImage(
          mojo::Clone(data_.image));
    case Tag::kLink:
      return NewLink(
          mojo::Clone(data_.link));
    case Tag::kText:
      return NewText(
          mojo::Clone(data_.text));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, PromoPart>::value>::type*>
bool PromoPart::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kImage:
      return mojo::Equals(data_.image, other.data_.image);
    case Tag::kLink:
      return mojo::Equals(data_.link, other.data_.link);
    case Tag::kText:
      return mojo::Equals(data_.text, other.data_.text);
  }

  return false;
}
template <typename StructPtrType>
BackgroundImagePtr BackgroundImage::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(url_2x),
      mojo::Clone(attribution_url),
      mojo::Clone(size),
      mojo::Clone(repeat_x),
      mojo::Clone(repeat_y),
      mojo::Clone(position_x),
      mojo::Clone(position_y),
      mojo::Clone(image_source)
  );
}

template <typename T, BackgroundImage::EnableIfSame<T>*>
bool BackgroundImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->url_2x, other_struct.url_2x))
    return false;
  if (!mojo::Equals(this->attribution_url, other_struct.attribution_url))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->repeat_x, other_struct.repeat_x))
    return false;
  if (!mojo::Equals(this->repeat_y, other_struct.repeat_y))
    return false;
  if (!mojo::Equals(this->position_x, other_struct.position_x))
    return false;
  if (!mojo::Equals(this->position_y, other_struct.position_y))
    return false;
  if (!mojo::Equals(this->image_source, other_struct.image_source))
    return false;
  return true;
}

template <typename T, BackgroundImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.url_2x < rhs.url_2x)
    return true;
  if (rhs.url_2x < lhs.url_2x)
    return false;
  if (lhs.attribution_url < rhs.attribution_url)
    return true;
  if (rhs.attribution_url < lhs.attribution_url)
    return false;
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.repeat_x < rhs.repeat_x)
    return true;
  if (rhs.repeat_x < lhs.repeat_x)
    return false;
  if (lhs.repeat_y < rhs.repeat_y)
    return true;
  if (rhs.repeat_y < lhs.repeat_y)
    return false;
  if (lhs.position_x < rhs.position_x)
    return true;
  if (rhs.position_x < lhs.position_x)
    return false;
  if (lhs.position_y < rhs.position_y)
    return true;
  if (rhs.position_y < lhs.position_y)
    return false;
  if (lhs.image_source < rhs.image_source)
    return true;
  if (rhs.image_source < lhs.image_source)
    return false;
  return false;
}
template <typename StructPtrType>
ThemePtr Theme::Clone() const {
  return New(
      mojo::Clone(text_color),
      mojo::Clone(background_color),
      mojo::Clone(is_baseline),
      mojo::Clone(is_custom_background),
      mojo::Clone(daily_refresh_enabled),
      mojo::Clone(is_dark),
      mojo::Clone(logo_color),
      mojo::Clone(background_image_collection_id),
      mojo::Clone(background_image),
      mojo::Clone(background_image_attribution_1),
      mojo::Clone(background_image_attribution_2),
      mojo::Clone(background_image_attribution_url),
      mojo::Clone(most_visited)
  );
}

template <typename T, Theme::EnableIfSame<T>*>
bool Theme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text_color, other_struct.text_color))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->is_baseline, other_struct.is_baseline))
    return false;
  if (!mojo::Equals(this->is_custom_background, other_struct.is_custom_background))
    return false;
  if (!mojo::Equals(this->daily_refresh_enabled, other_struct.daily_refresh_enabled))
    return false;
  if (!mojo::Equals(this->is_dark, other_struct.is_dark))
    return false;
  if (!mojo::Equals(this->logo_color, other_struct.logo_color))
    return false;
  if (!mojo::Equals(this->background_image_collection_id, other_struct.background_image_collection_id))
    return false;
  if (!mojo::Equals(this->background_image, other_struct.background_image))
    return false;
  if (!mojo::Equals(this->background_image_attribution_1, other_struct.background_image_attribution_1))
    return false;
  if (!mojo::Equals(this->background_image_attribution_2, other_struct.background_image_attribution_2))
    return false;
  if (!mojo::Equals(this->background_image_attribution_url, other_struct.background_image_attribution_url))
    return false;
  if (!mojo::Equals(this->most_visited, other_struct.most_visited))
    return false;
  return true;
}

template <typename T, Theme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text_color < rhs.text_color)
    return true;
  if (rhs.text_color < lhs.text_color)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.is_baseline < rhs.is_baseline)
    return true;
  if (rhs.is_baseline < lhs.is_baseline)
    return false;
  if (lhs.is_custom_background < rhs.is_custom_background)
    return true;
  if (rhs.is_custom_background < lhs.is_custom_background)
    return false;
  if (lhs.daily_refresh_enabled < rhs.daily_refresh_enabled)
    return true;
  if (rhs.daily_refresh_enabled < lhs.daily_refresh_enabled)
    return false;
  if (lhs.is_dark < rhs.is_dark)
    return true;
  if (rhs.is_dark < lhs.is_dark)
    return false;
  if (lhs.logo_color < rhs.logo_color)
    return true;
  if (rhs.logo_color < lhs.logo_color)
    return false;
  if (lhs.background_image_collection_id < rhs.background_image_collection_id)
    return true;
  if (rhs.background_image_collection_id < lhs.background_image_collection_id)
    return false;
  if (lhs.background_image < rhs.background_image)
    return true;
  if (rhs.background_image < lhs.background_image)
    return false;
  if (lhs.background_image_attribution_1 < rhs.background_image_attribution_1)
    return true;
  if (rhs.background_image_attribution_1 < lhs.background_image_attribution_1)
    return false;
  if (lhs.background_image_attribution_2 < rhs.background_image_attribution_2)
    return true;
  if (rhs.background_image_attribution_2 < lhs.background_image_attribution_2)
    return false;
  if (lhs.background_image_attribution_url < rhs.background_image_attribution_url)
    return true;
  if (rhs.background_image_attribution_url < lhs.background_image_attribution_url)
    return false;
  if (lhs.most_visited < rhs.most_visited)
    return true;
  if (rhs.most_visited < lhs.most_visited)
    return false;
  return false;
}
template <typename StructPtrType>
ImageDoodlePtr ImageDoodle::Clone() const {
  return New(
      mojo::Clone(image_url),
      mojo::Clone(animation_url),
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(background_color),
      mojo::Clone(image_impression_log_url),
      mojo::Clone(animation_impression_log_url)
  );
}

template <typename T, ImageDoodle::EnableIfSame<T>*>
bool ImageDoodle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->animation_url, other_struct.animation_url))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->image_impression_log_url, other_struct.image_impression_log_url))
    return false;
  if (!mojo::Equals(this->animation_impression_log_url, other_struct.animation_impression_log_url))
    return false;
  return true;
}

template <typename T, ImageDoodle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.animation_url < rhs.animation_url)
    return true;
  if (rhs.animation_url < lhs.animation_url)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.image_impression_log_url < rhs.image_impression_log_url)
    return true;
  if (rhs.image_impression_log_url < lhs.image_impression_log_url)
    return false;
  if (lhs.animation_impression_log_url < rhs.animation_impression_log_url)
    return true;
  if (rhs.animation_impression_log_url < lhs.animation_impression_log_url)
    return false;
  return false;
}
template <typename StructPtrType>
AllModeImageDoodlePtr AllModeImageDoodle::Clone() const {
  return New(
      mojo::Clone(light),
      mojo::Clone(dark),
      mojo::Clone(on_click_url),
      mojo::Clone(share_url)
  );
}

template <typename T, AllModeImageDoodle::EnableIfSame<T>*>
bool AllModeImageDoodle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->light, other_struct.light))
    return false;
  if (!mojo::Equals(this->dark, other_struct.dark))
    return false;
  if (!mojo::Equals(this->on_click_url, other_struct.on_click_url))
    return false;
  if (!mojo::Equals(this->share_url, other_struct.share_url))
    return false;
  return true;
}

template <typename T, AllModeImageDoodle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.light < rhs.light)
    return true;
  if (rhs.light < lhs.light)
    return false;
  if (lhs.dark < rhs.dark)
    return true;
  if (rhs.dark < lhs.dark)
    return false;
  if (lhs.on_click_url < rhs.on_click_url)
    return true;
  if (rhs.on_click_url < lhs.on_click_url)
    return false;
  if (lhs.share_url < rhs.share_url)
    return true;
  if (rhs.share_url < lhs.share_url)
    return false;
  return false;
}
template <typename StructPtrType>
InteractiveDoodlePtr InteractiveDoodle::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(width),
      mojo::Clone(height)
  );
}

template <typename T, InteractiveDoodle::EnableIfSame<T>*>
bool InteractiveDoodle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  return true;
}

template <typename T, InteractiveDoodle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.width < rhs.width)
    return true;
  if (rhs.width < lhs.width)
    return false;
  if (lhs.height < rhs.height)
    return true;
  if (rhs.height < lhs.height)
    return false;
  return false;
}
template <typename StructPtrType>
DoodlePtr Doodle::Clone() const {
  return New(
      mojo::Clone(image),
      mojo::Clone(interactive),
      mojo::Clone(description)
  );
}

template <typename T, Doodle::EnableIfSame<T>*>
bool Doodle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image, other_struct.image))
    return false;
  if (!mojo::Equals(this->interactive, other_struct.interactive))
    return false;
  if (!mojo::Equals(this->description, other_struct.description))
    return false;
  return true;
}

template <typename T, Doodle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image < rhs.image)
    return true;
  if (rhs.image < lhs.image)
    return false;
  if (lhs.interactive < rhs.interactive)
    return true;
  if (rhs.interactive < lhs.interactive)
    return false;
  if (lhs.description < rhs.description)
    return true;
  if (rhs.description < lhs.description)
    return false;
  return false;
}
template <typename StructPtrType>
PromoImagePartPtr PromoImagePart::Clone() const {
  return New(
      mojo::Clone(image_url),
      mojo::Clone(target)
  );
}

template <typename T, PromoImagePart::EnableIfSame<T>*>
bool PromoImagePart::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->image_url, other_struct.image_url))
    return false;
  if (!mojo::Equals(this->target, other_struct.target))
    return false;
  return true;
}

template <typename T, PromoImagePart::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.image_url < rhs.image_url)
    return true;
  if (rhs.image_url < lhs.image_url)
    return false;
  if (lhs.target < rhs.target)
    return true;
  if (rhs.target < lhs.target)
    return false;
  return false;
}
template <typename StructPtrType>
PromoLinkPartPtr PromoLinkPart::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(url)
  );
}

template <typename T, PromoLinkPart::EnableIfSame<T>*>
bool PromoLinkPart::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, PromoLinkPart::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}
template <typename StructPtrType>
PromoTextPartPtr PromoTextPart::Clone() const {
  return New(
      mojo::Clone(text)
  );
}

template <typename T, PromoTextPart::EnableIfSame<T>*>
bool PromoTextPart::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  return true;
}

template <typename T, PromoTextPart::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  return false;
}
template <typename StructPtrType>
PromoPtr Promo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(log_url),
      mojo::Clone(middle_slot_parts)
  );
}

template <typename T, Promo::EnableIfSame<T>*>
bool Promo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->log_url, other_struct.log_url))
    return false;
  if (!mojo::Equals(this->middle_slot_parts, other_struct.middle_slot_parts))
    return false;
  return true;
}

template <typename T, Promo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.log_url < rhs.log_url)
    return true;
  if (rhs.log_url < lhs.log_url)
    return false;
  if (lhs.middle_slot_parts < rhs.middle_slot_parts)
    return true;
  if (rhs.middle_slot_parts < lhs.middle_slot_parts)
    return false;
  return false;
}
template <typename StructPtrType>
ModuleIdNamePtr ModuleIdName::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name)
  );
}

template <typename T, ModuleIdName::EnableIfSame<T>*>
bool ModuleIdName::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  return true;
}

template <typename T, ModuleIdName::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  return false;
}


}  // new_tab_page::mojom

namespace mojo {


template <>
struct  StructTraits<::new_tab_page::mojom::BackgroundImage::DataView,
                                         ::new_tab_page::mojom::BackgroundImagePtr> {
  static bool IsNull(const ::new_tab_page::mojom::BackgroundImagePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::BackgroundImagePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::BackgroundImage::url)& url(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->url;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::url_2x)& url_2x(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->url_2x;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::attribution_url)& attribution_url(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->attribution_url;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::size)& size(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->size;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::repeat_x)& repeat_x(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->repeat_x;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::repeat_y)& repeat_y(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->repeat_y;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::position_x)& position_x(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->position_x;
  }

  static const decltype(::new_tab_page::mojom::BackgroundImage::position_y)& position_y(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->position_y;
  }

  static decltype(::new_tab_page::mojom::BackgroundImage::image_source) image_source(
      const ::new_tab_page::mojom::BackgroundImagePtr& input) {
    return input->image_source;
  }

  static bool Read(::new_tab_page::mojom::BackgroundImage::DataView input, ::new_tab_page::mojom::BackgroundImagePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::Theme::DataView,
                                         ::new_tab_page::mojom::ThemePtr> {
  static bool IsNull(const ::new_tab_page::mojom::ThemePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::ThemePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::Theme::text_color)& text_color(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->text_color;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_color)& background_color(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_color;
  }

  static decltype(::new_tab_page::mojom::Theme::is_baseline) is_baseline(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->is_baseline;
  }

  static decltype(::new_tab_page::mojom::Theme::is_custom_background) is_custom_background(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->is_custom_background;
  }

  static decltype(::new_tab_page::mojom::Theme::daily_refresh_enabled) daily_refresh_enabled(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->daily_refresh_enabled;
  }

  static decltype(::new_tab_page::mojom::Theme::is_dark) is_dark(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->is_dark;
  }

  static const decltype(::new_tab_page::mojom::Theme::logo_color)& logo_color(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->logo_color;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_image_collection_id)& background_image_collection_id(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_image_collection_id;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_image)& background_image(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_image;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_image_attribution_1)& background_image_attribution_1(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_image_attribution_1;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_image_attribution_2)& background_image_attribution_2(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_image_attribution_2;
  }

  static const decltype(::new_tab_page::mojom::Theme::background_image_attribution_url)& background_image_attribution_url(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->background_image_attribution_url;
  }

  static const decltype(::new_tab_page::mojom::Theme::most_visited)& most_visited(
      const ::new_tab_page::mojom::ThemePtr& input) {
    return input->most_visited;
  }

  static bool Read(::new_tab_page::mojom::Theme::DataView input, ::new_tab_page::mojom::ThemePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::ImageDoodle::DataView,
                                         ::new_tab_page::mojom::ImageDoodlePtr> {
  static bool IsNull(const ::new_tab_page::mojom::ImageDoodlePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::ImageDoodlePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::ImageDoodle::image_url)& image_url(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->image_url;
  }

  static const decltype(::new_tab_page::mojom::ImageDoodle::animation_url)& animation_url(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->animation_url;
  }

  static decltype(::new_tab_page::mojom::ImageDoodle::width) width(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->width;
  }

  static decltype(::new_tab_page::mojom::ImageDoodle::height) height(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->height;
  }

  static const decltype(::new_tab_page::mojom::ImageDoodle::background_color)& background_color(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->background_color;
  }

  static const decltype(::new_tab_page::mojom::ImageDoodle::image_impression_log_url)& image_impression_log_url(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->image_impression_log_url;
  }

  static const decltype(::new_tab_page::mojom::ImageDoodle::animation_impression_log_url)& animation_impression_log_url(
      const ::new_tab_page::mojom::ImageDoodlePtr& input) {
    return input->animation_impression_log_url;
  }

  static bool Read(::new_tab_page::mojom::ImageDoodle::DataView input, ::new_tab_page::mojom::ImageDoodlePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::AllModeImageDoodle::DataView,
                                         ::new_tab_page::mojom::AllModeImageDoodlePtr> {
  static bool IsNull(const ::new_tab_page::mojom::AllModeImageDoodlePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::AllModeImageDoodlePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::AllModeImageDoodle::light)& light(
      const ::new_tab_page::mojom::AllModeImageDoodlePtr& input) {
    return input->light;
  }

  static const decltype(::new_tab_page::mojom::AllModeImageDoodle::dark)& dark(
      const ::new_tab_page::mojom::AllModeImageDoodlePtr& input) {
    return input->dark;
  }

  static const decltype(::new_tab_page::mojom::AllModeImageDoodle::on_click_url)& on_click_url(
      const ::new_tab_page::mojom::AllModeImageDoodlePtr& input) {
    return input->on_click_url;
  }

  static const decltype(::new_tab_page::mojom::AllModeImageDoodle::share_url)& share_url(
      const ::new_tab_page::mojom::AllModeImageDoodlePtr& input) {
    return input->share_url;
  }

  static bool Read(::new_tab_page::mojom::AllModeImageDoodle::DataView input, ::new_tab_page::mojom::AllModeImageDoodlePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::InteractiveDoodle::DataView,
                                         ::new_tab_page::mojom::InteractiveDoodlePtr> {
  static bool IsNull(const ::new_tab_page::mojom::InteractiveDoodlePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::InteractiveDoodlePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::InteractiveDoodle::url)& url(
      const ::new_tab_page::mojom::InteractiveDoodlePtr& input) {
    return input->url;
  }

  static decltype(::new_tab_page::mojom::InteractiveDoodle::width) width(
      const ::new_tab_page::mojom::InteractiveDoodlePtr& input) {
    return input->width;
  }

  static decltype(::new_tab_page::mojom::InteractiveDoodle::height) height(
      const ::new_tab_page::mojom::InteractiveDoodlePtr& input) {
    return input->height;
  }

  static bool Read(::new_tab_page::mojom::InteractiveDoodle::DataView input, ::new_tab_page::mojom::InteractiveDoodlePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::Doodle::DataView,
                                         ::new_tab_page::mojom::DoodlePtr> {
  static bool IsNull(const ::new_tab_page::mojom::DoodlePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::DoodlePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::Doodle::image)& image(
      const ::new_tab_page::mojom::DoodlePtr& input) {
    return input->image;
  }

  static const decltype(::new_tab_page::mojom::Doodle::interactive)& interactive(
      const ::new_tab_page::mojom::DoodlePtr& input) {
    return input->interactive;
  }

  static const decltype(::new_tab_page::mojom::Doodle::description)& description(
      const ::new_tab_page::mojom::DoodlePtr& input) {
    return input->description;
  }

  static bool Read(::new_tab_page::mojom::Doodle::DataView input, ::new_tab_page::mojom::DoodlePtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::PromoImagePart::DataView,
                                         ::new_tab_page::mojom::PromoImagePartPtr> {
  static bool IsNull(const ::new_tab_page::mojom::PromoImagePartPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::PromoImagePartPtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::PromoImagePart::image_url)& image_url(
      const ::new_tab_page::mojom::PromoImagePartPtr& input) {
    return input->image_url;
  }

  static const decltype(::new_tab_page::mojom::PromoImagePart::target)& target(
      const ::new_tab_page::mojom::PromoImagePartPtr& input) {
    return input->target;
  }

  static bool Read(::new_tab_page::mojom::PromoImagePart::DataView input, ::new_tab_page::mojom::PromoImagePartPtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::PromoLinkPart::DataView,
                                         ::new_tab_page::mojom::PromoLinkPartPtr> {
  static bool IsNull(const ::new_tab_page::mojom::PromoLinkPartPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::PromoLinkPartPtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::PromoLinkPart::text)& text(
      const ::new_tab_page::mojom::PromoLinkPartPtr& input) {
    return input->text;
  }

  static const decltype(::new_tab_page::mojom::PromoLinkPart::url)& url(
      const ::new_tab_page::mojom::PromoLinkPartPtr& input) {
    return input->url;
  }

  static bool Read(::new_tab_page::mojom::PromoLinkPart::DataView input, ::new_tab_page::mojom::PromoLinkPartPtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::PromoTextPart::DataView,
                                         ::new_tab_page::mojom::PromoTextPartPtr> {
  static bool IsNull(const ::new_tab_page::mojom::PromoTextPartPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::PromoTextPartPtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::PromoTextPart::text)& text(
      const ::new_tab_page::mojom::PromoTextPartPtr& input) {
    return input->text;
  }

  static bool Read(::new_tab_page::mojom::PromoTextPart::DataView input, ::new_tab_page::mojom::PromoTextPartPtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::Promo::DataView,
                                         ::new_tab_page::mojom::PromoPtr> {
  static bool IsNull(const ::new_tab_page::mojom::PromoPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::PromoPtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::Promo::id)& id(
      const ::new_tab_page::mojom::PromoPtr& input) {
    return input->id;
  }

  static const decltype(::new_tab_page::mojom::Promo::log_url)& log_url(
      const ::new_tab_page::mojom::PromoPtr& input) {
    return input->log_url;
  }

  static const decltype(::new_tab_page::mojom::Promo::middle_slot_parts)& middle_slot_parts(
      const ::new_tab_page::mojom::PromoPtr& input) {
    return input->middle_slot_parts;
  }

  static bool Read(::new_tab_page::mojom::Promo::DataView input, ::new_tab_page::mojom::PromoPtr* output);
};


template <>
struct  StructTraits<::new_tab_page::mojom::ModuleIdName::DataView,
                                         ::new_tab_page::mojom::ModuleIdNamePtr> {
  static bool IsNull(const ::new_tab_page::mojom::ModuleIdNamePtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::ModuleIdNamePtr* output) { output->reset(); }

  static const decltype(::new_tab_page::mojom::ModuleIdName::id)& id(
      const ::new_tab_page::mojom::ModuleIdNamePtr& input) {
    return input->id;
  }

  static const decltype(::new_tab_page::mojom::ModuleIdName::name)& name(
      const ::new_tab_page::mojom::ModuleIdNamePtr& input) {
    return input->name;
  }

  static bool Read(::new_tab_page::mojom::ModuleIdName::DataView input, ::new_tab_page::mojom::ModuleIdNamePtr* output);
};


template <>
struct  UnionTraits<::new_tab_page::mojom::PromoPart::DataView,
                                        ::new_tab_page::mojom::PromoPartPtr> {
  static bool IsNull(const ::new_tab_page::mojom::PromoPartPtr& input) { return !input; }
  static void SetToNull(::new_tab_page::mojom::PromoPartPtr* output) { output->reset(); }

  static ::new_tab_page::mojom::PromoPart::Tag GetTag(const ::new_tab_page::mojom::PromoPartPtr& input) {
    return input->which();
  }

  static const ::new_tab_page::mojom::PromoImagePartPtr& image(const ::new_tab_page::mojom::PromoPartPtr& input) {
    return input->get_image();
  }

  static const ::new_tab_page::mojom::PromoLinkPartPtr& link(const ::new_tab_page::mojom::PromoPartPtr& input) {
    return input->get_link();
  }

  static const ::new_tab_page::mojom::PromoTextPartPtr& text(const ::new_tab_page::mojom::PromoPartPtr& input) {
    return input->get_text();
  }

  static bool Read(::new_tab_page::mojom::PromoPart::DataView input, ::new_tab_page::mojom::PromoPartPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_H_