// chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_type.mojom-shared.h"
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_shared_ui.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/new_tab_page/new_tab_page.mojom-data-view.h"




namespace std {

template <>
struct hash<::new_tab_page::mojom::NtpBackgroundImageSource>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::NtpBackgroundImageSource> {};

template <>
struct hash<::new_tab_page::mojom::IphFeature>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::IphFeature> {};

template <>
struct hash<::new_tab_page::mojom::DoodleImageType>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::DoodleImageType> {};

template <>
struct hash<::new_tab_page::mojom::DoodleShareChannel>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::DoodleShareChannel> {};

template <>
struct hash<::new_tab_page::mojom::CustomizeDialogAction>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::CustomizeDialogAction> {};

template <>
struct hash<::new_tab_page::mojom::OptInStatus>
    : public mojo::internal::EnumHashImpl<::new_tab_page::mojom::OptInStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::NtpBackgroundImageSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::NtpBackgroundImageSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::NtpBackgroundImageSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::IphFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::IphFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::IphFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::DoodleImageType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::DoodleImageType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::DoodleImageType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::DoodleShareChannel, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::DoodleShareChannel, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::DoodleShareChannel>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::CustomizeDialogAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::CustomizeDialogAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::CustomizeDialogAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::OptInStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::new_tab_page::mojom::OptInStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::new_tab_page::mojom::OptInStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::BackgroundImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::BackgroundImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::BackgroundImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BackgroundImage struct");

    decltype(Traits::url_2x(input)) in_url_2x = Traits::url_2x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_2x)::BaseType> url_2x_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url_2x,
      url_2x_fragment);

    fragment->url_2x.Set(
        url_2x_fragment.is_null() ? nullptr : url_2x_fragment.data());

    decltype(Traits::attribution_url(input)) in_attribution_url = Traits::attribution_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution_url)::BaseType> attribution_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_attribution_url,
      attribution_url_fragment);

    fragment->attribution_url.Set(
        attribution_url_fragment.is_null() ? nullptr : attribution_url_fragment.data());

    decltype(Traits::size(input)) in_size = Traits::size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size)::BaseType> size_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_size,
      size_fragment);

    fragment->size.Set(
        size_fragment.is_null() ? nullptr : size_fragment.data());

    decltype(Traits::repeat_x(input)) in_repeat_x = Traits::repeat_x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->repeat_x)::BaseType> repeat_x_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_repeat_x,
      repeat_x_fragment);

    fragment->repeat_x.Set(
        repeat_x_fragment.is_null() ? nullptr : repeat_x_fragment.data());

    decltype(Traits::repeat_y(input)) in_repeat_y = Traits::repeat_y(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->repeat_y)::BaseType> repeat_y_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_repeat_y,
      repeat_y_fragment);

    fragment->repeat_y.Set(
        repeat_y_fragment.is_null() ? nullptr : repeat_y_fragment.data());

    decltype(Traits::position_x(input)) in_position_x = Traits::position_x(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position_x)::BaseType> position_x_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_position_x,
      position_x_fragment);

    fragment->position_x.Set(
        position_x_fragment.is_null() ? nullptr : position_x_fragment.data());

    decltype(Traits::position_y(input)) in_position_y = Traits::position_y(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position_y)::BaseType> position_y_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_position_y,
      position_y_fragment);

    fragment->position_y.Set(
        position_y_fragment.is_null() ? nullptr : position_y_fragment.data());

    
    mojo::internal::Serialize<::new_tab_page::mojom::NtpBackgroundImageSource>(
      Traits::image_source(input),
      &fragment->image_source);
  }

  static bool Deserialize(::new_tab_page::mojom::internal::BackgroundImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::BackgroundImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::ThemeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::ThemeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::Theme_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text_color(input)) in_text_color = Traits::text_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text_color)::BaseType> text_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_text_color,
      text_color_fragment);

    fragment->text_color.Set(
        text_color_fragment.is_null() ? nullptr : text_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text_color in Theme struct");

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in Theme struct");

    fragment->is_baseline = Traits::is_baseline(input);

    fragment->is_custom_background = Traits::is_custom_background(input);

    fragment->daily_refresh_enabled = Traits::daily_refresh_enabled(input);

    fragment->is_dark = Traits::is_dark(input);

    decltype(Traits::logo_color(input)) in_logo_color = Traits::logo_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->logo_color)::BaseType> logo_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_logo_color,
      logo_color_fragment);

    fragment->logo_color.Set(
        logo_color_fragment.is_null() ? nullptr : logo_color_fragment.data());

    decltype(Traits::background_image_collection_id(input)) in_background_image_collection_id = Traits::background_image_collection_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_collection_id)::BaseType> background_image_collection_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_background_image_collection_id,
      background_image_collection_id_fragment);

    fragment->background_image_collection_id.Set(
        background_image_collection_id_fragment.is_null() ? nullptr : background_image_collection_id_fragment.data());

    decltype(Traits::background_image(input)) in_background_image = Traits::background_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image)::BaseType> background_image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::new_tab_page::mojom::BackgroundImageDataView>(
      in_background_image,
      background_image_fragment);

    fragment->background_image.Set(
        background_image_fragment.is_null() ? nullptr : background_image_fragment.data());

    decltype(Traits::background_image_attribution_1(input)) in_background_image_attribution_1 = Traits::background_image_attribution_1(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_attribution_1)::BaseType> background_image_attribution_1_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_background_image_attribution_1,
      background_image_attribution_1_fragment);

    fragment->background_image_attribution_1.Set(
        background_image_attribution_1_fragment.is_null() ? nullptr : background_image_attribution_1_fragment.data());

    decltype(Traits::background_image_attribution_2(input)) in_background_image_attribution_2 = Traits::background_image_attribution_2(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_attribution_2)::BaseType> background_image_attribution_2_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_background_image_attribution_2,
      background_image_attribution_2_fragment);

    fragment->background_image_attribution_2.Set(
        background_image_attribution_2_fragment.is_null() ? nullptr : background_image_attribution_2_fragment.data());

    decltype(Traits::background_image_attribution_url(input)) in_background_image_attribution_url = Traits::background_image_attribution_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_image_attribution_url)::BaseType> background_image_attribution_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_background_image_attribution_url,
      background_image_attribution_url_fragment);

    fragment->background_image_attribution_url.Set(
        background_image_attribution_url_fragment.is_null() ? nullptr : background_image_attribution_url_fragment.data());

    decltype(Traits::most_visited(input)) in_most_visited = Traits::most_visited(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->most_visited)::BaseType> most_visited_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::most_visited::mojom::MostVisitedThemeDataView>(
      in_most_visited,
      most_visited_fragment);

    fragment->most_visited.Set(
        most_visited_fragment.is_null() ? nullptr : most_visited_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->most_visited.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null most_visited in Theme struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::Theme_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::ThemeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::ImageDoodleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::ImageDoodleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::ImageDoodle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_url in ImageDoodle struct");

    decltype(Traits::animation_url(input)) in_animation_url = Traits::animation_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->animation_url)::BaseType> animation_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_animation_url,
      animation_url_fragment);

    fragment->animation_url.Set(
        animation_url_fragment.is_null() ? nullptr : animation_url_fragment.data());

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);

    decltype(Traits::background_color(input)) in_background_color = Traits::background_color(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->background_color)::BaseType> background_color_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
      in_background_color,
      background_color_fragment);

    fragment->background_color.Set(
        background_color_fragment.is_null() ? nullptr : background_color_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->background_color.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null background_color in ImageDoodle struct");

    decltype(Traits::image_impression_log_url(input)) in_image_impression_log_url = Traits::image_impression_log_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_impression_log_url)::BaseType> image_impression_log_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_impression_log_url,
      image_impression_log_url_fragment);

    fragment->image_impression_log_url.Set(
        image_impression_log_url_fragment.is_null() ? nullptr : image_impression_log_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_impression_log_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_impression_log_url in ImageDoodle struct");

    decltype(Traits::animation_impression_log_url(input)) in_animation_impression_log_url = Traits::animation_impression_log_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->animation_impression_log_url)::BaseType> animation_impression_log_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_animation_impression_log_url,
      animation_impression_log_url_fragment);

    fragment->animation_impression_log_url.Set(
        animation_impression_log_url_fragment.is_null() ? nullptr : animation_impression_log_url_fragment.data());
  }

  static bool Deserialize(::new_tab_page::mojom::internal::ImageDoodle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::ImageDoodleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::AllModeImageDoodleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::AllModeImageDoodleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::AllModeImageDoodle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::light(input)) in_light = Traits::light(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->light)::BaseType> light_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::new_tab_page::mojom::ImageDoodleDataView>(
      in_light,
      light_fragment);

    fragment->light.Set(
        light_fragment.is_null() ? nullptr : light_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->light.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null light in AllModeImageDoodle struct");

    decltype(Traits::dark(input)) in_dark = Traits::dark(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dark)::BaseType> dark_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::new_tab_page::mojom::ImageDoodleDataView>(
      in_dark,
      dark_fragment);

    fragment->dark.Set(
        dark_fragment.is_null() ? nullptr : dark_fragment.data());

    decltype(Traits::on_click_url(input)) in_on_click_url = Traits::on_click_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->on_click_url)::BaseType> on_click_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_on_click_url,
      on_click_url_fragment);

    fragment->on_click_url.Set(
        on_click_url_fragment.is_null() ? nullptr : on_click_url_fragment.data());

    decltype(Traits::share_url(input)) in_share_url = Traits::share_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->share_url)::BaseType> share_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_share_url,
      share_url_fragment);

    fragment->share_url.Set(
        share_url_fragment.is_null() ? nullptr : share_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->share_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null share_url in AllModeImageDoodle struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::AllModeImageDoodle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::AllModeImageDoodleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::InteractiveDoodleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::InteractiveDoodleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::InteractiveDoodle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in InteractiveDoodle struct");

    fragment->width = Traits::width(input);

    fragment->height = Traits::height(input);
  }

  static bool Deserialize(::new_tab_page::mojom::internal::InteractiveDoodle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::InteractiveDoodleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::DoodleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::DoodleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::Doodle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::new_tab_page::mojom::AllModeImageDoodleDataView>(
      in_image,
      image_fragment);

    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());

    decltype(Traits::interactive(input)) in_interactive = Traits::interactive(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->interactive)::BaseType> interactive_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::new_tab_page::mojom::InteractiveDoodleDataView>(
      in_interactive,
      interactive_fragment);

    fragment->interactive.Set(
        interactive_fragment.is_null() ? nullptr : interactive_fragment.data());

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in Doodle struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::Doodle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::DoodleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::PromoImagePartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::PromoImagePartDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::PromoImagePart_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image_url in PromoImagePart struct");

    decltype(Traits::target(input)) in_target = Traits::target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target)::BaseType> target_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_target,
      target_fragment);

    fragment->target.Set(
        target_fragment.is_null() ? nullptr : target_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target in PromoImagePart struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::PromoImagePart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::PromoImagePartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::PromoLinkPartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::PromoLinkPartDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::PromoLinkPart_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in PromoLinkPart struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in PromoLinkPart struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::PromoLinkPart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::PromoLinkPartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::PromoTextPartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::PromoTextPartDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::PromoTextPart_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in PromoTextPart struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::PromoTextPart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::PromoTextPartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::PromoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::PromoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::Promo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    decltype(Traits::log_url(input)) in_log_url = Traits::log_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->log_url)::BaseType> log_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_log_url,
      log_url_fragment);

    fragment->log_url.Set(
        log_url_fragment.is_null() ? nullptr : log_url_fragment.data());

    decltype(Traits::middle_slot_parts(input)) in_middle_slot_parts = Traits::middle_slot_parts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->middle_slot_parts)::BaseType>
        middle_slot_parts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& middle_slot_parts_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::new_tab_page::mojom::PromoPartDataView>>(
      in_middle_slot_parts,
      middle_slot_parts_fragment,
      &middle_slot_parts_validate_params);

    fragment->middle_slot_parts.Set(
        middle_slot_parts_fragment.is_null() ? nullptr : middle_slot_parts_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->middle_slot_parts.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null middle_slot_parts in Promo struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::Promo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::PromoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::ModuleIdNameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::new_tab_page::mojom::ModuleIdNameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::new_tab_page::mojom::internal::ModuleIdName_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in ModuleIdName struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ModuleIdName struct");
  }

  static bool Deserialize(::new_tab_page::mojom::internal::ModuleIdName_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::ModuleIdNameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::new_tab_page::mojom::PromoPartDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::new_tab_page::mojom::PromoPartDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::new_tab_page::mojom::internal::PromoPart_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::new_tab_page::mojom::PromoPartDataView::Tag::kImage: {
    decltype(Traits::image(input))
    in_image = Traits::image(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_image)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::new_tab_page::mojom::PromoImagePartDataView>(
  in_image,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null image in PromoPart union");
    fragment->data.f_image.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::new_tab_page::mojom::PromoPartDataView::Tag::kLink: {
    decltype(Traits::link(input))
    in_link = Traits::link(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_link)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::new_tab_page::mojom::PromoLinkPartDataView>(
  in_link,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null link in PromoPart union");
    fragment->data.f_link.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::new_tab_page::mojom::PromoPartDataView::Tag::kText: {
    decltype(Traits::text(input))
    in_text = Traits::text(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_text)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::new_tab_page::mojom::PromoTextPartDataView>(
  in_text,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null text in PromoPart union");
    fragment->data.f_text.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::new_tab_page::mojom::internal::PromoPart_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::new_tab_page::mojom::PromoPartDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace new_tab_page::mojom {

inline void BackgroundImageDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetUrl2xDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url_2x.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetAttributionUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->attribution_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetSizeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->size.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetRepeatXDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->repeat_x.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetRepeatYDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->repeat_y.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetPositionXDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->position_x.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BackgroundImageDataView::GetPositionYDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->position_y.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ThemeDataView::GetTextColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->text_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetLogoColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->logo_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundImageCollectionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->background_image_collection_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundImageDataView(
    BackgroundImageDataView* output) {
  auto pointer = data_->background_image.Get();
  *output = BackgroundImageDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundImageAttribution1DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->background_image_attribution_1.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundImageAttribution2DataView(
    mojo::StringDataView* output) {
  auto pointer = data_->background_image_attribution_2.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ThemeDataView::GetBackgroundImageAttributionUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->background_image_attribution_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ThemeDataView::GetMostVisitedDataView(
    ::most_visited::mojom::MostVisitedThemeDataView* output) {
  auto pointer = data_->most_visited.Get();
  *output = ::most_visited::mojom::MostVisitedThemeDataView(pointer, message_);
}


inline void ImageDoodleDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImageDoodleDataView::GetAnimationUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->animation_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImageDoodleDataView::GetBackgroundColorDataView(
    ::skia::mojom::SkColorDataView* output) {
  auto pointer = data_->background_color.Get();
  *output = ::skia::mojom::SkColorDataView(pointer, message_);
}
inline void ImageDoodleDataView::GetImageImpressionLogUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_impression_log_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ImageDoodleDataView::GetAnimationImpressionLogUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->animation_impression_log_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void AllModeImageDoodleDataView::GetLightDataView(
    ImageDoodleDataView* output) {
  auto pointer = data_->light.Get();
  *output = ImageDoodleDataView(pointer, message_);
}
inline void AllModeImageDoodleDataView::GetDarkDataView(
    ImageDoodleDataView* output) {
  auto pointer = data_->dark.Get();
  *output = ImageDoodleDataView(pointer, message_);
}
inline void AllModeImageDoodleDataView::GetOnClickUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->on_click_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AllModeImageDoodleDataView::GetShareUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->share_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void InteractiveDoodleDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void DoodleDataView::GetImageDataView(
    AllModeImageDoodleDataView* output) {
  auto pointer = data_->image.Get();
  *output = AllModeImageDoodleDataView(pointer, message_);
}
inline void DoodleDataView::GetInteractiveDataView(
    InteractiveDoodleDataView* output) {
  auto pointer = data_->interactive.Get();
  *output = InteractiveDoodleDataView(pointer, message_);
}
inline void DoodleDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PromoImagePartDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PromoImagePartDataView::GetTargetDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->target.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PromoLinkPartDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PromoLinkPartDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void PromoTextPartDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PromoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PromoDataView::GetLogUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->log_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void PromoDataView::GetMiddleSlotPartsDataView(
    mojo::ArrayDataView<PromoPartDataView>* output) {
  auto pointer = data_->middle_slot_parts.Get();
  *output = mojo::ArrayDataView<PromoPartDataView>(pointer, message_);
}


inline void ModuleIdNameDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ModuleIdNameDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void PromoPartDataView::GetImageDataView(
    PromoImagePartDataView* output) const {
  CHECK(is_image());
  *output = PromoImagePartDataView(data_->data.f_image.Get(), message_);
}
inline void PromoPartDataView::GetLinkDataView(
    PromoLinkPartDataView* output) const {
  CHECK(is_link());
  *output = PromoLinkPartDataView(data_->data.f_link.Get(), message_);
}
inline void PromoPartDataView::GetTextDataView(
    PromoTextPartDataView* output) const {
  CHECK(is_text());
  *output = PromoTextPartDataView(data_->data.f_text.Get(), message_);
}


}  // new_tab_page::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::NtpBackgroundImageSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::NtpBackgroundImageSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::IphFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::IphFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::DoodleImageType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::DoodleImageType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::DoodleShareChannel> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::DoodleShareChannel value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::CustomizeDialogAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::CustomizeDialogAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::new_tab_page::mojom::OptInStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::new_tab_page::mojom::OptInStatus value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NEW_TAB_PAGE_MOJOM_SHARED_H_