// chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_FOOTER_NEW_TAB_FOOTER_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_FOOTER_NEW_TAB_FOOTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_footer/new_tab_footer.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace new_tab_footer::mojom {

class NewTabFooterHandlerFactoryProxy;

template <typename ImplRefTraits>
class NewTabFooterHandlerFactoryStub;

class NewTabFooterHandlerFactoryRequestValidator;


class NewTabFooterHandlerFactory
    : public NewTabFooterHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_footer.mojom.NewTabFooterHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NewTabFooterHandlerFactoryInterfaceBase;
  using Proxy_ = NewTabFooterHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = NewTabFooterHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = NewTabFooterHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateNewTabFooterHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateNewTabFooterHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NewTabFooterHandlerFactory() = default;

  virtual void CreateNewTabFooterHandler(::mojo::PendingRemote<NewTabFooterDocument> document, ::mojo::PendingReceiver<NewTabFooterHandler> handler) = 0;
};

class NewTabFooterHandlerProxy;

template <typename ImplRefTraits>
class NewTabFooterHandlerStub;

class NewTabFooterHandlerRequestValidator;


class NewTabFooterHandler
    : public NewTabFooterHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_footer.mojom.NewTabFooterHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NewTabFooterHandlerInterfaceBase;
  using Proxy_ = NewTabFooterHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NewTabFooterHandlerStub<ImplRefTraits>;

  using RequestValidator_ = NewTabFooterHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateNtpExtensionNameMinVersion = 0,
    kUpdateManagementNoticeMinVersion = 0,
    kUpdateAttachedTabStateMinVersion = 0,
    kUpdateBackgroundAttributionMinVersion = 0,
    kOpenExtensionOptionsPageWithFallbackMinVersion = 0,
    kOpenManagementPageMinVersion = 0,
    kOpenUrlInCurrentTabMinVersion = 0,
    kShowContextMenuMinVersion = 0,
    kNotifyCustomizationButtonVisibleMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateNtpExtensionName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateManagementNotice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateAttachedTabState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateBackgroundAttribution_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenExtensionOptionsPageWithFallback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenManagementPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenUrlInCurrentTab_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenu_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyCustomizationButtonVisible_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NewTabFooterHandler() = default;

  virtual void UpdateNtpExtensionName() = 0;

  virtual void UpdateManagementNotice() = 0;

  virtual void UpdateAttachedTabState() = 0;

  virtual void UpdateBackgroundAttribution() = 0;

  virtual void OpenExtensionOptionsPageWithFallback() = 0;

  virtual void OpenManagementPage() = 0;

  virtual void OpenUrlInCurrentTab(const ::GURL& url) = 0;

  virtual void ShowContextMenu(const ::gfx::Point& point) = 0;

  virtual void NotifyCustomizationButtonVisible() = 0;
};

class NewTabFooterDocumentProxy;

template <typename ImplRefTraits>
class NewTabFooterDocumentStub;

class NewTabFooterDocumentRequestValidator;


class NewTabFooterDocument
    : public NewTabFooterDocumentInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "new_tab_footer.mojom.NewTabFooterDocument";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NewTabFooterDocumentInterfaceBase;
  using Proxy_ = NewTabFooterDocumentProxy;

  template <typename ImplRefTraits>
  using Stub_ = NewTabFooterDocumentStub<ImplRefTraits>;

  using RequestValidator_ = NewTabFooterDocumentRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetNtpExtensionNameMinVersion = 0,
    kSetManagementNoticeMinVersion = 0,
    kAttachedTabStateUpdatedMinVersion = 0,
    kSetBackgroundAttributionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetNtpExtensionName_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetManagementNotice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AttachedTabStateUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundAttribution_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NewTabFooterDocument() = default;

  virtual void SetNtpExtensionName(const std::string& name) = 0;

  virtual void SetManagementNotice(ManagementNoticePtr notice) = 0;

  virtual void AttachedTabStateUpdated(NewTabPageType ntp_type, bool can_customize_chrome) = 0;

  virtual void SetBackgroundAttribution(BackgroundAttributionPtr background_image_attribution) = 0;
};



class  NewTabFooterHandlerFactoryProxy
    : public NewTabFooterHandlerFactory {
 public:
  using InterfaceType = NewTabFooterHandlerFactory;

  explicit NewTabFooterHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateNewTabFooterHandler(::mojo::PendingRemote<NewTabFooterDocument> document, ::mojo::PendingReceiver<NewTabFooterHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NewTabFooterHandlerProxy
    : public NewTabFooterHandler {
 public:
  using InterfaceType = NewTabFooterHandler;

  explicit NewTabFooterHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateNtpExtensionName() final;
  
  void UpdateManagementNotice() final;
  
  void UpdateAttachedTabState() final;
  
  void UpdateBackgroundAttribution() final;
  
  void OpenExtensionOptionsPageWithFallback() final;
  
  void OpenManagementPage() final;
  
  void OpenUrlInCurrentTab(const ::GURL& url) final;
  
  void ShowContextMenu(const ::gfx::Point& point) final;
  
  void NotifyCustomizationButtonVisible() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NewTabFooterDocumentProxy
    : public NewTabFooterDocument {
 public:
  using InterfaceType = NewTabFooterDocument;

  explicit NewTabFooterDocumentProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetNtpExtensionName(const std::string& name) final;
  
  void SetManagementNotice(ManagementNoticePtr notice) final;
  
  void AttachedTabStateUpdated(NewTabPageType ntp_type, bool can_customize_chrome) final;
  
  void SetBackgroundAttribution(BackgroundAttributionPtr background_image_attribution) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NewTabFooterHandlerFactoryStubDispatch {
 public:
  static bool Accept(NewTabFooterHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NewTabFooterHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NewTabFooterHandlerFactory>>
class NewTabFooterHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NewTabFooterHandlerFactoryStub() = default;
  ~NewTabFooterHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NewTabFooterHandlerStubDispatch {
 public:
  static bool Accept(NewTabFooterHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NewTabFooterHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NewTabFooterHandler>>
class NewTabFooterHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NewTabFooterHandlerStub() = default;
  ~NewTabFooterHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NewTabFooterDocumentStubDispatch {
 public:
  static bool Accept(NewTabFooterDocument* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NewTabFooterDocument* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NewTabFooterDocument>>
class NewTabFooterDocumentStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NewTabFooterDocumentStub() = default;
  ~NewTabFooterDocumentStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterDocumentStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NewTabFooterDocumentStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NewTabFooterHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NewTabFooterHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NewTabFooterDocumentRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  ManagementNotice {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ManagementNotice, T>::value>;
  using DataView = ManagementNoticeDataView;
  using Data_ = internal::ManagementNotice_Data;

  template <typename... Args>
  static ManagementNoticePtr New(Args&&... args) {
    return ManagementNoticePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ManagementNoticePtr From(const U& u) {
    return mojo::TypeConverter<ManagementNoticePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ManagementNotice>::Convert(*this);
  }


  ManagementNotice();

  ManagementNotice(
      const std::string& text,
      const std::optional<::GURL>& custom_bitmap_data_url);


  ~ManagementNotice();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ManagementNoticePtr>
  ManagementNoticePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManagementNotice::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ManagementNotice::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ManagementNotice::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ManagementNotice_UnserializedMessageContext<
            UserType, ManagementNotice::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ManagementNotice::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ManagementNotice::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ManagementNotice_UnserializedMessageContext<
            UserType, ManagementNotice::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ManagementNotice::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string text;
  
  std::optional<::GURL> custom_bitmap_data_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ManagementNotice::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  BackgroundAttribution {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BackgroundAttribution, T>::value>;
  using DataView = BackgroundAttributionDataView;
  using Data_ = internal::BackgroundAttribution_Data;

  template <typename... Args>
  static BackgroundAttributionPtr New(Args&&... args) {
    return BackgroundAttributionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BackgroundAttributionPtr From(const U& u) {
    return mojo::TypeConverter<BackgroundAttributionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BackgroundAttribution>::Convert(*this);
  }


  BackgroundAttribution();

  BackgroundAttribution(
      const std::string& name,
      const std::optional<::GURL>& url);


  ~BackgroundAttribution();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BackgroundAttributionPtr>
  BackgroundAttributionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundAttribution::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BackgroundAttribution::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BackgroundAttribution::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BackgroundAttribution_UnserializedMessageContext<
            UserType, BackgroundAttribution::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BackgroundAttribution::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BackgroundAttribution::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BackgroundAttribution_UnserializedMessageContext<
            UserType, BackgroundAttribution::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BackgroundAttribution::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::optional<::GURL> url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BackgroundAttribution::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ManagementNoticePtr ManagementNotice::Clone() const {
  return New(
      mojo::Clone(text),
      mojo::Clone(custom_bitmap_data_url)
  );
}

template <typename T, ManagementNotice::EnableIfSame<T>*>
bool ManagementNotice::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->text, other_struct.text))
    return false;
  if (!mojo::Equals(this->custom_bitmap_data_url, other_struct.custom_bitmap_data_url))
    return false;
  return true;
}

template <typename T, ManagementNotice::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.text < rhs.text)
    return true;
  if (rhs.text < lhs.text)
    return false;
  if (lhs.custom_bitmap_data_url < rhs.custom_bitmap_data_url)
    return true;
  if (rhs.custom_bitmap_data_url < lhs.custom_bitmap_data_url)
    return false;
  return false;
}
template <typename StructPtrType>
BackgroundAttributionPtr BackgroundAttribution::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(url)
  );
}

template <typename T, BackgroundAttribution::EnableIfSame<T>*>
bool BackgroundAttribution::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, BackgroundAttribution::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}


}  // new_tab_footer::mojom

namespace mojo {


template <>
struct  StructTraits<::new_tab_footer::mojom::ManagementNotice::DataView,
                                         ::new_tab_footer::mojom::ManagementNoticePtr> {
  static bool IsNull(const ::new_tab_footer::mojom::ManagementNoticePtr& input) { return !input; }
  static void SetToNull(::new_tab_footer::mojom::ManagementNoticePtr* output) { output->reset(); }

  static const decltype(::new_tab_footer::mojom::ManagementNotice::text)& text(
      const ::new_tab_footer::mojom::ManagementNoticePtr& input) {
    return input->text;
  }

  static const decltype(::new_tab_footer::mojom::ManagementNotice::custom_bitmap_data_url)& custom_bitmap_data_url(
      const ::new_tab_footer::mojom::ManagementNoticePtr& input) {
    return input->custom_bitmap_data_url;
  }

  static bool Read(::new_tab_footer::mojom::ManagementNotice::DataView input, ::new_tab_footer::mojom::ManagementNoticePtr* output);
};


template <>
struct  StructTraits<::new_tab_footer::mojom::BackgroundAttribution::DataView,
                                         ::new_tab_footer::mojom::BackgroundAttributionPtr> {
  static bool IsNull(const ::new_tab_footer::mojom::BackgroundAttributionPtr& input) { return !input; }
  static void SetToNull(::new_tab_footer::mojom::BackgroundAttributionPtr* output) { output->reset(); }

  static const decltype(::new_tab_footer::mojom::BackgroundAttribution::name)& name(
      const ::new_tab_footer::mojom::BackgroundAttributionPtr& input) {
    return input->name;
  }

  static const decltype(::new_tab_footer::mojom::BackgroundAttribution::url)& url(
      const ::new_tab_footer::mojom::BackgroundAttributionPtr& input) {
    return input->url;
  }

  static bool Read(::new_tab_footer::mojom::BackgroundAttribution::DataView input, ::new_tab_footer::mojom::BackgroundAttributionPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_FOOTER_NEW_TAB_FOOTER_MOJOM_H_