// chrome/browser/ui/webui/downloads/downloads.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/downloads/downloads.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-params-data.h"
namespace downloads {
namespace mojom {

NOINLINE static const char* DangerTypeToStringHelper(DangerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DangerType::kNoApplicableDangerType:
      return "kNoApplicableDangerType";
    case DangerType::kDangerousFile:
      return "kDangerousFile";
    case DangerType::kDangerousUrl:
      return "kDangerousUrl";
    case DangerType::kDangerousContent:
      return "kDangerousContent";
    case DangerType::kCookieTheft:
      return "kCookieTheft";
    case DangerType::kUncommonContent:
      return "kUncommonContent";
    case DangerType::kDangerousHost:
      return "kDangerousHost";
    case DangerType::kPotentiallyUnwanted:
      return "kPotentiallyUnwanted";
    case DangerType::kAsyncScanning:
      return "kAsyncScanning";
    case DangerType::kAsyncLocalPasswordScanning:
      return "kAsyncLocalPasswordScanning";
    case DangerType::kBlockedPasswordProtected:
      return "kBlockedPasswordProtected";
    case DangerType::kBlockedTooLarge:
      return "kBlockedTooLarge";
    case DangerType::kSensitiveContentWarning:
      return "kSensitiveContentWarning";
    case DangerType::kSensitiveContentBlock:
      return "kSensitiveContentBlock";
    case DangerType::kDeepScannedFailed:
      return "kDeepScannedFailed";
    case DangerType::kDeepScannedSafe:
      return "kDeepScannedSafe";
    case DangerType::kDeepScannedOpenedDangerous:
      return "kDeepScannedOpenedDangerous";
    case DangerType::kBlockedScanFailed:
      return "kBlockedScanFailed";
    default:
      return nullptr;
  }
}

std::string DangerTypeToString(DangerType value) {
  const char *str = DangerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DangerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DangerType value) {
  return os << DangerTypeToString(value);
}

NOINLINE static const char* TailoredWarningTypeToStringHelper(TailoredWarningType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TailoredWarningType::kNoApplicableTailoredWarningType:
      return "kNoApplicableTailoredWarningType";
    case TailoredWarningType::kCookieTheft:
      return "kCookieTheft";
    case TailoredWarningType::kSuspiciousArchive:
      return "kSuspiciousArchive";
    default:
      return nullptr;
  }
}

std::string TailoredWarningTypeToString(TailoredWarningType value) {
  const char *str = TailoredWarningTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TailoredWarningType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TailoredWarningType value) {
  return os << TailoredWarningTypeToString(value);
}

NOINLINE static const char* StateToStringHelper(State value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case State::kInProgress:
      return "kInProgress";
    case State::kCancelled:
      return "kCancelled";
    case State::kComplete:
      return "kComplete";
    case State::kPaused:
      return "kPaused";
    case State::kDangerous:
      return "kDangerous";
    case State::kInterrupted:
      return "kInterrupted";
    case State::kInsecure:
      return "kInsecure";
    case State::kAsyncScanning:
      return "kAsyncScanning";
    case State::kPromptForScanning:
      return "kPromptForScanning";
    case State::kPromptForLocalPasswordScanning:
      return "kPromptForLocalPasswordScanning";
    default:
      return nullptr;
  }
}

std::string StateToString(State value) {
  const char *str = StateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown State value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, State value) {
  return os << StateToString(value);
}

NOINLINE static const char* SafeBrowsingStateToStringHelper(SafeBrowsingState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SafeBrowsingState::kNoSafeBrowsing:
      return "kNoSafeBrowsing";
    case SafeBrowsingState::kStandardProtection:
      return "kStandardProtection";
    case SafeBrowsingState::kEnhancedProtection:
      return "kEnhancedProtection";
    default:
      return nullptr;
  }
}

std::string SafeBrowsingStateToString(SafeBrowsingState value) {
  const char *str = SafeBrowsingStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SafeBrowsingState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SafeBrowsingState value) {
  return os << SafeBrowsingStateToString(value);
}

namespace internal {


// static
bool Data_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Data_Data* object =
      static_cast<const Data_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->by_ext_id, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& by_ext_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->by_ext_id, validation_context,
                                         &by_ext_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->by_ext_name, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& by_ext_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->by_ext_name, validation_context,
                                         &by_ext_name_validate_params)) {
    return false;
  }


  if (!::downloads::mojom::internal::DangerType_Data
        ::Validate(object->danger_type, validation_context))
    return false;


  if (!::downloads::mojom::internal::TailoredWarningType_Data
        ::Validate(object->tailored_warning_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->date_string, 15, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& date_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->date_string, validation_context,
                                         &date_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_name, 16, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_name, validation_context,
                                         &file_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 17, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_path_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_path, validation_context,
                                         &file_path_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_url, 18, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& file_url_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->file_url, validation_context,
                                         &file_url_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_reason_text, 20, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_reason_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_reason_text, validation_context,
                                         &last_reason_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->progress_status_text, 21, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& progress_status_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->progress_status_text, validation_context,
                                         &progress_status_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->show_in_folder_text, 22, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& show_in_folder_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->show_in_folder_text, validation_context,
                                         &show_in_folder_text_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->since_string, 23, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& since_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->since_string, validation_context,
                                         &since_string_validate_params)) {
    return false;
  }


  if (!::downloads::mojom::internal::State_Data
        ::Validate(object->state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_initiator_origin, 25, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_url, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_url, validation_context))
    return false;


  if (!::downloads::mojom::internal::SafeBrowsingState_Data
        ::Validate(object->safe_browsing_state, validation_context))
    return false;

  return true;
}

Data_Data::Data_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const PageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandlerFactory_CreatePageHandler_Params_Data::PageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDownloads_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDownloads_Params_Data* object =
      static_cast<const PageHandler_GetDownloads_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->search_terms, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& search_terms_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->search_terms, validation_context,
                                         &search_terms_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_GetDownloads_Params_Data::PageHandler_GetDownloads_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenFileRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenFileRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_OpenFileRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenFileRequiringGesture_Params_Data::PageHandler_OpenFileRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Drag_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Drag_Params_Data* object =
      static_cast<const PageHandler_Drag_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Drag_Params_Data::PageHandler_Drag_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SaveSuspiciousRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SaveSuspiciousRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_SaveSuspiciousRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SaveSuspiciousRequiringGesture_Params_Data::PageHandler_SaveSuspiciousRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordOpenBypassWarningDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordOpenBypassWarningDialog_Params_Data* object =
      static_cast<const PageHandler_RecordOpenBypassWarningDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RecordOpenBypassWarningDialog_Params_Data::PageHandler_RecordOpenBypassWarningDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data::PageHandler_SaveDangerousFromDialogRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordCancelBypassWarningDialog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordCancelBypassWarningDialog_Params_Data* object =
      static_cast<const PageHandler_RecordCancelBypassWarningDialog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RecordCancelBypassWarningDialog_Params_Data::PageHandler_RecordCancelBypassWarningDialog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DiscardDangerous_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DiscardDangerous_Params_Data* object =
      static_cast<const PageHandler_DiscardDangerous_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_DiscardDangerous_Params_Data::PageHandler_DiscardDangerous_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RetryDownload_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RetryDownload_Params_Data* object =
      static_cast<const PageHandler_RetryDownload_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_RetryDownload_Params_Data::PageHandler_RetryDownload_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Show_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Show_Params_Data* object =
      static_cast<const PageHandler_Show_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Show_Params_Data::PageHandler_Show_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Pause_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Pause_Params_Data* object =
      static_cast<const PageHandler_Pause_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Pause_Params_Data::PageHandler_Pause_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Resume_Params_Data* object =
      static_cast<const PageHandler_Resume_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Resume_Params_Data::PageHandler_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Remove_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Remove_Params_Data* object =
      static_cast<const PageHandler_Remove_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Remove_Params_Data::PageHandler_Remove_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Undo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Undo_Params_Data* object =
      static_cast<const PageHandler_Undo_Params_Data*>(data);

  return true;
}

PageHandler_Undo_Params_Data::PageHandler_Undo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Cancel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Cancel_Params_Data* object =
      static_cast<const PageHandler_Cancel_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_Cancel_Params_Data::PageHandler_Cancel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ClearAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ClearAll_Params_Data* object =
      static_cast<const PageHandler_ClearAll_Params_Data*>(data);

  return true;
}

PageHandler_ClearAll_Params_Data::PageHandler_ClearAll_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data*>(data);

  return true;
}

PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data::PageHandler_OpenDownloadsFolderRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenEsbSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenEsbSettings_Params_Data* object =
      static_cast<const PageHandler_OpenEsbSettings_Params_Data*>(data);

  return true;
}

PageHandler_OpenEsbSettings_Params_Data::PageHandler_OpenEsbSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_LogEsbPromotionRowViewed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_LogEsbPromotionRowViewed_Params_Data* object =
      static_cast<const PageHandler_LogEsbPromotionRowViewed_Params_Data*>(data);

  return true;
}

PageHandler_LogEsbPromotionRowViewed_Params_Data::PageHandler_LogEsbPromotionRowViewed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenDuringScanningRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenDuringScanningRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_OpenDuringScanningRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_OpenDuringScanningRequiringGesture_Params_Data::PageHandler_OpenDuringScanningRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_ReviewDangerousRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_ReviewDangerousRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_ReviewDangerousRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_ReviewDangerousRequiringGesture_Params_Data::PageHandler_ReviewDangerousRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeepScan_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeepScan_Params_Data* object =
      static_cast<const PageHandler_DeepScan_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_DeepScan_Params_Data::PageHandler_DeepScan_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_BypassDeepScanRequiringGesture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_BypassDeepScanRequiringGesture_Params_Data* object =
      static_cast<const PageHandler_BypassDeepScanRequiringGesture_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_BypassDeepScanRequiringGesture_Params_Data::PageHandler_BypassDeepScanRequiringGesture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsEligibleForEsbPromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsEligibleForEsbPromo_Params_Data* object =
      static_cast<const PageHandler_IsEligibleForEsbPromo_Params_Data*>(data);

  return true;
}

PageHandler_IsEligibleForEsbPromo_Params_Data::PageHandler_IsEligibleForEsbPromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_IsEligibleForEsbPromo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_IsEligibleForEsbPromo_ResponseParams_Data* object =
      static_cast<const PageHandler_IsEligibleForEsbPromo_ResponseParams_Data*>(data);

  return true;
}

PageHandler_IsEligibleForEsbPromo_ResponseParams_Data::PageHandler_IsEligibleForEsbPromo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_RemoveItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_RemoveItem_Params_Data* object =
      static_cast<const Page_RemoveItem_Params_Data*>(data);

  return true;
}

Page_RemoveItem_Params_Data::Page_RemoveItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_UpdateItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_UpdateItem_Params_Data* object =
      static_cast<const Page_UpdateItem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->data, validation_context))
    return false;

  return true;
}

Page_UpdateItem_Params_Data::Page_UpdateItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_InsertItems_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_InsertItems_Params_Data* object =
      static_cast<const Page_InsertItems_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

Page_InsertItems_Params_Data::Page_InsertItems_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_ClearAll_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_ClearAll_Params_Data* object =
      static_cast<const Page_ClearAll_Params_Data*>(data);

  return true;
}

Page_ClearAll_Params_Data::Page_ClearAll_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace downloads

namespace perfetto {

// static
void TraceFormatTraits<::downloads::mojom::DangerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::downloads::mojom::DangerType value) {
  return std::move(context).WriteString(::downloads::mojom::DangerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::downloads::mojom::TailoredWarningType>::WriteIntoTrace(
   perfetto::TracedValue context, ::downloads::mojom::TailoredWarningType value) {
  return std::move(context).WriteString(::downloads::mojom::TailoredWarningTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::downloads::mojom::State>::WriteIntoTrace(
   perfetto::TracedValue context, ::downloads::mojom::State value) {
  return std::move(context).WriteString(::downloads::mojom::StateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::downloads::mojom::SafeBrowsingState>::WriteIntoTrace(
   perfetto::TracedValue context, ::downloads::mojom::SafeBrowsingState value) {
  return std::move(context).WriteString(::downloads::mojom::SafeBrowsingStateToString(value));
}

} // namespace perfetto