// chrome/browser/ui/webui/discards/discards.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/discards/discards.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/discards/discards.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/discards/discards.mojom-forward.h"  // IWYU pragma: export
#include "chrome/browser/resource_coordinator/lifecycle_unit_state.mojom-forward.h"
#include "mojo/public/mojom/base/process_id.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace discards::mojom {

class DetailsProviderProxy;

template <typename ImplRefTraits>
class DetailsProviderStub;

class DetailsProviderRequestValidator;
class DetailsProviderResponseValidator;


class DetailsProvider
    : public DetailsProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "discards.mojom.DetailsProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DetailsProviderInterfaceBase;
  using Proxy_ = DetailsProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DetailsProviderStub<ImplRefTraits>;

  using RequestValidator_ = DetailsProviderRequestValidator;
  using ResponseValidator_ = DetailsProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetTabDiscardsInfoMinVersion = 0,
    kSetAutoDiscardableMinVersion = 0,
    kDiscardByIdMinVersion = 0,
    kFreezeByIdMinVersion = 0,
    kLoadByIdMinVersion = 0,
    kDiscardMinVersion = 0,
    kToggleBatterySaverModeMinVersion = 0,
    kRefreshPerformanceTabCpuMeasurementsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetTabDiscardsInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetAutoDiscardable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DiscardById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FreezeById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadById_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Discard_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleBatterySaverMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RefreshPerformanceTabCpuMeasurements_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DetailsProvider() = default;

  using GetTabDiscardsInfoCallback = base::OnceCallback<void(std::vector<TabDiscardsInfoPtr>)>;
  using GetTabDiscardsInfoMojoCallback = base::OnceCallback<void(std::vector<TabDiscardsInfoPtr>)>;

  virtual void GetTabDiscardsInfo(GetTabDiscardsInfoCallback callback) = 0;

  using SetAutoDiscardableCallback = base::OnceCallback<void()>;
  using SetAutoDiscardableMojoCallback = base::OnceCallback<void()>;

  virtual void SetAutoDiscardable(int32_t tab_id, bool is_auto_discardable, SetAutoDiscardableCallback callback) = 0;

  using DiscardByIdCallback = base::OnceCallback<void()>;
  using DiscardByIdMojoCallback = base::OnceCallback<void()>;

  virtual void DiscardById(int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason, DiscardByIdCallback callback) = 0;

  virtual void FreezeById(int32_t tab_id) = 0;

  virtual void LoadById(int32_t tab_id) = 0;

  using DiscardCallback = base::OnceCallback<void()>;
  using DiscardMojoCallback = base::OnceCallback<void()>;

  virtual void Discard(DiscardCallback callback) = 0;

  virtual void ToggleBatterySaverMode() = 0;

  virtual void RefreshPerformanceTabCpuMeasurements() = 0;
};

class GraphChangeStreamProxy;

template <typename ImplRefTraits>
class GraphChangeStreamStub;

class GraphChangeStreamRequestValidator;


class GraphChangeStream
    : public GraphChangeStreamInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "discards.mojom.GraphChangeStream";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GraphChangeStreamInterfaceBase;
  using Proxy_ = GraphChangeStreamProxy;

  template <typename ImplRefTraits>
  using Stub_ = GraphChangeStreamStub<ImplRefTraits>;

  using RequestValidator_ = GraphChangeStreamRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kFrameCreatedMinVersion = 0,
    kPageCreatedMinVersion = 0,
    kProcessCreatedMinVersion = 0,
    kWorkerCreatedMinVersion = 0,
    kFrameChangedMinVersion = 0,
    kPageChangedMinVersion = 0,
    kProcessChangedMinVersion = 0,
    kWorkerChangedMinVersion = 0,
    kFavIconDataAvailableMinVersion = 0,
    kNodeDeletedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FrameCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PageCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WorkerCreated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FrameChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ProcessChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WorkerChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FavIconDataAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NodeDeleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GraphChangeStream() = default;

  virtual void FrameCreated(FrameInfoPtr frame) = 0;

  virtual void PageCreated(PageInfoPtr pages) = 0;

  virtual void ProcessCreated(ProcessInfoPtr process) = 0;

  virtual void WorkerCreated(WorkerInfoPtr worker) = 0;

  virtual void FrameChanged(FrameInfoPtr frame) = 0;

  virtual void PageChanged(PageInfoPtr page) = 0;

  virtual void ProcessChanged(ProcessInfoPtr process) = 0;

  virtual void WorkerChanged(WorkerInfoPtr worker) = 0;

  virtual void FavIconDataAvailable(FavIconInfoPtr favicon) = 0;

  virtual void NodeDeleted(int64_t node_id) = 0;
};

class GraphDumpProxy;

template <typename ImplRefTraits>
class GraphDumpStub;

class GraphDumpRequestValidator;
class GraphDumpResponseValidator;


class GraphDump
    : public GraphDumpInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "discards.mojom.GraphDump";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GraphDumpInterfaceBase;
  using Proxy_ = GraphDumpProxy;

  template <typename ImplRefTraits>
  using Stub_ = GraphDumpStub<ImplRefTraits>;

  using RequestValidator_ = GraphDumpRequestValidator;
  using ResponseValidator_ = GraphDumpResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSubscribeToChangesMinVersion = 0,
    kRequestNodeDescriptionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SubscribeToChanges_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestNodeDescriptions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GraphDump() = default;

  virtual void SubscribeToChanges(::mojo::PendingRemote<GraphChangeStream> change_subscriber) = 0;

  using RequestNodeDescriptionsCallback = base::OnceCallback<void(const base::flat_map<int64_t, std::string>&)>;
  using RequestNodeDescriptionsMojoCallback = base::OnceCallback<void(const base::flat_map<int64_t, std::string>&)>;

  virtual void RequestNodeDescriptions(const std::vector<int64_t>& node_ids, RequestNodeDescriptionsCallback callback) = 0;
};



class  DetailsProviderProxy
    : public DetailsProvider {
 public:
  using InterfaceType = DetailsProvider;

  explicit DetailsProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetTabDiscardsInfo(GetTabDiscardsInfoCallback callback) final;
  
  void SetAutoDiscardable(int32_t tab_id, bool is_auto_discardable, SetAutoDiscardableCallback callback) final;
  
  void DiscardById(int32_t tab_id, ::mojom::LifecycleUnitDiscardReason reason, DiscardByIdCallback callback) final;
  
  void FreezeById(int32_t tab_id) final;
  
  void LoadById(int32_t tab_id) final;
  
  void Discard(DiscardCallback callback) final;
  
  void ToggleBatterySaverMode() final;
  
  void RefreshPerformanceTabCpuMeasurements() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GraphChangeStreamProxy
    : public GraphChangeStream {
 public:
  using InterfaceType = GraphChangeStream;

  explicit GraphChangeStreamProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FrameCreated(FrameInfoPtr frame) final;
  
  void PageCreated(PageInfoPtr pages) final;
  
  void ProcessCreated(ProcessInfoPtr process) final;
  
  void WorkerCreated(WorkerInfoPtr worker) final;
  
  void FrameChanged(FrameInfoPtr frame) final;
  
  void PageChanged(PageInfoPtr page) final;
  
  void ProcessChanged(ProcessInfoPtr process) final;
  
  void WorkerChanged(WorkerInfoPtr worker) final;
  
  void FavIconDataAvailable(FavIconInfoPtr favicon) final;
  
  void NodeDeleted(int64_t node_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GraphDumpProxy
    : public GraphDump {
 public:
  using InterfaceType = GraphDump;

  explicit GraphDumpProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SubscribeToChanges(::mojo::PendingRemote<GraphChangeStream> change_subscriber) final;
  
  void RequestNodeDescriptions(const std::vector<int64_t>& node_ids, RequestNodeDescriptionsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DetailsProviderStubDispatch {
 public:
  static bool Accept(DetailsProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DetailsProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DetailsProvider>>
class DetailsProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DetailsProviderStub() = default;
  ~DetailsProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DetailsProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DetailsProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GraphChangeStreamStubDispatch {
 public:
  static bool Accept(GraphChangeStream* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GraphChangeStream* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GraphChangeStream>>
class GraphChangeStreamStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GraphChangeStreamStub() = default;
  ~GraphChangeStreamStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GraphChangeStreamStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GraphChangeStreamStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GraphDumpStubDispatch {
 public:
  static bool Accept(GraphDump* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GraphDump* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GraphDump>>
class GraphDumpStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GraphDumpStub() = default;
  ~GraphDumpStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GraphDumpStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GraphDumpStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DetailsProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GraphChangeStreamRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GraphDumpRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DetailsProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GraphDumpResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  FavIconInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FavIconInfo, T>::value>;
  using DataView = FavIconInfoDataView;
  using Data_ = internal::FavIconInfo_Data;

  template <typename... Args>
  static FavIconInfoPtr New(Args&&... args) {
    return FavIconInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FavIconInfoPtr From(const U& u) {
    return mojo::TypeConverter<FavIconInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FavIconInfo>::Convert(*this);
  }


  FavIconInfo();

  FavIconInfo(
      int64_t node_id,
      const std::string& icon_data);


  ~FavIconInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FavIconInfoPtr>
  FavIconInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FavIconInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FavIconInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FavIconInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FavIconInfo_UnserializedMessageContext<
            UserType, FavIconInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FavIconInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FavIconInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FavIconInfo_UnserializedMessageContext<
            UserType, FavIconInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FavIconInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t node_id;
  
  std::string icon_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FavIconInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  TabDiscardsInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TabDiscardsInfo, T>::value>;
  using DataView = TabDiscardsInfoDataView;
  using Data_ = internal::TabDiscardsInfo_Data;

  template <typename... Args>
  static TabDiscardsInfoPtr New(Args&&... args) {
    return TabDiscardsInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TabDiscardsInfoPtr From(const U& u) {
    return mojo::TypeConverter<TabDiscardsInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TabDiscardsInfo>::Convert(*this);
  }


  TabDiscardsInfo();

  TabDiscardsInfo(
      const std::string& tab_url,
      const std::string& title,
      LifecycleUnitVisibility visibility,
      ::mojom::LifecycleUnitLoadingState loading_state,
      ::mojom::LifecycleUnitState state,
      bool can_discard,
      std::vector<std::string> cannot_discard_reasons,
      CanFreeze can_freeze,
      std::vector<std::string> cannot_freeze_reasons,
      int32_t discard_count,
      ::mojom::LifecycleUnitDiscardReason discard_reason,
      int32_t utility_rank,
      int32_t last_active_seconds,
      int32_t id,
      bool is_auto_discardable,
      double site_engagement_score,
      bool has_focus,
      ::base::TimeDelta state_change_time);


  ~TabDiscardsInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TabDiscardsInfoPtr>
  TabDiscardsInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabDiscardsInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TabDiscardsInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TabDiscardsInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TabDiscardsInfo_UnserializedMessageContext<
            UserType, TabDiscardsInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TabDiscardsInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TabDiscardsInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TabDiscardsInfo_UnserializedMessageContext<
            UserType, TabDiscardsInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TabDiscardsInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string tab_url;
  
  std::string title;
  
  LifecycleUnitVisibility visibility;
  
  ::mojom::LifecycleUnitLoadingState loading_state;
  
  ::mojom::LifecycleUnitState state;
  
  bool can_discard;
  
  std::vector<std::string> cannot_discard_reasons;
  
  CanFreeze can_freeze;
  
  std::vector<std::string> cannot_freeze_reasons;
  
  int32_t discard_count;
  
  ::mojom::LifecycleUnitDiscardReason discard_reason;
  
  int32_t utility_rank;
  
  int32_t last_active_seconds;
  
  int32_t id;
  
  bool is_auto_discardable;
  
  double site_engagement_score;
  
  bool has_focus;
  
  ::base::TimeDelta state_change_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TabDiscardsInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageInfo, T>::value>;
  using DataView = PageInfoDataView;
  using Data_ = internal::PageInfo_Data;

  template <typename... Args>
  static PageInfoPtr New(Args&&... args) {
    return PageInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageInfoPtr From(const U& u) {
    return mojo::TypeConverter<PageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageInfo>::Convert(*this);
  }


  PageInfo();

  PageInfo(
      int64_t id,
      const ::GURL& main_frame_url,
      int64_t opener_frame_id,
      int64_t embedder_frame_id,
      const std::string& description_json);


  ~PageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageInfoPtr>
  PageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageInfo_UnserializedMessageContext<
            UserType, PageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageInfo_UnserializedMessageContext<
            UserType, PageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::GURL main_frame_url;
  
  int64_t opener_frame_id;
  
  int64_t embedder_frame_id;
  
  std::string description_json;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  FrameInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<FrameInfo, T>::value>;
  using DataView = FrameInfoDataView;
  using Data_ = internal::FrameInfo_Data;

  template <typename... Args>
  static FrameInfoPtr New(Args&&... args) {
    return FrameInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static FrameInfoPtr From(const U& u) {
    return mojo::TypeConverter<FrameInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, FrameInfo>::Convert(*this);
  }


  FrameInfo();

  FrameInfo(
      int64_t id,
      const ::GURL& url,
      int64_t page_id,
      int64_t parent_frame_id,
      int64_t process_id,
      const std::string& description_json);


  ~FrameInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = FrameInfoPtr>
  FrameInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        FrameInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        FrameInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return FrameInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::FrameInfo_UnserializedMessageContext<
            UserType, FrameInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<FrameInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::GURL url;
  
  int64_t page_id;
  
  int64_t parent_frame_id;
  
  int64_t process_id;
  
  std::string description_json;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, FrameInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ProcessInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProcessInfo, T>::value>;
  using DataView = ProcessInfoDataView;
  using Data_ = internal::ProcessInfo_Data;

  template <typename... Args>
  static ProcessInfoPtr New(Args&&... args) {
    return ProcessInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProcessInfoPtr From(const U& u) {
    return mojo::TypeConverter<ProcessInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProcessInfo>::Convert(*this);
  }


  ProcessInfo();

  ProcessInfo(
      int64_t id,
      ::base::ProcessId pid,
      uint64_t private_footprint_kb,
      const std::string& description_json);


  ~ProcessInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProcessInfoPtr>
  ProcessInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProcessInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProcessInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProcessInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProcessInfo_UnserializedMessageContext<
            UserType, ProcessInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProcessInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProcessInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProcessInfo_UnserializedMessageContext<
            UserType, ProcessInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProcessInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::base::ProcessId pid;
  
  uint64_t private_footprint_kb;
  
  std::string description_json;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProcessInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WorkerInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WorkerInfo, T>::value>;
  using DataView = WorkerInfoDataView;
  using Data_ = internal::WorkerInfo_Data;

  template <typename... Args>
  static WorkerInfoPtr New(Args&&... args) {
    return WorkerInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WorkerInfoPtr From(const U& u) {
    return mojo::TypeConverter<WorkerInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WorkerInfo>::Convert(*this);
  }


  WorkerInfo();

  WorkerInfo(
      int64_t id,
      const ::GURL& url,
      int64_t process_id,
      std::vector<int64_t> client_frame_ids,
      std::vector<int64_t> client_worker_ids,
      std::vector<int64_t> child_worker_ids,
      const std::string& description_json);


  ~WorkerInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WorkerInfoPtr>
  WorkerInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WorkerInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WorkerInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WorkerInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WorkerInfo_UnserializedMessageContext<
            UserType, WorkerInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WorkerInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WorkerInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WorkerInfo_UnserializedMessageContext<
            UserType, WorkerInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WorkerInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t id;
  
  ::GURL url;
  
  int64_t process_id;
  
  std::vector<int64_t> client_frame_ids;
  
  std::vector<int64_t> client_worker_ids;
  
  std::vector<int64_t> child_worker_ids;
  
  std::string description_json;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WorkerInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
TabDiscardsInfoPtr TabDiscardsInfo::Clone() const {
  return New(
      mojo::Clone(tab_url),
      mojo::Clone(title),
      mojo::Clone(visibility),
      mojo::Clone(loading_state),
      mojo::Clone(state),
      mojo::Clone(can_discard),
      mojo::Clone(cannot_discard_reasons),
      mojo::Clone(can_freeze),
      mojo::Clone(cannot_freeze_reasons),
      mojo::Clone(discard_count),
      mojo::Clone(discard_reason),
      mojo::Clone(utility_rank),
      mojo::Clone(last_active_seconds),
      mojo::Clone(id),
      mojo::Clone(is_auto_discardable),
      mojo::Clone(site_engagement_score),
      mojo::Clone(has_focus),
      mojo::Clone(state_change_time)
  );
}

template <typename T, TabDiscardsInfo::EnableIfSame<T>*>
bool TabDiscardsInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->tab_url, other_struct.tab_url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->visibility, other_struct.visibility))
    return false;
  if (!mojo::Equals(this->loading_state, other_struct.loading_state))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->can_discard, other_struct.can_discard))
    return false;
  if (!mojo::Equals(this->cannot_discard_reasons, other_struct.cannot_discard_reasons))
    return false;
  if (!mojo::Equals(this->can_freeze, other_struct.can_freeze))
    return false;
  if (!mojo::Equals(this->cannot_freeze_reasons, other_struct.cannot_freeze_reasons))
    return false;
  if (!mojo::Equals(this->discard_count, other_struct.discard_count))
    return false;
  if (!mojo::Equals(this->discard_reason, other_struct.discard_reason))
    return false;
  if (!mojo::Equals(this->utility_rank, other_struct.utility_rank))
    return false;
  if (!mojo::Equals(this->last_active_seconds, other_struct.last_active_seconds))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->is_auto_discardable, other_struct.is_auto_discardable))
    return false;
  if (!mojo::Equals(this->site_engagement_score, other_struct.site_engagement_score))
    return false;
  if (!mojo::Equals(this->has_focus, other_struct.has_focus))
    return false;
  if (!mojo::Equals(this->state_change_time, other_struct.state_change_time))
    return false;
  return true;
}

template <typename T, TabDiscardsInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.tab_url < rhs.tab_url)
    return true;
  if (rhs.tab_url < lhs.tab_url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.visibility < rhs.visibility)
    return true;
  if (rhs.visibility < lhs.visibility)
    return false;
  if (lhs.loading_state < rhs.loading_state)
    return true;
  if (rhs.loading_state < lhs.loading_state)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.can_discard < rhs.can_discard)
    return true;
  if (rhs.can_discard < lhs.can_discard)
    return false;
  if (lhs.cannot_discard_reasons < rhs.cannot_discard_reasons)
    return true;
  if (rhs.cannot_discard_reasons < lhs.cannot_discard_reasons)
    return false;
  if (lhs.can_freeze < rhs.can_freeze)
    return true;
  if (rhs.can_freeze < lhs.can_freeze)
    return false;
  if (lhs.cannot_freeze_reasons < rhs.cannot_freeze_reasons)
    return true;
  if (rhs.cannot_freeze_reasons < lhs.cannot_freeze_reasons)
    return false;
  if (lhs.discard_count < rhs.discard_count)
    return true;
  if (rhs.discard_count < lhs.discard_count)
    return false;
  if (lhs.discard_reason < rhs.discard_reason)
    return true;
  if (rhs.discard_reason < lhs.discard_reason)
    return false;
  if (lhs.utility_rank < rhs.utility_rank)
    return true;
  if (rhs.utility_rank < lhs.utility_rank)
    return false;
  if (lhs.last_active_seconds < rhs.last_active_seconds)
    return true;
  if (rhs.last_active_seconds < lhs.last_active_seconds)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.is_auto_discardable < rhs.is_auto_discardable)
    return true;
  if (rhs.is_auto_discardable < lhs.is_auto_discardable)
    return false;
  if (lhs.site_engagement_score < rhs.site_engagement_score)
    return true;
  if (rhs.site_engagement_score < lhs.site_engagement_score)
    return false;
  if (lhs.has_focus < rhs.has_focus)
    return true;
  if (rhs.has_focus < lhs.has_focus)
    return false;
  if (lhs.state_change_time < rhs.state_change_time)
    return true;
  if (rhs.state_change_time < lhs.state_change_time)
    return false;
  return false;
}
template <typename StructPtrType>
PageInfoPtr PageInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(main_frame_url),
      mojo::Clone(opener_frame_id),
      mojo::Clone(embedder_frame_id),
      mojo::Clone(description_json)
  );
}

template <typename T, PageInfo::EnableIfSame<T>*>
bool PageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->main_frame_url, other_struct.main_frame_url))
    return false;
  if (!mojo::Equals(this->opener_frame_id, other_struct.opener_frame_id))
    return false;
  if (!mojo::Equals(this->embedder_frame_id, other_struct.embedder_frame_id))
    return false;
  if (!mojo::Equals(this->description_json, other_struct.description_json))
    return false;
  return true;
}

template <typename T, PageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.main_frame_url < rhs.main_frame_url)
    return true;
  if (rhs.main_frame_url < lhs.main_frame_url)
    return false;
  if (lhs.opener_frame_id < rhs.opener_frame_id)
    return true;
  if (rhs.opener_frame_id < lhs.opener_frame_id)
    return false;
  if (lhs.embedder_frame_id < rhs.embedder_frame_id)
    return true;
  if (rhs.embedder_frame_id < lhs.embedder_frame_id)
    return false;
  if (lhs.description_json < rhs.description_json)
    return true;
  if (rhs.description_json < lhs.description_json)
    return false;
  return false;
}
template <typename StructPtrType>
FrameInfoPtr FrameInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(page_id),
      mojo::Clone(parent_frame_id),
      mojo::Clone(process_id),
      mojo::Clone(description_json)
  );
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool FrameInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->page_id, other_struct.page_id))
    return false;
  if (!mojo::Equals(this->parent_frame_id, other_struct.parent_frame_id))
    return false;
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->description_json, other_struct.description_json))
    return false;
  return true;
}

template <typename T, FrameInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.page_id < rhs.page_id)
    return true;
  if (rhs.page_id < lhs.page_id)
    return false;
  if (lhs.parent_frame_id < rhs.parent_frame_id)
    return true;
  if (rhs.parent_frame_id < lhs.parent_frame_id)
    return false;
  if (lhs.process_id < rhs.process_id)
    return true;
  if (rhs.process_id < lhs.process_id)
    return false;
  if (lhs.description_json < rhs.description_json)
    return true;
  if (rhs.description_json < lhs.description_json)
    return false;
  return false;
}
template <typename StructPtrType>
ProcessInfoPtr ProcessInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(pid),
      mojo::Clone(private_footprint_kb),
      mojo::Clone(description_json)
  );
}

template <typename T, ProcessInfo::EnableIfSame<T>*>
bool ProcessInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->pid, other_struct.pid))
    return false;
  if (!mojo::Equals(this->private_footprint_kb, other_struct.private_footprint_kb))
    return false;
  if (!mojo::Equals(this->description_json, other_struct.description_json))
    return false;
  return true;
}

template <typename T, ProcessInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.pid < rhs.pid)
    return true;
  if (rhs.pid < lhs.pid)
    return false;
  if (lhs.private_footprint_kb < rhs.private_footprint_kb)
    return true;
  if (rhs.private_footprint_kb < lhs.private_footprint_kb)
    return false;
  if (lhs.description_json < rhs.description_json)
    return true;
  if (rhs.description_json < lhs.description_json)
    return false;
  return false;
}
template <typename StructPtrType>
WorkerInfoPtr WorkerInfo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(process_id),
      mojo::Clone(client_frame_ids),
      mojo::Clone(client_worker_ids),
      mojo::Clone(child_worker_ids),
      mojo::Clone(description_json)
  );
}

template <typename T, WorkerInfo::EnableIfSame<T>*>
bool WorkerInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->client_frame_ids, other_struct.client_frame_ids))
    return false;
  if (!mojo::Equals(this->client_worker_ids, other_struct.client_worker_ids))
    return false;
  if (!mojo::Equals(this->child_worker_ids, other_struct.child_worker_ids))
    return false;
  if (!mojo::Equals(this->description_json, other_struct.description_json))
    return false;
  return true;
}

template <typename T, WorkerInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.process_id < rhs.process_id)
    return true;
  if (rhs.process_id < lhs.process_id)
    return false;
  if (lhs.client_frame_ids < rhs.client_frame_ids)
    return true;
  if (rhs.client_frame_ids < lhs.client_frame_ids)
    return false;
  if (lhs.client_worker_ids < rhs.client_worker_ids)
    return true;
  if (rhs.client_worker_ids < lhs.client_worker_ids)
    return false;
  if (lhs.child_worker_ids < rhs.child_worker_ids)
    return true;
  if (rhs.child_worker_ids < lhs.child_worker_ids)
    return false;
  if (lhs.description_json < rhs.description_json)
    return true;
  if (rhs.description_json < lhs.description_json)
    return false;
  return false;
}
template <typename StructPtrType>
FavIconInfoPtr FavIconInfo::Clone() const {
  return New(
      mojo::Clone(node_id),
      mojo::Clone(icon_data)
  );
}

template <typename T, FavIconInfo::EnableIfSame<T>*>
bool FavIconInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->node_id, other_struct.node_id))
    return false;
  if (!mojo::Equals(this->icon_data, other_struct.icon_data))
    return false;
  return true;
}

template <typename T, FavIconInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.node_id < rhs.node_id)
    return true;
  if (rhs.node_id < lhs.node_id)
    return false;
  if (lhs.icon_data < rhs.icon_data)
    return true;
  if (rhs.icon_data < lhs.icon_data)
    return false;
  return false;
}


}  // discards::mojom

namespace mojo {


template <>
struct  StructTraits<::discards::mojom::TabDiscardsInfo::DataView,
                                         ::discards::mojom::TabDiscardsInfoPtr> {
  static bool IsNull(const ::discards::mojom::TabDiscardsInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::TabDiscardsInfoPtr* output) { output->reset(); }

  static const decltype(::discards::mojom::TabDiscardsInfo::tab_url)& tab_url(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->tab_url;
  }

  static const decltype(::discards::mojom::TabDiscardsInfo::title)& title(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->title;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::visibility) visibility(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->visibility;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::loading_state) loading_state(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->loading_state;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::state) state(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->state;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::can_discard) can_discard(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->can_discard;
  }

  static const decltype(::discards::mojom::TabDiscardsInfo::cannot_discard_reasons)& cannot_discard_reasons(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->cannot_discard_reasons;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::can_freeze) can_freeze(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->can_freeze;
  }

  static const decltype(::discards::mojom::TabDiscardsInfo::cannot_freeze_reasons)& cannot_freeze_reasons(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->cannot_freeze_reasons;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::discard_count) discard_count(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->discard_count;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::discard_reason) discard_reason(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->discard_reason;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::utility_rank) utility_rank(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->utility_rank;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::last_active_seconds) last_active_seconds(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->last_active_seconds;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::id) id(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->id;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::is_auto_discardable) is_auto_discardable(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->is_auto_discardable;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::site_engagement_score) site_engagement_score(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->site_engagement_score;
  }

  static decltype(::discards::mojom::TabDiscardsInfo::has_focus) has_focus(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->has_focus;
  }

  static const decltype(::discards::mojom::TabDiscardsInfo::state_change_time)& state_change_time(
      const ::discards::mojom::TabDiscardsInfoPtr& input) {
    return input->state_change_time;
  }

  static bool Read(::discards::mojom::TabDiscardsInfo::DataView input, ::discards::mojom::TabDiscardsInfoPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::PageInfo::DataView,
                                         ::discards::mojom::PageInfoPtr> {
  static bool IsNull(const ::discards::mojom::PageInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::PageInfoPtr* output) { output->reset(); }

  static decltype(::discards::mojom::PageInfo::id) id(
      const ::discards::mojom::PageInfoPtr& input) {
    return input->id;
  }

  static const decltype(::discards::mojom::PageInfo::main_frame_url)& main_frame_url(
      const ::discards::mojom::PageInfoPtr& input) {
    return input->main_frame_url;
  }

  static decltype(::discards::mojom::PageInfo::opener_frame_id) opener_frame_id(
      const ::discards::mojom::PageInfoPtr& input) {
    return input->opener_frame_id;
  }

  static decltype(::discards::mojom::PageInfo::embedder_frame_id) embedder_frame_id(
      const ::discards::mojom::PageInfoPtr& input) {
    return input->embedder_frame_id;
  }

  static const decltype(::discards::mojom::PageInfo::description_json)& description_json(
      const ::discards::mojom::PageInfoPtr& input) {
    return input->description_json;
  }

  static bool Read(::discards::mojom::PageInfo::DataView input, ::discards::mojom::PageInfoPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::FrameInfo::DataView,
                                         ::discards::mojom::FrameInfoPtr> {
  static bool IsNull(const ::discards::mojom::FrameInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::FrameInfoPtr* output) { output->reset(); }

  static decltype(::discards::mojom::FrameInfo::id) id(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->id;
  }

  static const decltype(::discards::mojom::FrameInfo::url)& url(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->url;
  }

  static decltype(::discards::mojom::FrameInfo::page_id) page_id(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->page_id;
  }

  static decltype(::discards::mojom::FrameInfo::parent_frame_id) parent_frame_id(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->parent_frame_id;
  }

  static decltype(::discards::mojom::FrameInfo::process_id) process_id(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->process_id;
  }

  static const decltype(::discards::mojom::FrameInfo::description_json)& description_json(
      const ::discards::mojom::FrameInfoPtr& input) {
    return input->description_json;
  }

  static bool Read(::discards::mojom::FrameInfo::DataView input, ::discards::mojom::FrameInfoPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::ProcessInfo::DataView,
                                         ::discards::mojom::ProcessInfoPtr> {
  static bool IsNull(const ::discards::mojom::ProcessInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::ProcessInfoPtr* output) { output->reset(); }

  static decltype(::discards::mojom::ProcessInfo::id) id(
      const ::discards::mojom::ProcessInfoPtr& input) {
    return input->id;
  }

  static const decltype(::discards::mojom::ProcessInfo::pid)& pid(
      const ::discards::mojom::ProcessInfoPtr& input) {
    return input->pid;
  }

  static decltype(::discards::mojom::ProcessInfo::private_footprint_kb) private_footprint_kb(
      const ::discards::mojom::ProcessInfoPtr& input) {
    return input->private_footprint_kb;
  }

  static const decltype(::discards::mojom::ProcessInfo::description_json)& description_json(
      const ::discards::mojom::ProcessInfoPtr& input) {
    return input->description_json;
  }

  static bool Read(::discards::mojom::ProcessInfo::DataView input, ::discards::mojom::ProcessInfoPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::WorkerInfo::DataView,
                                         ::discards::mojom::WorkerInfoPtr> {
  static bool IsNull(const ::discards::mojom::WorkerInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::WorkerInfoPtr* output) { output->reset(); }

  static decltype(::discards::mojom::WorkerInfo::id) id(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->id;
  }

  static const decltype(::discards::mojom::WorkerInfo::url)& url(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->url;
  }

  static decltype(::discards::mojom::WorkerInfo::process_id) process_id(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->process_id;
  }

  static const decltype(::discards::mojom::WorkerInfo::client_frame_ids)& client_frame_ids(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->client_frame_ids;
  }

  static const decltype(::discards::mojom::WorkerInfo::client_worker_ids)& client_worker_ids(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->client_worker_ids;
  }

  static const decltype(::discards::mojom::WorkerInfo::child_worker_ids)& child_worker_ids(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->child_worker_ids;
  }

  static const decltype(::discards::mojom::WorkerInfo::description_json)& description_json(
      const ::discards::mojom::WorkerInfoPtr& input) {
    return input->description_json;
  }

  static bool Read(::discards::mojom::WorkerInfo::DataView input, ::discards::mojom::WorkerInfoPtr* output);
};


template <>
struct  StructTraits<::discards::mojom::FavIconInfo::DataView,
                                         ::discards::mojom::FavIconInfoPtr> {
  static bool IsNull(const ::discards::mojom::FavIconInfoPtr& input) { return !input; }
  static void SetToNull(::discards::mojom::FavIconInfoPtr* output) { output->reset(); }

  static decltype(::discards::mojom::FavIconInfo::node_id) node_id(
      const ::discards::mojom::FavIconInfoPtr& input) {
    return input->node_id;
  }

  static const decltype(::discards::mojom::FavIconInfo::icon_data)& icon_data(
      const ::discards::mojom::FavIconInfoPtr& input) {
    return input->icon_data;
  }

  static bool Read(::discards::mojom::FavIconInfo::DataView input, ::discards::mojom::FavIconInfoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_DISCARDS_DISCARDS_MOJOM_H_