// chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-shared-internal.h"
#include "components/data_sharing/public/protocol/group_data.mojom-shared.h"
#include "mojo/public/mojom/base/absl_status.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/data_sharing/data_sharing.mojom-data-view.h"




namespace std {

template <>
struct hash<::data_sharing::mojom::GroupAction>
    : public mojo::internal::EnumHashImpl<::data_sharing::mojom::GroupAction> {};

template <>
struct hash<::data_sharing::mojom::GroupActionProgress>
    : public mojo::internal::EnumHashImpl<::data_sharing::mojom::GroupActionProgress> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::GroupAction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::data_sharing::mojom::GroupAction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::data_sharing::mojom::GroupAction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::GroupActionProgress, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::data_sharing::mojom::GroupActionProgress, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::data_sharing::mojom::GroupActionProgress>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::ReadGroupsParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupsParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupsParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::params(input)) in_params = Traits::params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->params)::BaseType>
        params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::ReadGroupParamsDataView>>(
      in_params,
      params_fragment,
      &params_validate_params);

    fragment->params.Set(
        params_fragment.is_null() ? nullptr : params_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->params.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in ReadGroupsParams struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::ReadGroupsParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::ReadGroupsParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::ReadGroupParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in ReadGroupParams struct");

    decltype(Traits::consistency_token(input)) in_consistency_token = Traits::consistency_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->consistency_token)::BaseType> consistency_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_consistency_token,
      consistency_token_fragment);

    fragment->consistency_token.Set(
        consistency_token_fragment.is_null() ? nullptr : consistency_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->consistency_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null consistency_token in ReadGroupParams struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::ReadGroupParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::ReadGroupParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::ReadGroupsResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupsResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupsResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::groups(input)) in_groups = Traits::groups(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->groups)::BaseType>
        groups_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>>(
      in_groups,
      groups_fragment,
      &groups_validate_params);

    fragment->groups.Set(
        groups_fragment.is_null() ? nullptr : groups_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->groups.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null groups in ReadGroupsResult struct");

    fragment->status_code = Traits::status_code(input);
  }

  static bool Deserialize(::data_sharing::mojom::internal::ReadGroupsResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::ReadGroupsResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::ReadGroupWithTokenParamDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupWithTokenParamDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupWithTokenParam_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in ReadGroupWithTokenParam struct");

    decltype(Traits::access_token(input)) in_access_token = Traits::access_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_token)::BaseType> access_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_access_token,
      access_token_fragment);

    fragment->access_token.Set(
        access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_token in ReadGroupWithTokenParam struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::ReadGroupWithTokenParam_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::ReadGroupWithTokenParamDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::ReadGroupWithTokenResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::ReadGroupWithTokenResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::ReadGroupWithTokenResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group(input)) in_group = Traits::group(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group)::BaseType> group_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::data_sharing::mojom::GroupDataDataView>(
      in_group,
      group_fragment);

    fragment->group.Set(
        group_fragment.is_null() ? nullptr : group_fragment.data());

    fragment->status_code = Traits::status_code(input);
  }

  static bool Deserialize(::data_sharing::mojom::internal::ReadGroupWithTokenResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::ReadGroupWithTokenResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::SharedTabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::SharedTabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::SharedTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::display_url(input)) in_display_url = Traits::display_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_url)::BaseType> display_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_url,
      display_url_fragment);

    fragment->display_url.Set(
        display_url_fragment.is_null() ? nullptr : display_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_url in SharedTab struct");

    decltype(Traits::favicon_url(input)) in_favicon_url = Traits::favicon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon_url)::BaseType> favicon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_favicon_url,
      favicon_url_fragment);

    fragment->favicon_url.Set(
        favicon_url_fragment.is_null() ? nullptr : favicon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon_url in SharedTab struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::SharedTab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::SharedTabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::GroupPreviewDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::GroupPreviewDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::GroupPreview_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in GroupPreview struct");

    decltype(Traits::shared_tabs(input)) in_shared_tabs = Traits::shared_tabs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_tabs)::BaseType>
        shared_tabs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& shared_tabs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::SharedTabDataView>>(
      in_shared_tabs,
      shared_tabs_fragment,
      &shared_tabs_validate_params);

    fragment->shared_tabs.Set(
        shared_tabs_fragment.is_null() ? nullptr : shared_tabs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->shared_tabs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null shared_tabs in GroupPreview struct");

    
    mojo::internal::Serialize<::mojo_base::mojom::AbslStatusCode>(
      Traits::status_code(input),
      &fragment->status_code);
  }

  static bool Deserialize(::data_sharing::mojom::internal::GroupPreview_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::GroupPreviewDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace data_sharing::mojom {

inline void ReadGroupsParamsDataView::GetParamsDataView(
    mojo::ArrayDataView<ReadGroupParamsDataView>* output) {
  auto pointer = data_->params.Get();
  *output = mojo::ArrayDataView<ReadGroupParamsDataView>(pointer, message_);
}


inline void ReadGroupParamsDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReadGroupParamsDataView::GetConsistencyTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->consistency_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReadGroupsResultDataView::GetGroupsDataView(
    mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>* output) {
  auto pointer = data_->groups.Get();
  *output = mojo::ArrayDataView<::data_sharing::mojom::GroupDataDataView>(pointer, message_);
}


inline void ReadGroupWithTokenParamDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ReadGroupWithTokenParamDataView::GetAccessTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->access_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ReadGroupWithTokenResultDataView::GetGroupDataView(
    ::data_sharing::mojom::GroupDataDataView* output) {
  auto pointer = data_->group.Get();
  *output = ::data_sharing::mojom::GroupDataDataView(pointer, message_);
}


inline void SharedTabDataView::GetDisplayUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SharedTabDataView::GetFaviconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->favicon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void GroupPreviewDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupPreviewDataView::GetSharedTabsDataView(
    mojo::ArrayDataView<SharedTabDataView>* output) {
  auto pointer = data_->shared_tabs.Get();
  *output = mojo::ArrayDataView<SharedTabDataView>(pointer, message_);
}



}  // data_sharing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::data_sharing::mojom::GroupAction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::data_sharing::mojom::GroupAction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::data_sharing::mojom::GroupActionProgress> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::data_sharing::mojom::GroupActionProgress value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_DATA_SHARING_DATA_SHARING_MOJOM_SHARED_H_