// chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/connectors_internals/connectors_internals.mojom-params-data.h"
namespace connectors_internals {
namespace mojom {

NOINLINE static const char* KeyManagerInitializedValueToStringHelper(KeyManagerInitializedValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyManagerInitializedValue::UNSUPPORTED:
      return "UNSUPPORTED";
    case KeyManagerInitializedValue::KEY_LOADED:
      return "KEY_LOADED";
    case KeyManagerInitializedValue::NO_KEY:
      return "NO_KEY";
    default:
      return nullptr;
  }
}

std::string KeyManagerInitializedValueToString(KeyManagerInitializedValue value) {
  const char *str = KeyManagerInitializedValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyManagerInitializedValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyManagerInitializedValue value) {
  return os << KeyManagerInitializedValueToString(value);
}

NOINLINE static const char* KeyTrustLevelToStringHelper(KeyTrustLevel value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyTrustLevel::UNSPECIFIED:
      return "UNSPECIFIED";
    case KeyTrustLevel::HW:
      return "HW";
    case KeyTrustLevel::OS:
      return "OS";
    case KeyTrustLevel::OS_SOFTWARE:
      return "OS_SOFTWARE";
    default:
      return nullptr;
  }
}

std::string KeyTrustLevelToString(KeyTrustLevel value) {
  const char *str = KeyTrustLevelToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyTrustLevel value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyTrustLevel value) {
  return os << KeyTrustLevelToString(value);
}

NOINLINE static const char* KeyTypeToStringHelper(KeyType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyType::UNKNOWN:
      return "UNKNOWN";
    case KeyType::RSA:
      return "RSA";
    case KeyType::EC:
      return "EC";
    default:
      return nullptr;
  }
}

std::string KeyTypeToString(KeyType value) {
  const char *str = KeyTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyType value) {
  return os << KeyTypeToString(value);
}

NOINLINE static const char* KeyManagerPermanentFailureToStringHelper(KeyManagerPermanentFailure value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case KeyManagerPermanentFailure::UNSPECIFIED:
      return "UNSPECIFIED";
    case KeyManagerPermanentFailure::CREATION_UPLOAD_CONFLICT:
      return "CREATION_UPLOAD_CONFLICT";
    case KeyManagerPermanentFailure::INSUFFICIENT_PERMISSIONS:
      return "INSUFFICIENT_PERMISSIONS";
    case KeyManagerPermanentFailure::OS_RESTRICTION:
      return "OS_RESTRICTION";
    case KeyManagerPermanentFailure::INVALID_INSTALLATION:
      return "INVALID_INSTALLATION";
    default:
      return nullptr;
  }
}

std::string KeyManagerPermanentFailureToString(KeyManagerPermanentFailure value) {
  const char *str = KeyManagerPermanentFailureToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown KeyManagerPermanentFailure value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, KeyManagerPermanentFailure value) {
  return os << KeyManagerPermanentFailureToString(value);
}

namespace internal {
// static
bool KeyUploadStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const KeyUploadStatus_Data* object = static_cast<const KeyUploadStatus_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case KeyUploadStatus_Tag::kSyncKeyResponseCode: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_sync_key_response_code, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_sync_key_response_code, validation_context))
        return false;
      return true;
    }
    case KeyUploadStatus_Tag::kUploadClientError: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_upload_client_error, 2, validation_context)) {
        return false;
      }
      constexpr const mojo::internal::ContainerValidateParams& upload_client_error_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      if (!mojo::internal::ValidateContainer(object->data.f_upload_client_error, validation_context,
                                             &upload_client_error_validate_params)) {
        return false;
      }
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in KeyUploadStatus");
      return false;
    }
  }
}


// static
bool Int32Value_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Int32Value_Data* object =
      static_cast<const Int32Value_Data*>(data);

  return true;
}

Int32Value_Data::Int32Value_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool LoadedKeyInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LoadedKeyInfo_Data* object =
      static_cast<const LoadedKeyInfo_Data*>(data);


  if (!::connectors_internals::mojom::internal::KeyTrustLevel_Data
        ::Validate(object->trust_level, validation_context))
    return false;


  if (!::connectors_internals::mojom::internal::KeyType_Data
        ::Validate(object->key_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoded_spki_hash, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& encoded_spki_hash_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->encoded_spki_hash, validation_context,
                                         &encoded_spki_hash_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnion(object->key_upload_status, validation_context))
    return false;

  return true;
}

LoadedKeyInfo_Data::LoadedKeyInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool KeyInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const KeyInfo_Data* object =
      static_cast<const KeyInfo_Data*>(data);


  if (!::connectors_internals::mojom::internal::KeyManagerInitializedValue_Data
        ::Validate(object->is_key_manager_initialized, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->loaded_key_info, validation_context))
    return false;


  if (!::connectors_internals::mojom::internal::KeyManagerPermanentFailure_Data
        ::Validate(object->permanent_failure, validation_context))
    return false;

  return true;
}

KeyInfo_Data::KeyInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ConsentMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ConsentMetadata_Data* object =
      static_cast<const ConsentMetadata_Data*>(data);

  return true;
}

ConsentMetadata_Data::ConsentMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceTrustState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceTrustState_Data* object =
      static_cast<const DeviceTrustState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_enabled_levels, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& policy_enabled_levels_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->policy_enabled_levels, validation_context,
                                         &policy_enabled_levels_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->key_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signals_json, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signals_json_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signals_json, validation_context,
                                         &signals_json_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->consent_metadata, validation_context))
    return false;

  return true;
}

DeviceTrustState_Data::DeviceTrustState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertificateMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertificateMetadata_Data* object =
      static_cast<const CertificateMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serial_number, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& serial_number_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serial_number, validation_context,
                                         &serial_number_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fingerprint, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fingerprint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fingerprint, validation_context,
                                         &fingerprint_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_date_string, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& creation_date_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->creation_date_string, validation_context,
                                         &creation_date_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration_date_string, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& expiration_date_string_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->expiration_date_string, validation_context,
                                         &expiration_date_string_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subject_display_name, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subject_display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subject_display_name, validation_context,
                                         &subject_display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuer_display_name, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issuer_display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->issuer_display_name, validation_context,
                                         &issuer_display_name_validate_params)) {
    return false;
  }

  return true;
}

CertificateMetadata_Data::CertificateMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientIdentity_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientIdentity_Data* object =
      static_cast<const ClientIdentity_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identity_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& identity_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->identity_name, validation_context,
                                         &identity_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->loaded_key_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->certificate_metadata, validation_context))
    return false;

  return true;
}

ClientIdentity_Data::ClientIdentity_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClientCertificateState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClientCertificateState_Data* object =
      static_cast<const ClientCertificateState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->policy_enabled_levels, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& policy_enabled_levels_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->policy_enabled_levels, validation_context,
                                         &policy_enabled_levels_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->managed_profile_identity, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->managed_browser_identity, validation_context))
    return false;

  return true;
}

ClientCertificateState_Data::ClientCertificateState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignalsReportingState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignalsReportingState_Data* object =
      static_cast<const SignalsReportingState_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_info, validation_context,
                                         &error_info_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_upload_attempt_timestamp, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_upload_attempt_timestamp_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_upload_attempt_timestamp, validation_context,
                                         &last_upload_attempt_timestamp_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_upload_success_timestamp, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_upload_success_timestamp_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_upload_success_timestamp, validation_context,
                                         &last_upload_success_timestamp_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_signals_upload_config, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& last_signals_upload_config_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->last_signals_upload_config, validation_context,
                                         &last_signals_upload_config_validate_params)) {
    return false;
  }

  return true;
}

SignalsReportingState_Data::SignalsReportingState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDeviceTrustState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDeviceTrustState_Params_Data* object =
      static_cast<const PageHandler_GetDeviceTrustState_Params_Data*>(data);

  return true;
}

PageHandler_GetDeviceTrustState_Params_Data::PageHandler_GetDeviceTrustState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetDeviceTrustState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetDeviceTrustState_ResponseParams_Data* object =
      static_cast<const PageHandler_GetDeviceTrustState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

PageHandler_GetDeviceTrustState_ResponseParams_Data::PageHandler_GetDeviceTrustState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteDeviceTrustKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteDeviceTrustKey_Params_Data* object =
      static_cast<const PageHandler_DeleteDeviceTrustKey_Params_Data*>(data);

  return true;
}

PageHandler_DeleteDeviceTrustKey_Params_Data::PageHandler_DeleteDeviceTrustKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_DeleteDeviceTrustKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_DeleteDeviceTrustKey_ResponseParams_Data* object =
      static_cast<const PageHandler_DeleteDeviceTrustKey_ResponseParams_Data*>(data);

  return true;
}

PageHandler_DeleteDeviceTrustKey_ResponseParams_Data::PageHandler_DeleteDeviceTrustKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetClientCertificateState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetClientCertificateState_Params_Data* object =
      static_cast<const PageHandler_GetClientCertificateState_Params_Data*>(data);

  return true;
}

PageHandler_GetClientCertificateState_Params_Data::PageHandler_GetClientCertificateState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetClientCertificateState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetClientCertificateState_ResponseParams_Data* object =
      static_cast<const PageHandler_GetClientCertificateState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

PageHandler_GetClientCertificateState_ResponseParams_Data::PageHandler_GetClientCertificateState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetSignalsReportingState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetSignalsReportingState_Params_Data* object =
      static_cast<const PageHandler_GetSignalsReportingState_Params_Data*>(data);

  return true;
}

PageHandler_GetSignalsReportingState_Params_Data::PageHandler_GetSignalsReportingState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_GetSignalsReportingState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_GetSignalsReportingState_ResponseParams_Data* object =
      static_cast<const PageHandler_GetSignalsReportingState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

PageHandler_GetSignalsReportingState_ResponseParams_Data::PageHandler_GetSignalsReportingState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace connectors_internals

namespace perfetto {

// static
void TraceFormatTraits<::connectors_internals::mojom::KeyManagerInitializedValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::connectors_internals::mojom::KeyManagerInitializedValue value) {
  return std::move(context).WriteString(::connectors_internals::mojom::KeyManagerInitializedValueToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::connectors_internals::mojom::KeyTrustLevel>::WriteIntoTrace(
   perfetto::TracedValue context, ::connectors_internals::mojom::KeyTrustLevel value) {
  return std::move(context).WriteString(::connectors_internals::mojom::KeyTrustLevelToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::connectors_internals::mojom::KeyType>::WriteIntoTrace(
   perfetto::TracedValue context, ::connectors_internals::mojom::KeyType value) {
  return std::move(context).WriteString(::connectors_internals::mojom::KeyTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::connectors_internals::mojom::KeyManagerPermanentFailure>::WriteIntoTrace(
   perfetto::TracedValue context, ::connectors_internals::mojom::KeyManagerPermanentFailure value) {
  return std::move(context).WriteString(::connectors_internals::mojom::KeyManagerPermanentFailureToString(value));
}

} // namespace perfetto