// chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-shared-internal.h"


namespace mojom::app_service_internals {
class AppInfoDataView;

class PreferredAppInfoDataView;

class PromiseAppInfoDataView;

class AppCapabilityInfoDataView;

class DebugInfoDataView;



}  // mojom::app_service_internals


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::app_service_internals::AppInfoDataView> {
  using Data = ::mojom::app_service_internals::internal::AppInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::app_service_internals::PreferredAppInfoDataView> {
  using Data = ::mojom::app_service_internals::internal::PreferredAppInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::app_service_internals::PromiseAppInfoDataView> {
  using Data = ::mojom::app_service_internals::internal::PromiseAppInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::app_service_internals::AppCapabilityInfoDataView> {
  using Data = ::mojom::app_service_internals::internal::AppCapabilityInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::app_service_internals::DebugInfoDataView> {
  using Data = ::mojom::app_service_internals::internal::DebugInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom::app_service_internals {
// Interface base classes. They are used for type safety check.
class AppServiceInternalsPageHandlerInterfaceBase {};

using AppServiceInternalsPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<AppServiceInternalsPageHandlerInterfaceBase>;
using AppServiceInternalsPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<AppServiceInternalsPageHandlerInterfaceBase>;
using AppServiceInternalsPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AppServiceInternalsPageHandlerInterfaceBase>;
using AppServiceInternalsPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AppServiceInternalsPageHandlerInterfaceBase>;


class AppInfoDataView {
 public:
  AppInfoDataView() = default;

  AppInfoDataView(
      internal::AppInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDebugInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugInfo(UserType* output) {
    
    auto* pointer = data_->debug_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PreferredAppInfoDataView {
 public:
  PreferredAppInfoDataView() = default;

  PreferredAppInfoDataView(
      internal::PreferredAppInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPreferredFiltersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreferredFilters(UserType* output) {
    
    auto* pointer = data_->preferred_filters.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PreferredAppInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PromiseAppInfoDataView {
 public:
  PromiseAppInfoDataView() = default;

  PromiseAppInfoDataView(
      internal::PromiseAppInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPackageIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackageId(UserType* output) {
    
    auto* pointer = data_->package_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDebugInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugInfo(UserType* output) {
    
    auto* pointer = data_->debug_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PromiseAppInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AppCapabilityInfoDataView {
 public:
  AppCapabilityInfoDataView() = default;

  AppCapabilityInfoDataView(
      internal::AppCapabilityInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDebugInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugInfo(UserType* output) {
    
    auto* pointer = data_->debug_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AppCapabilityInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DebugInfoDataView {
 public:
  DebugInfoDataView() = default;

  DebugInfoDataView(
      internal::DebugInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAppListDataView(
      mojo::ArrayDataView<AppInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppList(UserType* output) {
    
    auto* pointer = data_->app_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::app_service_internals::AppInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPreferredAppListDataView(
      mojo::ArrayDataView<PreferredAppInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPreferredAppList(UserType* output) {
    
    auto* pointer = data_->preferred_app_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::app_service_internals::PreferredAppInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetPromiseAppListDataView(
      mojo::ArrayDataView<PromiseAppInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPromiseAppList(UserType* output) {
    
    auto* pointer = data_->promise_app_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::app_service_internals::PromiseAppInfoDataView>>(
        pointer, output, message_);
  }
  inline void GetAppCapabilityListDataView(
      mojo::ArrayDataView<AppCapabilityInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAppCapabilityList(UserType* output) {
    
    auto* pointer = data_->app_capability_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::app_service_internals::AppCapabilityInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DebugInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojom::app_service_internals

#endif  // CHROME_BROWSER_UI_WEBUI_APP_SERVICE_INTERNALS_APP_SERVICE_INTERNALS_MOJOM_DATA_VIEW_H_