// chrome/browser/ui/webui/app_home/app_home.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "chrome/browser/web_applications/mojom/user_display_mode.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/app_home/app_home.mojom-data-view.h"




namespace std {

template <>
struct hash<::app_home::mojom::RunOnOsLoginMode>
    : public mojo::internal::EnumHashImpl<::app_home::mojom::RunOnOsLoginMode> {};

template <>
struct hash<::app_home::mojom::AppType>
    : public mojo::internal::EnumHashImpl<::app_home::mojom::AppType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_home::mojom::RunOnOsLoginMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_home::mojom::RunOnOsLoginMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_home::mojom::RunOnOsLoginMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_home::mojom::AppType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::app_home::mojom::AppType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::app_home::mojom::AppType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_home::mojom::AppInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_home::mojom::AppInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_home::mojom::internal::AppInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::app_home::mojom::AppType>(
      Traits::app_type(input),
      &fragment->app_type);

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in AppInfo struct");

    decltype(Traits::start_url(input)) in_start_url = Traits::start_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_url)::BaseType> start_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_start_url,
      start_url_fragment);

    fragment->start_url.Set(
        start_url_fragment.is_null() ? nullptr : start_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->start_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_url in AppInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in AppInfo struct");

    decltype(Traits::icon_url(input)) in_icon_url = Traits::icon_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_url)::BaseType> icon_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon_url,
      icon_url_fragment);

    fragment->icon_url.Set(
        icon_url_fragment.is_null() ? nullptr : icon_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon_url in AppInfo struct");

    fragment->may_show_run_on_os_login_mode = Traits::may_show_run_on_os_login_mode(input);

    fragment->may_toggle_run_on_os_login_mode = Traits::may_toggle_run_on_os_login_mode(input);

    
    mojo::internal::Serialize<::app_home::mojom::RunOnOsLoginMode>(
      Traits::run_on_os_login_mode(input),
      &fragment->run_on_os_login_mode);

    fragment->is_locally_installed = Traits::is_locally_installed(input);

    fragment->open_in_window = Traits::open_in_window(input);

    fragment->may_uninstall = Traits::may_uninstall(input);

    decltype(Traits::store_page_url(input)) in_store_page_url = Traits::store_page_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->store_page_url)::BaseType> store_page_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_store_page_url,
      store_page_url_fragment);

    fragment->store_page_url.Set(
        store_page_url_fragment.is_null() ? nullptr : store_page_url_fragment.data());
  }

  static bool Deserialize(::app_home::mojom::internal::AppInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_home::mojom::AppInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::app_home::mojom::ClickEventDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::app_home::mojom::ClickEventDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::app_home::mojom::internal::ClickEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->button = Traits::button(input);

    fragment->alt_key = Traits::alt_key(input);

    fragment->ctrl_key = Traits::ctrl_key(input);

    fragment->meta_key = Traits::meta_key(input);

    fragment->shift_key = Traits::shift_key(input);
  }

  static bool Deserialize(::app_home::mojom::internal::ClickEvent_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::app_home::mojom::ClickEventDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace app_home::mojom {

inline void AppInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppInfoDataView::GetStartUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->start_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AppInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AppInfoDataView::GetIconUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AppInfoDataView::GetStorePageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->store_page_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}





}  // app_home::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_home::mojom::RunOnOsLoginMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_home::mojom::RunOnOsLoginMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::app_home::mojom::AppType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::app_home::mojom::AppType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_SHARED_H_