// chrome/browser/ui/webui/actor_internals/actor_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/actor_internals/actor_internals.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace actor_internals::mojom {
class JournalEntryDataView;



}  // actor_internals::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::actor_internals::mojom::JournalEntryDataView> {
  using Data = ::actor_internals::mojom::internal::JournalEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace actor_internals::mojom {
// Interface base classes. They are used for type safety check.
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;


class JournalEntryDataView {
 public:
  JournalEntryDataView() = default;

  JournalEntryDataView(
      internal::JournalEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEventDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEvent(UserType* output) {
    
    auto* pointer = data_->event.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDetailsDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetails(UserType* output) {
    
    auto* pointer = data_->details.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::JSTimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::JSTimeDataView>(
        pointer, output, message_);
  }
  int32_t task_id() const {
    return data_->task_id;
  }
  inline void GetTrackDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrack(UserType* output) {
    
    auto* pointer = data_->track.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetScreenshotDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScreenshot(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `screenshot` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScreenshot` instead "
    "of `ReadScreenshot if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->screenshot.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::JournalEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // actor_internals::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_DATA_VIEW_H_