// chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-shared-internal.h"
#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_types.mojom-shared.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "components/tab_groups/public/mojom/tab_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "chrome/browser/ui/tabs/tab_strip_api/tab_strip_api_data_model.mojom-data-view.h"




namespace std {

template <>
struct hash<::tabs_api::mojom::SplitTabVisualData_Layout>
    : public mojo::internal::EnumHashImpl<::tabs_api::mojom::SplitTabVisualData_Layout> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::SplitTabVisualData_Layout, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::tabs_api::mojom::SplitTabVisualData_Layout, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::tabs_api::mojom::SplitTabVisualData_Layout>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::ImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::ImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Image_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data_url(input)) in_data_url = Traits::data_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_url)::BaseType> data_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_data_url,
      data_url_fragment);

    fragment->data_url.Set(
        data_url_fragment.is_null() ? nullptr : data_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data_url in Image struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::Image_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::ImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Tab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in Tab struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Tab struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in Tab struct");

    decltype(Traits::favicon(input)) in_favicon = Traits::favicon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->favicon)::BaseType> favicon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::ImageDataView>(
      in_favicon,
      favicon_fragment);

    fragment->favicon.Set(
        favicon_fragment.is_null() ? nullptr : favicon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->favicon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null favicon in Tab struct");

    decltype(Traits::alert_states(input)) in_alert_states = Traits::alert_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->alert_states)::BaseType>
        alert_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& alert_states_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::tabs::mojom::internal::TabAlertState_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
      in_alert_states,
      alert_states_fragment,
      &alert_states_validate_params);

    fragment->alert_states.Set(
        alert_states_fragment.is_null() ? nullptr : alert_states_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->alert_states.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null alert_states in Tab struct");

    
    mojo::internal::Serialize<::tabs::mojom::TabNetworkState>(
      Traits::network_state(input),
      &fragment->network_state);

    fragment->is_active = Traits::is_active(input);

    fragment->is_selected = Traits::is_selected(input);

    fragment->is_blocked = Traits::is_blocked(input);
  }

  static bool Deserialize(::tabs_api::mojom::internal::Tab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabStripDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabStripDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabStrip_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabStrip struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabStrip_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabStripDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::PinnedTabsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::PinnedTabsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::PinnedTabs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in PinnedTabs struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::PinnedTabs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::PinnedTabsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::UnpinnedTabsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::UnpinnedTabsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::UnpinnedTabs_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in UnpinnedTabs struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::UnpinnedTabs_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::UnpinnedTabsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in TabGroup struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::TabGroupVisualDataDataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in TabGroup struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabGroupVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabGroupVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabGroupVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in TabGroupVisualData struct");

    
    mojo::internal::Serialize<::tab_groups::mojom::Color>(
      Traits::color(input),
      &fragment->color);

    fragment->is_collapsed = Traits::is_collapsed(input);
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabGroupVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabGroupVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::SplitTabDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::SplitTabDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::SplitTab_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::NodeIdDataView>(
      in_id,
      id_fragment);

    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null id in SplitTab struct");

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::SplitTabVisualDataDataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SplitTab struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::SplitTab_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::SplitTabDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::SplitTabVisualDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::SplitTabVisualDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::SplitTabVisualData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::tabs_api::mojom::SplitTabVisualData_Layout>(
      Traits::layout(input),
      &fragment->layout);

    fragment->split_ratio = Traits::split_ratio(input);
  }

  static bool Deserialize(::tabs_api::mojom::internal::SplitTabVisualData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::SplitTabVisualDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::ContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::ContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::Container_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    
    mojo::internal::Serialize<::tabs_api::mojom::DataDataView>(
      in_data,
      data_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in Container struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::tabs_api::mojom::ContainerDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in Container struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::Container_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::ContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::TabCreatedContainerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::tabs_api::mojom::TabCreatedContainerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::tabs_api::mojom::internal::TabCreatedContainer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::tab(input)) in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab)::BaseType> tab_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::TabDataView>(
      in_tab,
      tab_fragment);

    fragment->tab.Set(
        tab_fragment.is_null() ? nullptr : tab_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->tab.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tab in TabCreatedContainer struct");

    decltype(Traits::position(input)) in_position = Traits::position(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->position)::BaseType> position_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::tabs_api::mojom::PositionDataView>(
      in_position,
      position_fragment);

    fragment->position.Set(
        position_fragment.is_null() ? nullptr : position_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->position.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null position in TabCreatedContainer struct");
  }

  static bool Deserialize(::tabs_api::mojom::internal::TabCreatedContainer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::TabCreatedContainerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::tabs_api::mojom::DataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::tabs_api::mojom::DataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::tabs_api::mojom::internal::Data_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::tabs_api::mojom::DataDataView::Tag::kTab: {
    decltype(Traits::tab(input))
    in_tab = Traits::tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabDataView>(
  in_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab in Data union");
    fragment->data.f_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kTabStrip: {
    decltype(Traits::tab_strip(input))
    in_tab_strip = Traits::tab_strip(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_strip)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabStripDataView>(
  in_tab_strip,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_strip in Data union");
    fragment->data.f_tab_strip.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kPinnedTabs: {
    decltype(Traits::pinned_tabs(input))
    in_pinned_tabs = Traits::pinned_tabs(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_pinned_tabs)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::PinnedTabsDataView>(
  in_pinned_tabs,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null pinned_tabs in Data union");
    fragment->data.f_pinned_tabs.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kUnpinnedTabs: {
    decltype(Traits::unpinned_tabs(input))
    in_unpinned_tabs = Traits::unpinned_tabs(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_unpinned_tabs)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::UnpinnedTabsDataView>(
  in_unpinned_tabs,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null unpinned_tabs in Data union");
    fragment->data.f_unpinned_tabs.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kTabGroup: {
    decltype(Traits::tab_group(input))
    in_tab_group = Traits::tab_group(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_tab_group)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::TabGroupDataView>(
  in_tab_group,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null tab_group in Data union");
    fragment->data.f_tab_group.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::tabs_api::mojom::DataDataView::Tag::kSplitTab: {
    decltype(Traits::split_tab(input))
    in_split_tab = Traits::split_tab(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_split_tab)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::tabs_api::mojom::SplitTabDataView>(
  in_split_tab,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null split_tab in Data union");
    fragment->data.f_split_tab.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::tabs_api::mojom::internal::Data_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::tabs_api::mojom::DataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace tabs_api::mojom {

inline void ImageDataView::GetDataUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->data_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void TabDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}
inline void TabDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TabDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void TabDataView::GetFaviconDataView(
    ImageDataView* output) {
  auto pointer = data_->favicon.Get();
  *output = ImageDataView(pointer, message_);
}
inline void TabDataView::GetAlertStatesDataView(
    mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output) {
  auto pointer = data_->alert_states.Get();
  *output = mojo::ArrayDataView<::tabs::mojom::TabAlertState>(pointer, message_);
}


inline void TabStripDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}


inline void PinnedTabsDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}


inline void UnpinnedTabsDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}


inline void TabGroupDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}
inline void TabGroupDataView::GetDataDataView(
    TabGroupVisualDataDataView* output) {
  auto pointer = data_->data.Get();
  *output = TabGroupVisualDataDataView(pointer, message_);
}


inline void TabGroupVisualDataDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SplitTabDataView::GetIdDataView(
    ::tabs_api::mojom::NodeIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = ::tabs_api::mojom::NodeIdDataView(pointer, message_);
}
inline void SplitTabDataView::GetDataDataView(
    SplitTabVisualDataDataView* output) {
  auto pointer = data_->data.Get();
  *output = SplitTabVisualDataDataView(pointer, message_);
}




inline void ContainerDataView::GetDataDataView(
    DataDataView* output) {
  auto pointer = &data_->data;
  *output = DataDataView(pointer, message_);
}
inline void ContainerDataView::GetChildrenDataView(
    mojo::ArrayDataView<ContainerDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<ContainerDataView>(pointer, message_);
}


inline void TabCreatedContainerDataView::GetTabDataView(
    TabDataView* output) {
  auto pointer = data_->tab.Get();
  *output = TabDataView(pointer, message_);
}
inline void TabCreatedContainerDataView::GetPositionDataView(
    ::tabs_api::mojom::PositionDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::tabs_api::mojom::PositionDataView(pointer, message_);
}


inline void DataDataView::GetTabDataView(
    TabDataView* output) const {
  CHECK(is_tab());
  *output = TabDataView(data_->data.f_tab.Get(), message_);
}
inline void DataDataView::GetTabStripDataView(
    TabStripDataView* output) const {
  CHECK(is_tab_strip());
  *output = TabStripDataView(data_->data.f_tab_strip.Get(), message_);
}
inline void DataDataView::GetPinnedTabsDataView(
    PinnedTabsDataView* output) const {
  CHECK(is_pinned_tabs());
  *output = PinnedTabsDataView(data_->data.f_pinned_tabs.Get(), message_);
}
inline void DataDataView::GetUnpinnedTabsDataView(
    UnpinnedTabsDataView* output) const {
  CHECK(is_unpinned_tabs());
  *output = UnpinnedTabsDataView(data_->data.f_unpinned_tabs.Get(), message_);
}
inline void DataDataView::GetTabGroupDataView(
    TabGroupDataView* output) const {
  CHECK(is_tab_group());
  *output = TabGroupDataView(data_->data.f_tab_group.Get(), message_);
}
inline void DataDataView::GetSplitTabDataView(
    SplitTabDataView* output) const {
  CHECK(is_split_tab());
  *output = SplitTabDataView(data_->data.f_split_tab.Get(), message_);
}


}  // tabs_api::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::tabs_api::mojom::SplitTabVisualData_Layout> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::tabs_api::mojom::SplitTabVisualData_Layout value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_TABS_TAB_STRIP_API_TAB_STRIP_API_DATA_MODEL_MOJOM_SHARED_H_