// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import '//resources/cr_elements/cr_icon/cr_iconset.js';

import {getTrustedHTML} from '//resources/js/static_types.js';

const div = document.createElement('div');
div.innerHTML = getTrustedHTML`
<cr-iconset name="webui-browser">
  <svg>
    <defs>
      <g id="folder"><path d="M4 20c-.55 0-1.02-.195-1.414-.586A1.935 1.935 0 0 1 2 18V6c0-.55.195-1.02.586-1.414C2.98 4.196 3.449 4 4 4h6l2 2h8c.55 0 1.02.195 1.414.586.39.394.586.863.586 1.414v10c0 .55-.195 1.02-.586 1.414-.394.39-.863.586-1.414.586Zm0-2h16V8h-8.824l-2-2H4Zm0 0V6Zm0 0"/></g>
      <g id="minimize"><path d="M 5 12 L 19 12" /></g>
      <g id="maximize"><rect x="5" y="5" width="14" height="14" /></g>
      <g id="restore">
        <rect x="7" y="3" width="14" height="14" rx="2" />
        <path d="M3 7h14" />
        <path d="M3 7v14a2 2 0 0 0 2 2h14" fill="none"/>
      </g>
      <g id="close">
        <line x1="18" y1="6" x2="6" y2="18" />
        <line x1="6" y1="6" x2="18" y2="18" />
      </g>
      <g id="HttpChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 7.34 11.26 h 1.32 V 7.2 H 7.34 Z m 0.66 -5.18 a 0.66 0.66 0 0 0 0.48 -0.19 a 0.66 0.66 0 0 0 0.2 -0.48 a 0.67 0.67 0 0 0 -0.2 -0.48 a 0.64 0.64 0 0 0 -0.48 -0.2 a 0.66 0.66 0 0 0 -0.48 0.2 a 0.64 0.64 0 0 0 -0.2 0.48 c 0 0.2 0.07 0.36 0.2 0.49 a 0.64 0.64 0 0 0 0.48 0.2 Z m 0.01 8.46 c -0.9 0 -1.75 -0.17 -2.54 -0.51 a 6.52 6.52 0 0 1 -2.08 -1.4 a 6.52 6.52 0 0 1 -1.4 -2.08 a 6.33 6.33 0 0 1 -0.51 -2.55 c 0 -0.91 0.17 -1.75 0.51 -2.54 A 6.53 6.53 0 0 1 3.38 3.38 A 6.52 6.52 0 0 1 5.46 1.98 a 6.33 6.33 0 0 1 2.55 -0.51 c 0.91 0 1.75 0.17 2.54 0.51 c 0.79 0.34 1.48 0.8 2.07 1.4 a 6.5 6.5 0 0 1 1.4 2.08 a 6.29 6.29 0 0 1 0.51 2.54 c 0 0.9 -0.17 1.75 -0.51 2.54 a 6.52 6.52 0 0 1 -1.4 2.08 a 6.5 6.5 0 0 1 -2.08 1.4 a 6.29 6.29 0 0 1 -2.54 0.51 Z M 8 13.15 c 1.43 0 2.65 -0.5 3.65 -1.5 c 1 -1 1.5 -2.22 1.5 -3.65 c 0 -1.43 -0.5 -2.65 -1.5 -3.65 S 9.43 2.85 8 2.85 c -1.43 0 -2.65 0.5 -3.65 1.5 S 2.85 6.57 2.85 8 c 0 1.43 0.5 2.65 1.5 3.65 c 1 1 2.22 1.5 3.65 1.5 Z"/>
      </g>
      <g id="SecurePageInfoChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 11.66 13.77 c -0.69 0 -1.28 -0.24 -1.75 -0.71 a 2.38 2.38 0 0 1 -0.72 -1.75 c 0 -0.69 0.24 -1.28 0.72 -1.75 c 0.48 -0.48 1.06 -0.72 1.75 -0.72 c 0.69 0 1.27 0.24 1.75 0.72 a 2.39 2.39 0 0 1 0.72 1.75 c 0 0.69 -0.24 1.27 -0.72 1.75 a 2.39 2.39 0 0 1 -1.75 0.71 Z m 0 -1.34 c 0.31 0 0.58 -0.11 0.8 -0.33 a 1.1 1.1 0 0 0 0.33 -0.8 c 0 -0.31 -0.11 -0.58 -0.33 -0.8 a 1.09 1.09 0 0 0 -0.8 -0.33 c -0.31 0 -0.58 0.11 -0.8 0.33 a 1.09 1.09 0 0 0 -0.33 0.8 c 0 0.31 0.11 0.58 0.33 0.8 c 0.22 0.22 0.49 0.33 0.8 0.33 Z m -9.16 -0.44 v -1.38 h 5.49 v 1.38 Z m 1.83 -4.83 a 2.38 2.38 0 0 1 -1.75 -0.72 a 2.39 2.39 0 0 1 -0.72 -1.75 c 0 -0.69 0.24 -1.27 0.72 -1.75 a 2.39 2.39 0 0 1 1.75 -0.71 c 0.69 0 1.28 0.24 1.75 0.71 c 0.48 0.48 0.72 1.06 0.72 1.75 c 0 0.69 -0.24 1.28 -0.72 1.75 c -0.48 0.48 -1.06 0.72 -1.75 0.72 Z m 0 -1.34 c 0.31 0 0.58 -0.11 0.8 -0.33 c 0.22 -0.22 0.33 -0.48 0.33 -0.8 c 0 -0.31 -0.11 -0.58 -0.33 -0.8 a 1.1 1.1 0 0 0 -0.8 -0.33 c -0.31 0 -0.58 0.11 -0.8 0.33 a 1.1 1.1 0 0 0 -0.33 0.8 c 0 0.31 0.11 0.58 0.33 0.8 c 0.22 0.22 0.49 0.33 0.8 0.33 Z m 3.67 -0.44 V 4 h 5.49 v 1.38 Z m 3.66 5.92 Z m -7.33 -6.61 Z"/>
      </g>
      <g id="NoEncryptionIcon" viewBox="0 0 16 16">
        <path d="M 12.93 11.06 L 11.55 9.67 V 6.84 H 8.72 L 7.34 5.45 h 2.54 V 3.97 c 0 -0.52 -0.18 -0.97 -0.54 -1.34 a 1.81 1.81 0 0 0 -1.34 -0.55 a 1.82 1.82 0 0 0 -1.34 0.55 a 1.81 1.81 0 0 0 -0.55 1.33 v 0.27 L 4.92 3.04 A 3.15 3.15 0 0 1 8 0.7 c 0.91 0 1.68 0.32 2.31 0.95 c 0.63 0.63 0.95 1.4 0.95 2.31 v 1.5 h 0.29 c 0.38 0 0.71 0.13 0.98 0.41 c 0.27 0.27 0.4 0.59 0.4 0.98 Z m 0.53 4.09 l -0.98 -0.99 a 1.49 1.49 0 0 1 -0.4 0.25 a 1.23 1.23 0 0 1 -0.53 0.11 H 4.44 a 1.35 1.35 0 0 1 -0.98 -0.4 a 1.26 1.26 0 0 1 -0.39 -0.98 V 6.84 c 0 -0.3 0.08 -0.56 0.24 -0.79 c 0.16 -0.23 0.36 -0.39 0.59 -0.48 L 0.93 2.61 l 0.89 -0.89 l 12.53 12.55 Z m -2.01 -2.01 l -2.49 -2.48 a 1.05 1.05 0 0 1 -0.41 0.39 a 1.18 1.18 0 0 1 -1.4 -0.21 a 1.16 1.16 0 0 1 -0.35 -0.85 c 0 -0.19 0.04 -0.37 0.13 -0.54 c 0.08 -0.17 0.22 -0.32 0.39 -0.44 L 5.16 6.84 H 4.45 v 6.31 Z M 8.14 9.82 Z m 1.94 -1.62 Z"/>
      </g>
      <g id="NotSecureWarningChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 0.68 13.67 L 8 1.47 l 7.32 12.2 Z m 2.33 -1.32 h 9.97 L 8 4.05 Z m 4.98 -0.75 c 0.17 0 0.32 -0.06 0.44 -0.18 a 0.6 0.6 0 0 0 0.18 -0.44 a 0.62 0.62 0 0 0 -0.62 -0.62 a 0.6 0.6 0 0 0 -0.44 0.18 a 0.58 0.58 0 0 0 -0.18 0.43 a 0.62 0.62 0 0 0 0.62 0.63 Z m -0.6 -1.99 h 1.2 V 6.45 H 7.4 Z M 8 8.2 Z"/>
      </g>
      <g id="BusinessChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 1.48 13.79 V 2.34 h 6.65 v 2.4 h 6.4 v 9.05 Z M 2.8 12.46 H 4 v -1.2 H 2.8 Z m 0 -2.53 H 4 v -1.2 H 2.8 Z m 0 -2.53 H 4 V 6.19 H 2.8 Z m 0 -2.54 H 4 V 3.66 H 2.8 Z m 2.8 7.6 h 1.2 v -1.2 H 5.6 Z m 0 -2.53 h 1.2 v -1.2 H 5.6 Z m 0 -2.53 h 1.2 V 6.19 H 5.6 Z m 0 -2.54 h 1.2 V 3.66 H 5.6 Z M 8 12.46 h 5.2 V 6.06 H 8 v 1.34 h 1.2 v 1.2 H 8 v 1.33 h 1.2 v 1.2 H 8 Z m 2.8 -3.87 v -1.2 H 12 v 1.2 Z m 0 2.53 v -1.2 H 12 v 1.2 Z"/>
      </g>
      <g id="DangerousChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 7.11 17 L 3 12.88 L 3 7.11 L 7.11 3 L 12.89 3 L 17 7.11 L 17 12.89 L 12.88 17 Z M 7.77 13.27 L 10 11.06 L 12.23 13.27 L 13.27 12.23 L 11.06 10 L 13.27 7.77 L 12.23 6.73 L 10 8.94 L 7.77 6.73 L 6.73 7.77 L 8.94 10 L 6.73 12.23 Z"/>
      </g>
      <g id="ProductChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 4.92 7.5 c 0 0.71 0.25 1.31 0.76 1.82 c 0.51 0.51 1.12 0.76 1.82 0.76 c 0.7 0 1.31 -0.25 1.82 -0.76 c 0.51 -0.51 0.76 -1.12 0.76 -1.82 c 0 -0.7 -0.25 -1.31 -0.76 -1.82 a 2.49 2.49 0 0 0 -1.82 -0.76 c -0.7 0 -1.31 0.25 -1.82 0.76 a 2.49 2.49 0 0 0 -0.76 1.82 Z M 7.5 11.48 c 0.14 0 0.28 0 0.41 -0.02 c 0.13 -0.01 0.26 -0.04 0.39 -0.07 L 6.77 14.06 c -1.65 -0.19 -3.04 -0.89 -4.15 -2.12 C 1.5 10.71 0.94 9.24 0.94 7.55 c 0 -0.46 0.05 -0.9 0.13 -1.33 c 0.08 -0.44 0.22 -0.85 0.39 -1.25 l 2.63 4.55 c 0.34 0.59 0.81 1.07 1.41 1.43 c 0.6 0.36 1.26 0.54 2.01 0.54 Z m 0 -7.87 c -0.87 0 -1.65 0.25 -2.33 0.77 a 3.95 3.95 0 0 0 -1.42 1.94 L 2.21 3.66 a 6.79 6.79 0 0 1 2.27 -1.94 C 5.4 1.22 6.4 0.98 7.5 0.98 c 1.1 0 2.08 0.24 2.99 0.72 A 6.66 6.66 0 0 1 12.76 3.6 H 7.51 l -0.01 0.01 Z m 6.01 1.31 c 0.19 0.4 0.32 0.83 0.41 1.27 c 0.09 0.44 0.15 0.89 0.15 1.36 c 0 1.7 -0.55 3.16 -1.68 4.38 c -1.11 1.23 -2.47 1.93 -4.1 2.13 l 2.63 -4.55 c 0.17 -0.28 0.29 -0.59 0.38 -0.92 c 0.09 -0.34 0.15 -0.69 0.15 -1.05 c 0 -0.52 -0.09 -0.99 -0.28 -1.42 a 3.96 3.96 0 0 0 -0.74 -1.2 h 3.08 v 0.01 Z"/>
      </g>
      <g id="ExtensionChromeRefreshIcon" viewBox="0 0 16 16">
        <path d="M 3.6 13.73 c -0.37 0 -0.69 -0.13 -0.95 -0.39 a 1.28 1.28 0 0 1 -0.39 -0.95 v -2.87 c 0.42 -0.02 0.77 -0.18 1.05 -0.47 A 1.46 1.46 0 0 0 3.75 8 c 0 -0.41 -0.14 -0.76 -0.43 -1.05 a 1.51 1.51 0 0 0 -1.05 -0.47 V 3.6 c 0 -0.37 0.13 -0.69 0.39 -0.95 c 0.26 -0.26 0.57 -0.39 0.95 -0.39 h 2.68 c 0.03 -0.46 0.21 -0.84 0.53 -1.16 a 1.63 1.63 0 0 1 1.18 -0.47 c 0.46 0 0.86 0.16 1.18 0.47 c 0.33 0.31 0.51 0.7 0.54 1.16 h 2.68 c 0.37 0 0.69 0.13 0.95 0.39 c 0.26 0.26 0.39 0.57 0.39 0.95 v 2.68 c 0.46 0.03 0.84 0.21 1.16 0.53 c 0.32 0.33 0.47 0.72 0.47 1.18 c 0 0.46 -0.16 0.86 -0.47 1.18 c -0.31 0.33 -0.7 0.51 -1.16 0.54 v 2.68 c 0 0.37 -0.13 0.69 -0.39 0.95 c -0.26 0.26 -0.57 0.39 -0.95 0.39 Z m 0.05 -1.38 h 8.7 V 3.65 H 3.65 v 1.81 c 0.47 0.25 0.83 0.61 1.09 1.07 c 0.26 0.46 0.39 0.95 0.39 1.48 c 0 0.54 -0.13 1.05 -0.39 1.5 a 2.58 2.58 0 0 1 -1.09 1.04 Z M 8 8 Z"/>
      </g>
      <g id="OfflinePinIcon" viewBox="0 0 16 16">
        <path d="M 12 2 C 6.5 2 2 6.5 2 12 c 0 5.5 4.5 10 10 10 c 5.5 0 10 -4.5 10 -10 c 0 -5.5 -4.5 -10 -10 -10 Z m 5 16 H 7 v -2 h 10 v 2 Z m -6.7 -4 L 7 10.7 l 1.4 -1.4 l 1.9 1.9 l 5.3 -5.3 L 17 7.3 L 10.3 14 Z"/>
      <g id="ExtensionChromeRefreshIcon" viewBox="0 0 20 20">
        <path d="M 4.5 17 c -0.41 0 -0.77 -0.15 -1.06 -0.44 A 1.44 1.44 0 0 1 3 15.5 V 12 a 2.12 2.12 0 0 0 1.42 -0.61 A 1.88 1.88 0 0 0 5 10 a 1.88 1.88 0 0 0 -0.58 -1.39 A 2.12 2.12 0 0 0 3 8 V 4.5 c 0 -0.41 0.15 -0.77 0.44 -1.06 A 1.44 1.44 0 0 1 4.5 3 H 8 c 0 -0.56 0.19 -1.03 0.58 -1.42 A 1.93 1.93 0 0 1 10 1 c 0.56 0 1.03 0.19 1.42 0.58 c 0.39 0.39 0.58 0.86 0.58 1.42 h 3.5 c 0.41 0 0.77 0.15 1.06 0.44 c 0.29 0.29 0.44 0.65 0.44 1.06 V 8 a 1.94 1.94 0 0 1 1.42 0.58 c 0.39 0.39 0.58 0.86 0.58 1.42 c 0 0.56 -0.19 1.03 -0.58 1.42 A 1.94 1.94 0 0 1 17 12 v 3.5 c 0 0.41 -0.15 0.77 -0.44 1.06 A 1.44 1.44 0 0 1 15.5 17 Z m 0 -1.5 h 11 v -11 h -11 v 2.33 a 3.23 3.23 0 0 1 1.47 1.28 C 6.32 8.69 6.5 9.32 6.5 10 c 0 0.7 -0.18 1.33 -0.53 1.91 A 3.12 3.12 0 0 1 4.5 13.17 Z M 10 10 Z"/>
      </g>
    </defs>
  </svg>
</cr-iconset>`;

const iconsets = div.querySelectorAll('cr-iconset');
for (const iconset of iconsets) {
  document.head.appendChild(iconset);
}
