// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{TabStripService}from"/tab_strip_api/tab_strip_api.mojom-webui.js";import{TabStripObservation}from"/tab_strip_api/tab_strip_observation.js";export class TabStripController{tabStripControllerDelegate_;tabStripService_;tabStripObservation_;tabStrip_;contentRegion_;constructor(tabStripControllerDelegate,tabStrip,contentRegion){this.tabStripControllerDelegate_=tabStripControllerDelegate;this.tabStripService_=TabStripService.getRemote();this.tabStripObservation_=new TabStripObservation(this);this.tabStrip_=tabStrip;this.contentRegion_=contentRegion;this.loadTabStripModel_()}addNewTab(){this.tabStripService_.createTabAt(null,null)}removeTab(tabId){this.tabStripService_.closeTabs([tabId])}onTabClick(e){this.tabStripService_.activateTab(e.detail.tabId)}onTabDragOutOfBounds(_){}async loadTabStripModel_(){const tabSnapshot=await this.tabStripService_.getTabs();const tabStrip=tabSnapshot.tabStrip;const processContainer=container=>{if(!container||!container.children){return}container.children.forEach(((containerElement,_)=>{if(containerElement.data.tab){this.addTab_(containerElement.data.tab)}else{processContainer(containerElement)}}))};processContainer(tabStrip);this.tabStripObservation_.bind(tabSnapshot.stream.handle)}addTab_(tab){this.tabStrip_.addTab(tab);if(tab.isActive){this.tabStrip_.activateTab(tab.id)}this.contentRegion_.createWebView(tab.id,tab.isActive);this.tabStripControllerDelegate_.refreshLayout()}onTabsCreated(tabsCreatedEvent){const tabsCreated=tabsCreatedEvent.tabs;tabsCreated.forEach((container=>{this.addTab_(container.tab)}))}onTabsClosed(tabsClosedEvent){const tabsClosed=tabsClosedEvent.tabs;tabsClosed.forEach((tabId=>{this.tabStrip_.removeTab(tabId);this.contentRegion_.removeTab(tabId)}))}onDataChanged(onDataChangedEvent){const data=onDataChangedEvent.data;if(data.tab){const tab=data.tab;this.tabStrip_.updateTab(tab);if(tab.isActive){this.tabStrip_.activateTab(tab.id);this.contentRegion_.activateTab(tab.id);this.tabStripControllerDelegate_.activeTabUpdated(tab)}this.tabStripControllerDelegate_.refreshLayout()}else if(data.tabGroup){const tabGroup=data.tabGroup;if(tabGroup){this.tabStrip_.setTabGroupVisualData(tabGroup.id,tabGroup.data)}}}onCollectionCreated(_onCollectionCreated){}onNodeMoved(_onNodeMoved){}}