// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/cr_elements/cr_button/cr_button.js";import"chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"chrome://resources/lit/v3_0/lit.rollup.js";import{getCss}from"./user_education_internals_card.css.js";import{getHtml}from"./user_education_internals_card.html.js";const PROMO_LAUNCH_EVENT="promo-launch";const CLEAR_PROMO_DATA_EVENT="clear-promo-data";export class UserEducationInternalsCardElement extends CrLitElement{static get is(){return"user-education-internals-card"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{promo:{type:Object},showAction:{type:Boolean},instructionsExpanded_:{type:Boolean},dataExpanded_:{type:Boolean}}}#promo_accessor_storage=null;get promo(){return this.#promo_accessor_storage}set promo(value){this.#promo_accessor_storage=value}#showAction_accessor_storage=false;get showAction(){return this.#showAction_accessor_storage}set showAction(value){this.#showAction_accessor_storage=value}#instructionsExpanded__accessor_storage=false;get instructionsExpanded_(){return this.#instructionsExpanded__accessor_storage}set instructionsExpanded_(value){this.#instructionsExpanded__accessor_storage=value}#dataExpanded__accessor_storage=false;get dataExpanded_(){return this.#dataExpanded__accessor_storage}set dataExpanded_(value){this.#dataExpanded__accessor_storage=value}launchPromo_(){assert(this.promo);this.dispatchEvent(new CustomEvent(PROMO_LAUNCH_EVENT,{bubbles:true,composed:true,detail:this.promo.internalName}))}clearData_(){assert(this.promo);if(confirm("Clear all data associated with this User Education journey?\n"+"Note: because of session tracking and event constraints, "+"Feature Engagement may still disallow some IPH.")){this.dispatchEvent(new CustomEvent(CLEAR_PROMO_DATA_EVENT,{bubbles:true,composed:true,detail:this.promo.internalName}))}}showMilestone_(){assert(this.promo);return this.promo.addedMilestone>0}showDescription_(){assert(this.promo);return this.promo.displayDescription!==""}formatPlatforms_(){assert(this.promo);return this.promo.supportedPlatforms.join(", ")}showRequiredFeatures_(){assert(this.promo);return this.promo.requiredFeatures.length}formatRequiredFeatures_(){assert(this.promo);return this.promo.requiredFeatures.join(", ")}showInstructions_(){assert(this.promo);return this.promo.instructions.length}showFollowedBy_(){assert(this.promo);return this.promo.followedByInternalName}showData_(){assert(this.promo);return this.promo.data.length}scrollToFollowedBy_(){assert(this.promo);const parent=this.parentElement;if(parent){const allCards=parent.querySelectorAll("user-education-internals-card");for(const card of allCards){card.classList.remove("highlighted")}const anchor=parent.querySelector(`[id="${this.promo.followedByInternalName}"]`);if(anchor){anchor.classList.add("highlighted");anchor.scrollIntoView()}}}getFollowedByAnchor_(){assert(this.promo);return encodeURIComponent(this.promo.followedByInternalName)}onInstructionsExpandedChanged_(e){this.instructionsExpanded_=e.detail.value}onDataExpandedChanged_(e){this.dataExpanded_=e.detail.value}}customElements.define(UserEducationInternalsCardElement.is,UserEducationInternalsCardElement);