// services/device/public/mojom/usb_manager_client.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UsbDeviceInfoSpec as device_mojom_UsbDeviceInfoSpec,
  UsbDeviceInfo as device_mojom_UsbDeviceInfo
} from './usb_device.mojom-webui.js';







export type UsbDeviceManagerClientPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerClientPendingReceiver>;

export class UsbDeviceManagerClientPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UsbDeviceManagerClient> {

  handle: mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerClientPendingReceiver>;
  constructor(handle: MojoHandle|UsbDeviceManagerClientPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.UsbDeviceManagerClient',
        scope);
  }
}

export interface UsbDeviceManagerClientInterface {
  onDeviceAdded(deviceInfo: device_mojom_UsbDeviceInfo): void;
  onDeviceRemoved(deviceInfo: device_mojom_UsbDeviceInfo): void;
}

export class UsbDeviceManagerClientRemote implements UsbDeviceManagerClientInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UsbDeviceManagerClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDeviceManagerClientPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UsbDeviceManagerClientPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceManagerClientPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onDeviceAdded(
      deviceInfo: device_mojom_UsbDeviceInfo): void {
    this.proxy.sendMessage(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  onDeviceRemoved(
      deviceInfo: device_mojom_UsbDeviceInfo): void {
    this.proxy.sendMessage(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceManagerClientReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerClientRemote, UsbDeviceManagerClientPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerClientRemote, UsbDeviceManagerClientPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UsbDeviceManagerClientInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceManagerClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        impl.onDeviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        impl.onDeviceRemoved.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceManagerClient {
  static get $interfaceName(): string {
    return "device.mojom.UsbDeviceManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UsbDeviceManagerClientRemote {
    let remote = new UsbDeviceManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceManagerClientCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerClientRemote, UsbDeviceManagerClientPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerClientRemote, UsbDeviceManagerClientPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onDeviceAdded: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onDeviceRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceManagerClientRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onDeviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        this.onDeviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onDeviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        this.onDeviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface UsbDeviceManagerClient_OnDeviceAdded_ParamsMojoType {
  deviceInfo: device_mojom_UsbDeviceInfo;
}


export type UsbDeviceManagerClient_OnDeviceAdded_Params = UsbDeviceManagerClient_OnDeviceAdded_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerClient_OnDeviceAdded_ParamsMojoType>(
    UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceAdded_Params',
    [
      mojo.internal.StructField<UsbDeviceManagerClient_OnDeviceAdded_ParamsMojoType, device_mojom_UsbDeviceInfo>(
        'deviceInfo', 0,
        0,
        device_mojom_UsbDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManagerClient_OnDeviceRemoved_ParamsMojoType {
  deviceInfo: device_mojom_UsbDeviceInfo;
}


export type UsbDeviceManagerClient_OnDeviceRemoved_Params = UsbDeviceManagerClient_OnDeviceRemoved_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerClient_OnDeviceRemoved_ParamsMojoType>(
    UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceRemoved_Params',
    [
      mojo.internal.StructField<UsbDeviceManagerClient_OnDeviceRemoved_ParamsMojoType, device_mojom_UsbDeviceInfo>(
        'deviceInfo', 0,
        0,
        device_mojom_UsbDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



