// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{ReadOnlyBufferSpec as mojoBase_mojom_ReadOnlyBufferSpec}from"//resources/mojo/mojo/public/mojom/base/read_only_buffer.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const USB_AUDIO_CLASS=1;export const USB_COMM_CLASS=2;export const USB_HID_CLASS=3;export const USB_MASS_STORAGE_CLASS=8;export const USB_SMART_CARD_CLASS=11;export const USB_VIDEO_CLASS=14;export const USB_AUDIO_VIDEO_CLASS=16;export const USB_WIRELESS_CLASS=224;export const UsbOpenDeviceSuccessSpec={$:mojo.internal.Enum()};export var UsbOpenDeviceSuccess;(function(UsbOpenDeviceSuccess){UsbOpenDeviceSuccess[UsbOpenDeviceSuccess["MIN_VALUE"]=0]="MIN_VALUE";UsbOpenDeviceSuccess[UsbOpenDeviceSuccess["MAX_VALUE"]=0]="MAX_VALUE";UsbOpenDeviceSuccess[UsbOpenDeviceSuccess["OK"]=0]="OK"})(UsbOpenDeviceSuccess||(UsbOpenDeviceSuccess={}));export const UsbOpenDeviceErrorSpec={$:mojo.internal.Enum()};export var UsbOpenDeviceError;(function(UsbOpenDeviceError){UsbOpenDeviceError[UsbOpenDeviceError["MIN_VALUE"]=0]="MIN_VALUE";UsbOpenDeviceError[UsbOpenDeviceError["MAX_VALUE"]=1]="MAX_VALUE";UsbOpenDeviceError[UsbOpenDeviceError["ACCESS_DENIED"]=0]="ACCESS_DENIED";UsbOpenDeviceError[UsbOpenDeviceError["ALREADY_OPEN"]=1]="ALREADY_OPEN"})(UsbOpenDeviceError||(UsbOpenDeviceError={}));export const UsbClaimInterfaceResultSpec={$:mojo.internal.Enum()};export var UsbClaimInterfaceResult;(function(UsbClaimInterfaceResult){UsbClaimInterfaceResult[UsbClaimInterfaceResult["MIN_VALUE"]=0]="MIN_VALUE";UsbClaimInterfaceResult[UsbClaimInterfaceResult["MAX_VALUE"]=2]="MAX_VALUE";UsbClaimInterfaceResult[UsbClaimInterfaceResult["kSuccess"]=0]="kSuccess";UsbClaimInterfaceResult[UsbClaimInterfaceResult["kProtectedClass"]=1]="kProtectedClass";UsbClaimInterfaceResult[UsbClaimInterfaceResult["kFailure"]=2]="kFailure"})(UsbClaimInterfaceResult||(UsbClaimInterfaceResult={}));export const UsbTransferDirectionSpec={$:mojo.internal.Enum()};export var UsbTransferDirection;(function(UsbTransferDirection){UsbTransferDirection[UsbTransferDirection["MIN_VALUE"]=0]="MIN_VALUE";UsbTransferDirection[UsbTransferDirection["MAX_VALUE"]=1]="MAX_VALUE";UsbTransferDirection[UsbTransferDirection["INBOUND"]=0]="INBOUND";UsbTransferDirection[UsbTransferDirection["OUTBOUND"]=1]="OUTBOUND"})(UsbTransferDirection||(UsbTransferDirection={}));export const UsbControlTransferTypeSpec={$:mojo.internal.Enum()};export var UsbControlTransferType;(function(UsbControlTransferType){UsbControlTransferType[UsbControlTransferType["MIN_VALUE"]=0]="MIN_VALUE";UsbControlTransferType[UsbControlTransferType["MAX_VALUE"]=3]="MAX_VALUE";UsbControlTransferType[UsbControlTransferType["STANDARD"]=0]="STANDARD";UsbControlTransferType[UsbControlTransferType["CLASS"]=1]="CLASS";UsbControlTransferType[UsbControlTransferType["VENDOR"]=2]="VENDOR";UsbControlTransferType[UsbControlTransferType["RESERVED"]=3]="RESERVED"})(UsbControlTransferType||(UsbControlTransferType={}));export const UsbControlTransferRecipientSpec={$:mojo.internal.Enum()};export var UsbControlTransferRecipient;(function(UsbControlTransferRecipient){UsbControlTransferRecipient[UsbControlTransferRecipient["MIN_VALUE"]=0]="MIN_VALUE";UsbControlTransferRecipient[UsbControlTransferRecipient["MAX_VALUE"]=3]="MAX_VALUE";UsbControlTransferRecipient[UsbControlTransferRecipient["DEVICE"]=0]="DEVICE";UsbControlTransferRecipient[UsbControlTransferRecipient["INTERFACE"]=1]="INTERFACE";UsbControlTransferRecipient[UsbControlTransferRecipient["ENDPOINT"]=2]="ENDPOINT";UsbControlTransferRecipient[UsbControlTransferRecipient["OTHER"]=3]="OTHER"})(UsbControlTransferRecipient||(UsbControlTransferRecipient={}));export const UsbTransferTypeSpec={$:mojo.internal.Enum()};export var UsbTransferType;(function(UsbTransferType){UsbTransferType[UsbTransferType["MIN_VALUE"]=0]="MIN_VALUE";UsbTransferType[UsbTransferType["MAX_VALUE"]=3]="MAX_VALUE";UsbTransferType[UsbTransferType["CONTROL"]=0]="CONTROL";UsbTransferType[UsbTransferType["ISOCHRONOUS"]=1]="ISOCHRONOUS";UsbTransferType[UsbTransferType["BULK"]=2]="BULK";UsbTransferType[UsbTransferType["INTERRUPT"]=3]="INTERRUPT"})(UsbTransferType||(UsbTransferType={}));export const UsbSynchronizationTypeSpec={$:mojo.internal.Enum()};export var UsbSynchronizationType;(function(UsbSynchronizationType){UsbSynchronizationType[UsbSynchronizationType["MIN_VALUE"]=0]="MIN_VALUE";UsbSynchronizationType[UsbSynchronizationType["MAX_VALUE"]=3]="MAX_VALUE";UsbSynchronizationType[UsbSynchronizationType["NONE"]=0]="NONE";UsbSynchronizationType[UsbSynchronizationType["ASYNCHRONOUS"]=1]="ASYNCHRONOUS";UsbSynchronizationType[UsbSynchronizationType["ADAPTIVE"]=2]="ADAPTIVE";UsbSynchronizationType[UsbSynchronizationType["SYNCHRONOUS"]=3]="SYNCHRONOUS"})(UsbSynchronizationType||(UsbSynchronizationType={}));export const UsbUsageTypeSpec={$:mojo.internal.Enum()};export var UsbUsageType;(function(UsbUsageType){UsbUsageType[UsbUsageType["MIN_VALUE"]=0]="MIN_VALUE";UsbUsageType[UsbUsageType["MAX_VALUE"]=5]="MAX_VALUE";UsbUsageType[UsbUsageType["DATA"]=0]="DATA";UsbUsageType[UsbUsageType["FEEDBACK"]=1]="FEEDBACK";UsbUsageType[UsbUsageType["EXPLICIT_FEEDBACK"]=2]="EXPLICIT_FEEDBACK";UsbUsageType[UsbUsageType["PERIODIC"]=3]="PERIODIC";UsbUsageType[UsbUsageType["NOTIFICATION"]=4]="NOTIFICATION";UsbUsageType[UsbUsageType["RESERVED"]=5]="RESERVED"})(UsbUsageType||(UsbUsageType={}));export const UsbTransferStatusSpec={$:mojo.internal.Enum()};export var UsbTransferStatus;(function(UsbTransferStatus){UsbTransferStatus[UsbTransferStatus["MIN_VALUE"]=0]="MIN_VALUE";UsbTransferStatus[UsbTransferStatus["MAX_VALUE"]=8]="MAX_VALUE";UsbTransferStatus[UsbTransferStatus["COMPLETED"]=0]="COMPLETED";UsbTransferStatus[UsbTransferStatus["TRANSFER_ERROR"]=1]="TRANSFER_ERROR";UsbTransferStatus[UsbTransferStatus["TIMEOUT"]=2]="TIMEOUT";UsbTransferStatus[UsbTransferStatus["CANCELLED"]=3]="CANCELLED";UsbTransferStatus[UsbTransferStatus["STALLED"]=4]="STALLED";UsbTransferStatus[UsbTransferStatus["DISCONNECT"]=5]="DISCONNECT";UsbTransferStatus[UsbTransferStatus["BABBLE"]=6]="BABBLE";UsbTransferStatus[UsbTransferStatus["SHORT_PACKET"]=7]="SHORT_PACKET";UsbTransferStatus[UsbTransferStatus["PERMISSION_DENIED"]=8]="PERMISSION_DENIED"})(UsbTransferStatus||(UsbTransferStatus={}));export class UsbDevicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"device.mojom.UsbDevice",scope)}}export class UsbDeviceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UsbDevicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}open(){return this.proxy.sendMessage(0,UsbDevice_Open_ParamsSpec.$,UsbDevice_Open_ResponseParamsSpec.$,[],false)}close(){return this.proxy.sendMessage(1,UsbDevice_Close_ParamsSpec.$,UsbDevice_Close_ResponseParamsSpec.$,[],false)}setConfiguration(value){return this.proxy.sendMessage(2,UsbDevice_SetConfiguration_ParamsSpec.$,UsbDevice_SetConfiguration_ResponseParamsSpec.$,[value],false)}claimInterface(interfaceNumber){return this.proxy.sendMessage(3,UsbDevice_ClaimInterface_ParamsSpec.$,UsbDevice_ClaimInterface_ResponseParamsSpec.$,[interfaceNumber],false)}releaseInterface(interfaceNumber){return this.proxy.sendMessage(4,UsbDevice_ReleaseInterface_ParamsSpec.$,UsbDevice_ReleaseInterface_ResponseParamsSpec.$,[interfaceNumber],false)}setInterfaceAlternateSetting(interfaceNumber,alternateSetting){return this.proxy.sendMessage(5,UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,[interfaceNumber,alternateSetting],false)}reset(){return this.proxy.sendMessage(6,UsbDevice_Reset_ParamsSpec.$,UsbDevice_Reset_ResponseParamsSpec.$,[],false)}clearHalt(direction,endpointNumber){return this.proxy.sendMessage(7,UsbDevice_ClearHalt_ParamsSpec.$,UsbDevice_ClearHalt_ResponseParamsSpec.$,[direction,endpointNumber],false)}controlTransferIn(params,length,timeout){return this.proxy.sendMessage(8,UsbDevice_ControlTransferIn_ParamsSpec.$,UsbDevice_ControlTransferIn_ResponseParamsSpec.$,[params,length,timeout],false)}controlTransferOut(params,data,timeout){return this.proxy.sendMessage(9,UsbDevice_ControlTransferOut_ParamsSpec.$,UsbDevice_ControlTransferOut_ResponseParamsSpec.$,[params,data,timeout],false)}genericTransferIn(endpointNumber,length,timeout){return this.proxy.sendMessage(10,UsbDevice_GenericTransferIn_ParamsSpec.$,UsbDevice_GenericTransferIn_ResponseParamsSpec.$,[endpointNumber,length,timeout],false)}genericTransferOut(endpointNumber,data,timeout){return this.proxy.sendMessage(11,UsbDevice_GenericTransferOut_ParamsSpec.$,UsbDevice_GenericTransferOut_ResponseParamsSpec.$,[endpointNumber,data,timeout],false)}isochronousTransferIn(endpointNumber,packetLengths,timeout){return this.proxy.sendMessage(12,UsbDevice_IsochronousTransferIn_ParamsSpec.$,UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,[endpointNumber,packetLengths,timeout],false)}isochronousTransferOut(endpointNumber,data,packetLengths,timeout){return this.proxy.sendMessage(13,UsbDevice_IsochronousTransferOut_ParamsSpec.$,UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,[endpointNumber,data,packetLengths,timeout],false)}}export class UsbDeviceReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UsbDeviceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UsbDevice_Open_ParamsSpec.$,UsbDevice_Open_ResponseParamsSpec.$,impl.open.bind(impl),false);this.helper_internal_.registerHandler(1,UsbDevice_Close_ParamsSpec.$,UsbDevice_Close_ResponseParamsSpec.$,impl.close.bind(impl),false);this.helper_internal_.registerHandler(2,UsbDevice_SetConfiguration_ParamsSpec.$,UsbDevice_SetConfiguration_ResponseParamsSpec.$,impl.setConfiguration.bind(impl),false);this.helper_internal_.registerHandler(3,UsbDevice_ClaimInterface_ParamsSpec.$,UsbDevice_ClaimInterface_ResponseParamsSpec.$,impl.claimInterface.bind(impl),false);this.helper_internal_.registerHandler(4,UsbDevice_ReleaseInterface_ParamsSpec.$,UsbDevice_ReleaseInterface_ResponseParamsSpec.$,impl.releaseInterface.bind(impl),false);this.helper_internal_.registerHandler(5,UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,impl.setInterfaceAlternateSetting.bind(impl),false);this.helper_internal_.registerHandler(6,UsbDevice_Reset_ParamsSpec.$,UsbDevice_Reset_ResponseParamsSpec.$,impl.reset.bind(impl),false);this.helper_internal_.registerHandler(7,UsbDevice_ClearHalt_ParamsSpec.$,UsbDevice_ClearHalt_ResponseParamsSpec.$,impl.clearHalt.bind(impl),false);this.helper_internal_.registerHandler(8,UsbDevice_ControlTransferIn_ParamsSpec.$,UsbDevice_ControlTransferIn_ResponseParamsSpec.$,impl.controlTransferIn.bind(impl),false);this.helper_internal_.registerHandler(9,UsbDevice_ControlTransferOut_ParamsSpec.$,UsbDevice_ControlTransferOut_ResponseParamsSpec.$,impl.controlTransferOut.bind(impl),false);this.helper_internal_.registerHandler(10,UsbDevice_GenericTransferIn_ParamsSpec.$,UsbDevice_GenericTransferIn_ResponseParamsSpec.$,impl.genericTransferIn.bind(impl),false);this.helper_internal_.registerHandler(11,UsbDevice_GenericTransferOut_ParamsSpec.$,UsbDevice_GenericTransferOut_ResponseParamsSpec.$,impl.genericTransferOut.bind(impl),false);this.helper_internal_.registerHandler(12,UsbDevice_IsochronousTransferIn_ParamsSpec.$,UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,impl.isochronousTransferIn.bind(impl),false);this.helper_internal_.registerHandler(13,UsbDevice_IsochronousTransferOut_ParamsSpec.$,UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,impl.isochronousTransferOut.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UsbDevice{static get $interfaceName(){return"device.mojom.UsbDevice"}static getRemote(){let remote=new UsbDeviceRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UsbDeviceCallbackRouter{helper_internal_;$;router_;open;close;setConfiguration;claimInterface;releaseInterface;setInterfaceAlternateSetting;reset;clearHalt;controlTransferIn;controlTransferOut;genericTransferIn;genericTransferOut;isochronousTransferIn;isochronousTransferOut;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UsbDeviceRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.open=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UsbDevice_Open_ParamsSpec.$,UsbDevice_Open_ResponseParamsSpec.$,this.open.createReceiverHandler(true),false);this.close=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,UsbDevice_Close_ParamsSpec.$,UsbDevice_Close_ResponseParamsSpec.$,this.close.createReceiverHandler(true),false);this.setConfiguration=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,UsbDevice_SetConfiguration_ParamsSpec.$,UsbDevice_SetConfiguration_ResponseParamsSpec.$,this.setConfiguration.createReceiverHandler(true),false);this.claimInterface=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,UsbDevice_ClaimInterface_ParamsSpec.$,UsbDevice_ClaimInterface_ResponseParamsSpec.$,this.claimInterface.createReceiverHandler(true),false);this.releaseInterface=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,UsbDevice_ReleaseInterface_ParamsSpec.$,UsbDevice_ReleaseInterface_ResponseParamsSpec.$,this.releaseInterface.createReceiverHandler(true),false);this.setInterfaceAlternateSetting=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,this.setInterfaceAlternateSetting.createReceiverHandler(true),false);this.reset=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,UsbDevice_Reset_ParamsSpec.$,UsbDevice_Reset_ResponseParamsSpec.$,this.reset.createReceiverHandler(true),false);this.clearHalt=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,UsbDevice_ClearHalt_ParamsSpec.$,UsbDevice_ClearHalt_ResponseParamsSpec.$,this.clearHalt.createReceiverHandler(true),false);this.controlTransferIn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,UsbDevice_ControlTransferIn_ParamsSpec.$,UsbDevice_ControlTransferIn_ResponseParamsSpec.$,this.controlTransferIn.createReceiverHandler(true),false);this.controlTransferOut=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,UsbDevice_ControlTransferOut_ParamsSpec.$,UsbDevice_ControlTransferOut_ResponseParamsSpec.$,this.controlTransferOut.createReceiverHandler(true),false);this.genericTransferIn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,UsbDevice_GenericTransferIn_ParamsSpec.$,UsbDevice_GenericTransferIn_ResponseParamsSpec.$,this.genericTransferIn.createReceiverHandler(true),false);this.genericTransferOut=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,UsbDevice_GenericTransferOut_ParamsSpec.$,UsbDevice_GenericTransferOut_ResponseParamsSpec.$,this.genericTransferOut.createReceiverHandler(true),false);this.isochronousTransferIn=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,UsbDevice_IsochronousTransferIn_ParamsSpec.$,UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,this.isochronousTransferIn.createReceiverHandler(true),false);this.isochronousTransferOut=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(13,UsbDevice_IsochronousTransferOut_ParamsSpec.$,UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,this.isochronousTransferOut.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class UsbDeviceClientPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"device.mojom.UsbDeviceClient",scope)}}export class UsbDeviceClientRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UsbDeviceClientPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onDeviceOpened(){this.proxy.sendMessage(0,UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,null,[],false)}onDeviceClosed(){this.proxy.sendMessage(1,UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,null,[],false)}}export class UsbDeviceClientReceiver{helper_internal_;$;onConnectionError;constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UsbDeviceClientRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,null,impl.onDeviceOpened.bind(impl),false);this.helper_internal_.registerHandler(1,UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,null,impl.onDeviceClosed.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UsbDeviceClient{static get $interfaceName(){return"device.mojom.UsbDeviceClient"}static getRemote(){let remote=new UsbDeviceClientRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UsbDeviceClientCallbackRouter{helper_internal_;$;router_;onDeviceOpened;onDeviceClosed;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UsbDeviceClientRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onDeviceOpened=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,null,this.onDeviceOpened.createReceiverHandler(false),false);this.onDeviceClosed=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,null,this.onDeviceClosed.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const UsbEndpointInfoSpec={$:{}};export const UsbAlternateInterfaceInfoSpec={$:{}};export const UsbInterfaceInfoSpec={$:{}};export const UsbConfigurationInfoSpec={$:{}};export const UsbDeviceInfoSpec={$:{}};export const UsbControlTransferParamsSpec={$:{}};export const UsbIsochronousPacketSpec={$:{}};export const UsbDevice_Open_ParamsSpec={$:{}};export const UsbDevice_Open_ResponseParamsSpec={$:{}};export const UsbDevice_Close_ParamsSpec={$:{}};export const UsbDevice_Close_ResponseParamsSpec={$:{}};export const UsbDevice_SetConfiguration_ParamsSpec={$:{}};export const UsbDevice_SetConfiguration_ResponseParamsSpec={$:{}};export const UsbDevice_ClaimInterface_ParamsSpec={$:{}};export const UsbDevice_ClaimInterface_ResponseParamsSpec={$:{}};export const UsbDevice_ReleaseInterface_ParamsSpec={$:{}};export const UsbDevice_ReleaseInterface_ResponseParamsSpec={$:{}};export const UsbDevice_SetInterfaceAlternateSetting_ParamsSpec={$:{}};export const UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec={$:{}};export const UsbDevice_Reset_ParamsSpec={$:{}};export const UsbDevice_Reset_ResponseParamsSpec={$:{}};export const UsbDevice_ClearHalt_ParamsSpec={$:{}};export const UsbDevice_ClearHalt_ResponseParamsSpec={$:{}};export const UsbDevice_ControlTransferIn_ParamsSpec={$:{}};export const UsbDevice_ControlTransferIn_ResponseParamsSpec={$:{}};export const UsbDevice_ControlTransferOut_ParamsSpec={$:{}};export const UsbDevice_ControlTransferOut_ResponseParamsSpec={$:{}};export const UsbDevice_GenericTransferIn_ParamsSpec={$:{}};export const UsbDevice_GenericTransferIn_ResponseParamsSpec={$:{}};export const UsbDevice_GenericTransferOut_ParamsSpec={$:{}};export const UsbDevice_GenericTransferOut_ResponseParamsSpec={$:{}};export const UsbDevice_IsochronousTransferIn_ParamsSpec={$:{}};export const UsbDevice_IsochronousTransferIn_ResponseParamsSpec={$:{}};export const UsbDevice_IsochronousTransferOut_ParamsSpec={$:{}};export const UsbDevice_IsochronousTransferOut_ResponseParamsSpec={$:{}};export const UsbDeviceClient_OnDeviceOpened_ParamsSpec={$:{}};export const UsbDeviceClient_OnDeviceClosed_ParamsSpec={$:{}};export const UsbOpenDeviceResultSpec={$:{}};mojo.internal.Struct(UsbEndpointInfoSpec.$,"UsbEndpointInfo",[mojo.internal.StructField("endpointNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("direction",4,0,UsbTransferDirectionSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("type",8,0,UsbTransferTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("packetSize",12,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("synchronizationType",16,0,UsbSynchronizationTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("usageType",20,0,UsbUsageTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("pollingInterval",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("extraData",24,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(UsbAlternateInterfaceInfoSpec.$,"UsbAlternateInterfaceInfo",[mojo.internal.StructField("alternateSetting",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("classCode",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("subclassCode",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("protocolCode",3,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("interfaceName",8,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("endpoints",16,0,mojo.internal.Array(UsbEndpointInfoSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("extraData",24,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(UsbInterfaceInfoSpec.$,"UsbInterfaceInfo",[mojo.internal.StructField("interfaceNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("firstInterface",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("alternates",8,0,mojo.internal.Array(UsbAlternateInterfaceInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbConfigurationInfoSpec.$,"UsbConfigurationInfo",[mojo.internal.StructField("configurationValue",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("configurationName",8,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("selfPowered",1,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("remoteWakeup",1,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("maximumPower",2,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("interfaces",16,0,mojo.internal.Array(UsbInterfaceInfoSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("extraData",24,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(UsbDeviceInfoSpec.$,"UsbDeviceInfo",[mojo.internal.StructField("guid",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("usbVersionMajor",8,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("usbVersionMinor",9,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("usbVersionSubminor",10,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("classCode",11,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("subclassCode",12,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("protocolCode",13,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("busNumber",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("portNumber",20,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("vendorId",14,0,mojo.internal.Uint16,0,false,0,undefined,undefined),mojo.internal.StructField("productId",24,0,mojo.internal.Uint16,0,false,0,undefined,undefined),mojo.internal.StructField("deviceVersionMajor",26,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("deviceVersionMinor",27,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("deviceVersionSubminor",28,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("manufacturerName",32,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("productName",40,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("serialNumber",48,0,mojoBase_mojom_String16Spec.$,null,true,0,undefined,undefined),mojo.internal.StructField("webusbLandingPage",56,0,url_mojom_UrlSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("activeConfiguration",29,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("configurations",64,0,mojo.internal.Array(UsbConfigurationInfoSpec.$,false),null,false,0,undefined,undefined)],[[0,80]]);export const UsbControlTransferParams_SECURITY_KEY_AOA_MODEL="12eba9f901039b36";mojo.internal.Struct(UsbControlTransferParamsSpec.$,"UsbControlTransferParams",[mojo.internal.StructField("type",0,0,UsbControlTransferTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("recipient",4,0,UsbControlTransferRecipientSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("request",8,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("value",10,0,mojo.internal.Uint16,0,false,0,undefined,undefined),mojo.internal.StructField("index",12,0,mojo.internal.Uint16,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbIsochronousPacketSpec.$,"UsbIsochronousPacket",[mojo.internal.StructField("length",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("transferredLength",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("status",8,0,UsbTransferStatusSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_Open_ParamsSpec.$,"UsbDevice_Open_Params",[],[[0,8]]);mojo.internal.Struct(UsbDevice_Open_ResponseParamsSpec.$,"UsbDevice_Open_ResponseParams",[mojo.internal.StructField("result",0,0,UsbOpenDeviceResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_Close_ParamsSpec.$,"UsbDevice_Close_Params",[],[[0,8]]);mojo.internal.Struct(UsbDevice_Close_ResponseParamsSpec.$,"UsbDevice_Close_ResponseParams",[],[[0,8]]);mojo.internal.Struct(UsbDevice_SetConfiguration_ParamsSpec.$,"UsbDevice_SetConfiguration_Params",[mojo.internal.StructField("value",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_SetConfiguration_ResponseParamsSpec.$,"UsbDevice_SetConfiguration_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ClaimInterface_ParamsSpec.$,"UsbDevice_ClaimInterface_Params",[mojo.internal.StructField("interfaceNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ClaimInterface_ResponseParamsSpec.$,"UsbDevice_ClaimInterface_ResponseParams",[mojo.internal.StructField("result",0,0,UsbClaimInterfaceResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ReleaseInterface_ParamsSpec.$,"UsbDevice_ReleaseInterface_Params",[mojo.internal.StructField("interfaceNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ReleaseInterface_ResponseParamsSpec.$,"UsbDevice_ReleaseInterface_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,"UsbDevice_SetInterfaceAlternateSetting_Params",[mojo.internal.StructField("interfaceNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("alternateSetting",1,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,"UsbDevice_SetInterfaceAlternateSetting_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_Reset_ParamsSpec.$,"UsbDevice_Reset_Params",[],[[0,8]]);mojo.internal.Struct(UsbDevice_Reset_ResponseParamsSpec.$,"UsbDevice_Reset_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ClearHalt_ParamsSpec.$,"UsbDevice_ClearHalt_Params",[mojo.internal.StructField("direction",0,0,UsbTransferDirectionSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("endpointNumber",4,0,mojo.internal.Uint8,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ClearHalt_ResponseParamsSpec.$,"UsbDevice_ClearHalt_ResponseParams",[mojo.internal.StructField("success",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_ControlTransferIn_ParamsSpec.$,"UsbDevice_ControlTransferIn_Params",[mojo.internal.StructField("params",0,0,UsbControlTransferParamsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("length",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("timeout",12,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_ControlTransferIn_ResponseParamsSpec.$,"UsbDevice_ControlTransferIn_ResponseParams",[mojo.internal.StructField("status",0,0,UsbTransferStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_ControlTransferOut_ParamsSpec.$,"UsbDevice_ControlTransferOut_Params",[mojo.internal.StructField("params",0,0,UsbControlTransferParamsSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("timeout",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(UsbDevice_ControlTransferOut_ResponseParamsSpec.$,"UsbDevice_ControlTransferOut_ResponseParams",[mojo.internal.StructField("status",0,0,UsbTransferStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_GenericTransferIn_ParamsSpec.$,"UsbDevice_GenericTransferIn_Params",[mojo.internal.StructField("endpointNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("length",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("timeout",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_GenericTransferIn_ResponseParamsSpec.$,"UsbDevice_GenericTransferIn_ResponseParams",[mojo.internal.StructField("status",0,0,UsbTransferStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_GenericTransferOut_ParamsSpec.$,"UsbDevice_GenericTransferOut_Params",[mojo.internal.StructField("endpointNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("timeout",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_GenericTransferOut_ResponseParamsSpec.$,"UsbDevice_GenericTransferOut_ResponseParams",[mojo.internal.StructField("status",0,0,UsbTransferStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDevice_IsochronousTransferIn_ParamsSpec.$,"UsbDevice_IsochronousTransferIn_Params",[mojo.internal.StructField("endpointNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("packetLengths",8,0,mojo.internal.Array(mojo.internal.Uint32,false),null,false,0,undefined,undefined),mojo.internal.StructField("timeout",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,"UsbDevice_IsochronousTransferIn_ResponseParams",[mojo.internal.StructField("data",0,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("packets",8,0,mojo.internal.Array(UsbIsochronousPacketSpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UsbDevice_IsochronousTransferOut_ParamsSpec.$,"UsbDevice_IsochronousTransferOut_Params",[mojo.internal.StructField("endpointNumber",0,0,mojo.internal.Uint8,0,false,0,undefined,undefined),mojo.internal.StructField("data",8,0,mojoBase_mojom_ReadOnlyBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("packetLengths",16,0,mojo.internal.Array(mojo.internal.Uint32,false),null,false,0,undefined,undefined),mojo.internal.StructField("timeout",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,"UsbDevice_IsochronousTransferOut_ResponseParams",[mojo.internal.StructField("packets",0,0,mojo.internal.Array(UsbIsochronousPacketSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,"UsbDeviceClient_OnDeviceOpened_Params",[],[[0,8]]);mojo.internal.Struct(UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,"UsbDeviceClient_OnDeviceClosed_Params",[],[[0,8]]);mojo.internal.Union(UsbOpenDeviceResultSpec.$,"UsbOpenDeviceResult",{success:{ordinal:0,type:UsbOpenDeviceSuccessSpec.$},error:{ordinal:1,type:UsbOpenDeviceErrorSpec.$}});export var UsbOpenDeviceResultFieldTags;(function(UsbOpenDeviceResultFieldTags){UsbOpenDeviceResultFieldTags[UsbOpenDeviceResultFieldTags["SUCCESS"]=0]="SUCCESS";UsbOpenDeviceResultFieldTags[UsbOpenDeviceResultFieldTags["ERROR"]=1]="ERROR"})(UsbOpenDeviceResultFieldTags||(UsbOpenDeviceResultFieldTags={}));export function whichUsbOpenDeviceResult(u){if(u.success!==null&&u.success!==undefined){return UsbOpenDeviceResultFieldTags.SUCCESS}if(u.error!==null&&u.error!==undefined){return UsbOpenDeviceResultFieldTags.ERROR}throw new Error("no union field has been set, this is an illegal state")}