import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/icons.html.js';
import '/strings.m.js';
import '../tab_search_item.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { TabData } from '../tab_data.js';
import { DeclutterCTREvent } from '../tab_search.mojom-webui.js';
export declare class DeclutterPageElement extends CrLitElement {
    static get is(): string;
    static get properties(): {
        availableHeight: {
            type: NumberConstructor;
        };
        showBackButton: {
            type: BooleanConstructor;
        };
        staleTabDatas_: {
            type: ArrayConstructor;
        };
        duplicateTabDatas_: {
            type: ArrayConstructor;
        };
        dedupeEnabled: {
            type: BooleanConstructor;
            reflect: boolean;
        };
    };
    accessor availableHeight: number;
    accessor showBackButton: boolean;
    accessor dedupeEnabled: boolean;
    protected accessor staleTabDatas_: TabData[];
    protected accessor duplicateTabDatas_: TabData[];
    private apiProxy_;
    private listenerIds_;
    private visibilityChangedListener_;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    constructor();
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    firstUpdated(): void;
    focus(): void;
    logCtrValue(event: DeclutterCTREvent): void;
    private getMaxScrollableHeight_;
    private onAvailableHeightChange_;
    private maybeAddScrollListener_;
    private updateScroll_;
    protected getBackButtonAriaLabel_(): string;
    protected getCloseButtonAriaLabel_(tabData: TabData): string;
    protected getCloseButtonTooltip_(): string;
    protected onBackClick_(): void;
    protected onCloseTabsClick_(): void;
    protected onTabFocus_(e: FocusEvent): void;
    protected onTabBlur_(e: FocusEvent): void;
    protected onTabKeyDown_(e: KeyboardEvent): void;
    protected onStaleTabExclude_(e: Event): void;
    protected onDuplicateTabExclude_(e: Event): void;
    private announceTabExcluded_;
    private setUnusedTabs_;
    private setStaleTabs_;
    private setDuplicateTabs_;
    private tabDataFromTab_;
}
declare global {
    interface HTMLElementTagNameMap {
        'declutter-page': DeclutterPageElement;
    }
}
