export interface DataCollectorItem {
    name: string;
    isIncluded: boolean;
    protoEnum: number;
}
export interface IssueDetails {
    caseId: string;
    emailAddress: string;
    issueDescription: string;
}
export interface PiiDataItem {
    piiTypeDescription: string;
    piiType: number;
    detectedData: string[];
    count: number;
    keep: boolean;
    expandDetails: boolean;
}
export interface StartDataCollectionResult {
    success: boolean;
    errorMessage: string;
}
export interface SupportTokenGenerationResult {
    success: boolean;
    token: string;
    errorMessage: string;
}
export interface BrowserProxy {
    /**
     * Gets the list of email addresses that are logged in from C++ side.
     */
    getEmailAddresses(): Promise<string[]>;
    getDataCollectors(): Promise<DataCollectorItem[]>;
    getAllDataCollectors(): Promise<DataCollectorItem[]>;
    startDataCollection(issueDetails: IssueDetails, selectedDataCollectors: DataCollectorItem[], screenshotBase64: string): Promise<StartDataCollectionResult>;
    takeScreenshot(): void;
    cancelDataCollection(): void;
    startDataExport(piiItems: PiiDataItem[]): void;
    showExportedDataInFolder(): void;
    generateCustomizedUrl(caseId: string, dataCollectors: DataCollectorItem[]): Promise<SupportTokenGenerationResult>;
    generateSupportToken(dataCollectors: DataCollectorItem[]): Promise<SupportTokenGenerationResult>;
}
export declare class BrowserProxyImpl implements BrowserProxy {
    getEmailAddresses(): Promise<any>;
    getDataCollectors(): Promise<any>;
    getAllDataCollectors(): Promise<any>;
    takeScreenshot(): void;
    startDataCollection(issueDetails: IssueDetails, dataCollectors: DataCollectorItem[], screenshotBase64: string): Promise<any>;
    cancelDataCollection(): void;
    startDataExport(piiItems: PiiDataItem[]): void;
    showExportedDataInFolder(): void;
    generateCustomizedUrl(caseId: string, dataCollectors: DataCollectorItem[]): Promise<any>;
    generateSupportToken(dataCollectors: DataCollectorItem[]): Promise<any>;
    static getInstance(): BrowserProxy;
    static setInstance(obj: BrowserProxy): void;
}
