export declare enum BrowsingDataHandling {
    MERGE = "merge",
    SEPARATE = "separate"
}
export declare enum State {
    DISCLOSURE = 0,
    PROCESSING = 1,
    SUCCESS = 2,
    TIMEOUT = 3,
    ERROR = 4,
    VALUE_PROPOSITION = 5,
    USER_DATA_HANDLING = 6
}
export interface ManagedUserProfileInfo {
    accountName: string;
    continueAs: string;
    email: string;
    pictureUrl: string;
    showEnterpriseBadge: boolean;
    title: string;
    subtitle: string;
    proceedLabel: string;
    checkLinkDataCheckboxByDefault: boolean;
}
export interface ManagedUserProfileNoticeBrowserProxy {
    initialized(): Promise<ManagedUserProfileInfo>;
    initializedWithSize(height: number): void;
    /**
     * Called when the user clicks the proceed button.
     */
    proceed(state: State, linkData: boolean): void;
    /**
     * Called when the user clicks the cancel button.
     */
    cancel(): void;
}
export declare class ManagedUserProfileNoticeBrowserProxyImpl implements ManagedUserProfileNoticeBrowserProxy {
    initialized(): Promise<any>;
    initializedWithSize(height: number): void;
    proceed(state: State, linkData: boolean): void;
    cancel(): void;
    static getInstance(): ManagedUserProfileNoticeBrowserProxy;
    static setInstance(obj: ManagedUserProfileNoticeBrowserProxy): void;
}
