// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './simple_action_menu.js';
import { WebUiListenerMixinLit } from '//resources/cr_elements/web_ui_listener_mixin_lit.js';
import { loadTimeData } from '//resources/js/load_time_data.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { ReadAnythingSettingsChange } from '../metrics_browser_proxy.js';
import { ReadAnythingLogger } from '../read_anything_logger.js';
import { getHtml } from './line_spacing_menu.html.js';
import { getIndexOfSetting } from './menu_util.js';
const LineSpacingMenuElementBase = WebUiListenerMixinLit(CrLitElement);
// Stores and propagates the data for the line spacing menu.
export class LineSpacingMenuElement extends LineSpacingMenuElementBase {
    static get is() {
        return 'line-spacing-menu';
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return { settingsPrefs: { type: Object } };
    }
    #settingsPrefs_accessor_storage = {
        letterSpacing: 0,
        lineSpacing: 0,
        theme: 0,
        speechRate: 0,
        font: '',
        highlightGranularity: 0,
    };
    get settingsPrefs() { return this.#settingsPrefs_accessor_storage; }
    set settingsPrefs(value) { this.#settingsPrefs_accessor_storage = value; }
    options_ = [
        {
            title: loadTimeData.getString('lineSpacingStandardTitle'),
            icon: 'read-anything:line-spacing-standard',
            data: chrome.readingMode.standardLineSpacing,
        },
        {
            title: loadTimeData.getString('lineSpacingLooseTitle'),
            icon: 'read-anything:line-spacing-loose',
            data: chrome.readingMode.looseLineSpacing,
        },
        {
            title: loadTimeData.getString('lineSpacingVeryLooseTitle'),
            icon: 'read-anything:line-spacing-very-loose',
            data: chrome.readingMode.veryLooseLineSpacing,
        },
    ];
    logger_ = ReadAnythingLogger.getInstance();
    open(anchor) {
        this.$.menu.open(anchor);
    }
    restoredLineSpacingIndex_() {
        return getIndexOfSetting(this.options_, this.settingsPrefs['lineSpacing']);
    }
    onLineSpacingChange_(event) {
        chrome.readingMode.onLineSpacingChange(event.detail.data);
        this.logger_.logTextSettingsChange(ReadAnythingSettingsChange.LINE_HEIGHT_CHANGE);
    }
}
customElements.define(LineSpacingMenuElement.is, LineSpacingMenuElement);
