import '/strings.m.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_input/cr_input.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/polymer/v3_0/iron-list/iron-list.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrInputElement } from 'chrome://resources/cr_elements/cr_input/cr_input.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { BookmarksTreeNode } from './bookmarks.mojom-webui.js';
export declare const TEMP_FOLDER_ID_PREFIX = "tmp_new_folder_";
export interface PowerBookmarksEditDialogElement {
    $: {
        dialog: CrDialogElement;
        nameInput: CrInputElement;
        urlInput: CrInputElement;
    };
}
export declare class PowerBookmarksEditDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        topLevelBookmarks_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        selectedBookmarks_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        selectedFolder_: {
            type: ObjectConstructor;
            value: null;
        };
        activeFolderPath_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        newFolders_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        moveOnly_: {
            type: BooleanConstructor;
            value: boolean;
        };
        newFolderName_: StringConstructor;
        showNewFolderInput_: BooleanConstructor;
    };
    private topLevelBookmarks_;
    private selectedBookmarks_;
    private selectedFolder_;
    private activeFolderPath_;
    private newFolders_;
    private moveOnly_;
    private newFolderName_;
    private showNewFolderInput_;
    showDialog(activeFolderPath: BookmarksTreeNode[], topLevelBookmarks: BookmarksTreeNode[], selectedBookmarks: BookmarksTreeNode[], moveOnly: boolean): void;
    private isAvailableFolder_;
    private getDialogTitle_;
    private getBookmarkName_;
    private getBookmarkUrl_;
    private getActiveFolder_;
    private getActiveFolderTitle_;
    private getFolderTitle_;
    private getShownFolders_;
    private getBackButtonLabel_;
    private getForwardButtonTooltip_;
    private getForwardButtonLabel_;
    private hasAvailableChildFolders_;
    private validateUrl_;
    private isSelected_;
    private onBack_;
    private onForward_;
    private onFolderSelected_;
    private onNewFolderClick_;
    private onNewFolderInputDomChange_;
    private onInput_;
    private onKeyDown_;
    private onBlur_;
    private saveNewFolder_;
    private onCancel_;
    private onSave_;
    private close_;
}
declare global {
    interface HTMLElementTagNameMap {
        'power-bookmarks-edit-dialog': PowerBookmarksEditDialogElement;
    }
}
