// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"//resources/cr_elements/cr_hidden_style.css.js";import"//resources/cr_elements/policy/cr_tooltip_icon.js";import{CrPolicyIndicatorType}from"//resources/cr_elements/policy/cr_policy_types.js";import{assert,assertNotReached}from"//resources/js/assert.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./cr_policy_pref_indicator.html.js";export class CrPolicyPrefIndicatorElement extends PolymerElement{static get is(){return"cr-policy-pref-indicator"}static get template(){return getTemplate()}static get properties(){return{iconAriaLabel:String,indicatorIcon:{type:String,computed:"getIndicatorIcon_(indicatorType)"},indicatorType:{type:String,value:CrPolicyIndicatorType.NONE,computed:"getIndicatorTypeForPref_(pref.*, associatedValue)"},indicatorTooltip:{type:String,computed:"getIndicatorTooltipForPref_(indicatorType, pref.*)"},indicatorVisible:{type:Boolean,computed:"getIndicatorVisible_(indicatorType)"},pref:Object,associatedValue:Object}}getIndicatorVisible_(type){return type!==CrPolicyIndicatorType.NONE}getIndicatorIcon_(type){switch(type){case CrPolicyIndicatorType.EXTENSION:return"cr:extension";case CrPolicyIndicatorType.NONE:return"";case CrPolicyIndicatorType.PRIMARY_USER:return"cr:group";case CrPolicyIndicatorType.OWNER:return"cr:person";case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:case CrPolicyIndicatorType.RECOMMENDED:return"cr20:domain";case CrPolicyIndicatorType.PARENT:case CrPolicyIndicatorType.CHILD_RESTRICTION:return"cr20:kite";default:assertNotReached()}}getIndicatorTooltip_(type,name,matches){if(!window.CrPolicyStrings){return""}const CrPolicyStrings=window.CrPolicyStrings;switch(type){case CrPolicyIndicatorType.EXTENSION:return name.length>0?CrPolicyStrings.controlledSettingExtension.replace("$1",name):CrPolicyStrings.controlledSettingExtensionWithoutName;case CrPolicyIndicatorType.USER_POLICY:case CrPolicyIndicatorType.DEVICE_POLICY:return CrPolicyStrings.controlledSettingPolicy;case CrPolicyIndicatorType.RECOMMENDED:return matches?CrPolicyStrings.controlledSettingRecommendedMatches:CrPolicyStrings.controlledSettingRecommendedDiffers;case CrPolicyIndicatorType.PARENT:return CrPolicyStrings.controlledSettingParent;case CrPolicyIndicatorType.CHILD_RESTRICTION:return CrPolicyStrings.controlledSettingChildRestriction;default:break}return""}getIndicatorTypeForPref_(){assert(this.pref);const{enforcement:enforcement,userSelectableValues:userSelectableValues,controlledBy:controlledBy,recommendedValue:recommendedValue}=this.pref;if(enforcement===chrome.settingsPrivate.Enforcement.RECOMMENDED){if(this.associatedValue!==undefined&&this.associatedValue!==recommendedValue){return CrPolicyIndicatorType.NONE}return CrPolicyIndicatorType.RECOMMENDED}if(enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){if(userSelectableValues!==undefined){if(recommendedValue&&this.associatedValue===recommendedValue){return CrPolicyIndicatorType.RECOMMENDED}else if(userSelectableValues.includes(this.associatedValue)){return CrPolicyIndicatorType.NONE}}switch(controlledBy){case chrome.settingsPrivate.ControlledBy.EXTENSION:return CrPolicyIndicatorType.EXTENSION;case chrome.settingsPrivate.ControlledBy.PRIMARY_USER:return CrPolicyIndicatorType.PRIMARY_USER;case chrome.settingsPrivate.ControlledBy.OWNER:return CrPolicyIndicatorType.OWNER;case chrome.settingsPrivate.ControlledBy.USER_POLICY:return CrPolicyIndicatorType.USER_POLICY;case chrome.settingsPrivate.ControlledBy.DEVICE_POLICY:return CrPolicyIndicatorType.DEVICE_POLICY;case chrome.settingsPrivate.ControlledBy.PARENT:return CrPolicyIndicatorType.PARENT;case chrome.settingsPrivate.ControlledBy.CHILD_RESTRICTION:return CrPolicyIndicatorType.CHILD_RESTRICTION;default:break}}if(enforcement===chrome.settingsPrivate.Enforcement.PARENT_SUPERVISED){return CrPolicyIndicatorType.PARENT}return CrPolicyIndicatorType.NONE}getIndicatorTooltipForPref_(){if(!this.pref){return""}const matches=this.pref&&this.pref.value===this.pref.recommendedValue;return this.getIndicatorTooltip_(this.indicatorType,this.pref.controlledByName||"",matches)}getFocusableElement(){return this.$.tooltipIcon.getFocusableElement()}}customElements.define(CrPolicyPrefIndicatorElement.is,CrPolicyPrefIndicatorElement);