/**
 * @fileoverview 'category-reference-card' is a card that shows a list of
 * chips related to a certain category.
 */
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import 'chrome://resources/cr_elements/cr_chip/cr_chip.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface ChipData {
    label: string;
    icon: string;
    counter?: number;
}
export declare class CategoryReferenceCardElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        cardTitle: StringConstructor;
        chips: {
            type: ArrayConstructor;
            value: () => never[];
        };
        isExternal: {
            type: BooleanConstructor;
        };
    };
    cardTitle: string;
    chips: ChipData[];
    isExternal: boolean;
    focus(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'category-reference-card': CategoryReferenceCardElement;
    }
}
