import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/cr_tooltip/cr_tooltip.js';
import '../i18n_setup.js';
import '../icons.html.js';
import '../privacy_icons.html.js';
import './safety_hub_module.js';
import type { CrActionMenuElement } from 'chrome://resources/cr_elements/cr_action_menu/cr_action_menu.js';
import type { CrToastElement } from 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route } from '../router.js';
import type { SettingsSafetyHubModuleElement } from './safety_hub_module.js';
export interface SettingsSafetyHubUnusedSitePermissionsModuleElement {
    $: {
        headerActionMenu: CrActionMenuElement;
        bulkUndoButton: HTMLElement;
        gotItButton: HTMLElement;
        goToSettings: HTMLElement;
        module: SettingsSafetyHubModuleElement;
        moreActionButton: HTMLElement;
        toastUndoButton: HTMLElement;
        undoToast: CrToastElement;
    };
}
declare const SettingsSafetyHubUnusedSitePermissionsModuleElementBase: typeof PolymerElement & (new (...args: any[]) => import("../site_settings/site_settings_mixin.js").SiteSettingsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../tooltip_mixin.js").TooltipMixinInterface);
export declare class SettingsSafetyHubUnusedSitePermissionsModuleElement extends SettingsSafetyHubUnusedSitePermissionsModuleElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        headerString_: StringConstructor;
        subheaderString_: StringConstructor;
        lastUnusedSitePermissionsAllowedAgain_: {
            type: ObjectConstructor;
            value: null;
        };
        lastUnusedSitePermissionsListAcknowledged_: {
            type: ArrayConstructor;
            value: null;
        };
        renderedOrigins_: {
            type: ArrayConstructor;
            value: never[];
        };
        lastUserAction_: {
            type: ObjectConstructor;
            value: null;
        };
        sites_: {
            type: ArrayConstructor;
            value: null;
            observer: string;
        };
        toastText_: StringConstructor;
        shouldShowCompletionInfo_: {
            type: BooleanConstructor;
            computed: string;
        };
    };
    private headerString_;
    private subheaderString_;
    private toastText_;
    private sites_;
    private shouldShowCompletionInfo_;
    private lastUnusedSitePermissionsAllowedAgain_;
    private lastUnusedSitePermissionsListAcknowledged_;
    private renderedOrigins_;
    private lastUserAction_;
    private pendingFocusCallback_;
    private eventTracker_;
    private browserProxy_;
    private metricsBrowserProxy_;
    connectedCallback(): Promise<void>;
    disconnectedCallback(): void;
    currentRouteChanged(currentRoute: Route): void;
    /**
     * Text that describes which permissions have been revoked for an origin.
     * Permissions are listed explicitly when there are up to and including 3.
     * For 4 or more, the two first permissions are listed explicitly and for
     * the remaining ones a count is shown, e.g. 'and 2 more'.
     */
    private getPermissionsText_;
    /** Clears all the changes made by a previous action. */
    private resetValues;
    private onAllowAgainClick_;
    private onGotItClick_;
    private onMoreActionClick_;
    private onGoToSettingsClick_;
    private onUnusedSitePermissionListChanged_;
    private setHeaderToCompletionState_;
    private onSitesChanged_;
    private onUndoClick_;
    /**
     * Show info that review is completed when there are no permissions left.
     */
    private computeShouldShowCompletionInfo_;
    private undoLastAction_;
    private onKeyDown_;
    private showUndoTooltip_;
    private doesSiteListIncludeAbusiveNotifications;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-safety-hub-unused-site-permissions': SettingsSafetyHubUnusedSitePermissionsModuleElement;
    }
}
export {};
