/**
 * @fileoverview
 *
 * 'settings-reset-profile-dialog' is the dialog shown for clearing profile
 * settings. A triggered variant of this dialog can be shown under certain
 * circumstances. See triggered_profile_resetter.h for when the triggered
 * variant will be used.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_spinner_style.css.js';
import 'chrome://resources/js/action_link.js';
import 'chrome://resources/cr_elements/action_link.css.js';
import '../settings_shared.css.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrCheckboxElement } from 'chrome://resources/cr_elements/cr_checkbox/cr_checkbox.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsResetProfileDialogElement {
    $: {
        cancel: CrButtonElement;
        dialog: CrDialogElement;
        reset: CrButtonElement;
        sendSettings: CrCheckboxElement;
    };
}
declare const SettingsResetProfileDialogElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsResetProfileDialogElement extends SettingsResetProfileDialogElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        isTriggered_: {
            type: BooleanConstructor;
            value: boolean;
        };
        triggeredResetToolName_: {
            type: StringConstructor;
            value: string;
        };
        resetRequestOrigin_: StringConstructor;
        clearingInProgress_: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    private isTriggered_;
    private triggeredResetToolName_;
    private resetRequestOrigin_;
    private clearingInProgress_;
    private browserProxy_;
    private getExplanationText_;
    private getPageTitle_;
    ready(): void;
    private showDialog_;
    show(): void;
    private onCancelClick_;
    cancel(): void;
    private onResetClick_;
    /**
     * Displays the settings that will be reported in a new tab.
     */
    private onShowReportedSettingsClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-reset-profile-dialog': SettingsResetProfileDialogElement;
    }
}
export {};
