/**
 * @fileoverview
 * 'settings-reset-profile-banner' is the banner shown for prompting the user to
 * clear profile settings.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import '../settings_shared.css.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsResetProfileBannerElement {
    $: {
        dialog: CrDialogElement;
        ok: HTMLElement;
        reset: HTMLElement;
    };
}
declare const SettingsResetProfileBannerElementBase: typeof PolymerElement & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface);
export declare class SettingsResetProfileBannerElement extends SettingsResetProfileBannerElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        showResetProfileBannerV2: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        tamperedPrefs: {
            type: ArrayConstructor;
            value: () => never[];
        };
        showTamperedPrefsList: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    showResetProfileBannerV2: boolean;
    tamperedPrefs: string[];
    showTamperedPrefsList: boolean;
    private browserProxy_;
    connectedCallback(): void;
    private onOkClick_;
    private onCancel_;
    private onResetClick_;
    private onConfirmClick_;
    private onLearnMoreClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-reset-profile-banner': SettingsResetProfileBannerElement;
    }
}
export {};
