import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { RestartType } from './relaunch_mixin.js';
export interface RelaunchConfirmationDialogElement {
    $: {
        cancel: CrButtonElement;
        confirm: CrButtonElement;
        dialog: CrDialogElement;
    };
}
/**
 * The polymer element corresponding to <relaunch-confirmation-dialog>.
 * The dialog is only supported for "non" ChromeOS platforms and is
 * shown to warn users if they have any open Incognito windows before
 * proceeding with the restart/relaunch action.
 *
 * To make use of this dialog, add the below html to the target html and
 * substitute the value of restart-type to either restartTypeEnum.RELAUNCH or
 * restartTypeEnum.RESTART.
 *
 * <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
 *   <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RELAUNCH]]"
 * on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
 * </template>
 *
 * Then, in the corresponding typescript file, make the target HTMLElement
 * inherit from RelaunchMixin and invoke the member method
 * RelaunchMixin#performRestart where required.
 */
export declare class RelaunchConfirmationDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        relaunchConfirmationDialogDesc: StringConstructor;
        restartType: ObjectConstructor;
        isVersionUpdate: {
            type: BooleanConstructor;
            value: boolean;
        };
    };
    relaunchConfirmationDialogDesc: string | null;
    restartType: RestartType;
    isVersionUpdate: boolean;
    connectedCallback(): Promise<void>;
    private onDialogCancel_;
    private onDialogConfirm_;
}
declare global {
    interface HTMLElementTagNameMap {
        'relaunch-confirmation-dialog': RelaunchConfirmationDialogElement;
    }
}
