import '/shared/settings/prefs/prefs.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_collapse/cr_collapse.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import 'chrome://resources/cr_elements/cr_toast/cr_toast.js';
import 'chrome://resources/cr_elements/cr_expand_button/cr_expand_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_subpage.js';
import './privacy_sandbox_interest_item.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
import type { Route } from '../router.js';
export interface SettingsPrivacySandboxTopicsSubpageElement {
    $: {
        topicsToggle: SettingsToggleButtonElement;
    };
}
declare const SettingsPrivacySandboxTopicsSubpageElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/i18n_mixin.js").I18nMixinInterface) & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export declare class SettingsPrivacySandboxTopicsSubpageElement extends SettingsPrivacySandboxTopicsSubpageElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        topicsList_: {
            type: ArrayConstructor;
            value(): never[];
        };
        blockedTopicsList_: {
            type: ArrayConstructor;
            value(): never[];
        };
        /**
         * Used to determine that the Topics list was already fetched and to
         * display the current topics description only after the list is loaded,
         * to avoid displaying first the description for an empty list since the
         * array is empty at first when the page is loaded and switching to the
         * default description once the list is fetched.
         */
        isTopicsListLoaded_: {
            type: BooleanConstructor;
            value: boolean;
        };
        blockedTopicsExpanded_: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
        blockTopicDialogTitle_: {
            type: StringConstructor;
            value: string;
        };
        blockTopicDialogBody_: {
            type: StringConstructor;
            value: string;
        };
        shouldShowBlockTopicDialog_: {
            type: BooleanConstructor;
            value: boolean;
        };
        emptyState_: {
            type: BooleanConstructor;
            computed: string;
        };
        /**
         * If true, the Ad Topics Content parity should be shown.
         */
        shouldShowAdTopicsContentParity_: {
            type: BooleanConstructor;
            value: boolean;
        };
        adTopicsToggleSubLabel_: {
            type: StringConstructor;
            computed: string;
        };
    };
    private privacySandboxBrowserProxy_;
    private metricsBrowserProxy_;
    private topicsList_;
    private blockedTopicsList_;
    private currentChildTopics_;
    private currentInterest_?;
    private isTopicsListLoaded_;
    private emptyState_;
    private blockedTopicsExpanded_;
    private shouldShowBlockTopicDialog_;
    private blockTopicDialogTitle_;
    private blockTopicDialogBody_;
    private shouldShowAdTopicsContentParity_;
    private adTopicsToggleSubLabel_;
    ready(): void;
    private computeEmptyState_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
    private isTopicsPrefManaged_;
    private onTopicsStateChanged_;
    private isTopicsEnabledAndLoaded_;
    private isTopicsListEmpty_;
    private isBlockedTopicsListEmpty_;
    private getBlockedTopicsDescriptionClass_;
    private onToggleChange_;
    private onBlockTopicDialogClose_;
    private updateTopicsStateForSelectedTopic_;
    private onInterestChanged_;
    private onBlockedTopicsExpanded_;
    private onPrivacySandboxManageTopicsClick_;
    private onHideToastClick_;
    private onPrivacyPolicyLinkClicked_;
    private computeAdTopicsToggleSubLabel_;
    getFocusConfig(): Map<string, string>;
    focusBackButton(): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-privacy-sandbox-topics-subpage': SettingsPrivacySandboxTopicsSubpageElement;
    }
}
export {};
