/**
 * A user interest to display. There must only be one of |topic| or |site| set.
 */
export interface PrivacySandboxInterest {
    removed: boolean;
    topic?: CanonicalTopic;
    site?: string;
}
export interface FledgeState {
    joiningSites: string[];
    blockedSites: string[];
}
/**
 * The canonical form of a Topics API topic. Must be kept in sync with the
 * version at components/privacy_sandbox/canonical_topic.h.
 */
export interface CanonicalTopic {
    topicId: number;
    taxonomyVersion: number;
    displayString: string;
    description: string;
}
export interface TopicsState {
    topTopics: CanonicalTopic[];
    blockedTopics: CanonicalTopic[];
}
export interface FirstLevelTopicsState {
    firstLevelTopics: CanonicalTopic[];
    blockedTopics: CanonicalTopic[];
}
export interface PrivacySandboxBrowserProxy {
    /** Retrieves the user's current FLEDGE state. */
    getFledgeState(): Promise<FledgeState>;
    /** Sets FLEDGE joining to |allowed| for |site|.*/
    setFledgeJoiningAllowed(site: string, allowed: boolean): void;
    /** Retrieves the user's current Topics state. */
    getTopicsState(): Promise<TopicsState>;
    /** Sets |topic| to |allowed| for the Topics API.*/
    setTopicAllowed(topic: CanonicalTopic, allowed: boolean): void;
    /**
     * Informs the Privacy Sandbox Service that the user interacted with the
     * Topics toggle.
     */
    topicsToggleChanged(newToggleValue: boolean): void;
    /**
     * Proactive Topics Blocking - used to get the full list of first level
     * topics.
     */
    getFirstLevelTopics(): Promise<FirstLevelTopicsState>;
    /**
     * Proactive Topics Blocking - used to see if the passed in topic has any
     *  child topics that are currently assigned
     */
    getChildTopicsCurrentlyAssigned(topic: CanonicalTopic): Promise<CanonicalTopic[]>;
    /** Determines if the Ad Topics Content Parity should be shown. */
    shouldShowPrivacySandboxAdTopicsContentParity(): Promise<boolean>;
}
export declare class PrivacySandboxBrowserProxyImpl implements PrivacySandboxBrowserProxy {
    getFledgeState(): Promise<any>;
    setFledgeJoiningAllowed(site: string, allowed: boolean): void;
    getTopicsState(): Promise<any>;
    setTopicAllowed(topic: CanonicalTopic, allowed: boolean): void;
    topicsToggleChanged(newToggleValue: boolean): void;
    getFirstLevelTopics(): Promise<any>;
    getChildTopicsCurrentlyAssigned(topic: CanonicalTopic): Promise<any>;
    shouldShowPrivacySandboxAdTopicsContentParity(): Promise<any>;
    static getInstance(): PrivacySandboxBrowserProxy;
    static setInstance(obj: PrivacySandboxBrowserProxy): void;
}
