/**
 * @fileoverview
 * 'settings-rivacy-guide-dialog' is a settings dialog that helps users guide
 * various privacy settings.
 */
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '/shared/settings/prefs/prefs.js';
import '../../settings_shared.css.js';
import './privacy_guide_page.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsPrivacyGuideDialogElement {
    $: {
        dialog: HTMLDialogElement;
    };
}
export declare class SettingsPrivacyGuideDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * Preferences state.
         */
        prefs: {
            type: ObjectConstructor;
            notify: boolean;
        };
    };
    prefs: {
        [key: string]: any;
    };
    connectedCallback(): void;
    private onDialogCancel_;
    private onDialogClose_;
    private onPrivacyGuidePageClose_;
    private onSettingsBackClick_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-privacy-guide-dialog': SettingsPrivacyGuideDialogElement;
    }
}
