import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared action-link">cr-action-menu.complex .dropdown-item{min-height:36px}cr-action-menu:not(.complex) hr{display:none}cr-action-menu.complex hr{border:none;border-top:var(--cr-separator-line);margin:6px 0 0 0}div.list-item.non-target .target-info{display:none}div.list-item.target~div.list-item.target .target-info{display:none}#languagesSectionHeader{padding-bottom:12px;padding-top:12px}

</style>
<settings-section page-title="$i18n{languagesCardTitle}">
<div id="languagesSection">
  <div class="cr-row continuation">
    <div id="languagesSectionHeader" class="flex">
      <div>$i18n{preferredLanguagesHeader}</div>
      <div class="secondary">$i18n{preferredLanguagesDesc}</div>
    </div>
    <cr-button id="addLanguages" class="cr-button-gap header-aligned-button"
        disabled="[[!canEnableSomeSupportedLanguage_(languages)]]"
        on-click="onAddLanguagesClick_">
      $i18n{addLanguages}
    </cr-button>
  </div>
  <div class="list-frame vertical-list" role="list">
    <template is="dom-repeat" items="[[languages.enabled]]">
      <div class$="list-item [[getLanguageItemClass_(
          item.language.code, language.prospectiveUILanguage)]]
          [[isTranslationTarget_(item.language.code,
          languages.translateTarget)]]" role="listitem">
        <div class="start cr-padded-text">
          <div title="[[item.language.nativeDisplayName]]" role="none">
            [[formatIndex_(index)]]. [[item.language.displayName]]
          </div>
          <div class="target-info secondary">
            $i18n{translateTargetLabel}
          </div>
 <!-- is_win -->
        </div>
 <!-- is_win -->
        <cr-icon-button class="icon-more-vert"
            title="$i18n{moreActions}"
            id="more-[[item.language.code]]"
            on-click="onDotsClick_">
        </cr-icon-button>
      </div>
    </template>
  </div>
  <cr-lazy-render id="menu">
    <template>
      <cr-action-menu role-description="$i18n{menu}"

          >
 <!-- is_win -->
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveToTopClick_"
            hidden="[[isNthLanguage_(
                0, detailLanguage_, languages.enabled.*)]]">
          $i18n{moveToTop}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveUpClick_"
            hidden="[[!showMoveUp_(detailLanguage_, languages.enabled.*)]]">
          $i18n{moveUp}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveDownClick_"
            hidden="[[!showMoveDown_(
                detailLanguage_, languages.enabled.*)]]">
          $i18n{moveDown}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onRemoveLanguageClick_"
            disabled="[[!detailLanguage_.removable]]">
          $i18n{removeLanguage}
        </button>
      </cr-action-menu>
    </template>
  </cr-lazy-render>
</div>
<template is="dom-if" if="[[showAddLanguagesDialog_]]" restamp>
  <settings-add-languages-dialog languages="[[addLanguagesDialogLanguages_]]"
      on-languages-added="onLanguagesAdded_"
      on-close="onAddLanguagesDialogClose_">
  </settings-add-languages-dialog>
</template>
<template is="dom-if" if="[[showManagedLanguageDialog_]]" restamp>
  <managed-dialog on-close="onManagedLanguageDialogClosed_"
      title="[[i18n('languageManagedDialogTitle')]]"
      body="[[i18n('languageManagedDialogBody')]]">
  </managed-dialog>
</template>
<template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
  <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RESTART]]"
      on-close="onRelaunchDialogClose">
  </relaunch-confirmation-dialog>
</template>
</settings-section>
<!--_html_template_end_-->`;
}
