import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->    <style include="settings-shared">#dialog-title{align-items:center;display:flex}#dialog-body{display:flex;flex-direction:column;height:350px;overflow:auto;padding-inline-start:0;padding-inline-end:0}settings-checkbox-list-entry::part(checkbox){padding-inline-start:40px}#dialog-title>span,iron-list{flex:1}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div id="dialog-title" slot="title">
        <span>$i18n{addLanguagesDialogTitle}</span>
        <cr-search-field label="$i18n{searchLanguages}" id="search"
            clear-label="$i18n{clearSearch}"
            on-search-changed="onSearchChanged_"
            on-keydown="onKeydown_" autofocus>
        </cr-search-field>
      </div>
      <div id="dialog-body" slot="body" scrollable>
        <iron-list scroll-target="dialog-body" role="listbox"
            items="[[getLanguages_(filterValue_)]]">
          <template>
            <settings-checkbox-list-entry role="option"
                checked="[[willAdd_(item.code)]]" tabindex="[[tabIndex]]"
                aria-posinset$="[[getAriaPosinset_(index)]]"
                aria-setsize$="[[getLanguagesCount_(filterValue_)]]"
                aria-label="[[i18n('addLanguageAriaLabel', item.displayName)]]"
                on-change="onLanguageCheckboxChange_">
              <div class="text-elide">
                [[getDisplayText_(item)]]
              </div>
            </settings-checkbox-list-entry>
          </template>
        </iron-list>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelButtonClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onActionButtonClick_"
            disabled="[[disableActionButton_]]">
          $i18n{add}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}
