import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">#defaultDownloadPath{word-break:break-word}
  </style>
  <settings-section page-title="$i18n{downloadsPageTitle}"
      class="cr-centered-card-container">
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="locationLabel" aria-hidden="true">
          $i18n{downloadLocation}
        </div>
        <div class="secondary" id="defaultDownloadPath" aria-hidden="true">

          [[prefs.download.default_directory.value]]


        </div>
      </div>
      <div class="separator"></div>
      <controlled-button id="changeDownloadsPath"
          label="$i18n{changeDownloadLocation}"
          aria-labelledby="locationLabel defaultDownloadPath"
          on-click="selectDownloadLocation_"
          pref="[[prefs.download.default_directory]]"
          end-justified>
      </controlled-button>
    </div>
    <settings-toggle-button
        class="hr"
        pref="{{prefs.download.prompt_for_download}}"
        label="$i18n{promptForDownload}">
    </settings-toggle-button>
    <template is="dom-if" if="[[autoOpenDownloads_]]" restamp>
      <div class="cr-row">
        <div class="flex">$i18n{openFileTypesAutomatically}</div>
        <div class="separator"></div>
        <cr-button id="resetAutoOpenFileTypes"
            on-click="onClearAutoOpenFileTypesClick_">
          $i18n{clear}
        </cr-button>
      </div>
    </template>
    <template is="dom-if" if="[[downloadBubblePartialViewControlledByPref_]]">
      <settings-toggle-button id="showDownloadsToggle"
          class="hr"
          pref="{{prefs.download_bubble.partial_view_enabled}}"
          label="$i18n{showDownloadsWhenFinished}">
      </settings-toggle-button>
    </template>
  </settings-section>
<!--_html_template_end_-->`;
}
