/**
 * @fileoverview
 * settings-slider wraps a cr-slider. It maps the slider's values from a
 * linear UI range to a range of real values.  When |value| does not map exactly
 * to a tick mark, it interpolates to the nearest tick.
 */
import '//resources/cr_elements/cr_shared_vars.css.js';
import '//resources/cr_elements/cr_slider/cr_slider.js';
import type { CrSliderElement, SliderTick } from '//resources/cr_elements/cr_slider/cr_slider.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsSliderElement {
    $: {
        slider: CrSliderElement;
    };
}
declare const SettingsSliderElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/controls/cr_policy_pref_mixin.js").CrPolicyPrefMixinInterface);
export declare class SettingsSliderElement extends SettingsSliderElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        pref: ObjectConstructor;
        /**
         * Values corresponding to each tick.
         */
        ticks: {
            type: ArrayConstructor;
            value: () => never[];
        };
        /**
         * A scale factor used to support fractional pref values. This is not
         * compatible with |ticks|, i.e. if |scale| is not 1 then |ticks| must be
         * empty.
         */
        scale: {
            type: NumberConstructor;
            value: number;
        };
        min: NumberConstructor;
        max: NumberConstructor;
        labelAria: StringConstructor;
        labelMin: StringConstructor;
        labelMax: StringConstructor;
        disabled: BooleanConstructor;
        ariaDisabled: StringConstructor;
        showMarkers: BooleanConstructor;
        disableSlider_: {
            computed: string;
            type: BooleanConstructor;
        };
        updateValueInstantly: {
            type: BooleanConstructor;
            value: boolean;
            observer: string;
        };
        loaded_: BooleanConstructor;
    };
    static get observers(): string[];
    pref: chrome.settingsPrivate.PrefObject<number>;
    ticks: SliderTick[] | number[];
    scale: number;
    min: number;
    max: number;
    labelAria: string;
    labelMin: string;
    labelMax: string;
    disabled: boolean;
    showMarkers: boolean;
    private disableSlider_;
    updateValueInstantly: boolean;
    private loaded_;
    ariaDisabled: string;
    connectedCallback(): void;
    focus(): void;
    private getTickValue_;
    private getTickValueAtIndex_;
    /**
     * Sets the |pref.value| property to the value corresponding to the knob
     * position after a user action.
     */
    private onSliderChanged_;
    private computeDisableSlider_;
    /**
     * Updates the knob position when |pref.value| changes. If the knob is still
     * being dragged, this instead forces |pref.value| back to the current
     * position.
     */
    private valueChanged_;
    private getRoleDescription_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-slider': SettingsSliderElement;
    }
}
export {};
