/**
 * @fileoverview 'settings-history-deletion-dialog' is a dialog that is
 * optionally shown inside settings-clear-browsing-data-dialog after deleting
 * browsing history. It informs the user about the existence of other forms
 * of browsing history in their account.
 */
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import '../settings_shared.css.js';
import type { CrButtonElement } from 'chrome://resources/cr_elements/cr_button/cr_button.js';
import type { CrDialogElement } from 'chrome://resources/cr_elements/cr_dialog/cr_dialog.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export interface SettingsHistoryDeletionDialogElement {
    $: {
        dialog: CrDialogElement;
        okButton: CrButtonElement;
    };
}
export declare class SettingsHistoryDeletionDialogElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    /** Click handler for the "OK" button. */
    private onOkClick_;
}
