/**
 * @fileoverview 'payments-list' is a list of saved payment methods (credit
 * cards etc.) to be shown in the settings page.
 */
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import '../settings_shared.css.js';
import './credit_card_list_entry.js';
import './iban_list_entry.js';
import './pay_over_time_issuer_list_entry.js';
import './passwords_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare class SettingsPaymentsListElement extends PolymerElement {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        /**
         * An array of all saved credit cards.
         */
        creditCards: ArrayConstructor;
        /**
         * An array of all saved IBANs.
         */
        ibans: ArrayConstructor;
        /**
         * An array of all saved Pay Over Time issuers.
         */
        payOverTimeIssuers: ArrayConstructor;
        /**
         * True if displaying IBANs in settings is enabled.
         */
        enableIbans_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * True if displaying Pay Over Time in settings is enabled.
         */
        enablePayOverTime_: {
            type: BooleanConstructor;
            value(): boolean;
        };
        /**
         * True iff any payment methods will be shown.
         */
        showAnyPaymentMethods_: {
            type: BooleanConstructor;
            value: boolean;
            computed: string;
        };
    };
    creditCards: chrome.autofillPrivate.CreditCardEntry[];
    ibans: chrome.autofillPrivate.IbanEntry[];
    payOverTimeIssuers: chrome.autofillPrivate.PayOverTimeIssuerEntry[];
    private enableIbans_;
    private enablePayOverTime_;
    private showAnyPaymentMethods_;
    /**
     * Focuses the next most appropriate element after removing a specific
     * credit card. Returns `false` if it could not find such an element,
     * in this case the focus is supposed to be handled by someone else.
     */
    updateFocusBeforeCreditCardRemoval(cardIndex: number): boolean;
    /**
     * Focuses the next most appropriate element after removing a specific
     * iban. Returns `false` if it could not find such an element,
     * in this case the focus is supposed to be handled by someone else.
     */
    updateFocusBeforeIbanRemoval(ibanIndex: number): boolean;
    /**
     * Handles focus resetting across all payment method lists. Returns `false`
     * only when the last payment method is removed, in other cases sets the focus
     * to either the next or previous payment method.
     */
    private updateFocusBeforeRemoval_;
    private getCreditCardId_;
    private getIbanId_;
    /**
     * @return Whether the list exists and has items.
     */
    private hasSome_;
    /**
     * @return true iff there are credit cards to be shown.
     */
    private showCreditCards_;
    /**
     * @return true iff there are IBANs to be shown.
     */
    private showIbans_;
    /**
     * @return true iff there are Pay Over Time issuers to be shown.
     */
    private showPayOverTimeIssuers_;
    /**
     * @return true iff any payment methods will be shown.
     */
    private computeShowAnyPaymentMethods_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-payments-list': SettingsPaymentsListElement;
    }
}
