import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared">#passkeys-list-header{padding-inline-end:calc(var(--cr-icon-ripple-size) + var(--cr-icon-button-margin-start))}#iconContainer{height:24px;line-height:100%;margin-inline-end:20px;padding:4px;width:24px}</style>

<settings-subpage page-title="$i18n{managePasskeysTitle}"
    search-label="$i18n{managePasskeysSearch}"
    search-term="{{filter_}}">
<template is="dom-if" if="[[noManagement_]]">
  <div id="error" class="cr-row first">
    <div id="iconContainer">
      <cr-icon icon="cr:info"></cr-icon>
    </div>
    <p>$i18n{managePasskeysNoSupport}</p>
  </div>
</template>

<div class="cr-row first cr-secondary-text">
  $i18n{managePasskeysSubTitle}
</div>

<div class="list-frame">
  <div id="passkeys-list-header"
       class="list-item column-header right-pad"
       aria-hidden="true">
    <div class="website-column">$i18n{editPasskeySiteLabel}</div>
    <div class="username-column">$i18n{editPasskeyUsernameLabel}</div>
  </div>
  <div class="cr-separators list-with-header">
    <template is="dom-repeat" items="[[passkeys_]]"
        filter="[[filterFunction_(filter_)]]">
      <div class="list-item" focus-row-container>
        <div class="website-column no-min-width">
          <site-favicon url="[[getIconUrl_(item)]]"></site-favicon>
          <span class="text-elide elide-left">[[item.relyingPartyId]]</span>
        </div>

        <div id="username" class="username-column no-min-width text-elide">
          [[item.userName]]
        </div>

         <cr-icon-button id="moreActionsButton" class="icon-more-vert"
            data-credential-id$="[[item.credentialId]]"
            on-click="onDotsClick_" title="[[getMoreActionsLabel_(item)]]"
            focus-row-control focus-type="moreActionsButton"></cr-icon-button>
      </div>
    </template>
  </div>
</div>

<cr-action-menu id="menu" role-description="$i18n{menu}">
  
    <button class="dropdown-item" on-click="onEditClick_" id="edit">
      $i18n{edit}
    </button>
  
  <button class="dropdown-item" on-click="onDeleteClick_" id="delete">
    $i18n{delete}
  </button>
</cr-action-menu>

<cr-lazy-render id="deleteErrorDialog">
  <template>
    <cr-dialog close-text="$i18n{close}">
      <div slot="title">$i18n{managePasskeysCannotDeleteTitle}</div>
      <div slot="body">$i18n{managePasskeysCannotDeleteBody}</div>
      <div slot="button-container">
        <cr-button class="action-button" on-click="onErrorDialogOkClick_">
          $i18n{ok}
        </cr-button>
      </div>
    </cr-dialog>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="deleteConfirmDialog"
      title-text="$i18n{managePasskeysDeleteConfirmationTitle}"
      body-text="$i18n{managePasskeysDeleteConfirmationDescription}"
      confirm-text="$i18n{delete}" no-primary-button
      on-close="onConfirmDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

  <template is="dom-if" if="[[showEditDialog_]]" restamp>
    <passkey-edit-dialog id="editPasskeyDialog" existing-entry="[[credential]]"
        on-saved-passkey-edited="onSavedPasskeyEdited_"
        relying-party-id="[[relyingPartyId_]]" username="[[username_]]"
        on-close="onEditDialogClose_">
    </passkey-edit-dialog>
  </template>

</settings-subpage>
<!--_html_template_end_-->`;
}
