// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// These values must stay in sync with
// optimization_guide::prefs::FeatureOptInState in
// components/optimization_guide/core/optimization_guide_prefs.h.
export var FeatureOptInState;
(function (FeatureOptInState) {
    FeatureOptInState[FeatureOptInState["NOT_INITIALIZED"] = 0] = "NOT_INITIALIZED";
    FeatureOptInState[FeatureOptInState["ENABLED"] = 1] = "ENABLED";
    FeatureOptInState[FeatureOptInState["DISABLED"] = 2] = "DISABLED";
})(FeatureOptInState || (FeatureOptInState = {}));
// LINT.IfChange(ModelExecutionEnterprisePolicyValue)
export var ModelExecutionEnterprisePolicyValue;
(function (ModelExecutionEnterprisePolicyValue) {
    ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["ALLOW"] = 0] = "ALLOW";
    ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["ALLOW_WITHOUT_LOGGING"] = 1] = "ALLOW_WITHOUT_LOGGING";
    ModelExecutionEnterprisePolicyValue[ModelExecutionEnterprisePolicyValue["DISABLE"] = 2] = "DISABLE";
})(ModelExecutionEnterprisePolicyValue || (ModelExecutionEnterprisePolicyValue = {}));
// LINT.ThenChange(/components/optimization_guide/core/model_execution/model_execution_prefs.h:ModelExecutionEnterprisePolicyValue)
// Exporting pref names so that they can be referenced by tests.
export var SettingsAiPageFeaturePrefName;
(function (SettingsAiPageFeaturePrefName) {
    SettingsAiPageFeaturePrefName["HISTORY_SEARCH"] = "optimization_guide.history_search_setting_state";
    SettingsAiPageFeaturePrefName["COMPOSE"] = "optimization_guide.compose_setting_state";
    SettingsAiPageFeaturePrefName["TAB_ORGANIZATION"] = "optimization_guide.tab_organization_setting_state";
    SettingsAiPageFeaturePrefName["AUTOFILL_AI"] = "autofill.autofill_ai.opt_in_status";
})(SettingsAiPageFeaturePrefName || (SettingsAiPageFeaturePrefName = {}));
// Exporting enterprise pref names so that they can be referenced by tests.
export var AiEnterpriseFeaturePrefName;
(function (AiEnterpriseFeaturePrefName) {
    AiEnterpriseFeaturePrefName["HISTORY_SEARCH"] = "optimization_guide.model_execution.history_search_enterprise_policy_allowed";
    AiEnterpriseFeaturePrefName["COMPOSE"] = "optimization_guide.model_execution.compose_enterprise_policy_allowed";
    AiEnterpriseFeaturePrefName["TAB_ORGANIZATION"] = "optimization_guide.model_execution.tab_organization_enterprise_policy_allowed";
    AiEnterpriseFeaturePrefName["COMPARE"] = "optimization_guide.model_execution.tab_compare_settings_enterprise_policy";
    AiEnterpriseFeaturePrefName["AUTOFILL_AI"] = "optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed";
})(AiEnterpriseFeaturePrefName || (AiEnterpriseFeaturePrefName = {}));
export var AiPageActions;
(function (AiPageActions) {
    AiPageActions["HISTORY_SEARCH_ENABLED"] = "Settings.AiPage.HistorySearch.Enabled";
    AiPageActions["HISTORY_SEARCH_DISABLED"] = "Settings.AiPage.HistorySearch.Disabled";
    AiPageActions["HISTORY_SEARCH_FEATURE_LINK_CLICKED"] = "Settings.AiPage.HistorySearch.FeatureLinkClicked";
    AiPageActions["HISTORY_SEARCH_LEARN_MORE_CLICKED"] = "Settings.AiPage.HistorySearch.LearnMoreClicked";
    AiPageActions["COMPARE_FEATURE_LINK_CLICKED"] = "Settings.AiPage.Compare.FeatureLinkClicked";
    AiPageActions["COMPARE_LEARN_MORE_CLICKED"] = "Settings.AiPage.Compare.LearnMoreClicked";
    AiPageActions["COMPOSE_LEARN_MORE_CLICKED"] = "Settings.AiPage.Compose.LearnMoreClicked";
    AiPageActions["COMPOSE_PROACTIVE_NUDGE_ENABLED"] = "Settings.AiPage.Compose.ProactiveNudgeEnabled";
    AiPageActions["COMPOSE_PROACTIVE_NUDGE_DISABLED"] = "Settings.AiPage.Compose.ProactiveNudgeDisabled";
    AiPageActions["TAB_ORGANIZATION_LEARN_MORE_CLICKED"] = "Settings.AiPage.TabOrganization.LearnMoreClicked";
    AiPageActions["GLIC_COLLAPSED_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicCollapsed.LearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.LearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_LAUNCHER_TOGGLE_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.LauncherToggleLearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_LOCATION_TOGGLE_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.LocationToggleLearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.TabAccessToggleLearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_DEFAULT_TAB_ACCESS_TOGGLE_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.DefaultTabAccessToggleLearnMoreClicked";
    AiPageActions["GLIC_SHORTCUTS_WEB_ACTUATION_TOGGLE_LEARN_MORE_CLICKED"] = "Settings.AiPage.GlicShortcuts.WebActuationToggleLearnMoreClicked";
})(AiPageActions || (AiPageActions = {}));
