/**
 * @fileoverview 'settings-live-translate' is a component for showing Live
 * Translate settings. It appears on the accessibility subpage
 * (chrome://settings/accessibility) on Mac and some versions of Windows and on
 * the captions subpage (chrome://settings/captions) on Linux, ChromeOS, and
 * other versions of Windows.
 */
import '//resources/cr_elements/cr_shared_style.css.js';
import '//resources/cr_elements/cr_collapse/cr_collapse.js';
import '../controls/settings_dropdown_menu.js';
import '../controls/settings_toggle_button.js';
import '../settings_shared.css.js';
import { PolymerElement } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
declare const SettingsLiveTranslateElementBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("//resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface);
export interface SettingsLiveTranslateElement {
    $: {
        liveTranslateToggleButton: SettingsToggleButtonElement;
    };
}
export declare class SettingsLiveTranslateElement extends SettingsLiveTranslateElementBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        enableLiveTranslateSubtitle_: {
            type: StringConstructor;
            value: string;
        };
        languageOptions_: {
            type: ArrayConstructor;
            value: () => never[];
        };
        translatableLanguages_: {
            type: ArrayConstructor;
            value: () => never[];
        };
    };
    private enableLiveTranslateSubtitle_;
    private languageOptions_;
    private translatableLanguages_;
    connectedCallback(): void;
    private onLiveTranslateEnabledChange_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-live-translate': SettingsLiveTranslateElement;
    }
}
export {};
