import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="privacy-guide-fragment-shared settings-shared">:host{display:flex;flex-flow:column;min-height:calc(400px - var(--privacy-guide-footer-total-height))}.welcome-completion-header{padding:24px 0 16px 0}cr-link-row{--cr-link-row-icon-width:24px;--iron-icon-height:24px;border-radius:4px;padding-inline-end:8px;padding-inline-start:4px}cr-link-row::part(icon){--cr-icon-button-icon-size:24px}.label{font-size:0.875rem}.footer{align-items:center;bottom:calc(-1 * var(--privacy-guide-footer-total-height));display:flex;justify-content:space-between;padding:var(--privacy-guide-footer-vertical-padding) 0;position:absolute;width:calc(100% - 48px)}</style>
<div class="welcome-completion-header">
  <picture>
    <source
        srcset="./images/privacy_guide/completion_banner_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/completion_banner_v2.svg">
  </picture>
  <h2 class="welcome-completion-header-label" tabindex="-1">
    $i18n{privacyGuideCompletionCardHeader}
  </h2>
  <div class="cr-secondary-text">[[getSubheader_(isNoLinkLayout_)]]</div>
</div>
<template is="dom-if" if="[[shouldShowPrivacySandbox_]]">
  <cr-link-row id="privacySandboxRow" using-slotted-label
      sub-label="[[computePrivacySandboxRowSubLabel_(
        shouldShowV2AdPrivacySubLabel_)]]"
      start-icon="privacy20:ads-click" external
      on-click="onPrivacySandboxClick_">
    <div slot="label" class="label">
      $i18n{privacyGuideCompletionCardPrivacySandboxLabel}
    </div>
  </cr-link-row>
  <div aria-disabled="true" role="none">
    <a id="privacySandboxLink" href="adPrivacy"
        target="_blank" tabindex="-1" aria-disabled="true"
        role="none"></a>
  </div>
</template>
<template is="dom-if" if="[[shouldShowAiSettings_]]">
  <cr-link-row id="aiRow" using-slotted-label
      sub-label="$i18n{privacyGuideCompletionCardAiSettingsLabel}"
      start-icon="settings20:magic" external on-click="onAiRowClick_">
    <div slot="label" class="label">$i18n{aiInnovationsPageTitle}</div>
  </cr-link-row>
  <div aria-disabled="true" role="none">
    <a id="aiRowLink" href="ai" target="_blank" tabindex="-1"
        aria-disabled="true" role="none"></a>
  </div>
</template>
<template is="dom-if" if="[[shouldShowWaa_]]">
  <cr-link-row id="waaRow" using-slotted-label
      sub-label="$i18n{privacyGuideCompletionCardWaaSubLabel}"
      start-icon="settings:devices" external
      on-click="onWaaClick_">
      <div slot="label" class="label">
        $i18n{privacyGuideCompletionCardWaaLabel}
      </div>
  </cr-link-row>
</template>
<div class="footer">
  <cr-button id="backButton" role="button" on-click="onBackButtonClick_">
    $i18n{privacyGuideBackButton}
  </cr-button>
  <cr-button class="action-button" id="leaveButton"
      on-click="onLeaveButtonClick_">
    $i18n{privacyGuideCompletionCardLeaveButton}
  </cr-button>
</div>
<!--_html_template_end_-->`;
}