import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared
    your-saved-info-shared">#cardBenefitsToggle{display:none}.expiration-column{align-items:center;display:flex;flex:1}.arrow-icon-down{fill:currentColor;flex-shrink:0;margin-inline-start:6px;margin-inline-end:-6px;width:var(--cr-icon-size)}.payment-list-margin-start{padding-inline-start:20px}
</style>
<settings-subpage page-title="[[getPageTitleLabel_(isYourSavedInfoSubpage_)]]"
    hide-close-button="[[hideCloseButton]]"
    learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}"
    class$="[[getMultiCardClass_(isYourSavedInfoSubpage_)]]">

<div class="card">
<settings-toggle-button id="autofillCreditCardToggle"
    no-extension-indicator label="$i18n{enableCreditCardsLabel}"
    sub-label="$i18n{enableCreditCardsSublabel}"
    pref="{{prefs.autofill.credit_card_enabled}}">
</settings-toggle-button>

  <settings-toggle-button id="mandatoryAuthToggle"
      no-extension-indicator label="$i18n{enableMandatoryAuthToggleLabel}"
      sub-label="$i18n{enableMandatoryAuthToggleSublabel}"
      pref="{{prefs.autofill.payment_methods_mandatory_reauth}}" no-set-pref
      disabled="[[shouldDisableAuthToggle_(
                prefs.autofill.credit_card_enabled.value, deviceAuthAvailable_)]]"
      on-settings-boolean-control-change="onMandatoryAuthToggleChange_">
  </settings-toggle-button>

<template is="dom-if" if="[[cvcStorageAvailable_]]">
  <settings-toggle-button id="cvcStorageToggle"
        no-extension-indicator label="$i18n{enableCvcStorageLabel}"
        aria-label="[[getCvcStorageAriaLabel_(creditCards)]]"
        sub-label-with-link="[[getCvcStorageSublabel_(creditCards)]]"
        disabled="[[!prefs.autofill.credit_card_enabled.value]]"
        on-sub-label-link-clicked="onBulkRemoveCvcClick_"
        pref="{{prefs.autofill.payment_cvc_storage}}">
    </settings-toggle-button>
</template>
<template is="dom-if" if="[[cardBenefitsFlagEnabled_]]">
  <settings-toggle-button id="cardBenefitsToggle"
      no-extension-indicator label="$i18n{cardBenefitsLabel}"
      sub-label-with-link="[[cardBenefitsSublabel_]]"
      on-sub-label-link-clicked="onCardBenefitsSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.payment_card_benefits}}">
  </settings-toggle-button>
</template>
<template is="dom-if" if="[[shouldShowPayOverTimeSettings_]]">
  <settings-toggle-button id="payOverTimeToggle"
      no-extension-indicator label="$i18n{autofillPayOverTimeSettingsLabel}"
      sub-label-with-link="[[payOverTimeSublabel_]]"
      on-sub-label-link-clicked="onPayOverTimeSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.bnpl_enabled}}">
  </settings-toggle-button>
</template>
<settings-toggle-button id="canMakePaymentToggle"
    aria-label="$i18n{canMakePaymentToggleLabel}"
    label="$i18n{canMakePaymentToggleLabel}"
    pref="{{prefs.payments.can_make_payment_enabled}}"
    on-settings-boolean-control-change="onCanMakePaymentChange_">
</settings-toggle-button>
<template is="dom-if"
    if="[[prefs.autofill.credit_card_enabled.extensionId]]">
  <div class="cr-row continuation">
    <extension-controlled-indicator class="flex"
        id="autofillExtensionIndicator"
        extension-id="[[prefs.autofill.credit_card_enabled.extensionId]]"
        extension-name="[[
            prefs.autofill.credit_card_enabled.controlledByName]]"
        extension-can-be-disabled="[[
            prefs.autofill.credit_card_enabled.extensionCanBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<div id="manageLink" class="cr-row first" hidden>
  <!-- This span lays out the link correctly, relative to the text. -->
  <div class="cr-padded-text">$i18nRaw{manageCreditCardsLabel}</div>
</div>

</div>

<div class="card">

<div class="cr-row continuation">
  <h2 class="flex">$i18n{creditCards}</h2>
  <template is="dom-if"
      if="[[!shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button id="addCreditCard" class="header-aligned-button"
        on-click="onAddCreditCardClick_" aria-label="$i18n{addCreditCardTitle}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
    </cr-button>
  </template>
  <template is="dom-if"
      if="[[shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button class="header-aligned-button"
        id="addPaymentMethods" on-click="onAddPaymentMethodClick_"
        aria-label="$i18n{addPaymentMethods}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
      <cr-icon icon="cr:arrow-drop-down" class="arrow-icon-down"></cr-icon>
    </cr-button>
    <cr-lazy-render id="paymentMethodsActionMenu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button id="addCreditCard" class="dropdown-item"
              on-click="onAddCreditCardClick_">
            $i18n{addPaymentMethodCreditOrDebitCard}
          </button>
          <button id="addIban" class="dropdown-item"
              on-click="onAddIbanClick_">
            $i18n{addPaymentMethodIban}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>
  </template>
</div>
<settings-payments-list id="paymentsList"
    class="list-frame payment-list-margin-start"
    credit-cards="[[creditCards]]"
    ibans="[[ibans]]"
    pay-over-time-issuers="[[payOverTimeIssuers]]"
    on-dots-iban-menu-click="onDotsIbanMenuClick_"
    on-remote-iban-menu-click="onRemoteEditIbanMenuClick_"
    on-dots-card-menu-click="onCreditCardDotsMenuClick_"
    on-remote-card-menu-click="onRemoteEditCreditCardClick_"
    aria-label="$i18n{paymentsMethodsTableAriaLabel}">
</settings-payments-list>

<cr-action-menu id="creditCardSharedMenu" role-description="$i18n{menu}">
  <button id="menuEditCreditCard" class="dropdown-item"
      on-click="onMenuEditCreditCardClick_">
    [[getMenuEditCardText_(activeCreditCard_.metadata.isLocal)]]
  </button>

  <button id="menuRemoveCreditCard" class="dropdown-item"
      hidden$="[[!activeCreditCard_.metadata.isLocal]]"
      on-click="onMenuRemoveCreditCardClick_">$i18n{delete}</button>

  <button id="menuAddVirtualCard" class="dropdown-item"
      on-click="onMenuAddVirtualCardClick_"
      hidden$="[[!shouldShowAddVirtualCardButton_(activeCreditCard_)]]">
    $i18n{addVirtualCard}
  </button>
  <button id="menuRemoveVirtualCard" class="dropdown-item"
      on-click="onMenuRemoveVirtualCardClick_"
      hidden$="[[!shouldShowRemoveVirtualCardButton_(activeCreditCard_)]]">
    $i18n{removeVirtualCard}
  </button>
</cr-action-menu>

<cr-lazy-render id="ibanSharedActionMenu">
  <template>
    <cr-action-menu id="ibanSharedMenu" role-description="$i18n{menu}">
      <button id="menuEditIban" class="dropdown-item"
          on-click="onMenuEditIbanClick_">
        $i18n{editIban}
      </button>
      <button id="menuRemoveIban" class="dropdown-item"
          on-click="onMenuRemoveIbanClick_">
        $i18n{delete}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showCreditCardDialog_]]" restamp>
  <settings-credit-card-edit-dialog credit-card="[[activeCreditCard_]]"
      on-close="onCreditCardDialogClose_" on-save-credit-card="saveCreditCard_"
      prefs="{{prefs}}">
  </settings-credit-card-edit-dialog>
</template>
<template is="dom-if" if="[[showIbanDialog_]]" restamp>
  <settings-iban-edit-dialog iban="[[activeIban_]]"
      on-close="onIbanDialogClose_" on-save-iban="onSaveIban_">
  </settings-iban-edit-dialog>
</template>

<template is="dom-if" if="[[showVirtualCardUnenrollDialog_]]" restamp>
  <settings-virtual-card-unenroll-dialog credit-card="[[activeCreditCard_]]"
      on-close="onVirtualCardUnenrollDialogClose_"
      on-unenroll-virtual-card="unenrollVirtualCard_">
  </settings-virtual-card-unenroll-dialog>
</template>

<template is="dom-if" if="[[showLocalCreditCardRemoveConfirmationDialog_]]"
    restamp>
  <settings-simple-confirmation-dialog id="localCardDeleteConfirmDialog"
      title-text="$i18n{removeLocalCreditCardConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalCreditCardRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showLocalIbanRemoveConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="localIbanDeleteConfirmationDialog"
      title-text="$i18n{removeLocalIbanConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalIbanRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showBulkRemoveCvcConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="bulkDeleteCvcConfirmDialog"
      title-text="$i18n{bulkRemoveCvcConfirmationTitle}"
      body-text="$i18n{bulkRemoveCvcConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onShowBulkRemoveCvcConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

</div>

</settings-subpage>
<!--_html_template_end_-->`;
}